/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Namespace;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class XSLNamespace
extends XSLStringConstructor {
    Expression name;

    public void prepareAttributes() throws XPathException {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string3 = this.getNamePool().getClarkName(n);
            if (string3 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string3 == "select") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("name");
        } else {
            this.name = this.makeAttributeValueTemplate(string);
        }
        if (string2 != null) {
            this.select = this.makeExpression(string2);
        }
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
        int n = 0;
        NodeInfo nodeInfo2 = null;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLFallback) continue;
            if (this.select != null) {
                String string = this.getErrorCodeForSelectPlusContent();
                this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", string);
            }
            ++n;
            if (nodeInfo2 != null) break;
            nodeInfo2 = nodeInfo;
        }
        if (this.select == null) {
            if (n == 0) {
                this.select = new StringLiteral(StringValue.EMPTY_STRING);
            } else if (n == 1 && nodeInfo2.getNodeKind() == 3) {
                this.select = new StringLiteral(nodeInfo2.getStringValueCS());
            }
        }
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0910";
    }

    public Expression compile(Executable executable) throws XPathException {
        Namespace namespace = new Namespace(this.name);
        this.compileContent(executable, namespace, new StringLiteral(StringValue.SINGLE_SPACE));
        ExpressionTool.makeParentReferences(namespace);
        return namespace;
    }
}

