/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.LogInputStream;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Utils;

public class RecordsIterator
extends AbstractIterator<LogEntry> {
    private final boolean shallow;
    private final boolean ensureMatchingMagic;
    private final int maxRecordSize;
    private final ShallowRecordsIterator<?> shallowIter;
    private final BufferSupplier bufferSupplier;
    private DeepRecordsIterator innerIter;

    public RecordsIterator(LogInputStream<?> logInputStream, boolean shallow, boolean ensureMatchingMagic, int maxRecordSize, BufferSupplier bufferSupplier) {
        this.shallowIter = new ShallowRecordsIterator(logInputStream);
        this.shallow = shallow;
        this.ensureMatchingMagic = ensureMatchingMagic;
        this.maxRecordSize = maxRecordSize;
        this.bufferSupplier = bufferSupplier;
    }

    public static <T extends LogEntry> Iterator<T> shallowIterator(LogInputStream<T> logInputStream) {
        return new ShallowRecordsIterator<T>(logInputStream);
    }

    @Override
    protected LogEntry makeNext() {
        if (this.innerDone()) {
            if (!this.shallowIter.hasNext()) {
                return (LogEntry)this.allDone();
            }
            LogEntry entry = (LogEntry)this.shallowIter.next();
            if (this.shallow || !entry.isCompressed()) {
                return entry;
            }
            this.innerIter = new DeepRecordsIterator(entry, this.ensureMatchingMagic, this.maxRecordSize, this.bufferSupplier);
            return (LogEntry)this.innerIter.next();
        }
        return (LogEntry)this.innerIter.next();
    }

    private boolean innerDone() {
        return this.innerIter == null || !this.innerIter.hasNext();
    }

    public static class DeepRecordsIterator
    extends AbstractIterator<LogEntry> {
        private final ArrayDeque<LogEntry> logEntries;
        private final long absoluteBaseOffset;
        private final byte wrapperMagic;

        public DeepRecordsIterator(LogEntry wrapperEntry, boolean ensureMatchingMagic, int maxMessageSize, BufferSupplier bufferSupplier) {
            Record wrapperRecord = wrapperEntry.record();
            this.wrapperMagic = wrapperRecord.magic();
            CompressionType compressionType = wrapperRecord.compressionType();
            ByteBuffer buffer = wrapperRecord.value();
            InputStream stream = MemoryRecordsBuilder.wrapForInput(buffer, compressionType, wrapperRecord.magic(), bufferSupplier);
            DataLogInputStream logStream = new DataLogInputStream(stream, maxMessageSize);
            long wrapperRecordOffset = wrapperEntry.offset();
            long wrapperRecordTimestamp = wrapperRecord.timestamp();
            this.logEntries = new ArrayDeque();
            try {
                Object logEntry;
                while ((logEntry = logStream.nextEntry()) != null) {
                    Record record = ((LogEntry)logEntry).record();
                    byte magic = record.magic();
                    if (ensureMatchingMagic && magic != this.wrapperMagic) {
                        throw new InvalidRecordException("Compressed message magic does not match wrapper magic");
                    }
                    if (magic > 0) {
                        Record recordWithTimestamp = new Record(record.buffer(), wrapperRecordTimestamp, wrapperRecord.timestampType());
                        logEntry = LogEntry.create(((LogEntry)logEntry).offset(), recordWithTimestamp);
                    }
                    this.logEntries.addLast((LogEntry)logEntry);
                }
                this.absoluteBaseOffset = this.wrapperMagic > 0 ? wrapperRecordOffset - this.logEntries.getLast().offset() : -1L;
            }
            catch (IOException e) {
                throw new KafkaException(e);
            }
            finally {
                Utils.closeQuietly(stream, "records iterator stream");
            }
        }

        @Override
        protected LogEntry makeNext() {
            if (this.logEntries.isEmpty()) {
                return (LogEntry)this.allDone();
            }
            LogEntry entry = this.logEntries.remove();
            if (this.absoluteBaseOffset >= 0L) {
                long absoluteOffset = this.absoluteBaseOffset + entry.offset();
                entry = LogEntry.create(absoluteOffset, entry.record());
            }
            if (entry.isCompressed()) {
                throw new InvalidRecordException("Inner messages must not be compressed");
            }
            return entry;
        }
    }

    private static class ShallowRecordsIterator<T extends LogEntry>
    extends AbstractIterator<T> {
        private final LogInputStream<T> logStream;

        public ShallowRecordsIterator(LogInputStream<T> logStream) {
            this.logStream = logStream;
        }

        @Override
        protected T makeNext() {
            try {
                T entry = this.logStream.nextEntry();
                if (entry == null) {
                    return (T)((LogEntry)this.allDone());
                }
                return entry;
            }
            catch (IOException e) {
                throw new KafkaException(e);
            }
        }
    }

    private static final class DataLogInputStream
    implements LogInputStream<LogEntry> {
        private final InputStream stream;
        protected final int maxMessageSize;
        private final ByteBuffer offsetAndSizeBuffer;

        DataLogInputStream(InputStream stream, int maxMessageSize) {
            this.stream = stream;
            this.maxMessageSize = maxMessageSize;
            this.offsetAndSizeBuffer = ByteBuffer.allocate(12);
        }

        @Override
        public LogEntry nextEntry() throws IOException {
            this.offsetAndSizeBuffer.clear();
            Utils.readFully(this.stream, this.offsetAndSizeBuffer);
            if (this.offsetAndSizeBuffer.hasRemaining()) {
                return null;
            }
            long offset = this.offsetAndSizeBuffer.getLong(0);
            int size = this.offsetAndSizeBuffer.getInt(8);
            if (size < 14) {
                throw new CorruptRecordException(String.format("Record size is less than the minimum record overhead (%d)", 14));
            }
            if (size > this.maxMessageSize) {
                throw new CorruptRecordException(String.format("Record size exceeds the largest allowable message size (%d).", this.maxMessageSize));
            }
            ByteBuffer batchBuffer = ByteBuffer.allocate(size);
            Utils.readFully(this.stream, batchBuffer);
            if (batchBuffer.hasRemaining()) {
                return null;
            }
            batchBuffer.flip();
            return LogEntry.create(offset, new Record(batchBuffer));
        }
    }
}

