
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method renameNode renames an existing node and raises a NAMESPACE_ERR
 *  if the qualifiedName is malformed per the Namespaces in XML specification.
 *  
 *  Invoke the renameNode method on a new document node to rename a node to nodes 
 *  with malformed qualifiedNames.
 *  Check if a NAMESPACE_ERR gets thrown.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-renameNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-renameNode</a>
*/
public final class documentrenamenode19 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentrenamenode19(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Document newDoc;
      DOMImplementation domImpl;
      Element element;
      Node renamedNode;
      String qualifiedName;
      DocumentType nullDocType = null;

      java.util.List qualifiedNames = new java.util.ArrayList();
      qualifiedNames.add("a_:");
      qualifiedNames.add("_:");
      qualifiedNames.add(":");
      qualifiedNames.add("::0;");
      qualifiedNames.add("a:-:c");
      
      doc = (Document) load("hc_staff", false);
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "newD", nullDocType);
      element = doc.createElementNS("http://www.w3.org/DOM/Test", "test");
      for (int indexN1006C = 0; indexN1006C < qualifiedNames.size(); indexN1006C++) {
          qualifiedName = (String) qualifiedNames.get(indexN1006C);
    
      {
         boolean success = false;
         try {
            renamedNode = doc.renameNode(element, "http://www.w3.org/2000/XMLNS", qualifiedName);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NAMESPACE_ERR);
         }
         assertTrue("documentrenamenode19_NAMESPACE_ERR", success);
      }
  }
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentrenamenode19";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentrenamenode19.class, args);
   }
}

