# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=enchant
VER=1.4.2-tml
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

# Avoid libtool relinking.
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have."  Screw libtool.

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev
PATH=/opt/pthread/bin:$PATH # Needed by aspell.exe...

unset MY_PKG_CONFIG_PATH
DEPS=`/devel/src/tml/latest.sh glib`
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

patch -p0 <<'EOF'
diff -pru ../orig-1.4.2/src/aspell/aspell_provider.c ./src/aspell/aspell_provider.c
--- ../orig-1.4.2/src/aspell/aspell_provider.c	2008-05-05 23:19:17.000000000 +0300
+++ ./src/aspell/aspell_provider.c	2008-06-12 16:37:05.507932600 +0300
@@ -338,14 +338,14 @@ init_enchant_provider (void)
 
 #if defined(_WIN32)
 
-static WCHAR* GetDirectoryOfThisLibrary()
+static WCHAR* GetDirectoryOfThisLibrary(void)
 {
 	WCHAR dll_path[MAX_PATH];
     gchar* utf8_dll_path;
     gchar* utf8_prefix;
     gunichar2* utf16_prefix;
 
-    if(!GetModuleFileName(s_hModule,dll_path,MAX_PATH))
+    if(!GetModuleFileNameW(s_hModule,dll_path,MAX_PATH))
         { /* unable to determine filename of this library */
             return NULL;
         }
@@ -372,7 +372,7 @@ static HMODULE LoadLibraryFromPath(const
     wcscat(wszFullLibraryPath, L"\\");
     wcscat(wszFullLibraryPath, libraryName);
 
-    h = LoadLibrary(wszFullLibraryPath);
+    h = LoadLibraryW(wszFullLibraryPath);
 
     g_free(wszFullLibraryPath);
     return h;
@@ -385,13 +385,13 @@ static WCHAR* GetRegistryValue(HKEY base
 	DWORD dwSize;
 	WCHAR* wszValue = NULL;
 
-	if(RegOpenKeyEx(baseKey, uKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
+	if(RegOpenKeyExW(baseKey, uKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
 		{
 			/* Determine size of string */
-			if(RegQueryValueEx( hKey, uKey, NULL, &lType, NULL, &dwSize) == ERROR_SUCCESS)
+			if(RegQueryValueExW( hKey, uKey, NULL, &lType, NULL, &dwSize) == ERROR_SUCCESS)
 				{
 					wszValue = g_new0(WCHAR, dwSize + 1);
-					RegQueryValueEx(hKey, uKey, NULL, &lType, (LPBYTE) wszValue, &dwSize);
+					RegQueryValueExW(hKey, uKey, NULL, &lType, (LPBYTE) wszValue, &dwSize);
 				}
 		}
 
@@ -399,10 +399,9 @@ static WCHAR* GetRegistryValue(HKEY base
 }
 #endif
 
-void configure_enchant_provider(EnchantProvider * me, const char *dir_name)
-{
 #if defined(_WIN32)
-    const WCHAR* aspell_module_name = L"aspell-15.dll";
+gboolean try(EnchantProvider * me, const char *dir_name, const WCHAR *aspell_module_name)
+{
     HMODULE aspell_module = NULL;
     char* szModule;
 
@@ -413,7 +412,7 @@ void configure_enchant_provider(EnchantP
         WCHAR* wszModule;
 
 	    wszModule = g_utf8_to_utf16 (szModule, -1, NULL, NULL, NULL);
-        aspell_module = LoadLibrary(wszModule);
+        aspell_module = LoadLibraryW(wszModule);
         g_free(wszModule);
     }
 
@@ -442,7 +441,7 @@ void configure_enchant_provider(EnchantP
     if (aspell_module == NULL) 
         {
             /* then try default lookup */
-            aspell_module = LoadLibrary(aspell_module_name);
+            aspell_module = LoadLibraryW(aspell_module_name);
         }
 
     if (aspell_module == NULL) 
@@ -452,9 +451,18 @@ void configure_enchant_provider(EnchantP
             me->request_dict = NULL;
             me->dispose_dict = NULL;
             me->list_dicts = NULL;
+	    return FALSE;
         }
+    return TRUE;
+}
 #endif
 
+void configure_provider(EnchantProvider * me, const char *dir_name)
+{
+#if defined(_WIN32)
+	try(me, dir_name, L"aspell-15.dll") ||
+	try(me, dir_name, L"libaspell-15.dll");
+#endif
 }
 
 
diff -pru ../orig-1.4.2/src/enchant.c ./src/enchant.c
--- ../orig-1.4.2/src/enchant.c	2008-05-05 23:19:19.000000000 +0300
+++ ./src/enchant.c	2008-06-12 17:07:53.336057600 +0300
@@ -314,13 +314,13 @@ enchant_get_registry_value_ex (int curre
 	uKeyName = g_utf8_to_utf16 (keyName, -1, NULL, NULL, NULL);
 	uKey = g_utf8_to_utf16 (key, -1, NULL, NULL, NULL);
 
-	if(RegOpenKeyEx(baseKey, uKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
+	if(RegOpenKeyExW(baseKey, uKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
 		{
 			/* Determine size of string */
-			if(RegQueryValueEx( hKey, uKey, NULL, &lType, NULL, &dwSize) == ERROR_SUCCESS)
+			if(RegQueryValueExW( hKey, uKey, NULL, &lType, NULL, &dwSize) == ERROR_SUCCESS)
 				{
 					wszValue = g_new0(WCHAR, dwSize + 1);
-					RegQueryValueEx(hKey, uKey, NULL, &lType, (LPBYTE) wszValue, &dwSize);
+					RegQueryValueExW(hKey, uKey, NULL, &lType, (LPBYTE) wszValue, &dwSize);
 				}
 		}
 
@@ -2160,17 +2160,18 @@ enchant_get_prefix_dir(void)
 #ifdef _WIN32
 	if (!prefix) {
 		/* Dynamically locate library and return containing directory */
-		HINSTANCE hInstance = GetModuleHandle(L"libenchant");
-		if(hInstance != NULL)
+		WCHAR dll_path[MAX_PATH];
+
+		if(GetModuleFileNameW(s_hModule,dll_path,MAX_PATH))
 			{
-				WCHAR dll_path[MAX_PATH];
-	  
-				if(GetModuleFileName(hInstance,dll_path,MAX_PATH))
-					{
-						gchar* utf8_dll_path = g_utf16_to_utf8 (dll_path, -1, NULL, NULL, NULL);
-						prefix = g_path_get_dirname(utf8_dll_path);
-						g_free(utf8_dll_path);
-					}
+				gchar* utf8_dll_path = g_utf16_to_utf8 (dll_path, -1, NULL, NULL, NULL);
+				prefix = g_path_get_dirname(utf8_dll_path);
+				g_free(utf8_dll_path);
+				/* Strip off "bin" subfolder if present */
+				if (strlen(prefix) >=6 &&
+				    G_IS_DIR_SEPARATOR(prefix[strlen(prefix)-4]) &&
+				    g_ascii_strcasecmp(prefix+strlen(prefix)-3, "bin") == 0)
+					prefix[strlen(prefix)-4] = '\0';
 			}
 	}
 #endif
diff -pru ../orig-1.4.2/src/myspell/Makefile.am ./src/myspell/Makefile.am
--- ../orig-1.4.2/src/myspell/Makefile.am	2008-05-05 23:19:18.000000000 +0300
+++ ./src/myspell/Makefile.am	2008-06-12 16:43:05.929807600 +0300
@@ -39,7 +39,7 @@ EXTRA_MYSPELL_FILES=
 EXTRA_MYSPELL_CFLAGS=-DWITH_SYSTEM_MYSPELL
 else
 EXTRA_MYSPELL_FILES=$(COPIED_MYSPELL_FILES)
-EXTRA_MYSPELL_CFLAGS=
+EXTRA_MYSPELL_CFLAGS=-DHUNSPELL_STATIC
 endif
 
 INCLUDES=-I$(top_srcdir)/src $(ENCHANT_CFLAGS) $(MYSPELL_CFLAGS) $(CXX_WARN_CFLAGS) $(EXTRA_MYSPELL_CFLAGS) -D_ENCHANT_BUILD=1
diff -pru ../orig-1.4.2/src/myspell/Makefile.in ./src/myspell/Makefile.in
--- ../orig-1.4.2/src/myspell/Makefile.in	2008-05-05 23:27:21.000000000 +0300
+++ ./src/myspell/Makefile.in	2008-06-12 16:44:53.851682600 +0300
@@ -272,7 +272,7 @@ COPIED_MYSPELL_FILES = \
 
 @WITH_SYSTEM_MYSPELL_FALSE@EXTRA_MYSPELL_FILES = $(COPIED_MYSPELL_FILES)
 @WITH_SYSTEM_MYSPELL_TRUE@EXTRA_MYSPELL_FILES = 
-@WITH_SYSTEM_MYSPELL_FALSE@EXTRA_MYSPELL_CFLAGS = 
+@WITH_SYSTEM_MYSPELL_FALSE@EXTRA_MYSPELL_CFLAGS = -DHUNSPELL_STATIC
 @WITH_SYSTEM_MYSPELL_TRUE@EXTRA_MYSPELL_CFLAGS = -DWITH_SYSTEM_MYSPELL
 INCLUDES = -I$(top_srcdir)/src $(ENCHANT_CFLAGS) $(MYSPELL_CFLAGS) $(CXX_WARN_CFLAGS) $(EXTRA_MYSPELL_CFLAGS) -D_ENCHANT_BUILD=1
 myspell_LTLIBRARIES = $(target_lib)
diff -pru ../orig-1.4.2/src/myspell/myspell_checker.cpp ./src/myspell/myspell_checker.cpp
--- ../orig-1.4.2/src/myspell/myspell_checker.cpp	2008-05-05 23:19:18.000000000 +0300
+++ ./src/myspell/myspell_checker.cpp	2008-06-12 16:39:22.336057600 +0300
@@ -81,13 +81,13 @@ static WCHAR* GetRegistryValue(HKEY base
 	DWORD dwSize;
 	WCHAR* wszValue = NULL;
 
-	if(RegOpenKeyEx(baseKey, uKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
+	if(RegOpenKeyExW(baseKey, uKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
 		{
 			/* Determine size of string */
-			if(RegQueryValueEx( hKey, uKey, NULL, &lType, NULL, &dwSize) == ERROR_SUCCESS)
+			if(RegQueryValueExW( hKey, uKey, NULL, &lType, NULL, &dwSize) == ERROR_SUCCESS)
 				{
 					wszValue = g_new0(WCHAR, dwSize + 1);
-					RegQueryValueEx(hKey, uKey, NULL, &lType, (LPBYTE) wszValue, &dwSize);
+					RegQueryValueExW(hKey, uKey, NULL, &lType, (LPBYTE) wszValue, &dwSize);
 				}
 		}
 
diff -pru ../orig-1.4.2/src/pwl.c ./src/pwl.c
--- ../orig-1.4.2/src/pwl.c	2008-05-05 23:19:19.000000000 +0300
+++ ./src/pwl.c	2008-06-12 16:15:59.211057600 +0300
@@ -60,7 +60,8 @@
 #include <fcntl.h>
 
 #ifdef _WIN32
-#include <io.h>
+#define WIN32_LEAN_AND_MEAN
+#include <windows.h>
 #endif
 
 #include <glib.h>
@@ -197,7 +198,13 @@ enchant_lock_file (FILE * f)
 #elif defined(HAVE_LOCKF)
 	lockf (fileno (f), F_LOCK, 0);
 #elif defined(_WIN32)
-	_lock_file(f);
+	OVERLAPPED overlapped;
+
+	overlapped.Offset = 0;
+	overlapped.OffsetHigh = 0;
+	overlapped.hEvent = NULL;
+	if (!LockFileEx ((HANDLE) _get_osfhandle (fileno (f)), LOCKFILE_EXCLUSIVE_LOCK, 0, 0, 0x80000000, &overlapped))
+		g_warning ("Could not lock file\n");
 #else
 	/* TODO: UNIX fcntl. This race condition probably isn't too bad. */
 #endif /* HAVE_FLOCK */
@@ -211,7 +218,13 @@ enchant_unlock_file (FILE * f)
 #elif defined(HAVE_LOCKF)
 	lockf (fileno (f), F_ULOCK, 0);
 #elif defined(_WIN32)
-	_unlock_file(f);
+	OVERLAPPED overlapped;
+
+	overlapped.Offset = 0;
+	overlapped.OffsetHigh = 0;
+	overlapped.hEvent = NULL;
+	if (!UnlockFileEx ((HANDLE) _get_osfhandle (fileno (f)), 0, 0, 0x80000000, &overlapped))
+		g_warning ("Could not unlock file\n");
 #else
 	/* TODO: UNIX fcntl. This race condition probably isn't too bad. */
 #endif /* HAVE_FLOCK */
--- /dev/null	1970-01-01 02:00:00.000000000 +0200
+++ compile-resource	2008-06-12 15:40:26.179807600 +0300
@@ -0,0 +1,46 @@
+#!/bin/sh
+
+# Script to compile a resource file for a DLL if there is a .rc file
+# for it. The resource source file is supposed to contain a version
+# info section, that uses the string BUILDNUMBER as the least
+# significant part of the version numbers. This script replaces that
+# string with a "build number" before compiling the binary resource
+# file. The build number is kept between builds in a "stamp" file, and
+# incremented each time. (If there is no stamp file, build number 0 is
+# used.) The intention is that only the "official" maintainer of a DLL
+# keeps such a stamp file, and thus the DLLs he releases have
+# increasing version number resources, which can be used by an
+# installer program to decide whether to replace an existing DLL with
+# the same name.
+
+# This is just my (tml@iki.fi) idea, if somebody comes up with a
+# better way to generate version number resources, don't hesitate to
+# suggest.
+
+# The command line arguments are:
+# $1: the name of the .rc file to check
+# $2: the name of the resource object file to produce, if the rc file exists
+
+# Check if we have a resource file for this DLL.
+rcfile=$1
+resfile=$2
+if [ -f $rcfile ]; then
+    # Check if we have a build number stamp file.
+    basename=`basename $rcfile .rc`
+    if [ -f $basename-build.stamp ]; then
+	read number <$basename-build.stamp
+	buildnumber=$[number]
+	echo Build number $buildnumber
+	rm -rf $basename-build.stamp
+    else
+	echo Using zero as build number
+        buildnumber=0
+    fi
+
+    m4 -DBUILDNUMBER=$buildnumber <$rcfile >$$.rc &&
+	${WINDRES-windres} $$.rc $resfile &&
+	rm $$.rc
+else
+    # Return failure
+    exit 1
+fi
EOF


PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3' LDFLAGS='-L/opt/proxy-libintl/lib -Wl,--exclude-libs=libintl.a' CFLAGS=-O2 ./configure --disable-static --prefix=c:/devel/target/$HEX &&
libtoolcacheize &&

make -j3 &&

make -j3 install &&

rm -f /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip &&
(cd /devel/target/$HEX &&
zip /tmp/enchant-$VER.zip bin/libenchant.dll
zip /tmp/enchant-$VER.zip lib/enchant/*.dll
zip -r -D /tmp/enchant-$VER.zip share/enchant

zip /tmp/enchant-dev-$VER.zip bin/enchant.exe bin/enchant-lsmod.exe
zip -r -D /tmp/enchant-dev-$VER.zip include
zip /tmp/enchant-dev-$VER.zip lib/libenchant.dll.a
zip /tmp/enchant-dev-$VER.zip lib/pkgconfig/enchant.pc
zip -r -D /tmp/enchant-dev-$VER.zip share/man
zip /tmp/enchant-dev-$VER.zip lib/pkgconfig/enchant.pc
) &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip
