/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.LEFDEF;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Iterator;

public class DEF
extends LEFDEF {
    private String lineBuffer;
    private int lineBufferPosition;
    private double scaleUnits;
    private LEFDEF.ViaDef firstViaDef;

    protected boolean importALibrary(Library lib) {
        this.lineBufferPosition = 0;
        this.lineBuffer = "";
        this.scaleUnits = 1000.0;
        this.firstViaDef = null;
        try {
            boolean ret = this.readFile(lib);
        }
        catch (IOException e) {
            System.out.println("ERROR reading DEF libraries");
        }
        return false;
    }

    private String getKeyword() throws IOException {
        char chr;
        while (true) {
            char chr2;
            if (this.lineBuffer == null) {
                return null;
            }
            if (this.lineBufferPosition >= this.lineBuffer.length()) {
                this.lineBuffer = this.lineReader.readLine();
                this.lineBufferPosition = 0;
                continue;
            }
            while (this.lineBufferPosition < this.lineBuffer.length() && ((chr2 = this.lineBuffer.charAt(this.lineBufferPosition)) == ' ' || chr2 == '\t')) {
                ++this.lineBufferPosition;
            }
            if (this.lineBufferPosition < this.lineBuffer.length()) break;
        }
        int start = this.lineBufferPosition;
        while (this.lineBufferPosition < this.lineBuffer.length() && (chr = this.lineBuffer.charAt(this.lineBufferPosition)) != ' ' && chr != '\t') {
            ++this.lineBufferPosition;
        }
        return this.lineBuffer.substring(start, this.lineBufferPosition);
    }

    private boolean ignoreToSemicolon(String command) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command)) != null) continue;
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private String mustGetKeyword(String where) throws IOException {
        String key = this.getKeyword();
        if (key == null) {
            this.reportError("EOF parsing " + where);
        }
        return key;
    }

    private double convertDEFString(String key) {
        double v = TextUtils.atof(key) / this.scaleUnits / 2.0;
        return TextUtils.convertFromDistance(v, Technology.getCurrent(), TextUtils.UnitScale.MICRO);
    }

    private void reportError(String command) {
        System.out.println("File " + this.filePath + ", line " + this.lineReader.getLineNumber() + ": " + command);
    }

    private boolean readFile(Library lib) throws IOException {
        String key;
        Cell cell = null;
        while ((key = this.getKeyword()) != null) {
            if (key.equalsIgnoreCase("VERSION") || key.equalsIgnoreCase("NAMESCASESENSITIVE") || key.equalsIgnoreCase("DIVIDERCHAR") || key.equalsIgnoreCase("BUSBITCHARS") || key.equalsIgnoreCase("DIEAREA") || key.equalsIgnoreCase("ROW") || key.equalsIgnoreCase("TRACKS") || key.equalsIgnoreCase("GCELLGRID") || key.equalsIgnoreCase("HISTORY") || key.equalsIgnoreCase("TECHNOLOGY")) {
                if (!this.ignoreToSemicolon(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DEFAULTCAP") || key.equalsIgnoreCase("REGIONS")) {
                if (!this.ignoreBlock(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DESIGN")) {
                String cellName = this.mustGetKeyword("DESIGN");
                if (cellName == null) {
                    return true;
                }
                cell = Cell.makeInstance(lib, cellName);
                if (cell == null) {
                    this.reportError("Cannot create cell '" + cellName + "'");
                    return true;
                }
                if (!this.ignoreToSemicolon("DESIGN")) continue;
                return true;
            }
            if (key.equalsIgnoreCase("UNITS")) {
                if (!this.readUnits()) continue;
                return true;
            }
            if (key.equalsIgnoreCase("PROPERTYDEFINITIONS")) {
                if (!this.readPropertyDefinitions()) continue;
                return true;
            }
            if (key.equalsIgnoreCase("VIAS")) {
                if (!this.readVias(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("COMPONENTS")) {
                if (!this.readComponents(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("PINS")) {
                if (!this.readPins(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("SPECIALNETS")) {
                if (!this.readNets(cell, true)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("NETS")) {
                if (!this.readNets(cell, false)) continue;
                return true;
            }
            if (!key.equalsIgnoreCase("END")) continue;
            key = this.getKeyword();
            break;
        }
        return false;
    }

    private boolean ignoreBlock(String command) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command)) != null) continue;
            return true;
        } while (!key.equalsIgnoreCase("END"));
        this.getKeyword();
        return false;
    }

    private Point2D readCoordinate() throws IOException {
        String key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        if (!key.equals("(")) {
            this.reportError("Expected '(' in coordinate");
            return null;
        }
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        double x = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        double y = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        if (!key.equals(")")) {
            this.reportError("Expected ')' in coordinate");
            return null;
        }
        return new Point2D.Double(x, y);
    }

    private Cell getNodeProto(String name, Library curlib) {
        Cell cell = curlib.findNodeProto(name);
        if (cell != null) {
            return cell;
        }
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || lib == curlib || (cell = lib.findNodeProto(name)) == null) continue;
            return cell;
        }
        return null;
    }

    private PortInst findConnection(double x, double y, ArcProto ap, Cell cell, NodeInst noti) {
        Rectangle2D.Double bound = new Rectangle2D.Double(x, y, 0.0, 0.0);
        Point2D.Double pt = new Point2D.Double(x, y);
        Geometric.Search sea = new Geometric.Search(bound, cell);
        while (sea.hasNext()) {
            NodeInst ni;
            Geometric geom = (Geometric)sea.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom) == noti) continue;
            Iterator it = ni.getPortInsts();
            while (it.hasNext()) {
                Poly poly;
                PortInst pi = (PortInst)it.next();
                if (!pi.getPortProto().connectsTo(ap) || !(poly = pi.getPoly()).isInside(pt)) continue;
                return pi;
            }
        }
        return null;
    }

    private PortInst getPin(double x, double y, ArcProto ap, Cell cell) {
        double sY;
        double sX;
        PortInst pi = this.findConnection(x, y, ap, cell, null);
        if (pi != null) {
            return pi;
        }
        PrimitiveNode pin = ((PrimitiveArc)ap).findPinProto();
        NodeInst ni = NodeInst.makeInstance(pin, new Point2D.Double(x, y), sX = pin.getDefWidth(), sY = pin.getDefHeight(), cell);
        if (ni == null) {
            this.reportError("Unable to create net pin");
            return null;
        }
        return ni.getOnlyPortInst();
    }

    private boolean readPins(Cell cell) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("PINS")) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("PINs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readPin(cell)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean readPin(Cell cell) throws IOException {
        String key = this.mustGetKeyword("PIN");
        if (key == null) {
            return true;
        }
        String pinName = key;
        PortCharacteristic portCharacteristic = null;
        NodeProto np = null;
        Point2D ll = null;
        Point2D ur = null;
        Point2D xy = null;
        boolean haveCoord = false;
        GetOrientation orient = null;
        while (true) {
            if ((key = this.mustGetKeyword("PIN")) == null) {
                return true;
            }
            if (key.equals("+")) {
                key = this.mustGetKeyword("PIN");
                if (key == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("NET")) {
                    key = this.mustGetKeyword("net name");
                    if (key != null) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("DIRECTION")) {
                    key = this.mustGetKeyword("DIRECTION");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("INPUT")) {
                        portCharacteristic = PortCharacteristic.IN;
                        continue;
                    }
                    if (key.equalsIgnoreCase("OUTPUT")) {
                        portCharacteristic = PortCharacteristic.OUT;
                        continue;
                    }
                    if (key.equalsIgnoreCase("INOUT")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("FEEDTHRU")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    this.reportError("Unknown direction (" + key + ")");
                    return true;
                }
                if (key.equalsIgnoreCase("USE")) {
                    key = this.mustGetKeyword("USE");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("SIGNAL")) continue;
                    if (key.equalsIgnoreCase("POWER")) {
                        portCharacteristic = PortCharacteristic.PWR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("GROUND")) {
                        portCharacteristic = PortCharacteristic.GND;
                        continue;
                    }
                    if (key.equalsIgnoreCase("CLOCK")) {
                        portCharacteristic = PortCharacteristic.CLK;
                        continue;
                    }
                    if (key.equalsIgnoreCase("TIEOFF") || key.equalsIgnoreCase("ANALOG")) continue;
                    this.reportError("Unknown usage (" + key + ")");
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.mustGetKeyword("LAYER");
                    if (key == null) {
                        return true;
                    }
                    LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown layer (" + key + ")");
                        return true;
                    }
                    np = li.pin;
                    ll = this.readCoordinate();
                    if (ll == null) {
                        return true;
                    }
                    ur = this.readCoordinate();
                    if (ur != null) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED")) continue;
                xy = this.readCoordinate();
                if (xy == null) {
                    return true;
                }
                orient = new GetOrientation();
                haveCoord = true;
                continue;
            }
            if (key.equals(";")) break;
        }
        if (np != null && haveCoord) {
            AffineTransform trans = NodeInst.pureRotate(orient.angle, orient.mX, orient.mY);
            trans.transform(ll, ll);
            trans.transform(ur, ur);
            double sX = Math.abs(ll.getX() - ur.getX());
            double sY = Math.abs(ll.getY() - ur.getY());
            double cX = (ll.getX() + ur.getX()) / 2.0 + xy.getX();
            double cY = (ll.getY() + ur.getY()) / 2.0 + xy.getY();
            NodeInst ni = NodeInst.makeInstance(np, new Point2D.Double(cX, cY), sX, sY, cell);
            if (ni == null) {
                this.reportError("Unable to create pin");
                return true;
            }
            PortInst pi = ni.findPortInstFromProto(np.getPort(0));
            Export e = Export.newInstance(cell, pi, pinName);
            if (e == null) {
                this.reportError("Unable to create pin name");
                return true;
            }
            e.setCharacteristic(portCharacteristic);
        }
        return false;
    }

    private boolean readComponents(Cell cell) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("COMPONENTS")) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("COMPONENTs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readComponent(cell)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean readComponent(Cell cell) throws IOException {
        String key = this.mustGetKeyword("COMPONENT");
        if (key == null) {
            return true;
        }
        String compName = key;
        key = this.mustGetKeyword("COMPONENT");
        if (key == null) {
            return true;
        }
        String modelName = key;
        Cell np = this.getNodeProto(modelName, cell.getLibrary());
        if (np == null) {
            this.reportError("Unknown cell (" + modelName + ")");
            return true;
        }
        while (true) {
            if ((key = this.mustGetKeyword("COMPONENT")) == null) {
                return true;
            }
            if (key.equals("+")) {
                NodeInst ni;
                key = this.mustGetKeyword("COMPONENT");
                if (key == null) {
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED") && !key.equalsIgnoreCase("FIXED")) continue;
                Point2D pt = this.readCoordinate();
                if (pt == null) {
                    return true;
                }
                GetOrientation or = new GetOrientation();
                double sX = np.getDefWidth();
                double sY = np.getDefHeight();
                if (or.mX) {
                    sX = -sX;
                }
                if (or.mY) {
                    sY = -sY;
                }
                if ((ni = NodeInst.makeInstance(np, pt, sX, sY, cell, or.angle, compName, 0)) != null) continue;
                this.reportError("Unable to create node");
                return true;
            }
            if (key.equals(";")) break;
        }
        return false;
    }

    private boolean readNets(Cell cell, boolean special) throws IOException {
        String key;
        block3: {
            while (true) {
                if ((key = this.mustGetKeyword("NETs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readNet(cell, special)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block3;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean readNet(Cell cell, boolean special) throws IOException {
        String key = this.mustGetKeyword("NET");
        if (key == null) {
            return true;
        }
        key = this.mustGetKeyword("NET");
        if (key == null) {
            return true;
        }
        boolean wantPinPairs = true;
        double lastX = 0.0;
        double lastY = 0.0;
        double curX = 0.0;
        double curY = 0.0;
        double specialWidth = 0.0;
        boolean pathStart = true;
        PortInst lastLogPi = null;
        PortInst lastPi = null;
        LEFDEF.GetLayerInformation li = null;
        while (!key.equals(";")) {
            ArcInst ai;
            PortInst nextPi;
            NodeInst ni;
            if (key.equals("+")) {
                wantPinPairs = false;
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("USE")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                } else if (key.equalsIgnoreCase("ROUTED")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    li = new LEFDEF.GetLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown layer (" + key + ")");
                        return true;
                    }
                    pathStart = true;
                    if (special) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        specialWidth = this.convertDEFString(key);
                    }
                } else if (key.equalsIgnoreCase("FIXED")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    li = new LEFDEF.GetLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown layer (" + key + ")");
                        return true;
                    }
                    pathStart = true;
                } else if (key.equalsIgnoreCase("SHAPE")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                } else {
                    this.reportError("Cannot handle '" + key + "' nets");
                    return true;
                }
                if ((key = this.mustGetKeyword("NET")) != null) continue;
                return true;
            }
            if (wantPinPairs) {
                PrimitiveArc ap;
                ArcInst ai2;
                if (!key.equals("(")) {
                    this.reportError("Expected '(' of pin pair");
                    return true;
                }
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                PortInst pi = null;
                if (key.equalsIgnoreCase("PIN")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    Export pp = (Export)cell.findPortProto(key);
                    if (pp == null) {
                        this.reportError("Warning: unknown pin '" + key + "'");
                        return this.ignoreToSemicolon("NETS");
                    }
                    pi = pp.getOriginalPort();
                } else {
                    NodeInst found = null;
                    Iterator it = cell.getNodes();
                    while (it.hasNext()) {
                        NodeInst ni2 = (NodeInst)it.next();
                        if (!ni2.getName().equalsIgnoreCase(key)) continue;
                        found = ni2;
                        break;
                    }
                    if (found == null) {
                        this.reportError("Unknown component '" + key + "'");
                        return true;
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    PortProto pp = found.getProto().findPortProto(key);
                    if (pp == null) {
                        this.reportError("Unknown port '" + key + "' on component '" + found.describe() + "'");
                        return true;
                    }
                    pi = found.findPortInstFromProto(pp);
                }
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (!key.equals(")")) {
                    this.reportError("Expected ')' of pin pair");
                    return true;
                }
                if (lastLogPi != null && IOTool.isDEFLogicalPlacement() && (ai2 = ArcInst.makeInstance(ap = Generic.tech.unrouted_arc, ap.getDefaultWidth(), pi, lastLogPi)) == null) {
                    this.reportError("Could not create unrouted arc");
                    return true;
                }
                lastLogPi = pi;
                key = this.mustGetKeyword("NET");
                if (key != null) continue;
                return true;
            }
            if (key.equalsIgnoreCase("NEW")) {
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                li = new LEFDEF.GetLayerInformation(key);
                if (li.pin == null) {
                    this.reportError("Unknown layer (" + key + ")");
                    return true;
                }
                pathStart = true;
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (!special) continue;
                specialWidth = this.convertDEFString(key);
                key = this.mustGetKeyword("NET");
                if (key != null) continue;
                return true;
            }
            boolean foundCoord = false;
            if (key.equals("(")) {
                foundCoord = true;
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                curX = key.equals("*") ? lastX : this.convertDEFString(key);
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                curY = key.equals("*") ? lastY : this.convertDEFString(key);
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (!key.equals(")")) {
                    this.reportError("Expected ')' of coordinate pair");
                    return true;
                }
            }
            if ((key = this.mustGetKeyword("NET")) == null) {
                return true;
            }
            LEFDEF.ViaDef vd = null;
            vd = this.firstViaDef;
            while (vd != null && !key.equalsIgnoreCase(vd.viaName)) {
                vd = vd.nextViaDef;
            }
            if (vd == null) {
                vd = firstViaDefFromLEF;
                while (vd != null && !key.equalsIgnoreCase(vd.viaName)) {
                    vd = vd.nextViaDef;
                }
            }
            if (!IOTool.isDEFPhysicalPlacement()) {
                if (vd == null || (key = this.mustGetKeyword("NET")) != null) continue;
                return true;
            }
            PortInst pi = null;
            boolean placedVia = false;
            if (vd != null) {
                SizeOffset so;
                double sX = vd.sX;
                double sY = vd.sY;
                if (vd.via == null) {
                    this.reportError("Cannot to create via");
                    return true;
                }
                if (pathStart) {
                    lastPi = this.findConnection(curX, curY, li.arc, cell, null);
                }
                if ((ni = NodeInst.makeInstance(vd.via, new Point2D.Double(curX, curY), sX += (so = vd.via.getProtoSizeOffset()).getLowXOffset() + so.getHighXOffset(), sY += so.getLowYOffset() + so.getHighYOffset(), cell)) == null) {
                    this.reportError("Unable to create via layer");
                    return true;
                }
                pi = ni.getOnlyPortInst();
                if (pathStart && lastPi != null && foundCoord) {
                    double width = li.arc.getDefaultWidth();
                    if (special) {
                        width = specialWidth;
                    } else {
                        Double wid = (Double)widthsFromLEF.get(li.arc);
                        if (wid != null) {
                            width = wid;
                        }
                    }
                    ArcInst ai3 = ArcInst.makeInstance(li.arc, width, lastPi, pi);
                    if (ai3 == null) {
                        this.reportError("Unable to create net starting point");
                        return true;
                    }
                }
                placedVia = true;
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
            } else {
                pi = this.getPin(curX, curY, li.arc, cell);
                if (pi == null) {
                    return true;
                }
            }
            if (!foundCoord) continue;
            if (!pathStart) {
                if (!pi.getPortProto().connectsTo(li.arc)) {
                    double sY;
                    double sX;
                    PrimitiveNode np = ((PrimitiveArc)li.arc).findPinProto();
                    ni = NodeInst.makeInstance(np, new Point2D.Double(curX, curY), sX = np.getDefWidth(), sY = np.getDefHeight(), cell);
                    if (ni == null) {
                        this.reportError("Unable to create net pin");
                        return true;
                    }
                    pi = ni.getOnlyPortInst();
                }
                double width = li.arc.getDefaultWidth();
                if (special) {
                    width = specialWidth;
                } else {
                    Double wid = (Double)widthsFromLEF.get(li.arc);
                    if (wid != null) {
                        width = wid;
                    }
                }
                ArcInst ai4 = ArcInst.makeInstance(li.arc, width, lastPi, pi);
                if (ai4 == null) {
                    this.reportError("Unable to create net path");
                    return true;
                }
            }
            lastX = curX;
            lastY = curY;
            pathStart = false;
            lastPi = pi;
            if (placedVia) {
                if (li.arc == vd.lay1) {
                    li.arc = vd.lay2;
                } else if (li.arc == vd.lay2) {
                    li.arc = vd.lay1;
                }
                li.pin = ((PrimitiveArc)li.arc).findPinProto();
            }
            if (!key.equalsIgnoreCase("NEW") && !key.equals(";") || (nextPi = this.findConnection(curX, curY, li.arc, cell, pi.getNodeInst())) == null) continue;
            double width = li.arc.getDefaultWidth();
            if (special) {
                width = specialWidth;
            } else {
                Double wid = (Double)widthsFromLEF.get(li.arc);
                if (wid != null) {
                    width = wid;
                }
            }
            if ((ai = ArcInst.makeInstance(li.arc, width, pi, nextPi)) != null) continue;
            this.reportError("Unable to create net ending point");
            return true;
        }
        return false;
    }

    private boolean readVias(Cell cell) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("VIAS")) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("VIAs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readVia()) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean readVia() throws IOException {
        String key = this.mustGetKeyword("VIA");
        if (key == null) {
            return true;
        }
        LEFDEF.ViaDef vd = new LEFDEF.ViaDef();
        vd.viaName = key;
        vd.sY = 0.0;
        vd.sX = 0.0;
        vd.via = null;
        vd.lay2 = null;
        vd.lay1 = null;
        vd.nextViaDef = this.firstViaDef;
        this.firstViaDef = vd;
        while (true) {
            if ((key = this.mustGetKeyword("VIA")) == null) {
                return true;
            }
            if (key.equals("+")) {
                Point2D ll;
                key = this.mustGetKeyword("VIA");
                if (key == null) {
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.mustGetKeyword("VIA");
                if (key == null) {
                    return true;
                }
                LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                if (li.pure == null) {
                    this.reportError("Layer " + key + " not in current technology");
                }
                if (key.startsWith("VIA")) {
                    if (li.pin == null) {
                        li.pin = Generic.tech.universalPinNode;
                    }
                    vd.via = li.pin;
                }
                if (key.startsWith("METAL")) {
                    if (li.arc == null) {
                        li.arc = Generic.tech.universal_arc;
                    }
                    if (vd.lay1 == null) {
                        vd.lay1 = li.arc;
                    } else {
                        vd.lay2 = li.arc;
                    }
                }
                if ((ll = this.readCoordinate()) == null) {
                    return true;
                }
                Point2D ur = this.readCoordinate();
                if (ur == null) {
                    return true;
                }
                if (ur.getX() - ll.getX() > vd.sX) {
                    vd.sX = ur.getX() - ll.getX();
                }
                if (!(ur.getY() - ll.getY() > vd.sY)) continue;
                vd.sY = ur.getY() - ll.getY();
                continue;
            }
            if (key.equals(";")) break;
        }
        if (vd.via != null) {
            if (vd.sX == 0.0) {
                vd.sX = vd.via.getDefWidth();
            }
            if (vd.sY == 0.0) {
                vd.sY = vd.via.getDefHeight();
            }
        }
        return false;
    }

    private boolean readPropertyDefinitions() throws IOException {
        String key;
        block2: {
            do {
                if ((key = this.mustGetKeyword("PROPERTYDEFINITION")) == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block2;
            } while (!this.ignoreToSemicolon(key));
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean readUnits() throws IOException {
        String key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("DISTANCE")) {
            this.reportError("Expected 'DISTANCE' after 'UNITS'");
            return true;
        }
        key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("MICRONS")) {
            this.reportError("Expected 'MICRONS' after 'UNITS'");
            return true;
        }
        key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        this.scaleUnits = TextUtils.atof(key);
        return this.ignoreToSemicolon("UNITS");
    }

    private class GetOrientation {
        private int angle;
        private boolean mX;
        private boolean mY;

        private GetOrientation() throws IOException {
            String key = DEF.this.mustGetKeyword("orientation");
            if (key == null) {
                return;
            }
            boolean transpose = false;
            if (key.equalsIgnoreCase("N")) {
                this.angle = 0;
            } else if (key.equalsIgnoreCase("S")) {
                this.angle = 1800;
            } else if (key.equalsIgnoreCase("E")) {
                this.angle = 2700;
            } else if (key.equalsIgnoreCase("W")) {
                this.angle = 900;
            } else if (key.equalsIgnoreCase("FN")) {
                this.angle = 900;
                transpose = true;
            } else if (key.equalsIgnoreCase("FS")) {
                this.angle = 2700;
                transpose = true;
            } else if (key.equalsIgnoreCase("FE")) {
                this.angle = 1800;
                transpose = true;
            } else if (key.equalsIgnoreCase("FW")) {
                this.angle = 0;
                transpose = true;
            } else {
                DEF.this.reportError("Unknown orientation (" + key + ")");
                return;
            }
            NodeInst.OldStyleTransform ost = new NodeInst.OldStyleTransform(this.angle, transpose);
            this.angle = ost.getJAngle();
            this.mX = ost.isJMirrorX();
            this.mY = ost.isJMirrorY();
        }
    }
}

