/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ViewControl
extends EDialog {
    private DefaultListModel listModel;
    private JList list;
    private View currentView;
    private JTextField abbreviation;
    private JButton create;
    private JButton delete;
    private JButton done;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane listPane;
    private JTextField name;
    private JCheckBox textView;

    public ViewControl(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.listPane.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ViewControl.this.viewListClick();
            }
        });
        this.loadViews();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.done(null);
    }

    private void viewListClick() {
        String viewLine = (String)this.list.getSelectedValue();
        int curlyPos = viewLine.indexOf(123);
        if (curlyPos >= 0) {
            viewLine = viewLine.substring(0, curlyPos - 1);
        }
        this.currentView = View.findView(viewLine);
        if (this.currentView != null) {
            this.name.setText(this.currentView.getFullName());
            this.abbreviation.setText(this.currentView.getAbbreviation());
            this.textView.setSelected(this.currentView.isTextView());
            this.delete.setEnabled(!this.currentView.isPermanentView());
        }
    }

    private void loadViews() {
        this.listModel.clear();
        List views = View.getOrderedViews();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            View v = (View)it.next();
            this.listModel.addElement(v.getFullName() + " {" + v.getAbbreviation() + "}");
        }
        this.list.setSelectedIndex(0);
        this.viewListClick();
    }

    private void initComponents() {
        this.done = new JButton();
        this.jLabel1 = new JLabel();
        this.listPane = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.name = new JTextField();
        this.jLabel3 = new JLabel();
        this.abbreviation = new JTextField();
        this.textView = new JCheckBox();
        this.create = new JButton();
        this.delete = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("View Control");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ViewControl.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewControl.this.done(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.jLabel1.setText("Views:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(300, 200));
        this.listPane.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.jLabel2.setText("View name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.name.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.name, gridBagConstraints);
        this.jLabel3.setText("Abbreviation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.abbreviation.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.abbreviation, gridBagConstraints);
        this.textView.setText("Text view");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textView, gridBagConstraints);
        this.create.setText("Create");
        this.create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewControl.this.createActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.create, gridBagConstraints);
        this.delete.setText("Delete");
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewControl.this.deleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.delete, gridBagConstraints);
        this.pack();
    }

    private void createActionPerformed(ActionEvent evt) {
        String viewName = this.name.getText();
        String viewAbbr = this.abbreviation.getText();
        boolean isText = this.textView.isSelected();
        CreateView job = new CreateView(viewName, viewAbbr, isText, this);
    }

    private void deleteActionPerformed(ActionEvent evt) {
        if (this.currentView == null) {
            return;
        }
        DeleteView job = new DeleteView(this.currentView, this);
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class CreateView
    extends Job {
        String viewName;
        String viewAbbr;
        boolean isText;
        ViewControl dialog;

        protected CreateView(String viewName, String viewAbbr, boolean isText, ViewControl dialog) {
            super("Create View " + viewName, User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.viewName = viewName;
            this.viewAbbr = viewAbbr;
            this.isText = isText;
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            View newView = null;
            newView = this.isText ? View.newTextInstance(this.viewName, this.viewAbbr) : View.newInstance(this.viewName, this.viewAbbr);
            this.dialog.loadViews();
            return true;
        }
    }

    private static class DeleteView
    extends Job {
        View view;
        ViewControl dialog;

        protected DeleteView(View view, ViewControl dialog) {
            super("Delete View " + view.getFullName(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.view = view;
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            this.view.kill();
            this.dialog.loadViews();
            return true;
        }
    }
}

