/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.change;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class Undo {
    private static Type broadcasting = null;
    private static boolean doChangesQuietly = false;
    private static ChangeBatch currentBatch = null;
    private static int maximumBatches = User.getMaxUndoHistory();
    private static int overallBatchNumber = 0;
    private static List doneList = new ArrayList();
    private static List undoneList = new ArrayList();
    private static HashSet changedCells = new HashSet();
    private static List changeListeners = new ArrayList();
    private static List propertyChangeListeners = new ArrayList();
    public static final String propUndoEnabled = "UndoEnabled";
    public static final String propRedoEnabled = "RedoEnabled";
    private static boolean undoEnabled = false;
    private static boolean redoEnabled = false;
    static /* synthetic */ Class class$com$sun$electric$database$change$Undo;

    public static void startChanges(Tool tool, String activity, Cell cell, List startingHighlights, Point2D startingHighlightsOffset) {
        Undo.endChanges();
        Undo.noRedoAllowed();
        changedCells.clear();
        currentBatch = new ChangeBatch();
        currentBatch.changes = new ArrayList();
        currentBatch.batchNumber = ++Undo.overallBatchNumber;
        currentBatch.activity = activity;
        currentBatch.upCell = cell;
        currentBatch.startingHighlights = startingHighlights;
        currentBatch.startHighlightsOffset = startingHighlightsOffset;
        doneList.add(currentBatch);
        Undo.setUndoEnabled(true);
        if (doneList.size() > maximumBatches) {
            doneList.remove(0);
        }
        Constraints.getCurrent().startBatch(tool, false);
        Iterator it = Tool.getListeners();
        while (it.hasNext()) {
            Listener listener = (Listener)it.next();
            listener.startBatch(tool, false);
        }
    }

    public static void endChanges() {
        if (currentBatch == null) {
            return;
        }
        if (currentBatch.changes.size() == 0) {
            doneList.remove(currentBatch);
            if (doneList.size() == 0) {
                Undo.setUndoEnabled(false);
            }
        }
        Constraints.getCurrent().endBatch();
        Iterator it = Tool.getListeners();
        while (it.hasNext()) {
            Listener listener = (Listener)it.next();
            listener.endBatch();
        }
        Undo.fireEndChangeBatch(currentBatch);
        currentBatch = null;
    }

    public static Iterator getChangedCells() {
        return changedCells.iterator();
    }

    public static synchronized void addDatabaseChangeListener(DatabaseChangeListener l) {
        changeListeners.add(l);
    }

    public static synchronized void removeDatabaseChangeListener(DatabaseChangeListener l) {
        changeListeners.remove(l);
    }

    private static synchronized void fireEndChangeBatch(ChangeBatch batch) {
        DatabaseChangeEvent event = new DatabaseChangeEvent(batch);
        Iterator it = changeListeners.iterator();
        while (it.hasNext()) {
            DatabaseChangeListener l = (DatabaseChangeListener)it.next();
            SwingUtilities.invokeLater(new DatabaseChangeRun(l, event));
        }
    }

    public static synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeListeners.add(l);
    }

    public static synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeListeners.remove(l);
    }

    private static synchronized void firePropertyChange(String prop, boolean oldValue, boolean newValue) {
        Iterator it = propertyChangeListeners.iterator();
        while (it.hasNext()) {
            PropertyChangeListener l = (PropertyChangeListener)it.next();
            PropertyChangeEvent e = new PropertyChangeEvent(class$com$sun$electric$database$change$Undo == null ? Undo.class$("com.sun.electric.database.change.Undo") : class$com$sun$electric$database$change$Undo, prop, new Boolean(oldValue), new Boolean(newValue));
            SwingUtilities.invokeLater(new PropertyChangeThread(l, e));
        }
    }

    private static synchronized void setUndoEnabled(boolean enabled) {
        if (enabled != undoEnabled) {
            Undo.firePropertyChange(propUndoEnabled, undoEnabled, enabled);
            undoEnabled = enabled;
        }
    }

    private static synchronized void setRedoEnabled(boolean enabled) {
        if (enabled != redoEnabled) {
            Undo.firePropertyChange(propRedoEnabled, redoEnabled, enabled);
            redoEnabled = enabled;
        }
    }

    public static synchronized boolean getUndoEnabled() {
        return undoEnabled;
    }

    public static synchronized boolean getRedoEnabled() {
        return redoEnabled;
    }

    private static Change newChange(ElectricObject obj, Type change, Object o1) {
        if (currentBatch == null) {
            System.out.println("Received " + change + " change when no batch started");
            return null;
        }
        if (broadcasting != null) {
            System.out.println("Received " + change + " change during broadcast of " + broadcasting);
            return null;
        }
        Change.setDirty(change, obj, o1);
        Change ch = new Change(obj, change);
        ch.o1 = o1;
        Undo.currentBatch.add(ch);
        return ch;
    }

    public static void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(ni, Type.NODEINSTMOD, null);
        if (ch == null) {
            return;
        }
        ch.setDoubles(oCX, oCY, oSX, oSY);
        ch.i1 = oRot;
        ni.setChange(ch);
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
    }

    public static void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(ai, Type.ARCINSTMOD, null);
        if (ch == null) {
            return;
        }
        ch.setDoubles(oHX, oHY, oTX, oTY);
        ch.a5 = oWid;
        ai.setChange(ch);
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
    }

    public static void modifyExport(Export pp, PortInst oldPi) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(pp, Type.EXPORTMOD, oldPi);
        if (ch == null) {
            return;
        }
        pp.setChange(ch);
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().modifyExport(pp, oldPi);
    }

    public static void modifyCell(Cell cell, double oLX, double oHX, double oLY, double oHY) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(cell, Type.CELLMOD, null);
        if (ch == null) {
            return;
        }
        ch.setDoubles(oLX, oHX, oLY, oHY);
        cell.setChange(ch);
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
    }

    public static void modifyCellGroup(Cell cell, Cell.CellGroup oldGroup) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(cell, Type.CELLGROUPMOD, oldGroup);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
    }

    public static void modifyTextDescript(ElectricObject obj, String varName, ImmutableTextDescriptor oldDescriptor) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(obj, Type.DESCRIPTORMOD, varName);
        if (ch == null) {
            return;
        }
        ch.o2 = oldDescriptor;
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().modifyTextDescript(obj, varName, oldDescriptor);
    }

    public static void newObject(ElectricObject obj) {
        if (!Undo.recordChange()) {
            return;
        }
        Cell cell = obj.whichCell();
        if (cell != null) {
            cell.checkInvariants();
        }
        Type type = Type.OBJECTNEW;
        if (obj instanceof Cell) {
            type = Type.CELLNEW;
        } else if (obj instanceof NodeInst) {
            type = Type.NODEINSTNEW;
        } else if (obj instanceof ArcInst) {
            type = Type.ARCINSTNEW;
        } else if (obj instanceof Export) {
            type = Type.EXPORTNEW;
        } else if (obj instanceof Library) {
            type = Type.LIBRARYNEW;
        }
        Change ch = Undo.newChange(obj, type, null);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().newObject(obj);
    }

    public static void killObject(ElectricObject obj) {
        if (!Undo.recordChange()) {
            return;
        }
        Type type = Type.OBJECTKILL;
        if (obj instanceof Cell) {
            type = Type.CELLKILL;
        } else if (obj instanceof NodeInst) {
            type = Type.NODEINSTKILL;
        } else if (obj instanceof ArcInst) {
            type = Type.ARCINSTKILL;
        } else if (obj instanceof Library) {
            type = Type.LIBRARYKILL;
        }
        Change ch = Undo.newChange(obj, type, null);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().killObject(obj);
    }

    public static void killExport(Export pp, Collection oldPortInsts) {
        if (!Undo.recordChange()) {
            return;
        }
        Type type = Type.EXPORTKILL;
        Change ch = Undo.newChange(pp, type, oldPortInsts);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().killExport(pp, oldPortInsts);
    }

    public static void renameObject(ElectricObject obj, Object oldName) {
        if (!Undo.recordChange()) {
            return;
        }
        Type type = Type.OBJECTRENAME;
        Change ch = Undo.newChange(obj, type, oldName);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().renameObject(obj, oldName);
    }

    public static void renameGeometric(Geometric obj, Object oldName, int oldDuplicate) {
        if (!Undo.recordChange()) {
            return;
        }
        Type type = Type.OBJECTRENAME;
        Change ch = Undo.newChange(obj, type, oldName);
        if (ch == null) {
            return;
        }
        ch.i1 = oldDuplicate;
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().renameObject(obj, oldName);
    }

    public static void redrawObject(ElectricObject obj) {
        if (!Undo.recordChange()) {
            return;
        }
        Type type = Type.OBJECTREDRAW;
        Change ch = Undo.newChange(obj, type, null);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
    }

    public static void newVariable(ElectricObject obj, Variable var) {
        if (!Undo.recordChange()) {
            return;
        }
        Type type = Type.VARIABLENEW;
        Change ch = Undo.newChange(obj, type, var);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().newVariable(obj, var);
    }

    public static void killVariable(ElectricObject obj, Variable var) {
        if (!Undo.recordChange()) {
            return;
        }
        Type type = Type.VARIABLEKILL;
        Change ch = Undo.newChange(obj, type, var);
        if (ch == null) {
            return;
        }
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().killVariable(obj, var);
    }

    public static void modifyVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(obj, Type.VARIABLEMOD, var);
        if (ch == null) {
            return;
        }
        ch.i1 = index;
        ch.o2 = oldValue;
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().modifyVariable(obj, var, index, oldValue);
    }

    public static void insertVariable(ElectricObject obj, Variable var, int index) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(obj, Type.VARIABLEINSERT, var);
        if (ch == null) {
            return;
        }
        ch.i1 = index;
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().insertVariable(obj, var, index);
    }

    public static void deleteVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(obj, Type.VARIABLEDELETE, var);
        if (ch == null) {
            return;
        }
        ch.i1 = index;
        ch.o2 = oldValue;
        ch.broadcast(Undo.currentBatch.getNumChanges() <= 1, false);
        Constraints.getCurrent().deleteVariable(obj, var, index, oldValue);
    }

    public static void otherChange(ElectricObject obj) {
        if (!Undo.recordChange()) {
            return;
        }
        Change ch = Undo.newChange(obj, Type.OTHERCHANGE, null);
        if (ch == null) {
            return;
        }
    }

    public static ChangeBatch getCurrentBatch() {
        return currentBatch;
    }

    public static boolean changesQuiet(boolean quiet) {
        Library.checkInvariants();
        NetworkTool.changesQuiet(quiet);
        boolean formerQuiet = doChangesQuietly;
        doChangesQuietly = quiet;
        return formerQuiet;
    }

    public static boolean recordChange() {
        if (currentBatch == null) {
            return false;
        }
        return !doChangesQuietly;
    }

    public static ChangeBatch undoABatch() {
        ArrayList savedHighlights = new ArrayList();
        Point2D offset = new Point2D.Double(0.0, 0.0);
        EditWindow wnd = EditWindow.getCurrent();
        Highlighter highlighter = null;
        if (wnd != null) {
            highlighter = wnd.getHighlighter();
            Iterator it = highlighter.getHighlights().iterator();
            while (it.hasNext()) {
                savedHighlights.add(it.next());
            }
            offset = highlighter.getHighlightOffset();
            highlighter.clear();
            highlighter.finished();
        }
        Undo.endChanges();
        int listSize = doneList.size();
        if (listSize == 0) {
            return null;
        }
        ChangeBatch batch = (ChangeBatch)doneList.get(listSize - 1);
        doneList.remove(listSize - 1);
        undoneList.add(batch);
        if (doneList.size() == 0) {
            Undo.setUndoEnabled(false);
        }
        Undo.setRedoEnabled(true);
        batch.preUndoHighlights = savedHighlights;
        batch.preUndoHighlightsOffset = offset;
        boolean firstChange = true;
        int batchSize = batch.changes.size();
        for (int i = batchSize - 1; i >= 0; --i) {
            Change ch = (Change)batch.changes.get(i);
            ch.reverse(true);
            ch.broadcast(firstChange, true);
            firstChange = false;
        }
        Iterator it = Tool.getListeners();
        while (it.hasNext()) {
            Listener listener = (Listener)it.next();
            listener.endBatch();
        }
        Undo.fireEndChangeBatch(batch);
        ArrayList highlights = new ArrayList();
        Iterator it2 = batch.startingHighlights.iterator();
        while (it2.hasNext()) {
            highlights.add(it2.next());
        }
        if (highlighter != null) {
            highlighter.setHighlightList(highlights);
            if (batch.startHighlightsOffset != null) {
                highlighter.setHighlightOffset((int)batch.startHighlightsOffset.getX(), (int)batch.startHighlightsOffset.getY());
            }
            highlighter.finished();
        }
        return batch;
    }

    public static boolean redoABatch() {
        EditWindow wnd = EditWindow.getCurrent();
        Highlighter highlighter = null;
        if (wnd != null) {
            highlighter = wnd.getHighlighter();
        }
        if (highlighter != null) {
            highlighter.clear();
            highlighter.finished();
        }
        Undo.endChanges();
        if (undoneList == null) {
            return false;
        }
        int listSize = undoneList.size();
        if (listSize == 0) {
            return false;
        }
        ChangeBatch batch = (ChangeBatch)undoneList.get(listSize - 1);
        undoneList.remove(listSize - 1);
        doneList.add(batch);
        if (undoneList.size() == 0) {
            Undo.setRedoEnabled(false);
        }
        Undo.setUndoEnabled(true);
        boolean firstChange = true;
        int batchSize = batch.changes.size();
        for (int i = 0; i < batchSize; ++i) {
            Change ch = (Change)batch.changes.get(i);
            ch.reverse(false);
            ch.broadcast(firstChange, true);
            firstChange = false;
        }
        Iterator it = Tool.getListeners();
        while (it.hasNext()) {
            Listener listener = (Listener)it.next();
            listener.endBatch();
        }
        Undo.fireEndChangeBatch(batch);
        ArrayList highlights = new ArrayList();
        Iterator it2 = batch.preUndoHighlights.iterator();
        while (it2.hasNext()) {
            highlights.add(it2.next());
        }
        if (highlighter != null) {
            highlighter.setHighlightList(highlights);
            highlighter.setHighlightOffset((int)batch.preUndoHighlightsOffset.getX(), (int)batch.preUndoHighlightsOffset.getY());
            highlighter.finished();
        }
        return true;
    }

    public static Cell upCell(boolean redo) {
        ChangeBatch batch = null;
        if (redo) {
            int listSize = undoneList.size();
            if (listSize > 0) {
                batch = (ChangeBatch)undoneList.get(listSize - 1);
            }
        } else {
            int listSize = doneList.size();
            if (listSize != 0) {
                batch = (ChangeBatch)doneList.get(listSize - 1);
            }
        }
        return batch != null ? batch.upCell : null;
    }

    public static void noUndoAllowed() {
        Undo.endChanges();
        doneList.clear();
        undoneList.clear();
        Undo.setUndoEnabled(false);
        Undo.setRedoEnabled(false);
    }

    public static void noRedoAllowed() {
        Undo.endChanges();
        undoneList.clear();
        Undo.setRedoEnabled(false);
    }

    public static int setHistoryListSize(int newSize) {
        if (newSize <= 0) {
            return maximumBatches;
        }
        int oldSize = maximumBatches;
        maximumBatches = newSize;
        if (doneList.size() > maximumBatches) {
            doneList.remove(0);
        }
        if (doneList.size() == 0) {
            Undo.setUndoEnabled(false);
        }
        return oldSize;
    }

    public static void showHistoryList() {
        ChangeBatch batch;
        int i;
        System.out.println("----------  Done batches (" + doneList.size() + ") ----------:");
        for (i = 0; i < doneList.size(); ++i) {
            batch = (ChangeBatch)doneList.get(i);
            batch.describe("Done");
        }
        System.out.println("----------  Undone batches (" + undoneList.size() + ") ----------:");
        for (i = 0; i < undoneList.size(); ++i) {
            batch = (ChangeBatch)undoneList.get(i);
            batch.describe("Undone");
        }
    }

    private static class DatabaseChangeRun
    implements Runnable {
        private DatabaseChangeListener l;
        private DatabaseChangeEvent event;

        private DatabaseChangeRun(DatabaseChangeListener l, DatabaseChangeEvent e) {
            this.l = l;
            this.event = e;
        }

        public void run() {
            this.l.databaseChanged(this.event);
        }
    }

    private static class PropertyChangeThread
    implements Runnable {
        private PropertyChangeListener l;
        private PropertyChangeEvent e;

        private PropertyChangeThread(PropertyChangeListener l, PropertyChangeEvent e) {
            this.l = l;
            this.e = e;
        }

        public void run() {
            this.l.propertyChange(this.e);
        }
    }

    public static class ChangeBatch {
        private List changes;
        private int batchNumber;
        private String activity;
        private Cell upCell;
        private List startingHighlights = null;
        private Point2D startHighlightsOffset = null;
        private List preUndoHighlights = null;
        private Point2D preUndoHighlightsOffset = null;

        private ChangeBatch() {
        }

        private void add(Change change) {
            this.changes.add(change);
        }

        public Iterator getChanges() {
            return this.changes.iterator();
        }

        public int getBatchNumber() {
            return this.batchNumber;
        }

        public int getNumChanges() {
            return this.changes.size();
        }

        private void describe(String title) {
            int nodeInst = 0;
            int arcInst = 0;
            int export = 0;
            int cell = 0;
            int object = 0;
            int variable = 0;
            int batchSize = this.changes.size();
            for (int j = 0; j < batchSize; ++j) {
                Change ch = (Change)this.changes.get(j);
                if (ch.getType() == Type.NODEINSTNEW || ch.getType() == Type.NODEINSTKILL || ch.getType() == Type.NODEINSTMOD || ch.getType() == Type.OBJECTRENAME && ch.obj instanceof NodeInst) {
                    ++nodeInst;
                    continue;
                }
                if (ch.getType() == Type.ARCINSTNEW || ch.getType() == Type.ARCINSTKILL || ch.getType() == Type.ARCINSTMOD || ch.getType() == Type.OBJECTRENAME && ch.obj instanceof NodeInst) {
                    ++arcInst;
                    continue;
                }
                if (ch.getType() == Type.EXPORTNEW || ch.getType() == Type.EXPORTKILL || ch.getType() == Type.EXPORTMOD) {
                    ++export;
                    continue;
                }
                if (ch.getType() == Type.CELLNEW || ch.getType() == Type.CELLKILL || ch.getType() == Type.CELLMOD || ch.getType() == Type.CELLGROUPMOD) {
                    ++cell;
                    continue;
                }
                if (ch.getType() == Type.OBJECTNEW || ch.getType() == Type.OBJECTKILL || ch.getType() == Type.OBJECTREDRAW) {
                    ++object;
                    continue;
                }
                if (ch.getType() == Type.VARIABLENEW || ch.getType() == Type.VARIABLEKILL || ch.getType() == Type.VARIABLEMOD || ch.getType() == Type.VARIABLEINSERT || ch.getType() == Type.VARIABLEDELETE) {
                    ++variable;
                    continue;
                }
                if (ch.getType() == Type.DESCRIPTORMOD) {
                    String varName = (String)ch.o1;
                    if (ch.obj instanceof NodeInst) {
                        NodeInst ni = (NodeInst)ch.obj;
                        if (varName == NodeInst.NODE_NAME_TD || varName == NodeInst.NODE_PROTO_TD) {
                            ++nodeInst;
                            continue;
                        }
                        ++variable;
                        continue;
                    }
                    if (ch.obj instanceof ArcInst) {
                        ArcInst ai = (ArcInst)ch.obj;
                        if (varName == ArcInst.ARC_NAME_TD) {
                            ++arcInst;
                            continue;
                        }
                        ++variable;
                        continue;
                    }
                    if (ch.obj instanceof Export) {
                        Export e = (Export)ch.obj;
                        if (varName == Export.EXPORT_NAME_TD) {
                            ++export;
                            continue;
                        }
                        ++variable;
                        continue;
                    }
                    ++variable;
                    continue;
                }
                if (ch.getType() != Type.OTHERCHANGE) continue;
                ++object;
            }
            String message = "*** Batch '" + title + "', " + this.batchNumber + " (" + this.activity + ") has " + batchSize + " changes and affects";
            if (nodeInst != 0) {
                message = message + " " + nodeInst + " nodes";
            }
            if (arcInst != 0) {
                message = message + " " + arcInst + " arcs";
            }
            if (export != 0) {
                message = message + " " + export + " exports";
            }
            if (cell != 0) {
                message = message + " " + cell + " cells";
            }
            if (object != 0) {
                message = message + " " + object + " objects";
            }
            if (variable != 0) {
                message = message + " " + variable + " variables";
            }
            System.out.println(message + ":");
            for (int j = 0; j < batchSize; ++j) {
                Change ch = (Change)this.changes.get(j);
                System.out.println("   " + ch.describe());
            }
        }
    }

    public static class Change {
        private ElectricObject obj;
        private Type type;
        private double a1;
        private double a2;
        private double a3;
        private double a4;
        private double a5;
        private int i1;
        private int i2;
        private int i3;
        private Object o1;
        private Object o2;

        Change(ElectricObject obj, Type type) {
            this.obj = obj;
            this.type = type;
        }

        private void setDoubles(double a1, double a2, double a3, double a4) {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
        }

        public ElectricObject getObject() {
            return this.obj;
        }

        public Type getType() {
            return this.type;
        }

        public double getA1() {
            return this.a1;
        }

        public double getA2() {
            return this.a2;
        }

        public double getA3() {
            return this.a3;
        }

        public double getA4() {
            return this.a4;
        }

        public double getA5() {
            return this.a5;
        }

        public int getI1() {
            return this.i1;
        }

        public int getI2() {
            return this.i2;
        }

        public int getI3() {
            return this.i3;
        }

        public Object getO1() {
            return this.o1;
        }

        public Object getO2() {
            return this.o2;
        }

        private void broadcast(boolean firstchange, boolean undoRedo) {
            Listener listener;
            Iterator it;
            broadcasting = this.type;
            if (firstchange) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.startBatch(listener, undoRedo);
                }
            }
            if (this.type == Type.NODEINSTNEW || this.type == Type.ARCINSTNEW || this.type == Type.EXPORTNEW || this.type == Type.CELLNEW || this.type == Type.OBJECTNEW) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.newObject(this.obj);
                }
            } else if (this.type == Type.NODEINSTKILL || this.type == Type.ARCINSTKILL || this.type == Type.CELLKILL || this.type == Type.OBJECTKILL) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.killObject(this.obj);
                }
            } else if (this.type == Type.EXPORTKILL) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.killExport((Export)this.obj, (Collection)this.o1);
                }
            } else if (this.type == Type.OBJECTRENAME) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.renameObject(this.obj, this.o1);
                }
            } else if (this.type == Type.OBJECTREDRAW) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.redrawObject(this.obj);
                }
            } else if (this.type == Type.NODEINSTMOD) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.modifyNodeInst((NodeInst)this.obj, this.a1, this.a2, this.a3, this.a4, this.i1);
                }
            } else if (this.type == Type.ARCINSTMOD) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.modifyArcInst((ArcInst)this.obj, this.a1, this.a2, this.a3, this.a4, this.a5);
                }
            } else if (this.type == Type.EXPORTMOD) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.modifyExport((Export)this.obj, (PortInst)this.o1);
                }
            } else if (this.type == Type.CELLMOD) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.modifyCell((Cell)this.obj, this.a1, this.a2, this.a3, this.a4);
                }
            } else if (this.type == Type.CELLGROUPMOD) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.modifyCellGroup((Cell)this.obj, (Cell.CellGroup)this.o1);
                }
            } else if (this.type == Type.VARIABLENEW) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.newVariable(this.obj, (Variable)this.o1);
                }
            } else if (this.type == Type.VARIABLEKILL) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.killVariable(this.obj, (Variable)this.o1);
                }
            } else if (this.type == Type.VARIABLEMOD) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.modifyVariable(this.obj, (Variable)this.o1, this.i1, this.o2);
                }
            } else if (this.type == Type.VARIABLEINSERT) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.insertVariable(this.obj, (Variable)this.o1, this.i1);
                }
            } else if (this.type == Type.VARIABLEDELETE) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.deleteVariable(this.obj, (Variable)this.o1, this.i1, this.o2);
                }
            } else if (this.type == Type.DESCRIPTORMOD) {
                it = Tool.getListeners();
                while (it.hasNext()) {
                    listener = (Listener)it.next();
                    listener.modifyTextDescript(this.obj, (String)this.o1, (ImmutableTextDescriptor)this.o2);
                }
            } else if (this.type == Type.OTHERCHANGE) {
                // empty if block
            }
            broadcasting = null;
        }

        private void reverse(boolean backwards) {
            Change.setDirty(this.type, this.obj, this.o1);
            if (this.type == Type.NODEINSTNEW) {
                NodeInst ni = (NodeInst)this.obj;
                ni.lowLevelUnlink();
                this.type = Type.NODEINSTKILL;
                return;
            }
            if (this.type == Type.NODEINSTKILL) {
                NodeInst ni = (NodeInst)this.obj;
                ni.lowLevelLink();
                this.type = Type.NODEINSTNEW;
                return;
            }
            if (this.type == Type.NODEINSTMOD) {
                NodeInst ni = (NodeInst)this.obj;
                double oldCX = ni.getAnchorCenterX();
                double oldCY = ni.getAnchorCenterY();
                double oldSX = ni.getXSizeWithMirror();
                double oldSY = ni.getYSizeWithMirror();
                int oldRot = ni.getAngle();
                ni.lowLevelModify(this.a1 - oldCX, this.a2 - oldCY, this.a3 - oldSX, this.a4 - oldSY, this.i1 - oldRot);
                if (backwards) {
                    Iterator it = ni.getParent().getInstancesOf();
                    while (it.hasNext()) {
                        NodeInst superNi = (NodeInst)it.next();
                        superNi.lowLevelModify(0.0, 0.0, 0.0, 0.0, 0);
                    }
                }
                this.a1 = oldCX;
                this.a2 = oldCY;
                this.a3 = oldSX;
                this.a4 = oldSY;
                this.i1 = oldRot;
                return;
            }
            if (this.type == Type.ARCINSTNEW) {
                ArcInst ai = (ArcInst)this.obj;
                ai.lowLevelUnlink();
                this.type = Type.ARCINSTKILL;
                return;
            }
            if (this.type == Type.ARCINSTKILL) {
                ArcInst ai = (ArcInst)this.obj;
                ai.lowLevelLink();
                this.type = Type.ARCINSTNEW;
                ai.getParent().checkInvariants();
                return;
            }
            if (this.type == Type.ARCINSTMOD) {
                ArcInst ai = (ArcInst)this.obj;
                Point2D.Double oldHeadPt = new Point2D.Double();
                oldHeadPt.setLocation(ai.getHeadLocation());
                Point2D.Double oldTailPt = new Point2D.Double();
                oldTailPt.setLocation(ai.getTailLocation());
                double oldWid = ai.getWidth();
                ai.lowLevelModify(this.a5 - oldWid, this.a1 - ((Point2D)oldHeadPt).getX(), this.a2 - ((Point2D)oldHeadPt).getY(), this.a3 - ((Point2D)oldTailPt).getX(), this.a4 - ((Point2D)oldTailPt).getY());
                if (backwards) {
                    Iterator it = ai.getParent().getInstancesOf();
                    while (it.hasNext()) {
                        NodeInst superNi = (NodeInst)it.next();
                        superNi.lowLevelModify(0.0, 0.0, 0.0, 0.0, 0);
                    }
                }
                this.a1 = ((Point2D)oldHeadPt).getX();
                this.a2 = ((Point2D)oldHeadPt).getY();
                this.a3 = ((Point2D)oldTailPt).getX();
                this.a4 = ((Point2D)oldTailPt).getY();
                this.a5 = oldWid;
                return;
            }
            if (this.type == Type.EXPORTNEW) {
                Export pp = (Export)this.obj;
                this.o1 = pp.lowLevelUnlink();
                this.type = Type.EXPORTKILL;
                return;
            }
            if (this.type == Type.EXPORTKILL) {
                Export pp = (Export)this.obj;
                pp.lowLevelLink((Collection)this.o1);
                this.type = Type.EXPORTNEW;
                this.o1 = null;
                ((Cell)pp.getParent()).checkInvariants();
                return;
            }
            if (this.type == Type.EXPORTMOD) {
                Export pp = (Export)this.obj;
                PortInst oldPi = (PortInst)this.o1;
                PortInst currentPi = pp.getOriginalPort();
                pp.lowLevelModify(oldPi);
                this.o1 = currentPi;
                return;
            }
            if (this.type == Type.CELLNEW) {
                Cell cell = (Cell)this.obj;
                cell.lowLevelUnlink();
                this.type = Type.CELLKILL;
                return;
            }
            if (this.type == Type.CELLKILL) {
                Cell cell = (Cell)this.obj;
                cell.lowLevelLink();
                this.type = Type.CELLNEW;
                return;
            }
            if (this.type == Type.CELLGROUPMOD) {
                Cell cell = (Cell)this.obj;
                Cell.CellGroup oldGroup = (Cell.CellGroup)this.o1;
                this.o1 = cell.getCellGroup();
                cell.lowLevelSetCellGroup(oldGroup);
                return;
            }
            if (this.type == Type.CELLMOD) {
                Cell cell = (Cell)this.obj;
                Rectangle2D bounds = cell.getBounds();
                this.a1 = bounds.getMinX();
                this.a2 = bounds.getMaxX();
                this.a3 = bounds.getMinY();
                this.a4 = bounds.getMaxY();
                return;
            }
            if (this.type == Type.OBJECTNEW) {
                this.type = Type.OBJECTKILL;
                return;
            }
            if (this.type == Type.OBJECTKILL) {
                this.type = Type.OBJECTNEW;
                return;
            }
            if (this.type == Type.OBJECTRENAME) {
                if (this.obj instanceof NodeInst) {
                    NodeInst ni = (NodeInst)this.obj;
                    Name oldName = (Name)this.o1;
                    int oldDuplicate = this.i1;
                    this.o1 = ni.getNameKey();
                    this.i1 = ni.getDuplicate();
                    ni.lowLevelRename(oldName, oldDuplicate);
                } else if (this.obj instanceof ArcInst) {
                    ArcInst ai = (ArcInst)this.obj;
                    Name oldName = (Name)this.o1;
                    int oldDuplicate = this.i1;
                    this.o1 = ai.getNameKey();
                    this.i1 = ai.getDuplicate();
                    ai.lowLevelRename(oldName, oldDuplicate);
                } else if (this.obj instanceof Cell) {
                    Cell cell = (Cell)this.obj;
                    CellName oldName = (CellName)this.o1;
                    this.o1 = cell.getCellName();
                    cell.lowLevelRename(oldName);
                } else if (this.obj instanceof Export) {
                    Export pp = (Export)this.obj;
                    Name oldName = (Name)this.o1;
                    this.o1 = pp.getNameKey();
                    pp.lowLevelRename(oldName);
                } else if (this.obj instanceof Library) {
                    Library lib = (Library)this.obj;
                    String oldName = (String)this.o1;
                    this.o1 = lib.getName();
                    lib.lowLevelRename(oldName);
                }
                return;
            }
            if (this.type == Type.VARIABLENEW) {
                Variable var = (Variable)this.o1;
                this.obj.lowLevelUnlinkVar(var);
                this.type = Type.VARIABLEKILL;
                return;
            }
            if (this.type == Type.VARIABLEKILL) {
                Variable var = (Variable)this.o1;
                this.obj.lowLevelLinkVar(var);
                this.type = Type.VARIABLENEW;
                return;
            }
            if (this.type == Type.VARIABLEMOD) {
                Variable var = (Variable)this.o1;
                Object[] arr = (Object[])var.getObject();
                Object oldVal = arr[this.i1];
                arr[this.i1] = this.o2;
                this.o2 = oldVal;
                this.obj.lowLevelModVar(var);
                return;
            }
            if (this.type == Type.VARIABLEINSERT) {
                Variable var = (Variable)this.o1;
                Object[] oldArr = (Object[])var.getObject();
                this.o2 = oldArr[this.i1];
                var.lowLevelDelete(this.i1);
                this.type = Type.VARIABLEDELETE;
                return;
            }
            if (this.type == Type.VARIABLEDELETE) {
                Variable var = (Variable)this.o1;
                var.lowLevelInsert(this.i1, this.o2);
                this.type = Type.VARIABLEINSERT;
                return;
            }
            if (this.type == Type.DESCRIPTORMOD) {
                String varName = (String)this.o1;
                this.o2 = this.obj.lowLevelSetTextDescriptor(varName, (ImmutableTextDescriptor)this.o2);
                return;
            }
            if (this.type == Type.OTHERCHANGE) {
                return;
            }
        }

        private static void setDirty(Type type, ElectricObject obj, Object o1) {
            Cell cell = null;
            Library lib = null;
            boolean major = false;
            if (type == Type.NODEINSTNEW || type == Type.NODEINSTKILL || type == Type.NODEINSTMOD) {
                NodeInst ni = (NodeInst)obj;
                cell = ni.getParent();
                lib = cell.getLibrary();
                major = true;
            } else if (type == Type.ARCINSTNEW || type == Type.ARCINSTKILL || type == Type.ARCINSTMOD) {
                ArcInst ai = (ArcInst)obj;
                cell = ai.getParent();
                lib = cell.getLibrary();
                major = true;
            } else if (type == Type.EXPORTNEW || type == Type.EXPORTKILL || type == Type.EXPORTMOD) {
                Export pp = (Export)obj;
                cell = (Cell)pp.getParent();
                lib = cell.getLibrary();
                major = true;
            } else if (type == Type.CELLNEW || type == Type.CELLKILL) {
                cell = (Cell)obj;
                lib = cell.getLibrary();
                major = true;
            } else if (type == Type.CELLMOD || type == Type.CELLGROUPMOD) {
                cell = (Cell)obj;
                lib = cell.getLibrary();
            } else if (type == Type.OBJECTNEW || type == Type.OBJECTKILL || type == Type.OBJECTREDRAW) {
                cell = obj.whichCell();
                if (cell != null) {
                    lib = cell.getLibrary();
                }
            } else if (type == Type.OBJECTRENAME) {
                cell = obj.whichCell();
                if (cell != null) {
                    lib = cell.getLibrary();
                    Iterator it = cell.getUsagesOf();
                    while (it.hasNext()) {
                        NodeUsage nu = (NodeUsage)it.next();
                        Cell parent = nu.getParent();
                        parent.getLibrary().setChangedMinor();
                    }
                }
            } else if (type == Type.VARIABLENEW || type == Type.VARIABLEKILL || type == Type.VARIABLEMOD || type == Type.VARIABLEINSERT || type == Type.VARIABLEDELETE) {
                cell = obj.whichCell();
                if (cell != null) {
                    lib = cell.getLibrary();
                }
                Variable var = (Variable)o1;
                major = Change.isMajorVariable(obj, var.getKey());
            } else if (type == Type.DESCRIPTORMOD) {
                cell = obj.whichCell();
                if (cell != null) {
                    lib = cell.getLibrary();
                }
            } else if (type == Type.OTHERCHANGE && (cell = obj.whichCell()) != null) {
                lib = cell.getLibrary();
            }
            if (cell != null) {
                if (major) {
                    cell.madeRevision();
                }
                changedCells.add(cell);
            }
            if (lib != null) {
                if (major) {
                    lib.setChangedMajor();
                } else {
                    lib.setChangedMinor();
                }
            }
        }

        private static boolean isMajorVariable(ElectricObject obj, Variable.Key key) {
            return false;
        }

        public String toString() {
            return this.describe();
        }

        private String describe() {
            if (this.type == Type.NODEINSTNEW) {
                NodeInst ni = (NodeInst)this.obj;
                return ni + " created in " + ni.getParent();
            }
            if (this.type == Type.NODEINSTKILL) {
                NodeInst ni = (NodeInst)this.obj;
                return ni + " deleted from " + ni.getParent();
            }
            if (this.type == Type.NODEINSTMOD) {
                NodeInst ni = (NodeInst)this.obj;
                return ni + " modified in " + ni.getParent() + "[was " + this.getA3() + "x" + this.getA4() + " at (" + this.getA1() + "," + this.getA2() + ") rotated " + (double)this.getI1() / 10.0 + ", is " + ni.getXSizeWithMirror() + "x" + ni.getYSizeWithMirror() + " at (" + ni.getAnchorCenterX() + "," + ni.getAnchorCenterY() + ") rotated " + (double)ni.getAngle() / 10.0 + "]";
            }
            if (this.type == Type.ARCINSTNEW) {
                ArcInst ai = (ArcInst)this.obj;
                return ai + " created in " + ai.getParent();
            }
            if (this.type == Type.ARCINSTKILL) {
                ArcInst ai = (ArcInst)this.obj;
                return ai + " deleted from " + ai.getParent();
            }
            if (this.type == Type.ARCINSTMOD) {
                ArcInst ai = (ArcInst)this.obj;
                return ai + " modified in " + ai.getParent() + "[was " + this.getA5() + " wide from (" + this.getA1() + "," + this.getA2() + ") to (" + this.getA3() + "," + this.getA4() + ")]";
            }
            if (this.type == Type.EXPORTNEW) {
                Export pp = (Export)this.obj;
                return "Export " + pp.getName() + " created in " + pp.getParent();
            }
            if (this.type == Type.EXPORTKILL) {
                Export pp = (Export)this.obj;
                return "Export " + pp.getName() + " deleted from " + pp.getParent();
            }
            if (this.type == Type.EXPORTMOD) {
                Export pp = (Export)this.obj;
                PortInst pi = (PortInst)this.o1;
                return "Export " + pp.getName() + " moved in " + pp.getParent() + "[was on " + pi.getNodeInst() + " port " + pi.getPortProto().getName() + "]";
            }
            if (this.type == Type.CELLNEW) {
                Cell cell = (Cell)this.obj;
                return cell + " created";
            }
            if (this.type == Type.CELLKILL) {
                Cell cell = (Cell)this.obj;
                return cell + " deleted";
            }
            if (this.type == Type.CELLMOD) {
                Cell cell = (Cell)this.obj;
                return cell + " modified (was from " + this.a1 + "<=X<=" + this.a2 + " " + this.a3 + "<=Y<=" + this.a4 + ")";
            }
            if (this.type == Type.CELLGROUPMOD) {
                Cell cell = (Cell)this.obj;
                return cell + " moved to group";
            }
            if (this.type == Type.OBJECTNEW) {
                return "Created new object " + this.obj;
            }
            if (this.type == Type.OBJECTKILL) {
                return "Deleted object " + this.obj;
            }
            if (this.type == Type.OBJECTRENAME) {
                return "Renamed object " + this.obj + " (was " + this.o1 + ")";
            }
            if (this.type == Type.OBJECTREDRAW) {
                return "Redraw object " + this.obj;
            }
            if (this.type == Type.VARIABLENEW) {
                return "Created variable " + this.o1 + " on " + this.obj;
            }
            if (this.type == Type.VARIABLEKILL) {
                return "Deleted variable " + this.o1 + " on " + this.obj + " [was " + ((Variable)this.o1).getObject() + "]";
            }
            if (this.type == Type.VARIABLEMOD) {
                return "Modified variable " + this.o1 + "[" + this.i1 + "] on " + this.obj;
            }
            if (this.type == Type.VARIABLEINSERT) {
                return "Inserted variable " + this.o1 + " on " + this.obj;
            }
            if (this.type == Type.VARIABLEDELETE) {
                return "Deleted variable " + this.o1 + " on " + this.obj;
            }
            if (this.type == Type.DESCRIPTORMOD) {
                return "Modified Text Descriptor in " + this.obj + "." + this.o1 + " [was " + this.o2 + "]";
            }
            if (this.type == Type.OTHERCHANGE) {
                return "Other (non-undoable) change in " + this.obj;
            }
            return "?";
        }
    }

    public static class Type {
        private final String name;
        public static final Type NODEINSTNEW = new Type("NodeInstNew");
        public static final Type NODEINSTKILL = new Type("NodeInstKill");
        public static final Type NODEINSTMOD = new Type("NodeInstMod");
        public static final Type ARCINSTNEW = new Type("ArcInstNew");
        public static final Type ARCINSTKILL = new Type("ArcInstKill");
        public static final Type ARCINSTMOD = new Type("ArcInstMod");
        public static final Type EXPORTNEW = new Type("ExportNew");
        public static final Type EXPORTKILL = new Type("ExportKill");
        public static final Type EXPORTMOD = new Type("ExportMod");
        public static final Type CELLNEW = new Type("CellNew");
        public static final Type CELLKILL = new Type("CellKill");
        public static final Type CELLMOD = new Type("CellMod");
        public static final Type OBJECTNEW = new Type("ObjectNew");
        public static final Type OBJECTKILL = new Type("ObjectKill");
        public static final Type OBJECTRENAME = new Type("ObjectRename");
        public static final Type OBJECTREDRAW = new Type("ObjectRedraw");
        public static final Type VARIABLENEW = new Type("VariableNew");
        public static final Type VARIABLEKILL = new Type("VariableKill");
        public static final Type VARIABLEMOD = new Type("VariableMod");
        public static final Type VARIABLEINSERT = new Type("VariableInsert");
        public static final Type VARIABLEDELETE = new Type("VariableDelete");
        public static final Type DESCRIPTORMOD = new Type("DescriptMod");
        public static final Type LIBRARYNEW = new Type("LibraryNew");
        public static final Type LIBRARYKILL = new Type("LibraryKill");
        public static final Type CELLGROUPMOD = new Type("CellGroupMod");
        public static final Type OTHERCHANGE = new Type("OtherChange");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

