/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.hierarchy.RTNode;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class Cell
extends ElectricObject
implements NodeProto,
Comparable {
    public static final Variable.Key CHARACTERISTIC_SPACING;
    public static final Variable.Key CELL_TEXT_KEY;
    public static final Variable.Key MULTIPAGE_COUNT_KEY;
    private static final Export[] NULL_EXPORT_ARRAY;
    private static final int WANTNEXPAND = 2;
    private static final int NPLOCKED = 0x100000;
    private static final int NPILOCKED = 0x200000;
    private static final int INCELLLIBRARY = 0x400000;
    private static final int TECEDITCELL = 0x800000;
    private static final int MULTIPAGE = 0x7E000000;
    private static final int ABBREVLEN = 8;
    private static final Rectangle2D CENTERRECT;
    private static int cellNumber;
    private CellName cellName;
    private CellGroup cellGroup = null;
    private Library lib;
    private Date creationDate;
    private Date revisionDate;
    private int userBits = 0;
    private Name basename;
    private Export[] exports = NULL_EXPORT_ARRAY;
    private List essenBounds = new ArrayList();
    private List nodes;
    private Map usagesIn;
    List usagesOf;
    private Map maxSuffix;
    private List arcs;
    private Map tempNames;
    private Rectangle2D cellBounds;
    private boolean boundsDirty = false;
    private boolean boundsEmpty = true;
    private RTNode rTree = RTNode.makeTopLevel();
    private Undo.Change change;
    private int cellIndex;
    private Technology tech = null;
    private int tempInt;
    private boolean boundLock = false;
    private Rectangle2D lastBounds = new Rectangle2D.Double();
    private static boolean allowCirDep;
    private static boolean invariantsFailed;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    private Cell() {
        this.cellIndex = cellNumber++;
        this.nodes = new ArrayList();
        this.usagesIn = new HashMap();
        this.usagesOf = new ArrayList();
        this.maxSuffix = new HashMap();
        this.arcs = new ArrayList();
        this.tempNames = new HashMap();
        this.creationDate = new Date();
        this.revisionDate = new Date();
        this.cellBounds = new Rectangle2D.Double();
    }

    public static Cell makeInstance(Library lib, String name) {
        PrimitiveNode cellCenterProto;
        NodeInst cellCenter;
        Cell cell = Cell.newInstance(lib, name);
        if (User.isPlaceCellCenter() && (cellCenter = NodeInst.newInstance(cellCenterProto = Generic.tech.cellCenterNode, new Point2D.Double(0.0, 0.0), cellCenterProto.getDefWidth(), cellCenterProto.getDefHeight(), cell)) != null) {
            cellCenter.setVisInside();
            cellCenter.setHardSelect();
        }
        return cell;
    }

    public static Cell newInstance(Library lib, String name) {
        Job.checkChanging();
        Cell cell = Cell.lowLevelAllocate(lib);
        if (cell.lowLevelPopulate(name)) {
            return null;
        }
        if (cell.lowLevelLink()) {
            return null;
        }
        Undo.newObject(cell);
        return cell;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("Cell already killed");
            return;
        }
        this.checkChanging();
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public static Cell copyNodeProto(Cell fromCell, Library toLib, String toName, boolean useExisting) {
        NodeInst ni;
        if (fromCell == null) {
            return null;
        }
        if (toLib == null) {
            return null;
        }
        for (int i = 0; i < toName.length(); ++i) {
            char ch = toName.charAt(i);
            if (ch > ' ' && ch != ':' && ch < '\u007f') continue;
            System.out.println("invalid name of new cell");
            return null;
        }
        Library destLib = toLib;
        if (toLib == fromCell.getLibrary()) {
            destLib = null;
        }
        HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
        Iterator it = fromCell.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            nodePrototypes.put(ni, ni.getProto());
        }
        if (destLib != null) {
            it = fromCell.getNodes();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                if (ni.getProto() instanceof PrimitiveNode) continue;
                Cell niProto = (Cell)ni.getProto();
                boolean maySubstitute = useExisting;
                if (!maySubstitute && niProto.isIcon() && niProto.isIconOf(fromCell)) {
                    maySubstitute = true;
                }
                if (!maySubstitute) continue;
                Cell lnt = null;
                Iterator cIt = toLib.getCells();
                while (cIt.hasNext() && (!(lnt = (Cell)cIt.next()).getName().equalsIgnoreCase(niProto.getName()) || lnt.getView() != niProto.getView())) {
                    lnt = null;
                }
                if (lnt == null) continue;
                boolean validPorts = true;
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    PortProto pp = pi.getPortProto();
                    PortProto ppt = lnt.findPortProto(pp.getName());
                    if (ppt != null) {
                        // empty if block
                    }
                    if (ppt != null) continue;
                    System.out.println("Cannot use subcell " + lnt.noLibDescribe() + " in " + destLib + ": exports don't match");
                    validPorts = false;
                    break;
                }
                if (!validPorts) continue;
                nodePrototypes.put(ni, lnt);
            }
        }
        return Cell.copyNodeProtoUsingMapping(fromCell, toLib, toName, nodePrototypes);
    }

    public static Cell copyNodeProtoUsingMapping(Cell fromCell, Library toLib, String toName, HashMap nodePrototypes) {
        NodeInst ni;
        Cell newCell;
        String cellName = toName;
        if (toName.indexOf(123) < 0 && fromCell.getView() != View.UNKNOWN) {
            cellName = toName + "{" + fromCell.getView().getAbbreviation() + "}";
        }
        if ((newCell = Cell.newInstance(toLib, cellName)) == null) {
            return null;
        }
        newCell.lowLevelSetUserbits(fromCell.lowLevelGetUserbits());
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        Iterator it = fromCell.getNodes();
        while (it.hasNext()) {
            NodeInst toNi;
            ni = (NodeInst)it.next();
            NodeProto lnt = (NodeProto)nodePrototypes.get(ni);
            double scaleX = ni.getXSize();
            if (ni.isXMirrored()) {
                scaleX = -scaleX;
            }
            double scaleY = ni.getYSize();
            if (ni.isYMirrored()) {
                scaleY = -scaleY;
            }
            if ((toNi = NodeInst.newInstance(lnt, new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), scaleX, scaleY, newCell, ni.getAngle(), ni.getName(), 0)) == null) {
                return null;
            }
            newNodes.put(ni, toNi);
            toNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO_TD);
            toNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME_TD);
            toNi.lowLevelSetUserbits(ni.lowLevelGetUserbits());
        }
        it = fromCell.getNodes();
        while (it.hasNext()) {
            String name;
            Variable var;
            ni = (NodeInst)it.next();
            NodeInst toNi = (NodeInst)newNodes.get(ni);
            toNi.copyVarsFrom(ni);
            if (!newCell.isIcon() || (var = toNi.getVar(Schematics.SCHEM_FUNCTION)) == null || !(name = (String)var.getObject()).equals(fromCell.getName())) continue;
            toNi.updateVar(var.getKey(), (Object)newCell.getName());
        }
        it = fromCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            PortInst[] opi = new PortInst[2];
            for (int i = 0; i < 2; ++i) {
                opi[i] = null;
                NodeInst ono = (NodeInst)newNodes.get(ai.getPortInst(i).getNodeInst());
                PortProto pp = ai.getPortInst(i).getPortProto();
                if (ono.getProto() instanceof PrimitiveNode) {
                    opi[i] = ono.findPortInstFromProto(pp);
                } else {
                    PortProto ppt = ono.getProto().findPortProto(pp.getName());
                    if (ppt != null) {
                        opi[i] = ono.findPortInstFromProto(ppt);
                    }
                }
                if (opi[i] != null) continue;
                System.out.println("Error: no port for " + ai.getProto() + " arc on " + ono.getProto());
            }
            if (opi[0] == null || opi[1] == null) {
                return null;
            }
            ArcInst toAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), opi[1], opi[0], ai.getHeadLocation(), ai.getTailLocation(), ai.getName(), ai.getAngle());
            if (toAi == null) {
                return null;
            }
            toAi.copyPropertiesFrom(ai);
        }
        it = fromCell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            NodeInst ni2 = (NodeInst)newNodes.get(pp.getOriginalPort().getNodeInst());
            PortInst pi = ni2.findPortInst(pp.getOriginalPort().getPortProto().getName());
            if (pi == null) {
                System.out.println("Error: no port on " + pp.getOriginalPort().getNodeInst().getProto());
                return null;
            }
            Export ppt = Export.newInstance(newCell, pi, pp.getName());
            if (ppt == null) {
                return null;
            }
            ppt.copyVarsFrom(pp);
            ppt.lowLevelSetUserbits(pp.lowLevelGetUserbits());
            ppt.copyTextDescriptorFrom(pp, Export.EXPORT_NAME_TD);
        }
        newCell.copyVarsFrom(fromCell);
        newCell.lowLevelSetCreationDate(fromCell.getCreationDate());
        newCell.lowLevelSetRevisionDate(fromCell.getRevisionDate());
        return newCell;
    }

    public void rename(String newName) {
        this.rename(CellName.parseName(newName + ";" + this.getVersion() + "{" + this.getView().getAbbreviation() + "}"));
    }

    private void rename(CellName cellName) {
        this.checkChanging();
        if (!$assertionsDisabled && !this.isLinked()) {
            throw new AssertionError();
        }
        if (cellName == null) {
            return;
        }
        if (cellName.equals(this.cellName)) {
            return;
        }
        CellName oldCellName = this.cellName;
        this.lowLevelRename(cellName);
        Undo.renameObject(this, oldCellName);
    }

    public static Cell lowLevelAllocate(Library lib) {
        Job.checkChanging();
        Cell c = new Cell();
        c.lib = lib;
        return c;
    }

    public boolean lowLevelPopulate(String name) {
        if (!$assertionsDisabled && this.isLinked()) {
            throw new AssertionError();
        }
        CellName n = CellName.parseName(name);
        if (n == null) {
            return true;
        }
        String cellName = n.getName();
        String original = null;
        for (int i = 0; i < cellName.length(); ++i) {
            char chr = cellName.charAt(i);
            if (!Character.isWhitespace(chr) && chr != ':' && chr != ';' && chr != '{' && chr != '}') continue;
            if (original == null) {
                original = cellName;
            }
            cellName = cellName.substring(0, i) + '_' + cellName.substring(i + 1);
        }
        if (original != null) {
            System.out.println("Cell name changed from '" + original + "' to '" + cellName + "'");
            n = CellName.newName(cellName, n.getView(), n.getVersion());
        }
        this.setCellName(n);
        return false;
    }

    public boolean lowLevelLink() {
        this.lib.checkChanging();
        if (!$assertionsDisabled && this.isLinked()) {
            throw new AssertionError();
        }
        if (this.cellName == null) {
            System.out.println(this + " has bad name");
            return true;
        }
        this.lowLevelLinkCellName();
        Iterator it = this.getUsagesIn();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            NodeProto np = nu.getProto();
            if (!(np instanceof Cell)) continue;
            ((Cell)np).usagesOf.add(nu);
        }
        Library.databaseObjs.add(this);
        this.checkInvariants();
        return false;
    }

    public void lowLevelUnlink() {
        this.checkChanging();
        if (!this.isLinked()) {
            System.out.println(this + " already unlinked");
            return;
        }
        this.lib.removeCell(this);
        this.cellGroup.remove(this);
        Iterator it = this.getUsagesIn();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            NodeProto np = nu.getProto();
            if (!(np instanceof Cell)) continue;
            ((Cell)np).usagesOf.remove(nu);
        }
        Library.databaseObjs.remove(this);
    }

    public void lowLevelRename(CellName newCellName) {
        if (!$assertionsDisabled && !this.isLinked()) {
            throw new AssertionError();
        }
        if (newCellName.equals(this.cellName)) {
            return;
        }
        this.lib.removeCell(this);
        this.cellGroup.remove(this);
        this.setCellName(newCellName);
        this.lowLevelLinkCellName();
        this.checkInvariants();
    }

    private void lowLevelLinkCellName() {
        Cell c;
        String protoName = this.getName();
        View view = this.getView();
        int version = this.getVersion();
        int greatestVersion = 0;
        boolean conflict = version <= 0;
        Iterator it = this.lib.getCells();
        while (it.hasNext()) {
            c = (Cell)it.next();
            if (!c.getName().equalsIgnoreCase(protoName) || c.getView() != view) continue;
            if (c.getVersion() == this.getVersion()) {
                conflict = true;
            }
            if (c.getVersion() <= greatestVersion) continue;
            greatestVersion = c.getVersion();
        }
        if (conflict) {
            if (this.getVersion() > 0) {
                System.out.println("Already have cell " + this.getCellName() + " with version " + this.getVersion() + ", generating a new version");
            }
            CellName cn = CellName.newName(this.getName(), this.getView(), greatestVersion + 1);
            this.setCellName(cn);
        }
        it = this.getViewsTail();
        while (it.hasNext()) {
            c = (Cell)it.next();
            if (!c.getName().equals(this.getName())) continue;
            this.cellGroup = c.cellGroup;
        }
        if (this.cellGroup == null) {
            this.cellGroup = new CellGroup();
        }
        this.lib.addCell(this);
        this.cellGroup.add(this);
    }

    private void setCellName(CellName cellName) {
        this.cellName = cellName;
        String protoName = cellName.getName();
        this.basename = Name.findName(protoName.substring(0, Math.min(8, protoName.length())) + '@').getBasename();
        if (this.basename == null) {
            this.basename = PrimitiveNode.Function.UNKNOWN.getBasename();
        }
    }

    public int lowLevelGetUserbits() {
        return this.userBits;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.checkChanging();
        this.userBits = userBits;
        Undo.otherChange(this);
    }

    public double getDefWidth() {
        return this.getBounds().getWidth();
    }

    public double getDefHeight() {
        return this.getBounds().getHeight();
    }

    public SizeOffset getProtoSizeOffset() {
        return SizeOffset.ZERO_OFFSET;
    }

    public Dimension2D getCharacteristicSpacing() {
        Variable var = this.getVar(CHARACTERISTIC_SPACING);
        if (var != null) {
            Object obj = var.getObject();
            if (obj instanceof Integer[]) {
                Integer[] iSpac = (Integer[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(iSpac[0].intValue(), iSpac[1].intValue());
                return spacing;
            }
            if (obj instanceof Double[]) {
                Double[] dSpac = (Double[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(dSpac[0], dSpac[1]);
                return spacing;
            }
        }
        return null;
    }

    public void setCharacteristicSpacing(double x, double y) {
        Double[] newVals = new Double[]{new Double(x), new Double(y)};
        this.newVar(CHARACTERISTIC_SPACING, (Object)newVals);
    }

    public void setDirty() {
        this.boundsDirty = true;
    }

    public Iterator searchIterator(Rectangle2D bounds) {
        return new RTNode.Search(bounds, this);
    }

    public void rememberBounds() {
        if (this.boundsDirty) {
            this.getBounds();
        }
        this.boundLock = true;
    }

    public Rectangle2D getRememberedBounds() {
        Rectangle2D retBounds = this.lastBounds;
        if (this.boundLock) {
            retBounds = this.cellBounds;
        }
        this.boundLock = false;
        return retBounds;
    }

    public Rectangle2D getBounds() {
        if (this.boundsDirty) {
            int i;
            if (this.boundLock) {
                this.boundLock = false;
                this.lastBounds.setRect(this.cellBounds);
            }
            this.boundsEmpty = true;
            double cellHighY = 0.0;
            double cellLowY = 0.0;
            double cellHighX = 0.0;
            double cellLowX = 0.0;
            for (i = 0; i < this.nodes.size(); ++i) {
                NodeInst ni = (NodeInst)this.nodes.get(i);
                NodeProto np = ni.getProto();
                if (np == Generic.tech.cellCenterNode) continue;
                if (np == Generic.tech.invisiblePinNode) {
                    boolean found = false;
                    Iterator it = ni.getVariables();
                    while (it.hasNext()) {
                        ImmutableTextDescriptor td;
                        Variable var = (Variable)it.next();
                        if (!var.isDisplay() || !(td = var.getTextDescriptor()).isInterior() && !td.isInherit()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                Rectangle2D bounds = ni.getBounds();
                double lowx = bounds.getMinX();
                double highx = bounds.getMaxX();
                double lowy = bounds.getMinY();
                double highy = bounds.getMaxY();
                if (this.boundsEmpty) {
                    this.boundsEmpty = false;
                    cellLowX = lowx;
                    cellHighX = highx;
                    cellLowY = lowy;
                    cellHighY = highy;
                    continue;
                }
                if (lowx < cellLowX) {
                    cellLowX = lowx;
                }
                if (highx > cellHighX) {
                    cellHighX = highx;
                }
                if (lowy < cellLowY) {
                    cellLowY = lowy;
                }
                if (!(highy > cellHighY)) continue;
                cellHighY = highy;
            }
            for (i = 0; i < this.arcs.size(); ++i) {
                ArcInst ai = (ArcInst)this.arcs.get(i);
                Rectangle2D bounds = ai.getBounds();
                double lowx = bounds.getMinX();
                double highx = bounds.getMaxX();
                double lowy = bounds.getMinY();
                double highy = bounds.getMaxY();
                if (lowx < cellLowX) {
                    cellLowX = lowx;
                }
                if (highx > cellHighX) {
                    cellHighX = highx;
                }
                if (lowy < cellLowY) {
                    cellLowY = lowy;
                }
                if (!(highy > cellHighY)) continue;
                cellHighY = highy;
            }
            this.cellBounds.setRect(DBMath.round(cellLowX), DBMath.round(cellLowY), DBMath.round(cellHighX - cellLowX), DBMath.round(cellHighY - cellLowY));
            this.boundsDirty = false;
        }
        return this.cellBounds;
    }

    RTNode getRTree() {
        return this.rTree;
    }

    void setRTree(RTNode rTree) {
        this.checkChanging();
        this.rTree = rTree;
    }

    public Rectangle2D findEssentialBounds() {
        if (this.essenBounds.size() < 2) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < this.essenBounds.size(); ++i) {
            NodeInst ni = (NodeInst)this.essenBounds.get(i);
            minX = Math.min(minX, ni.getTrueCenterX());
            maxX = Math.max(maxX, ni.getTrueCenterX());
            minY = Math.min(minY, ni.getTrueCenterY());
            maxY = Math.max(maxY, ni.getTrueCenterY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public void adjustReferencePoint(NodeInst referencePointNode) {
        NodeInst ni;
        this.checkChanging();
        double cX = referencePointNode.getAnchorCenterX();
        double cY = referencePointNode.getAnchorCenterY();
        if (cX == 0.0 && cY == 0.0) {
            return;
        }
        referencePointNode.modifyInstance(-cX, -cY, 0.0, 0.0, 0);
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            if (ni == referencePointNode) continue;
            ni.lowLevelModify(-cX, -cY, 0.0, 0.0, 0);
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ai.lowLevelModify(0.0, -cX, -cY, -cX, -cY);
        }
        it = this.getInstancesOf();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            Undo.redrawObject(ni);
            AffineTransform trans = NodeInst.pureRotate(ni.getAngle(), ni.isMirroredAboutXAxis(), ni.isMirroredAboutYAxis());
            Point2D.Double in = new Point2D.Double(cX, cY);
            trans.transform(in, in);
            ni.modifyInstance(((Point2D)in).getX(), ((Point2D)in).getY(), 0.0, 0.0, 0);
        }
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            Cell cell;
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (cell = content.getCell()) != this) continue;
            EditWindow wnd = (EditWindow)content;
            Point2D off = wnd.getOffset();
            off.setLocation(off.getX() - cX, off.getY() - cY);
            wnd.setOffset(off);
        }
    }

    public boolean alreadyCellCenter() {
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() != Generic.tech.cellCenterNode) continue;
            return true;
        }
        return false;
    }

    public synchronized Iterator getNodes() {
        ArrayList nodesCopy = new ArrayList(this.nodes);
        return nodesCopy.iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public final NodeInst getNode(int nodeIndex) {
        return (NodeInst)this.nodes.get(nodeIndex);
    }

    public synchronized Iterator getUsagesIn() {
        HashMap usagesCopy = new HashMap(this.usagesIn);
        return usagesCopy.values().iterator();
    }

    public int getNumUsagesIn() {
        return this.usagesIn.size();
    }

    public NodeInst findNode(String name) {
        NodeInst ni;
        int nodeIndex = this.searchNode(name, 0);
        if (nodeIndex >= 0) {
            return (NodeInst)this.nodes.get(nodeIndex);
        }
        if ((nodeIndex = -nodeIndex - 1) < this.nodes.size() && (ni = (NodeInst)this.nodes.get(nodeIndex)).getName().equals(name)) {
            return ni;
        }
        return null;
    }

    public static void setAllowCircularLibraryDependences(boolean val) {
        allowCirDep = val;
    }

    public boolean addNode(NodeInst ni) {
        Library.LibraryDependency libDep;
        Cell instProto;
        this.checkChanging();
        String name = ni.getName();
        NodeUsage nu = ni.getNodeUsage();
        if (nu.contains(ni)) {
            System.out.println("Cell " + this + " already contains node inst " + ni);
            return true;
        }
        NodeProto protoType = nu.getProto();
        if (protoType instanceof Cell && (instProto = (Cell)protoType).getLibrary() != this.getLibrary() && (libDep = this.getLibrary().addReferencedLib(instProto.getLibrary())) != null) {
            if (!allowCirDep) {
                System.out.println("ERROR: " + this.libDescribe() + " cannot instantiate " + instProto.libDescribe() + " because it would create a circular library dependence: ");
                System.out.println(libDep.toString());
                return true;
            }
            System.out.println("WARNING: " + this.libDescribe() + " instantiates " + instProto.libDescribe() + " which causes a circular library dependence: ");
            System.out.println(libDep.toString());
        }
        this.addNodeName(ni);
        nu.addInst(ni);
        return false;
    }

    public void addNodeName(NodeInst ni) {
        int nodeIndex = this.searchNode(ni.getName(), ni.getDuplicate());
        if (!$assertionsDisabled && nodeIndex >= 0) {
            throw new AssertionError();
        }
        this.nodes.add(nodeIndex, ni);
        for (nodeIndex = -nodeIndex - 1; nodeIndex < this.nodes.size(); ++nodeIndex) {
            NodeInst n = (NodeInst)this.nodes.get(nodeIndex);
            n.setNodeIndex(nodeIndex);
        }
        this.addTempName(ni);
    }

    public int fixupNodeDuplicate(Name name, int duplicate) {
        String nameString = name.toString();
        int nodeIndex = 0;
        if (duplicate >= 0 && (nodeIndex = this.searchNode(nameString, duplicate)) >= 0) {
            duplicate = -1;
        }
        if (duplicate < 0) {
            nodeIndex = this.searchNode(nameString, Integer.MAX_VALUE);
            if (nodeIndex < 0) {
                NodeInst n;
                duplicate = 0;
                if (nodeIndex != -1 && (n = (NodeInst)this.nodes.get(-nodeIndex - 2)).getName().equals(nameString)) {
                    duplicate = n.getDuplicate() + 1;
                }
            } else {
                duplicate = 0;
                while ((nodeIndex = this.searchNode(nameString, duplicate)) >= 0) {
                    ++duplicate;
                }
            }
        }
        if (!$assertionsDisabled && nodeIndex >= 0) {
            throw new AssertionError();
        }
        nodeIndex = -nodeIndex - 1;
        return duplicate;
    }

    public void removeNode(NodeInst ni) {
        this.checkChanging();
        if (!$assertionsDisabled && !ni.isLinked()) {
            throw new AssertionError();
        }
        NodeUsage nu = ni.getNodeUsage();
        if (nu == null || !nu.contains(ni)) {
            System.out.println("Cell " + this + " doesn't contain node inst " + ni);
            return;
        }
        nu.removeInst(ni);
        if (nu.isEmpty()) {
            this.removeUsage(nu);
        }
        this.removeNodeName(ni);
    }

    public void removeNodeName(NodeInst ni) {
        int nodeIndex = ni.getNodeIndex();
        NodeInst removedNi = (NodeInst)this.nodes.remove(nodeIndex);
        if (!$assertionsDisabled && removedNi != ni) {
            throw new AssertionError();
        }
        for (int i = nodeIndex; i < this.nodes.size(); ++i) {
            NodeInst n = (NodeInst)this.nodes.get(i);
            n.setNodeIndex(i);
        }
        ni.setNodeIndex(-1);
        this.removeTempName(ni);
    }

    public NodeUsage addUsage(NodeProto protoType) {
        NodeUsage nu;
        this.checkChanging();
        if (!this.isLinked()) {
            System.out.println("addUsage of " + protoType + " to unlinked " + this);
        }
        if ((nu = (NodeUsage)this.usagesIn.get(protoType)) == null) {
            nu = new NodeUsage(protoType, this);
            this.usagesIn.put(protoType, nu);
            if (protoType instanceof Cell) {
                ((Cell)protoType).usagesOf.add(nu);
            }
        }
        return nu;
    }

    private void removeUsage(NodeUsage nu) {
        NodeProto protoType;
        if (!this.isLinked()) {
            System.out.println("removeUsage of " + nu.getProto() + " to unliked " + this);
        }
        if ((protoType = nu.getProto()) instanceof Cell) {
            ((Cell)protoType).usagesOf.remove(nu);
            this.getLibrary().removeReferencedLib(((Cell)protoType).getLibrary());
        }
        this.usagesIn.remove(protoType);
    }

    private int searchNode(String name, int duplicate) {
        int high;
        int low = 0;
        int pick = high = this.nodes.size() - 1;
        while (low <= high) {
            NodeInst ni = (NodeInst)this.nodes.get(pick);
            int cmp = TextUtils.nameSameNumeric(ni.getName(), name);
            if (cmp == 0) {
                cmp = ni.getDuplicate() - duplicate;
            }
            if (cmp < 0) {
                low = pick + 1;
            } else if (cmp > 0) {
                high = pick - 1;
            } else {
                return pick;
            }
            pick = low + high >> 1;
        }
        return -(low + 1);
    }

    public void linkNode(NodeInst ni) {
        this.boundsDirty = true;
        RTNode.linkGeom(this, ni);
        NodeProto np = ni.getProto();
        if (np == Generic.tech.cellCenterNode) {
            this.adjustReferencePoint(ni);
        }
        if (np == Generic.tech.essentialBoundsNode) {
            this.essenBounds.add(ni);
        }
    }

    public void unLinkNode(NodeInst ni) {
        this.boundsDirty = true;
        RTNode.unLinkGeom(this, ni);
        this.essenBounds.remove(ni);
    }

    public synchronized Iterator getArcs() {
        ArrayList arcsCopy = new ArrayList(this.arcs);
        return arcsCopy.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return (ArcInst)this.arcs.get(arcIndex);
    }

    public ArcInst findArc(String name) {
        ArcInst ai;
        int arcIndex = this.searchArc(name, 0);
        if (arcIndex >= 0) {
            return (ArcInst)this.arcs.get(arcIndex);
        }
        if ((arcIndex = -arcIndex - 1) < this.arcs.size() && (ai = (ArcInst)this.arcs.get(arcIndex)).getName().equals(name)) {
            return ai;
        }
        return null;
    }

    public int addArc(ArcInst ai) {
        ArcInst a;
        this.checkChanging();
        String name = ai.getName();
        int duplicate = ai.getDuplicate();
        int arcIndex = 0;
        if (duplicate >= 0 && (arcIndex = this.searchArc(name, duplicate)) >= 0) {
            if (this.arcs.get(arcIndex) == ai) {
                System.out.println("Cell " + this + " already contains arc " + ai);
                return duplicate;
            }
            duplicate = -1;
        }
        if (duplicate < 0) {
            arcIndex = this.searchArc(name, Integer.MAX_VALUE);
            if (arcIndex < 0) {
                duplicate = 0;
                if (arcIndex != -1 && (a = (ArcInst)this.arcs.get(-arcIndex - 2)).getName().equals(name)) {
                    duplicate = a.getDuplicate() + 1;
                }
            } else {
                duplicate = 0;
                while ((arcIndex = this.searchArc(name, duplicate)) >= 0) {
                    ++duplicate;
                }
            }
        }
        if (!$assertionsDisabled && arcIndex >= 0) {
            throw new AssertionError();
        }
        this.arcs.add(arcIndex, ai);
        for (arcIndex = -arcIndex - 1; arcIndex < this.arcs.size(); ++arcIndex) {
            a = (ArcInst)this.arcs.get(arcIndex);
            a.setArcIndex(arcIndex);
        }
        this.addTempName(ai);
        return duplicate;
    }

    public void removeArc(ArcInst ai) {
        this.checkChanging();
        if (!$assertionsDisabled && !ai.isLinked()) {
            throw new AssertionError();
        }
        int arcIndex = ai.getArcIndex();
        ArcInst removedAi = (ArcInst)this.arcs.remove(arcIndex);
        if (!$assertionsDisabled && removedAi != ai) {
            throw new AssertionError();
        }
        for (int i = arcIndex; i < this.arcs.size(); ++i) {
            ArcInst a = (ArcInst)this.arcs.get(i);
            a.setArcIndex(i);
        }
        ai.setArcIndex(-1);
        this.removeTempName(ai);
    }

    private int searchArc(String name, int duplicate) {
        int low = 0;
        int high = this.arcs.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            ArcInst ai = (ArcInst)this.arcs.get(mid);
            int cmp = TextUtils.nameSameNumeric(ai.getName(), name);
            if (cmp == 0) {
                cmp = ai.getDuplicate() - duplicate;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void linkArc(ArcInst ai) {
        this.boundsDirty = true;
        RTNode.linkGeom(this, ai);
    }

    public void unLinkArc(ArcInst ai) {
        this.boundsDirty = true;
        RTNode.unLinkGeom(this, ai);
    }

    void addExport(Export export, Collection oldPortInsts) {
        this.checkChanging();
        int portIndex = -this.searchExport(export.getName()) - 1;
        if (!$assertionsDisabled && portIndex < 0) {
            throw new AssertionError();
        }
        export.setPortIndex(portIndex);
        Export[] newExports = new Export[this.exports.length + 1];
        System.arraycopy(this.exports, 0, newExports, 0, portIndex);
        newExports[portIndex] = export;
        for (int i = portIndex; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            e.setPortIndex(i + 1);
            newExports[i + 1] = e;
        }
        this.exports = newExports;
        if (oldPortInsts != null) {
            Iterator it = oldPortInsts.iterator();
            while (it.hasNext()) {
                PortInst pi = (PortInst)it.next();
                pi.getNodeInst().linkPortInst(pi);
            }
        } else {
            Iterator it = this.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.addPortInst(export);
            }
        }
    }

    Collection removeExport(Export export) {
        this.checkChanging();
        int portIndex = export.getPortIndex();
        Export[] newExports = this.exports.length > 1 ? new Export[this.exports.length - 1] : NULL_EXPORT_ARRAY;
        System.arraycopy(this.exports, 0, newExports, 0, portIndex);
        for (int i = portIndex; i < newExports.length; ++i) {
            Export e = this.exports[i + 1];
            e.setPortIndex(i);
            newExports[i] = e;
        }
        this.exports = newExports;
        ArrayList<PortInst> portInsts = new ArrayList<PortInst>();
        Iterator it = this.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            portInsts.add(ni.removePortInst(export));
        }
        export.setPortIndex(-1);
        return portInsts;
    }

    void moveExport(int oldPortIndex, String newName) {
        Export e;
        int i;
        Export export = this.exports[oldPortIndex];
        int newPortIndex = -this.searchExport(newName) - 1;
        System.out.println("Move " + export + " " + oldPortIndex + " " + newPortIndex);
        if (newPortIndex < 0) {
            return;
        }
        if (newPortIndex > oldPortIndex) {
            --newPortIndex;
        }
        if (newPortIndex == oldPortIndex) {
            return;
        }
        if (newPortIndex > oldPortIndex) {
            for (i = oldPortIndex; i < newPortIndex; ++i) {
                e = this.exports[i + 1];
                e.setPortIndex(i);
                this.exports[i] = e;
            }
        } else {
            for (i = oldPortIndex; i > newPortIndex; --i) {
                e = this.exports[i - 1];
                e.setPortIndex(i);
                this.exports[i] = e;
            }
        }
        export.setPortIndex(newPortIndex);
        this.exports[newPortIndex] = export;
        for (i = 0; i < this.exports.length; ++i) {
            System.out.print(" " + this.exports[i].getPortIndex() + ":" + this.exports[i].getName());
        }
        System.out.println();
        Iterator it = this.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            ni.movePortInst(oldPortIndex);
        }
    }

    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        int portIndex = this.searchExport(name.toString());
        if (portIndex >= 0) {
            return this.exports[portIndex];
        }
        name = name.lowerCase();
        for (int i = 0; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            if (e.getNameKey().lowerCase() != name) continue;
            return e;
        }
        return null;
    }

    public Iterator getPorts() {
        return ArrayIterator.iterator(this.exports);
    }

    public int getNumPorts() {
        return this.exports.length;
    }

    public final PortProto getPort(int portIndex) {
        return this.exports[portIndex];
    }

    public Export findExport(String name) {
        return (Export)this.findPortProto(name);
    }

    public Export findExport(Name name) {
        return (Export)this.findPortProto(name);
    }

    private int searchExport(String name) {
        int low = 0;
        int high = this.exports.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Export e = this.exports[mid];
            int cmp = TextUtils.nameSameNumeric(e.getName(), name);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public String getName() {
        return this.cellName.getName();
    }

    public CellName getCellName() {
        return this.cellName;
    }

    public String describe(boolean withQuotes) {
        String name = "";
        if (this.lib != Library.getCurrent()) {
            name = name + this.lib.getName() + ":";
        }
        name = name + this.noLibDescribe();
        return withQuotes ? "'" + name + "'" : name;
    }

    public String libDescribe() {
        return this.lib.getName() + ":" + this.noLibDescribe();
    }

    public String noLibDescribe() {
        String name = this.getName();
        if (this.getNewestVersion() != this) {
            name = name + ";" + this.getVersion();
        }
        name = name + "{" + this.getView().getAbbreviation() + "}";
        return name;
    }

    public static NodeProto findNodeProto(String line) {
        Comparable np;
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        Library lib = Library.getCurrent();
        boolean saidtech = false;
        boolean saidlib = false;
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            Library l;
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
                saidtech = true;
            }
            if ((l = Library.findLibrary(prefix)) != null) {
                lib = l;
                saidlib = true;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        if (!saidlib && (np = tech.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        if (!saidtech && (np = lib.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        return null;
    }

    public String[] getTextViewContents() {
        String[] strings = TextWindow.getEditedText(this);
        if (strings != null) {
            return strings;
        }
        Variable var = this.getVar(CELL_TEXT_KEY);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (!(obj instanceof String[])) {
            return null;
        }
        return (String[])obj;
    }

    public void setTextViewContents(String[] strings) {
        Job.checkChanging();
        TextWindow.updateText(this, strings);
        this.newVar(CELL_TEXT_KEY, (Object)strings);
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow wnd) {
        int dispVars = this.numDisplayableVariables(false);
        if (dispVars == 0) {
            return null;
        }
        Poly[] polys = new Poly[dispVars];
        this.addDisplayableVariables(CENTERRECT, polys, 0, wnd, false);
        return polys;
    }

    public Rectangle2D getRelativeTextBounds(EditWindow wnd) {
        Rectangle2D bounds = null;
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ni, bounds, wnd);
            Iterator pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                bounds = this.accumulateTextBoundsOnObject(pi, bounds, wnd);
            }
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ai, bounds, wnd);
        }
        it = this.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            bounds = this.accumulateTextBoundsOnObject(pp, bounds, wnd);
        }
        bounds = this.accumulateTextBoundsOnObject(this, bounds, wnd);
        return bounds;
    }

    private Rectangle2D accumulateTextBoundsOnObject(ElectricObject eObj, Rectangle2D bounds, EditWindow wnd) {
        Poly poly;
        Geometric geom;
        Name name;
        Rectangle2D polyBound;
        Poly poly2;
        Iterator vIt = eObj.getVariables();
        while (vIt.hasNext()) {
            ImmutableTextDescriptor td;
            Variable var = (Variable)vIt.next();
            if (!var.isDisplay() || (td = var.getTextDescriptor()).getSize().isAbsolute() || (poly2 = eObj.computeTextPoly(wnd, var, null)) == null) continue;
            polyBound = poly2.getBounds2D();
            if (bounds == null) {
                bounds = polyBound;
                continue;
            }
            Rectangle2D.union(bounds, polyBound, bounds);
        }
        if (eObj instanceof Geometric && !(name = (geom = (Geometric)eObj).getNameKey()).isTempname() && (poly = eObj.computeTextPoly(wnd, null, name)) != null) {
            Rectangle2D polyBound2 = poly.getBounds2D();
            if (bounds == null) {
                bounds = polyBound2;
            } else {
                Rectangle2D.union(bounds, polyBound2, bounds);
            }
        }
        if (eObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)eObj;
            Iterator it = ni.getExports();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                poly2 = pp.computeTextPoly(wnd, null, null);
                if (poly2 == null) continue;
                polyBound = poly2.getBounds2D();
                if (bounds == null) {
                    bounds = polyBound;
                    continue;
                }
                Rectangle2D.union(bounds, polyBound, bounds);
            }
        }
        return bounds;
    }

    public Name getBasename() {
        return this.basename;
    }

    public Name getAutoname(Name basename) {
        MaxSuffix ms = (MaxSuffix)this.maxSuffix.get(basename);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basename.lowerCase(), ms);
            return basename.findSuffixed(0);
        }
        ++ms.v;
        return basename.findSuffixed(ms.v);
    }

    public void addTempName(Geometric geom) {
        Name name = geom.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        this.tempNames.put(name.lowerCase(), geom);
        Name basename = name.getBasename();
        if (basename != null && basename != name) {
            int numSuffix;
            MaxSuffix ms = (MaxSuffix)this.maxSuffix.get(basename = basename.lowerCase());
            if (ms == null) {
                ms = new MaxSuffix();
                this.maxSuffix.put(basename, ms);
            }
            if ((numSuffix = name.getNumSuffix()) > ms.v) {
                ms.v = numSuffix;
            }
        }
    }

    public void removeTempName(Geometric geom) {
        Name name = geom.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        this.tempNames.remove(name.lowerCase());
    }

    public boolean hasTempName(Name name) {
        return this.tempNames.get(name) != null;
    }

    public int getUniqueNameIndex(String prefix, Class cls, int startingIndex) {
        int uniqueIndex;
        block4: {
            int len;
            block5: {
                block3: {
                    len = prefix.length();
                    uniqueIndex = startingIndex;
                    if (cls != PortProto.class) break block3;
                    Iterator it = this.getPorts();
                    while (it.hasNext()) {
                        int indexVal;
                        String restOfName;
                        PortProto pp = (PortProto)it.next();
                        if (!TextUtils.startsWithIgnoreCase(pp.getName(), prefix) || !TextUtils.isANumber(restOfName = pp.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                        uniqueIndex = indexVal + 1;
                    }
                    break block4;
                }
                if (cls != NodeInst.class) break block5;
                Iterator it = this.getNodes();
                while (it.hasNext()) {
                    int indexVal;
                    String restOfName;
                    NodeInst ni = (NodeInst)it.next();
                    if (!TextUtils.startsWithIgnoreCase(ni.getName(), prefix) || !TextUtils.isANumber(restOfName = ni.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                    uniqueIndex = indexVal + 1;
                }
                break block4;
            }
            if (cls != ArcInst.class) break block4;
            Iterator it = this.getArcs();
            while (it.hasNext()) {
                int indexVal;
                String restOfName;
                ArcInst ai = (ArcInst)it.next();
                if (!TextUtils.startsWithIgnoreCase(ai.getName(), prefix) || !TextUtils.isANumber(restOfName = ai.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                uniqueIndex = indexVal + 1;
            }
        }
        return uniqueIndex;
    }

    public boolean isUniqueName(String name, Class cls, ElectricObject exclude) {
        return this.isUniqueName(Name.findName(name), cls, exclude);
    }

    public boolean isUniqueName(Name name, Class cls, ElectricObject exclude) {
        name = name.lowerCase();
        if (cls == PortProto.class) {
            Export pp = this.findExport(name);
            return pp == null || exclude == pp;
        }
        if (cls == NodeInst.class) {
            if (name.isTempname()) {
                Geometric geom = (Geometric)this.tempNames.get(name);
                return geom == null || exclude == geom;
            }
            Iterator it = this.getNodes();
            while (it.hasNext()) {
                Name nodeName;
                NodeInst ni = (NodeInst)it.next();
                if (exclude == ni || name != (nodeName = ni.getNameKey()).lowerCase()) continue;
                return false;
            }
            return true;
        }
        if (cls == ArcInst.class) {
            if (name.isTempname()) {
                Geometric geom = (Geometric)this.tempNames.get(name);
                return geom == null || exclude == geom;
            }
            Iterator it = this.getArcs();
            while (it.hasNext()) {
                Name arcName;
                ArcInst ai = (ArcInst)it.next();
                if (exclude == ai || name != (arcName = ai.getNameKey()).lowerCase()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        String name = key.getName();
        if (name.equals("NET_last_good_ncc") || name.equals("NET_last_good_ncc_facet") || name.equals("SIM_window_signal_order")) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public String toString() {
        return "cell " + this.describe(true);
    }

    public Iterator getUsagesOf() {
        return this.usagesOf.iterator();
    }

    public Iterator getInstancesOf() {
        return new NodeInstsIterator();
    }

    public static boolean isInstantiationRecursive(Cell toInstantiate, Cell parent) {
        if (toInstantiate == parent) {
            return true;
        }
        if (toInstantiate.isIconOf(parent) && toInstantiate.isIcon() && !parent.isIcon()) {
            return false;
        }
        return parent.isAChildOf(toInstantiate);
    }

    public boolean isAChildOf(Cell parent) {
        return this.getIsAChildOf(parent, new HashMap());
    }

    private boolean getIsAChildOf(Cell parent, Map checkedParents) {
        Cell c;
        if (parent.isIcon() && (c = parent.contentsView()) != null && c != parent && this.getIsAChildOf(c, checkedParents)) {
            return true;
        }
        if (checkedParents.get(parent) != null) {
            return false;
        }
        checkedParents.put(parent, parent);
        Cell contentView = this.contentsView();
        if (contentView == null) {
            contentView = this;
        }
        Cell iconView = this.iconView();
        Iterator it = parent.getNodes();
        while (it.hasNext()) {
            Cell c2;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (c2 = (Cell)np).isIconOf(parent)) continue;
            if (c2 == contentView) {
                return true;
            }
            if (c2 == iconView) {
                return true;
            }
            if (!this.getIsAChildOf(c2, checkedParents)) continue;
            return true;
        }
        return false;
    }

    private boolean getIsAParentOf(Cell child) {
        if (this == child) {
            return true;
        }
        Cell lastParent = null;
        Iterator it = child.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getParent() == lastParent) continue;
            lastParent = ni.getParent();
            if (!this.getIsAParentOf(ni.getParent())) continue;
            return true;
        }
        Cell np = child.iconView();
        if (np != null) {
            lastParent = null;
            Iterator it2 = np.getInstancesOf();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                if (ni.getParent() == lastParent) continue;
                lastParent = ni.getParent();
                NodeProto niProto = ni.getProto();
                if (niProto instanceof Cell && ((Cell)niProto).isIconOf(child) && !child.isIcon() || !this.getIsAParentOf(ni.getParent())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInUse(String action) {
        String parents = null;
        Iterator it = this.getUsagesOf();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            Cell parent = nu.getParent();
            if (parents == null) {
                parents = parent.describe(true);
                continue;
            }
            parents = parents + ", " + parent.describe(true);
        }
        if (parents != null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot " + action + " " + this + " because it is used in " + parents, action + " failed", 0);
            return true;
        }
        return false;
    }

    public Cell makeNewVersion() {
        Cell newVersion = Cell.copyNodeProto(this, this.lib, this.noLibDescribe(), false);
        return newVersion;
    }

    public int getVersion() {
        return this.cellName.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumVersions() {
        int count = 0;
        String protoName = this.getName();
        View view = this.getView();
        TreeMap treeMap = this.lib.cells;
        synchronized (treeMap) {
            Cell c;
            Iterator it = this.getVersionsTail();
            while (it.hasNext() && (c = (Cell)it.next()).getName().equals(protoName) && c.getView() == view) {
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getVersions() {
        ArrayList<Cell> versions = new ArrayList<Cell>();
        String protoName = this.getName();
        View view = this.getView();
        TreeMap treeMap = this.lib.cells;
        synchronized (treeMap) {
            Cell c;
            Iterator it = this.getVersionsTail();
            while (it.hasNext() && (c = (Cell)it.next()).getName().equals(protoName) && c.getView() == view) {
                versions.add(c);
            }
        }
        return versions.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell getNewestVersion() {
        TreeMap treeMap = this.lib.cells;
        synchronized (treeMap) {
            Cell c;
            Iterator it = this.getVersionsTail();
            if (it.hasNext() && (c = (Cell)it.next()).getName().equals(this.getName()) && c.getView() == this.getView()) {
                return c;
            }
        }
        return null;
    }

    private Iterator getVersionsTail() {
        CellName cn = CellName.parseName(this.getName() + "{" + this.getView().getAbbreviation() + "}");
        return this.lib.getCellsTail(cn);
    }

    private Iterator getViewsTail() {
        CellName cn = CellName.parseName(this.getName());
        return this.lib.getCellsTail(cn);
    }

    public CellGroup getCellGroup() {
        return this.cellGroup;
    }

    public void joinGroup(Cell otherCell) {
        this.setCellGroup(otherCell.getCellGroup());
    }

    public void putInOwnCellGroup() {
        this.setCellGroup(null);
    }

    public void setCellGroup(CellGroup cellGroup) {
        if (!this.isLinked()) {
            return;
        }
        CellGroup oldCellGroup = this.cellGroup;
        if (cellGroup == null) {
            cellGroup = new CellGroup();
        }
        this.lowLevelSetCellGroup(cellGroup);
        Undo.modifyCellGroup(this, oldCellGroup);
    }

    public void lowLevelSetCellGroup(CellGroup cellGroup) {
        Cell cell;
        this.checkChanging();
        if (cellGroup == this.cellGroup) {
            return;
        }
        String protoName = this.getName();
        Iterator it = this.getViewsTail();
        while (it.hasNext() && (cell = (Cell)it.next()).getName().equals(protoName)) {
            cell.cellGroup.remove(cell);
            cellGroup.add(cell);
        }
    }

    public View getView() {
        return this.cellName.getView();
    }

    public void setView(View newView) {
        this.rename(CellName.newName(this.getName(), newView, this.getVersion()));
    }

    public boolean isIcon() {
        return this.getView() == View.ICON;
    }

    public boolean isIconOf(Cell cell) {
        return this.getView() == View.ICON && this.cellGroup == cell.cellGroup && cell.isSchematic();
    }

    public boolean isMultiPartIcon() {
        return false;
    }

    public boolean isSchematic() {
        return this.getView() == View.SCHEMATIC;
    }

    public int getNumMultiPages() {
        Integer storedCount;
        if (!this.isMultiPage()) {
            return 1;
        }
        Rectangle2D bounds = this.getBounds();
        int numPages = (int)(bounds.getHeight() / 1000.0) + 1;
        Variable var = this.getVar(MULTIPAGE_COUNT_KEY, Integer.class);
        if (var != null && (storedCount = (Integer)var.getObject()) > numPages) {
            numPages = storedCount;
        }
        return numPages;
    }

    public Cell contentsView() {
        Cell cellInGroup;
        if (!this.isIcon() && this.getView() != View.LAYOUTSKEL) {
            return null;
        }
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (!cellInGroup.isSchematic()) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell iconView() {
        if (!this.isSchematic()) {
            return null;
        }
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = (Cell)it.next();
            if (!cellInGroup.isIcon()) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell otherView(View view) {
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != view) continue;
            return cellInGroup.getNewestVersion();
        }
        return null;
    }

    public Netlist getNetlist(boolean shortResistors) {
        return NetworkTool.getNetlist(this, shortResistors);
    }

    public Netlist getUserNetlist() {
        return NetworkTool.getUserNetlist(this);
    }

    public Netlist acquireUserNetlist() {
        return NetworkTool.acquireUserNetlist(this);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void lowLevelSetCreationDate(Date creationDate) {
        this.checkChanging();
        this.creationDate = creationDate;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public void lowLevelSetRevisionDate(Date revisionDate) {
        this.checkChanging();
        this.revisionDate = revisionDate;
    }

    public void madeRevision() {
        this.checkChanging();
        this.revisionDate = new Date();
    }

    public void checkCellDates() {
        HashSet cellsChecked = new HashSet();
        this.checkCellDate(this.getRevisionDate(), cellsChecked);
    }

    private void checkCellDate(Date rev_time, HashSet cellsChecked) {
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            Cell contentsCell;
            Cell subCell;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (subCell = (Cell)np).isIconOf(this)) continue;
            if (!cellsChecked.contains(subCell)) {
                subCell.checkCellDate(rev_time, cellsChecked);
            }
            if ((contentsCell = subCell.contentsView()) == null || cellsChecked.contains(contentsCell)) continue;
            contentsCell.checkCellDate(rev_time, cellsChecked);
        }
        cellsChecked.add(this);
        if (!this.getRevisionDate().after(rev_time)) {
            return;
        }
        System.out.println("WARNING: sub-cell " + this + " has been edited since the last revision to the current cell");
    }

    public void setWantExpanded() {
        this.checkChanging();
        this.userBits |= 2;
        Undo.otherChange(this);
    }

    public void clearWantExpanded() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFD;
        Undo.otherChange(this);
    }

    public boolean isWantExpanded() {
        return (this.userBits & 2) != 0;
    }

    public PrimitiveNode.Function getFunction() {
        return PrimitiveNode.Function.UNKNOWN;
    }

    public void setAllLocked() {
        this.checkChanging();
        this.userBits |= 0x100000;
        Undo.otherChange(this);
    }

    public void clearAllLocked() {
        this.checkChanging();
        this.userBits &= 0xFFEFFFFF;
        Undo.otherChange(this);
    }

    public boolean isAllLocked() {
        return (this.userBits & 0x100000) != 0;
    }

    public void setInstancesLocked() {
        this.checkChanging();
        this.userBits |= 0x200000;
        Undo.otherChange(this);
    }

    public void clearInstancesLocked() {
        this.checkChanging();
        this.userBits &= 0xFFDFFFFF;
        Undo.otherChange(this);
    }

    public boolean isInstancesLocked() {
        return (this.userBits & 0x200000) != 0;
    }

    public void setInCellLibrary() {
        this.checkChanging();
        this.userBits |= 0x400000;
        Undo.otherChange(this);
    }

    public void clearInCellLibrary() {
        this.checkChanging();
        this.userBits &= 0xFFBFFFFF;
        Undo.otherChange(this);
    }

    public boolean isInCellLibrary() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setInTechnologyLibrary() {
        this.checkChanging();
        this.userBits |= 0x800000;
        Undo.otherChange(this);
    }

    public void clearInTechnologyLibrary() {
        this.checkChanging();
        this.userBits &= 0xFF7FFFFF;
        Undo.otherChange(this);
    }

    public boolean isInTechnologyLibrary() {
        return (this.userBits & 0x800000) != 0;
    }

    public void setMultiPage(boolean multi) {
        this.checkChanging();
        this.userBits = multi ? (this.userBits |= 0x7E000000) : (this.userBits &= 0x81FFFFFF);
    }

    public boolean isMultiPage() {
        return (this.userBits & 0x7E000000) != 0;
    }

    public boolean isLinked() {
        return Library.databaseObjs.contains(this);
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        int errorCount = 0;
        Iterator it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            errorCount += ai.checkAndRepair(repair, errorLogger);
        }
        it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            errorCount += ni.checkAndRepair(repair, errorLogger);
        }
        return errorCount;
    }

    void check() {
        if (!$assertionsDisabled && !Library.databaseObjs.contains(this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.cellName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getVersion() <= 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            if (!$assertionsDisabled && e.getParent() != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && e.getPortIndex() != i) {
                throw new AssertionError(e);
            }
            if (i > 0 && !$assertionsDisabled && TextUtils.nameSameNumeric(e.getName(), this.exports[i - 1].getName()) <= 0) {
                throw new AssertionError(i);
            }
            e.check();
        }
        HashSet<Connection> connections = new HashSet<Connection>();
        Geometric prevAi = null;
        for (int i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = (ArcInst)this.arcs.get(i);
            if (!$assertionsDisabled && ai.getParent() != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && ai.getArcIndex() != i) {
                throw new AssertionError();
            }
            if (prevAi != null) {
                int cmp = TextUtils.nameSameNumeric(ai.getName(), prevAi.getName());
                if (!$assertionsDisabled && cmp < 0) {
                    throw new AssertionError();
                }
                if (cmp == 0 && !$assertionsDisabled && ai.getDuplicate() <= ((ArcInst)prevAi).getDuplicate()) {
                    throw new AssertionError();
                }
            }
            ai.check();
            if (!$assertionsDisabled && connections.contains(ai.getHead())) {
                throw new AssertionError(ai);
            }
            connections.add(ai.getHead());
            if (!$assertionsDisabled && connections.contains(ai.getTail())) {
                throw new AssertionError(ai);
            }
            connections.add(ai.getTail());
            prevAi = ai;
        }
        Geometric prevNi = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = (NodeInst)this.nodes.get(i);
            if (!$assertionsDisabled && ni.getParent() != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && ni.getNodeIndex() != i) {
                throw new AssertionError();
            }
            if (prevNi != null) {
                int cmp = TextUtils.nameSameNumeric(ni.getName(), prevNi.getName());
                if (!$assertionsDisabled && cmp < 0) {
                    throw new AssertionError();
                }
                if (cmp == 0 && !$assertionsDisabled && ni.getDuplicate() <= ((NodeInst)prevNi).getDuplicate()) {
                    throw new AssertionError();
                }
            }
            ni.check();
            Iterator pIt = ni.getConnections();
            while (pIt.hasNext()) {
                Connection con = (Connection)pIt.next();
                if (!$assertionsDisabled && !connections.contains(con)) {
                    throw new AssertionError(ni);
                }
                connections.remove(con);
            }
            prevNi = ni;
        }
        if (!$assertionsDisabled && !connections.isEmpty()) {
            throw new AssertionError();
        }
        Iterator it = this.getUsagesIn();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            nu.check();
        }
        if (!$assertionsDisabled && this.cellGroup == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.cellGroup.containsCell(this)) {
            throw new AssertionError();
        }
    }

    public boolean checkInvariants() {
        try {
            this.check();
            return true;
        }
        catch (Throwable e) {
            if (!invariantsFailed) {
                System.out.println("Exception checking invariants of " + this);
                e.printStackTrace();
                ActivityLogger.logException(e);
                invariantsFailed = true;
            }
            return false;
        }
    }

    public boolean objInCell(ElectricObject eObj) {
        block4: {
            block5: {
                block3: {
                    if (!(eObj instanceof NodeInst)) break block3;
                    Iterator it = this.getNodes();
                    while (it.hasNext()) {
                        if ((ElectricObject)it.next() != eObj) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(eObj instanceof ArcInst)) break block5;
                Iterator it = this.getArcs();
                while (it.hasNext()) {
                    if ((ElectricObject)it.next() != eObj) continue;
                    return true;
                }
                break block4;
            }
            if (!(eObj instanceof PortInst)) break block4;
            NodeInst ni = ((PortInst)eObj).getNodeInst();
            Iterator it = this.getNodes();
            while (it.hasNext()) {
                if ((ElectricObject)it.next() != ni) continue;
                return true;
            }
        }
        return false;
    }

    public final int getCellIndex() {
        return this.cellIndex;
    }

    public static int getCellNumber() {
        return cellNumber;
    }

    public void setTempInt(int tempInt) {
        this.checkChanging();
        this.tempInt = tempInt;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    public void setChange(Undo.Change change) {
        this.checkChanging();
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public Cell whichCell() {
        return this;
    }

    public Library getLibrary() {
        return this.lib;
    }

    public Technology getTechnology() {
        if (this.tech == null) {
            this.tech = Technology.whatTechnology(this, null, 0, 0, null, 0, 0);
        }
        return this.tech;
    }

    public void setTechnology(Technology tech) {
        this.checkChanging();
        this.tech = tech;
        Undo.otherChange(this);
    }

    public Cell getEquivalent() {
        return this.isIcon() ? this.cellGroup.getMainSchematics() : this;
    }

    public boolean containsInstance(Geometric thing) {
        if (thing instanceof ArcInst) {
            return this.arcs.contains(thing);
        }
        if (thing instanceof NodeInst) {
            NodeInst ni = (NodeInst)thing;
            NodeUsage nu = (NodeUsage)this.usagesIn.get(ni.getProto());
            return nu != null && nu.contains(ni);
        }
        return false;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Iterator i;
        boolean found;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cell toCompare = (Cell)obj;
        HashSet<Object> noCheckAgain = new HashSet<Object>();
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            found = false;
            NodeInst node = (NodeInst)it.next();
            i = toCompare.getNodes();
            while (i.hasNext()) {
                NodeInst n = (NodeInst)i.next();
                if (noCheckAgain.contains(n) || !node.compare(n, buffer)) continue;
                found = true;
                noCheckAgain.add(n);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding node '" + node + "' found in '" + toCompare + "'\n");
            }
            return false;
        }
        if (this.getNumNodes() != toCompare.getNumNodes()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more nodes than '" + this + "'\n");
            }
            return false;
        }
        it = this.getArcs();
        while (it.hasNext()) {
            found = false;
            ArcInst arc = (ArcInst)it.next();
            i = toCompare.getArcs();
            while (i.hasNext()) {
                ArcInst a = (ArcInst)i.next();
                if (noCheckAgain.contains(a) || !arc.compare(a, buffer)) continue;
                found = true;
                noCheckAgain.add(a);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding arc '" + arc + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumArcs() != toCompare.getNumArcs()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more arcs than '" + this + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getPorts();
        while (it.hasNext()) {
            found = false;
            Export port = (Export)it.next();
            i = toCompare.getPorts();
            while (i.hasNext()) {
                Export p = (Export)i.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding port '" + port.getName() + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumPorts() != toCompare.getNumPorts()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more pors than '" + this + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            boolean found2 = false;
            i = toCompare.getVariables();
            while (i.hasNext()) {
                Variable v = (Variable)i.next();
                if (noCheckAgain.contains(v) || !var.compare(v, buffer)) continue;
                found2 = true;
                noCheckAgain.add(v);
                break;
            }
            if (found2) continue;
            if (buffer != null) {
                buffer.append("No corresponding variable '" + var + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumVariables() != toCompare.getNumVariables()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare + "' has more variables than '" + this + "'\n");
            }
            return false;
        }
        return true;
    }

    public int compareTo(Object obj) {
        int cmp;
        Cell that = (Cell)obj;
        if (this.lib != that.lib && (cmp = this.lib.compareTo(that.lib)) != 0) {
            return cmp;
        }
        return this.getCellName().compareTo(that.getCellName());
    }

    public void getZValues(double[] array) {
        int i;
        for (i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = (NodeInst)this.nodes.get(i);
            NodeProto nProto = ni.getProto();
            if (nProto instanceof Cell) {
                Cell nCell = (Cell)nProto;
                nCell.getZValues(array);
                continue;
            }
            PrimitiveNode np = (PrimitiveNode)nProto;
            np.getZValues(array);
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = (ArcInst)this.arcs.get(i);
            ArcProto ap = ai.getProto();
            ap.getZValues(array);
        }
    }

    public boolean findReferenceInCell(Library elib, Set set) {
        if (this.lib == elib) {
            return true;
        }
        int initial = set.size();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = (NodeInst)this.nodes.get(i);
            NodeProto nProto = ni.getProto();
            if (!(nProto instanceof Cell)) continue;
            Cell nCell = (Cell)nProto;
            if (nCell.getLibrary() == elib) {
                set.add(this);
                continue;
            }
            nCell.findReferenceInCell(elib, set);
        }
        return set.size() != initial;
    }

    static {
        $assertionsDisabled = !Cell.class.desiredAssertionStatus();
        CHARACTERISTIC_SPACING = ElectricObject.newKey("FACET_characteristic_spacing");
        CELL_TEXT_KEY = ElectricObject.newKey("FACET_message");
        MULTIPAGE_COUNT_KEY = ElectricObject.newKey("CELL_page_count");
        NULL_EXPORT_ARRAY = new Export[0];
        CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        cellNumber = 0;
        allowCirDep = false;
        invariantsFailed = false;
    }

    private class NodeInstsIterator
    implements Iterator {
        private Iterator uit;
        private NodeUsage nu;
        private int i;
        private int n;

        NodeInstsIterator() {
            this.uit = Cell.this.getUsagesOf();
            this.n = 0;
            this.i = 0;
            while (this.i >= this.n && this.uit.hasNext()) {
                this.nu = (NodeUsage)this.uit.next();
                this.n = this.nu.getNumInsts();
            }
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public Object next() {
            if (this.i >= this.n) {
                this.uit.next();
            }
            NodeInst ni = this.nu.getInst(this.i);
            ++this.i;
            while (this.i >= this.n && this.uit.hasNext()) {
                this.nu = (NodeUsage)this.uit.next();
                this.n = this.nu.getNumInsts();
                this.i = 0;
            }
            return ni;
        }

        public void remove() {
            throw new UnsupportedOperationException("NodeInstsIterator.remove()");
        }
    }

    public static class FrameDescription {
        public static final double MULTIPAGESEPARATION = 1000.0;
        private static final double FRAMESCALE = 18.0;
        private static final double HASCHXSIZE = 153.0;
        private static final double HASCHYSIZE = 99.0;
        private static final double ASCHXSIZE = 198.0;
        private static final double ASCHYSIZE = 153.0;
        private static final double BSCHXSIZE = 306.0;
        private static final double BSCHYSIZE = 198.0;
        private static final double CSCHXSIZE = 432.0;
        private static final double CSCHYSIZE = 306.0;
        private static final double DSCHXSIZE = 648.0;
        private static final double DSCHYSIZE = 432.0;
        private static final double ESCHXSIZE = 864.0;
        private static final double ESCHYSIZE = 648.0;
        private static final double FRAMEWID = 2.6999999999999997;
        private static final double XLOGOBOX = 36.0;
        private static final double YLOGOBOX = 18.0;
        private Cell cell;
        private List lineFromEnd;
        private List lineToEnd;
        private List textPoint;
        private List textSize;
        private List textBox;
        private List textMessage;
        private int pageNo;

        public FrameDescription(Cell cell, int pageNo) {
            this.cell = cell;
            this.pageNo = pageNo;
            this.lineFromEnd = new ArrayList();
            this.lineToEnd = new ArrayList();
            this.textPoint = new ArrayList();
            this.textSize = new ArrayList();
            this.textBox = new ArrayList();
            this.textMessage = new ArrayList();
            this.loadFrame();
        }

        public void renderInit() {
        }

        public void showFrameLine(Point2D from, Point2D to) {
        }

        public void showFrameText(Point2D ctr, double size, double maxWid, double maxHei, String string) {
        }

        public void renderFrame() {
            int i;
            double offY = 0.0;
            if (this.cell.isMultiPage()) {
                offY = (double)this.pageNo * 1000.0;
            }
            for (i = 0; i < this.lineFromEnd.size(); ++i) {
                Point2D from = (Point2D)this.lineFromEnd.get(i);
                Point2D to = (Point2D)this.lineToEnd.get(i);
                if (offY != 0.0) {
                    from = new Point2D.Double(from.getX(), from.getY() + offY);
                    to = new Point2D.Double(to.getX(), to.getY() + offY);
                }
                this.showFrameLine(from, to);
            }
            for (i = 0; i < this.textPoint.size(); ++i) {
                Point2D at = (Point2D)this.textPoint.get(i);
                if (offY != 0.0) {
                    at = new Point2D.Double(at.getX(), at.getY() + offY);
                }
                double size = (Double)this.textSize.get(i);
                Point2D box = (Point2D)this.textBox.get(i);
                double width = box.getX();
                double height = box.getY();
                String msg = (String)this.textMessage.get(i);
                this.showFrameText(at, size, width, height, msg);
            }
        }

        public static int getCellFrameInfo(Cell cell, Dimension d) {
            Variable var = cell.getVar(User.FRAME_SIZE, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
            if (var == null) {
                return 2;
            }
            String frameInfo = (String)var.getObject();
            if (frameInfo.length() == 0) {
                return 2;
            }
            int retval = 0;
            char chr = frameInfo.charAt(0);
            double wid = 0.0;
            double hei = 0.0;
            if (chr == 'x') {
                wid = 38.7;
                hei = 20.7;
                retval = 1;
            } else {
                switch (chr) {
                    case 'h': {
                        wid = 153.0;
                        hei = 99.0;
                        break;
                    }
                    case 'a': {
                        wid = 198.0;
                        hei = 153.0;
                        break;
                    }
                    case 'b': {
                        wid = 306.0;
                        hei = 198.0;
                        break;
                    }
                    case 'c': {
                        wid = 432.0;
                        hei = 306.0;
                        break;
                    }
                    case 'd': {
                        wid = 648.0;
                        hei = 432.0;
                        break;
                    }
                    case 'e': {
                        wid = 864.0;
                        hei = 648.0;
                    }
                }
            }
            if (frameInfo.indexOf("v") >= 0) {
                d.setSize(hei, wid);
            } else {
                d.setSize(wid, hei);
            }
            return retval;
        }

        private void loadFrame() {
            Dimension d = new Dimension();
            int frameFactor = FrameDescription.getCellFrameInfo(this.cell, d);
            if (frameFactor == 2) {
                return;
            }
            Variable var = this.cell.getVar(User.FRAME_SIZE, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
            if (var == null) {
                return;
            }
            String frameInfo = (String)var.getObject();
            double schXSize = d.getWidth();
            double schYSize = d.getHeight();
            boolean drawTitleBox = true;
            int xSections = 8;
            int ySections = 4;
            if (frameFactor == 1) {
                ySections = 0;
                xSections = 0;
            } else {
                if (frameInfo.indexOf("v") >= 0) {
                    xSections = 4;
                    ySections = 8;
                }
                if (frameInfo.indexOf("n") >= 0) {
                    drawTitleBox = false;
                }
            }
            double xLogoBox = 36.0;
            double yLogoBox = 18.0;
            double frameWid = 2.6999999999999997;
            if (xSections > 0) {
                char chr;
                int i;
                double xSecSize = (schXSize - frameWid * 2.0) / (double)xSections;
                double ySecSize = (schYSize - frameWid * 2.0) / (double)ySections;
                Point2D.Double point0 = new Point2D.Double(-schXSize / 2.0, -schYSize / 2.0);
                Point2D.Double point1 = new Point2D.Double(-schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0, -schYSize / 2.0);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, -schYSize / 2.0 + frameWid);
                point1 = new Point2D.Double(-schXSize / 2.0 + frameWid, schYSize / 2.0 - frameWid);
                point2 = new Point2D.Double(schXSize / 2.0 - frameWid, schYSize / 2.0 - frameWid);
                point3 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                for (i = 0; i < xSections; ++i) {
                    double x = (double)i * xSecSize - (schXSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(x, schYSize / 2.0 - frameWid);
                        point1 = new Point2D.Double(x, schYSize / 2.0 - frameWid / 2.0);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(x, -schYSize / 2.0 + frameWid);
                        point1 = new Point2D.Double(x, -schYSize / 2.0 + frameWid / 2.0);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(49 + xSections - i - 1);
                    point0 = new Point2D.Double(x + xSecSize / 2.0, schYSize / 2.0 - frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(x + xSecSize / 2.0, -schYSize / 2.0 + frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
                for (i = 0; i < ySections; ++i) {
                    double y = (double)i * ySecSize - (schYSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(schXSize / 2.0 - frameWid, y);
                        point1 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, y);
                        point1 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(65 + i);
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
            }
            if (drawTitleBox) {
                Point2D.Double point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 13.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, "Name: " + this.cell.describe(false) + (this.cell.isMultiPage() ? " Page " + (this.pageNo + 1) : ""));
                String projectName = User.getFrameProjectName();
                Variable pVar = this.cell.getLibrary().getVar(User.FRAME_PROJECT_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
                if (pVar != null) {
                    projectName = (String)pVar.getObject();
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 10.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, projectName);
                String designerName = User.getFrameDesignerName();
                Variable dVar = this.cell.getLibrary().getVar(User.FRAME_DESIGNER_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
                if (dVar != null) {
                    designerName = (String)dVar.getObject();
                }
                if ((dVar = this.cell.getVar(User.FRAME_DESIGNER_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String)) != null) {
                    designerName = (String)dVar.getObject();
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 7.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, designerName);
                String companyName = User.getFrameCompanyName();
                Variable cVar = this.cell.getLibrary().getVar(User.FRAME_COMPANY_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
                if (cVar != null) {
                    companyName = (String)cVar.getObject();
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 5.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, companyName);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 3.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Created: " + TextUtils.formatDate(this.cell.getCreationDate()));
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 1.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
            }
        }

        private void addLine(Point2D from, Point2D to) {
            this.lineFromEnd.add(from);
            this.lineToEnd.add(to);
        }

        private void addText(Point2D at, double size, double width, double height, String msg) {
            this.textPoint.add(at);
            this.textSize.add(new Double(size));
            this.textBox.add(new Point2D.Double(width, height));
            this.textMessage.add(msg);
        }
    }

    private class MaxSuffix {
        int v = 0;

        private MaxSuffix() {
        }
    }

    public static class CellGroup {
        private TreeSet cells = new TreeSet();
        private Cell mainSchematic;
        private String groupName = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        private CellGroup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Cell cell) {
            TreeSet treeSet = this.cells;
            synchronized (treeSet) {
                if (!this.cells.contains(cell)) {
                    this.cells.add(cell);
                }
            }
            cell.cellGroup = this;
            if (this.mainSchematic != null) {
                this.mainSchematic = this.mainSchematic.getNewestVersion();
            }
            this.groupName = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Cell f) {
            TreeSet treeSet = this.cells;
            synchronized (treeSet) {
                this.cells.remove(f);
                if (f == this.mainSchematic) {
                    this.mainSchematic = null;
                }
            }
            this.groupName = null;
        }

        public Iterator getCells() {
            return this.cells.iterator();
        }

        public int getNumCells() {
            return this.cells.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getCellsSortedByView() {
            TreeSet treeSet = this.cells;
            synchronized (treeSet) {
                ArrayList sortedList = new ArrayList(this.cells);
                Collections.sort(sortedList, new TextUtils.CellsByView());
                return sortedList;
            }
        }

        public Cell getMainSchematics() {
            if (this.mainSchematic != null) {
                return this.mainSchematic;
            }
            Iterator it = this.getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (!c.isSchematic()) continue;
                this.mainSchematic = c;
                return this.mainSchematic;
            }
            return null;
        }

        public void setMainSchematics(Cell cell) {
            if (this.getMainSchematics() == cell) {
                return;
            }
            if (!cell.isSchematic() || cell.getNewestVersion() != cell) {
                System.out.println("Cell " + cell + ": cannot be main schematics");
                return;
            }
            this.mainSchematic = cell;
            Undo.modifyCellGroup(cell, this);
        }

        public boolean containsCell(Cell cell) {
            return this.cells.contains(cell);
        }

        public String toString() {
            return "CellGroup " + this.getName();
        }

        public String getName() {
            if (this.groupName != null) {
                return this.groupName;
            }
            Cell onlyCell = null;
            Iterator it = this.getCells();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                if (onlyCell == null) {
                    onlyCell = cell.getNewestVersion();
                    continue;
                }
                if (cell.getNewestVersion() == onlyCell) continue;
                onlyCell = null;
                break;
            }
            if (onlyCell != null) {
                this.groupName = onlyCell.describe(false);
                return this.groupName;
            }
            TreeSet<String> groupNames = new TreeSet<String>();
            int widestName = 0;
            Iterator it2 = this.getCells();
            while (it2.hasNext()) {
                Cell cell = (Cell)it2.next();
                String cellName = cell.getName();
                if (cellName.length() > widestName) {
                    widestName = cellName.length();
                }
                groupNames.add(cellName);
            }
            if (groupNames.size() == 1) {
                this.groupName = (String)groupNames.iterator().next();
                return this.groupName;
            }
            for (int i = widestName; i > widestName / 2; --i) {
                String lastName = null;
                boolean allSame = true;
                Iterator it3 = groupNames.iterator();
                while (it3.hasNext()) {
                    String oneName = (String)it3.next();
                    if (!(lastName == null || oneName.length() >= i && lastName.length() >= i && lastName.substring(0, i).equals(oneName.substring(0, i)))) {
                        allSame = false;
                        break;
                    }
                    lastName = oneName;
                }
                if (!allSame) continue;
                this.groupName = lastName.substring(0, i) + "*";
                return this.groupName;
            }
            Iterator it22 = groupNames.iterator();
            while (it22.hasNext()) {
                String oneName = (String)it22.next();
                if (this.groupName == null) {
                    this.groupName = oneName;
                    continue;
                }
                this.groupName = this.groupName + "," + oneName;
            }
            return this.groupName;
        }

        void check() {
            Library lib = null;
            Iterator it = this.cells.iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                if (lib == null) {
                    lib = cell.lib;
                }
                if (!$assertionsDisabled && !lib.contains(cell)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && cell.cellGroup != this) {
                    throw new AssertionError();
                }
            }
            if (!$assertionsDisabled && lib == null) {
                throw new AssertionError();
            }
            if (this.mainSchematic != null) {
                if (!$assertionsDisabled && !this.containsCell(this.mainSchematic)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.mainSchematic.getNewestVersion() != this.mainSchematic) {
                    throw new AssertionError();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$electric$database$hierarchy$Cell == null ? (class$com$sun$electric$database$hierarchy$Cell = Cell.class$("com.sun.electric.database.hierarchy.Cell")) : class$com$sun$electric$database$hierarchy$Cell).desiredAssertionStatus();
        }
    }
}

