/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;

public class StratCountPartPinsOnWires
extends Strategy {
    private PinType pinType;

    private StratCountPartPinsOnWires(NccGlobals globals, PinType pinType) {
        super(globals);
        this.pinType = pinType;
    }

    private LeafList doYourJob2() {
        EquivRecord wires = this.globals.getWires();
        LeafList offspring = wires != null ? this.doFor(wires) : new LeafList();
        this.setReasons(offspring);
        this.summary(offspring);
        return offspring;
    }

    private void setReasons(LeafList offspring) {
        Iterator it = offspring.iterator();
        while (it.hasNext()) {
            EquivRecord r = (EquivRecord)it.next();
            int value = r.getValue();
            String reason = value + " = number of " + this.pinType.description() + " pins.";
            this.globals.status2(reason);
            r.setPartitionReason(reason);
        }
    }

    private void summary(LeafList offspring) {
        this.globals.status2(" StratCountPartPinsOnWires produced " + offspring.size() + " offspring when counting " + this.pinType.description() + " pins");
        if (offspring.size() != 0) {
            this.globals.status2(offspring.sizeInfoString());
            this.globals.status2(this.offspringStats(offspring));
        }
    }

    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Wire), "StratCountPartPinsOnWires expects only Wires");
        Wire w = (Wire)n;
        int count = 0;
        Iterator it = w.getParts();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            count += this.pinType.numConnectionsToPinOfThisType(p, w);
        }
        return new Integer(count);
    }

    public static LeafList doYourJob(NccGlobals globals, PinType pinTester) {
        StratCountPartPinsOnWires pow = new StratCountPartPinsOnWires(globals, pinTester);
        return pow.doYourJob2();
    }
}

