/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.Main;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class AttributesTable
extends JTable
implements DatabaseChangeListener {
    private static JComboBox codeComboBox = null;
    private static JComboBox dispComboBox = null;
    private static JComboBox unitComboBox = null;
    private static final String displaynone = "None";
    private JPopupMenu popup;
    private Point popupLocation;
    private ElectricObject owner;
    private boolean showAttrOnly;
    static /* synthetic */ Class class$com$sun$electric$database$variable$TextDescriptor$Code;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$electric$database$variable$TextDescriptor$Unit;
    static /* synthetic */ Class class$java$lang$String;

    public AttributesTable(ElectricObject owner, boolean showCode, boolean showDispPos, boolean showUnits) {
        TableColumn codeColumn;
        this.setElectricObject(owner);
        this.showAttrOnly = Main.getDebug();
        this.setGridColor(this.getBackground());
        this.setSelectionMode(0);
        VariableTableModel model = new VariableTableModel(showCode, showDispPos, showUnits);
        this.setModel(model);
        this.initComboBoxes();
        if (showCode && (codeColumn = this.getColumnModel().getColumn(model.getCodeColumn())) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(codeComboBox));
        }
        if (showDispPos && (codeColumn = this.getColumnModel().getColumn(model.getDispColumn())) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(dispComboBox));
        }
        if (showUnits && (codeColumn = this.getColumnModel().getColumn(model.getUnitsColumn())) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(unitComboBox));
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isShiftDown() || e.isControlDown() || e.isAltDown()) {
                    return;
                }
                if (e.isMetaDown()) {
                    AttributesTable.this.initPopupMenu();
                    AttributesTable.this.popupLocation = new Point(e.getX(), e.getY());
                    AttributesTable.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(mouseListener);
        Undo.addDatabaseChangeListener(this);
    }

    private void initComboBoxes() {
        Iterator it;
        if (codeComboBox == null) {
            codeComboBox = new JComboBox();
            it = TextDescriptor.Code.getCodes();
            while (it.hasNext()) {
                codeComboBox.addItem(it.next());
            }
            codeComboBox.setFont(new Font("Dialog", 0, 11));
        }
        if (dispComboBox == null) {
            dispComboBox = new JComboBox();
            dispComboBox.addItem(displaynone);
            it = TextDescriptor.DispPos.getShowStyles();
            while (it.hasNext()) {
                dispComboBox.addItem(it.next());
            }
            dispComboBox.setFont(new Font("Dialog", 0, 11));
        }
        if (unitComboBox == null) {
            unitComboBox = new JComboBox();
            it = TextDescriptor.Unit.getUnits();
            while (it.hasNext()) {
                unitComboBox.addItem(it.next());
            }
            unitComboBox.setFont(new Font("Dialog", 0, 11));
        }
    }

    private void initPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem m = new JMenuItem("New Attr");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.newVar();
            }
        });
        this.popup.add(m);
        m = new JMenuItem("Duplicate Attr");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.duplicateVar(AttributesTable.this.popupLocation);
            }
        });
        this.popup.add(m);
        m = new JMenuItem("Delete Attr");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.deleteVar(AttributesTable.this.popupLocation);
            }
        });
        this.popup.add(m);
        JMenu showMenu = new JMenu("Show...");
        VariableTableModel model = (VariableTableModel)this.getModel();
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem("Code", model.showCode);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.toggleShowCode();
            }
        });
        showMenu.add(cb);
        cb = new JCheckBoxMenuItem("Display", model.showDispPos);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.toggleShowDisp();
            }
        });
        showMenu.add(cb);
        cb = new JCheckBoxMenuItem("Units", model.showUnits);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.toggleShowUnits();
            }
        });
        showMenu.add(cb);
        this.popup.add(showMenu);
    }

    private void newVar() {
        VariableTableModel model = (VariableTableModel)this.getModel();
        model.newVar(this.owner);
    }

    private void duplicateVar(Point location) {
        int row = this.rowAtPoint(location);
        VariableTableModel model = (VariableTableModel)this.getModel();
        model.duplicateVar(row);
    }

    private void deleteVar(Point location) {
        int row = this.rowAtPoint(location);
        VariableTableModel model = (VariableTableModel)this.getModel();
        model.deleteVar(row);
    }

    public void applyChanges() {
        VariableTableModel model = (VariableTableModel)this.getModel();
        if (this.isEditing()) {
            int row = this.getEditingRow();
            int col = this.getEditingColumn();
            TableCellEditor editor = this.getCellEditor(row, col);
            editor.stopCellEditing();
        }
        model.applyChanges();
    }

    public void cancelChanges() {
        VariableTableModel model = (VariableTableModel)this.getModel();
        if (this.isEditing()) {
            int row = this.getEditingRow();
            int col = this.getEditingColumn();
            TableCellEditor editor = this.getCellEditor(row, col);
            editor.cancelCellEditing();
        }
        this.setElectricObject(this.owner);
    }

    private void toggleShowCode() {
        VariableTableModel model;
        model.setShowCode(!(model = (VariableTableModel)this.getModel()).showCode);
        this.updateEditors();
    }

    private void toggleShowDisp() {
        VariableTableModel model;
        model.setShowDisp(!(model = (VariableTableModel)this.getModel()).showDispPos);
        this.updateEditors();
    }

    private void toggleShowUnits() {
        VariableTableModel model;
        model.setShowUnits(!(model = (VariableTableModel)this.getModel()).showUnits);
        this.updateEditors();
    }

    private void updateEditors() {
        TableColumn codeColumn;
        int unitsCol;
        TableColumn codeColumn2;
        int dispCol;
        TableColumn codeColumn3;
        VariableTableModel model = (VariableTableModel)this.getModel();
        int codeCol = model.getCodeColumn();
        if (codeCol != -1 && (codeColumn3 = this.getColumnModel().getColumn(codeCol)) != null) {
            codeColumn3.setCellEditor(new DefaultCellEditor(codeComboBox));
        }
        if ((dispCol = model.getDispColumn()) != -1 && (codeColumn2 = this.getColumnModel().getColumn(dispCol)) != null) {
            codeColumn2.setCellEditor(new DefaultCellEditor(dispComboBox));
        }
        if ((unitsCol = model.getUnitsColumn()) != -1 && (codeColumn = this.getColumnModel().getColumn(unitsCol)) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(unitComboBox));
        }
    }

    public void setElectricObject(ElectricObject eobj) {
        if (this.owner == eobj) {
            return;
        }
        this.clearVariables();
        if (eobj != null) {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            Iterator it = eobj.getVariables();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                if (!var.isAttribute()) continue;
                vars.add(var);
            }
            ((VariableTableModel)this.getModel()).setVars(vars);
        }
        this.owner = eobj;
    }

    private void clearVariables() {
        ((VariableTableModel)this.getModel()).clearVariables();
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        ElectricObject eobj = this.owner;
        this.setElectricObject(null);
        this.setElectricObject(eobj);
    }

    private static class VariableTableModel
    extends AbstractTableModel {
        private List vars = new ArrayList();
        private boolean DEBUG = false;
        private static final String[] columnNames = new String[]{"Name", "Value", "Code", "Display", "Units"};
        private boolean showCode = true;
        private boolean showDispPos = false;
        private boolean showUnits = false;
        private List varsToDelete = new ArrayList();

        private VariableTableModel(boolean showCode, boolean showDispPos, boolean showUnits) {
            this.showCode = showCode;
            this.showDispPos = showDispPos;
            this.showUnits = showUnits;
        }

        public int getColumnCount() {
            int c = 2;
            if (this.showCode) {
                ++c;
            }
            if (this.showDispPos) {
                ++c;
            }
            if (this.showUnits) {
                ++c;
            }
            return c;
        }

        public int getRowCount() {
            return this.vars.size();
        }

        private int getCodeColumn() {
            if (!this.showCode) {
                return -1;
            }
            return 2;
        }

        private int getDispColumn() {
            if (!this.showDispPos) {
                return -1;
            }
            int c = 2;
            if (this.showCode) {
                ++c;
            }
            return c;
        }

        private int getUnitsColumn() {
            if (!this.showUnits) {
                return -1;
            }
            int c = 2;
            if (this.showCode) {
                ++c;
            }
            if (this.showDispPos) {
                ++c;
            }
            return c;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            VarEntry ve = (VarEntry)this.vars.get(rowIndex);
            if (ve == null) {
                return null;
            }
            if (columnIndex == 0) {
                return ve.getName();
            }
            if (columnIndex == 1) {
                return ve.getObject().toString();
            }
            if (columnIndex == this.getCodeColumn()) {
                return ve.getCode();
            }
            if (columnIndex == this.getDispColumn()) {
                if (!ve.isDisplay()) {
                    return AttributesTable.displaynone;
                }
                return ve.getDispPos();
            }
            if (columnIndex == this.getUnitsColumn()) {
                return ve.getUnits();
            }
            return null;
        }

        public String getColumnName(int col) {
            if (col < 2) {
                return columnNames[col];
            }
            if (col == this.getCodeColumn()) {
                return columnNames[2];
            }
            if (col == this.getDispColumn()) {
                return columnNames[3];
            }
            if (col == this.getUnitsColumn()) {
                return columnNames[4];
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public void setValueAt(Object aValue, int row, int col) {
            VarEntry ve = (VarEntry)this.vars.get(row);
            ElectricObject owner = ve.getOwner();
            if (ve == null) {
                return;
            }
            if (owner == null) {
                return;
            }
            if (col == 0) {
                return;
            }
            if (col == 1) {
                if (!aValue.toString().equals(ve.getObject().toString())) {
                    ve.value = aValue;
                    this.fireTableCellUpdated(row, col);
                }
                return;
            }
            if (col == this.getCodeColumn()) {
                TextDescriptor.Code newCode = (TextDescriptor.Code)aValue;
                if (newCode != ve.getCode()) {
                    ve.code = newCode;
                    this.fireTableCellUpdated(row, col);
                }
                return;
            }
            if (col == this.getDispColumn()) {
                if (aValue == AttributesTable.displaynone) {
                    if (ve.isDisplay()) {
                        ve.display = false;
                        this.fireTableCellUpdated(row, col);
                    }
                } else {
                    TextDescriptor.DispPos newDispPos = (TextDescriptor.DispPos)aValue;
                    if (newDispPos != ve.getDispPos() || !ve.isDisplay()) {
                        ve.dispPos = newDispPos;
                        ve.display = true;
                        this.fireTableCellUpdated(row, col);
                    }
                }
                return;
            }
            if (col == this.getUnitsColumn()) {
                TextDescriptor.Unit newUnit = (TextDescriptor.Unit)aValue;
                if (newUnit != ve.getUnits()) {
                    ve.units = newUnit;
                    this.fireTableCellUpdated(row, col);
                }
                return;
            }
        }

        private void setVars(List variables) {
            this.vars.clear();
            this.varsToDelete.clear();
            Iterator it = variables.iterator();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                this.vars.add(new VarEntry(var));
            }
            Collections.sort(this.vars, new VarEntrySort());
            this.fireTableDataChanged();
        }

        private void addVariable(Variable var) {
            this.vars.add(new VarEntry(var));
            Collections.sort(this.vars, new VarEntrySort());
            this.fireTableDataChanged();
        }

        private void clearVariables() {
            this.vars.clear();
            this.varsToDelete.clear();
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int col) {
            if (col == this.getCodeColumn()) {
                return class$com$sun$electric$database$variable$TextDescriptor$Code == null ? (class$com$sun$electric$database$variable$TextDescriptor$Code = AttributesTable.class$("com.sun.electric.database.variable.TextDescriptor$Code")) : class$com$sun$electric$database$variable$TextDescriptor$Code;
            }
            if (col == this.getDispColumn()) {
                return class$java$lang$Object == null ? (class$java$lang$Object = AttributesTable.class$("java.lang.Object")) : class$java$lang$Object;
            }
            if (col == this.getUnitsColumn()) {
                return class$com$sun$electric$database$variable$TextDescriptor$Unit == null ? (class$com$sun$electric$database$variable$TextDescriptor$Unit = AttributesTable.class$("com.sun.electric.database.variable.TextDescriptor$Unit")) : class$com$sun$electric$database$variable$TextDescriptor$Unit;
            }
            return class$java$lang$String == null ? (class$java$lang$String = AttributesTable.class$("java.lang.String")) : class$java$lang$String;
        }

        public void setShowCode(boolean showCode) {
            if (this.showCode == showCode) {
                return;
            }
            this.showCode = showCode;
            this.fireTableStructureChanged();
        }

        public void setShowDisp(boolean showDisp) {
            if (this.showDispPos == showDisp) {
                return;
            }
            this.showDispPos = showDisp;
            this.fireTableStructureChanged();
        }

        public void setShowUnits(boolean showUnits) {
            if (this.showUnits == showUnits) {
                return;
            }
            this.showUnits = showUnits;
            this.fireTableStructureChanged();
        }

        public void newVar(ElectricObject owner) {
            VarEntry ve = new VarEntry(null);
            ve.var = null;
            ve.varKey = null;
            ve.varTrueName = this.getUniqueName("newVar");
            ve.value = "?";
            ve.code = TextDescriptor.Code.NONE;
            ve.dispPos = TextDescriptor.DispPos.NAMEVALUE;
            ve.units = TextDescriptor.Unit.NONE;
            ve.display = true;
            ve.owner = owner;
            this.vars.add(ve);
            Collections.sort(this.vars, new VarEntrySort());
            this.fireTableDataChanged();
        }

        public void duplicateVar(int row) {
            if (row >= this.vars.size()) {
                JOptionPane.showMessageDialog(null, "Please select an attribute to duplicate", "Invalid Action", 2);
                return;
            }
            VarEntry srcVe = (VarEntry)this.vars.get(row);
            VarEntry ve = new VarEntry(null);
            ve.var = null;
            ve.varKey = null;
            ve.varTrueName = this.getUniqueName(srcVe.getName());
            ve.value = srcVe.getObject();
            ve.code = srcVe.getCode();
            ve.dispPos = srcVe.getDispPos();
            ve.units = srcVe.getUnits();
            ve.display = srcVe.isDisplay();
            ve.owner = srcVe.getOwner();
            this.vars.add(ve);
            Collections.sort(this.vars, new VarEntrySort());
            this.fireTableDataChanged();
        }

        public void deleteVar(int row) {
            if (row >= this.vars.size()) {
                JOptionPane.showMessageDialog(null, "Please select an attribute to delete", "Invalid Action", 2);
                return;
            }
            VarEntry ve = (VarEntry)this.vars.remove(row);
            this.varsToDelete.add(ve);
            this.fireTableDataChanged();
        }

        public void applyChanges() {
            ApplyChanges job = new ApplyChanges(new ArrayList(this.vars), new ArrayList(this.varsToDelete));
        }

        public void cancelChanges() {
        }

        private String getUniqueName(String name) {
            boolean nameConflict = true;
            String newName = name;
            int i = 0;
            block0: while (nameConflict) {
                nameConflict = false;
                ++i;
                Iterator it = this.vars.iterator();
                while (it.hasNext()) {
                    VarEntry ve = (VarEntry)it.next();
                    if (!newName.equals(ve.getName())) continue;
                    nameConflict = true;
                    newName = name + "_" + i;
                    continue block0;
                }
            }
            return newName;
        }

        private static class ApplyChanges
        extends Job {
            private List varEntries;
            private List varEntriesToDelete;

            private ApplyChanges(List varEntries, List varEntriesToDelete) {
                super("Apply Attribute Changes", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.varEntries = varEntries;
                this.varEntriesToDelete = varEntriesToDelete;
                this.startJob();
            }

            public boolean doIt() {
                ElectricObject owner;
                Variable var;
                VarEntry ve;
                Iterator it = this.varEntriesToDelete.iterator();
                while (it.hasNext()) {
                    ve = (VarEntry)it.next();
                    var = ve.var;
                    if (var == null) continue;
                    owner = var.getOwner();
                    owner.delVar(var.getKey());
                }
                it = this.varEntries.iterator();
                while (it.hasNext()) {
                    ve = (VarEntry)it.next();
                    var = ve.var;
                    owner = ve.getOwner();
                    Variable newVar = null;
                    if (var == null) {
                        String name = ve.getName();
                        if (!name.startsWith("ATTR_") && !name.startsWith("ATTRP_")) {
                            name = "ATTR_" + name;
                        }
                        newVar = owner.newVar(name, ve.getObject());
                        ve.var = newVar;
                    } else {
                        if (!ve.isChanged()) continue;
                        newVar = owner.updateVar(ve.getKey(), ve.getObject());
                        ve.var = newVar;
                    }
                    if (newVar == null) continue;
                    newVar.setCode(ve.getCode());
                    newVar.setDispPart(ve.getDispPos());
                    newVar.setUnit(ve.getUnits());
                    newVar.setDisplay(ve.isDisplay());
                }
                return true;
            }
        }

        public static class VarEntrySort
        implements Comparator {
            public int compare(Object o1, Object o2) {
                VarEntry v1 = (VarEntry)o1;
                VarEntry v2 = (VarEntry)o2;
                String s1 = v1.getName();
                String s2 = v2.getName();
                return s1.compareToIgnoreCase(s2);
            }
        }

        private static class VarEntry {
            private String varTrueName;
            private Variable.Key varKey;
            private Object value;
            private TextDescriptor.Code code;
            private TextDescriptor.DispPos dispPos;
            private TextDescriptor.Unit units;
            private boolean display;
            private ElectricObject owner;
            private Variable var;
            private String initialVarTrueName;
            private Object initialValue;
            private TextDescriptor.Code initialCode;
            private TextDescriptor.DispPos initialDispPos;
            private TextDescriptor.Unit initialUnits;
            private boolean initialDisplay;

            private VarEntry(Variable var) {
                this.var = var;
                if (var == null) {
                    return;
                }
                this.varKey = var.getKey();
                this.varTrueName = this.initialVarTrueName = var.getTrueName();
                this.value = this.initialValue = var.getObject();
                this.code = this.initialCode = var.getCode();
                this.dispPos = this.initialDispPos = var.getDispPart();
                this.units = this.initialUnits = var.getUnit();
                this.display = this.initialDisplay = var.isDisplay();
                this.owner = var.getOwner();
            }

            private String getName() {
                return this.varTrueName;
            }

            private Object getObject() {
                return this.value;
            }

            private TextDescriptor.Code getCode() {
                return this.code;
            }

            private TextDescriptor.DispPos getDispPos() {
                return this.dispPos;
            }

            private TextDescriptor.Unit getUnits() {
                return this.units;
            }

            private boolean isDisplay() {
                return this.display;
            }

            private ElectricObject getOwner() {
                return this.owner;
            }

            private Variable.Key getKey() {
                return this.varKey;
            }

            private boolean isChanged() {
                if (!this.varTrueName.equals(this.initialVarTrueName)) {
                    return true;
                }
                if (this.value != this.initialValue) {
                    return true;
                }
                if (this.code != this.initialCode) {
                    return true;
                }
                if (this.display != this.initialDisplay) {
                    return true;
                }
                if (this.dispPos != this.initialDispPos) {
                    return true;
                }
                return this.units != this.initialUnits;
            }
        }
    }

    public static class AttValPair {
        Variable.Key key;
        String trueName;
        String value;
        String eval;
        boolean code;
    }
}

