/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.LibId;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import java.io.IOException;

public class ImmutableCell
extends ImmutableElectricObject {
    public final CellId cellId;
    public final LibId libId;
    public final CellName cellName;
    public final CellName groupName;
    public final long creationDate;
    public final Technology tech;

    private ImmutableCell(CellId cellId, LibId libId, CellName cellName, CellName groupName, long creationDate, Technology tech, int flags, Variable[] vars) {
        super(vars, flags);
        this.cellId = cellId;
        this.libId = libId;
        this.cellName = cellName;
        this.groupName = groupName;
        this.creationDate = creationDate;
        this.tech = tech;
        this.check();
    }

    public static ImmutableCell newInstance(CellId cellId, LibId libId, CellName cellName, long creationDate) {
        if (cellId == null) {
            throw new NullPointerException("cellId");
        }
        if (libId == null) {
            throw new NullPointerException("libId");
        }
        if (cellName == null) {
            throw new NullPointerException("cellName");
        }
        return new ImmutableCell(cellId, libId, cellName, null, creationDate, null, 0, Variable.NULL_ARRAY);
    }

    public ImmutableCell withLibrary(LibId libId) {
        if (this.libId == libId) {
            return this;
        }
        if (libId == null) {
            throw new NullPointerException("libId");
        }
        return new ImmutableCell(this.cellId, libId, this.cellName, this.groupName, this.creationDate, this.tech, this.flags, this.getVars());
    }

    public ImmutableCell withCellName(CellName cellName) {
        if (this.cellName == cellName) {
            return this;
        }
        if (cellName == null) {
            throw new NullPointerException("cellName");
        }
        if (this.cellName.equals(cellName)) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.libId, cellName, this.groupName, this.creationDate, this.tech, this.flags, this.getVars());
    }

    public ImmutableCell withGroupName(CellName groupName) {
        if (this.groupName == groupName) {
            return this;
        }
        if (this.groupName != null && this.groupName.equals(groupName)) {
            return this;
        }
        if (groupName != null && (groupName.getVersion() != 0 || groupName.getView() != View.SCHEMATIC)) {
            throw new IllegalArgumentException(groupName.toString());
        }
        return new ImmutableCell(this.cellId, this.libId, this.cellName, groupName, this.creationDate, this.tech, this.flags, this.getVars());
    }

    public ImmutableCell withCreationDate(long creationDate) {
        if (this.creationDate == creationDate) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.libId, this.cellName, this.groupName, creationDate, this.tech, this.flags, this.getVars());
    }

    public ImmutableCell withTech(Technology tech) {
        if (this.tech == tech) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.libId, this.cellName, this.groupName, this.creationDate, tech, this.flags, this.getVars());
    }

    public ImmutableCell withFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.libId, this.cellName, this.groupName, this.creationDate, this.tech, flags, this.getVars());
    }

    public ImmutableCell withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.libId, this.cellName, this.groupName, this.creationDate, this.tech, this.flags, vars);
    }

    public ImmutableCell withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.libId, this.cellName, this.groupName, this.creationDate, this.tech, this.flags, vars);
    }

    ImmutableCell withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        CellId cellId = idMapper.get(this.cellId);
        LibId libId = idMapper.get(this.libId);
        if (this.getVars() == vars && this.cellId == cellId && this.libId == libId) {
            return this;
        }
        return new ImmutableCell(cellId, libId, this.cellName, this.groupName, this.creationDate, this.tech, this.flags, vars);
    }

    public ImmutableCell withoutVariables() {
        if (this.getNumVariables() == 0) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.libId, this.cellName, this.groupName, this.creationDate, this.tech, this.flags, Variable.NULL_ARRAY);
    }

    void write(SnapshotWriter writer) throws IOException {
        writer.writeNodeProtoId(this.cellId);
        writer.writeLibId(this.libId);
        writer.writeString(this.cellName.toString());
        writer.writeBoolean(this.groupName != null);
        if (this.groupName != null) {
            writer.writeString(this.groupName.toString());
        }
        writer.writeLong(this.creationDate);
        writer.writeBoolean(this.tech != null);
        if (this.tech != null) {
            writer.writeTechnology(this.tech);
        }
        writer.writeInt(this.flags);
        super.write(writer);
    }

    static ImmutableCell read(SnapshotReader reader) throws IOException {
        CellId cellId = (CellId)reader.readNodeProtoId();
        LibId libId = reader.readLibId();
        String cellNameString = reader.readString();
        CellName cellName = CellName.parseName(cellNameString);
        CellName groupName = null;
        boolean hasGroupName = reader.readBoolean();
        if (hasGroupName) {
            String groupNameString = reader.readString();
            groupName = CellName.parseName(groupNameString);
        }
        long creationDate = reader.readLong();
        boolean hasTech = reader.readBoolean();
        Technology tech = hasTech ? reader.readTechnology() : null;
        int flags = reader.readInt();
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableCell.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableCell(cellId, libId, cellName, groupName, creationDate, tech, flags, vars);
    }

    public int hashCodeExceptVariables() {
        return this.cellId.hashCode();
    }

    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableCell)) {
            return false;
        }
        ImmutableCell that = (ImmutableCell)o;
        return this.cellId == that.cellId && this.libId == that.libId && this.cellName == that.cellName && this.groupName == that.groupName && this.creationDate == that.creationDate && this.tech == that.tech && this.flags == that.flags;
    }

    public void check() {
        this.check(true);
        assert (this.cellId != null);
        assert (this.libId != null);
        this.cellName.check();
        if (this.groupName != null) {
            assert (this.groupName.getVersion() == 0);
            assert (this.groupName.getView() == View.SCHEMATIC);
        }
    }
}

