/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.IdManager;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.CellName;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class LibId
implements Serializable {
    public static final LibId[] NULL_ARRAY = new LibId[0];
    public final IdManager idManager;
    public final String libName;
    public final int libIndex;

    LibId(IdManager idManager, String libName, int libIndex) {
        if (LibId.legalLibraryName(libName) != libName) {
            throw new IllegalArgumentException(libName);
        }
        this.idManager = idManager;
        this.libName = libName;
        this.libIndex = libIndex;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LibIdKey(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("LibId");
    }

    public CellId newCellId(CellName cellName) {
        return this.idManager.newCellId(cellName);
    }

    public Library inDatabase(EDatabase database) {
        return database.getLib(this);
    }

    public String toString() {
        return this.libName;
    }

    void check() {
        assert (this == this.idManager.getLibId(this.libIndex));
        assert (LibId.legalLibraryName(this.libName) == this.libName);
    }

    public static String legalLibraryName(String libName) {
        char ch;
        int i;
        if (libName == null || libName.length() == 0) {
            return null;
        }
        for (i = 0; i < libName.length() && !Character.isWhitespace(ch = libName.charAt(i)) && ch != ':'; ++i) {
        }
        if (i == libName.length()) {
            return libName;
        }
        char[] chars = libName.toCharArray();
        while (i < libName.length()) {
            int ch2 = chars[i];
            chars[i] = Character.isWhitespace((char)ch2) || ch2 == 58 ? 45 : ch2;
            ++i;
        }
        return new String(chars);
    }

    private static class LibIdKey
    extends EObjectInputStream.Key {
        private final int libIndex;

        private LibIdKey(LibId libId) {
            this.libIndex = libId.libIndex;
        }

        protected Object readResolveInDatabase(EDatabase database) throws InvalidObjectException {
            return database.getIdManager().getLibId(this.libIndex);
        }
    }
}

