/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Info {
    static final int LAYERTRANSPARENCY = 1;
    static final int LAYERSTYLE = 2;
    static final int LAYERCIF = 3;
    static final int LAYERFUNCTION = 4;
    static final int LAYERLETTERS = 5;
    static final int LAYERPATTERN = 6;
    static final int LAYERPATCONT = 7;
    static final int LAYERPATCH = 8;
    static final int ARCFUNCTION = 9;
    static final int NODEFUNCTION = 10;
    static final int ARCFIXANG = 11;
    static final int ARCWIPESPINS = 12;
    static final int ARCNOEXTEND = 13;
    static final int TECHSCALE = 14;
    static final int TECHDESCRIPT = 15;
    static final int NODESERPENTINE = 16;
    static final int LAYERDRCMINWID = 17;
    static final int PORTOBJ = 18;
    public static final int HIGHLIGHTOBJ = 19;
    static final int LAYERGDS = 20;
    static final int NODESQUARE = 21;
    static final int NODEWIPES = 22;
    static final int ARCINC = 23;
    static final int NODEMULTICUT = 24;
    static final int NODELOCKABLE = 25;
    static final int CENTEROBJ = 26;
    static final int LAYERSPIRES = 27;
    static final int LAYERSPICAP = 28;
    static final int LAYERSPIECAP = 29;
    static final int LAYERDXF = 30;
    static final int LAYER3DHEIGHT = 31;
    static final int LAYER3DTHICK = 32;
    static final int LAYERCOLOR = 33;
    static final int LAYERPATCLEAR = 34;
    static final int LAYERPATINVERT = 35;
    static final int LAYERPATCOPY = 36;
    static final int LAYERPATPASTE = 37;
    static final int TECHSPICEMINRES = 38;
    static final int TECHSPICEMINCAP = 39;
    static final int ARCANTENNARATIO = 40;
    static final int LAYERCOVERAGE = 41;
    static final int TECHGATESHRINK = 42;
    static final int TECHGATEINCLUDED = 43;
    static final int TECHGROUNDINCLUDED = 44;
    static final int TECHTRANSPCOLORS = 45;
    static final int TECHSHORTNAME = 46;
    static final int TECHFOUNDRY = 47;
    static final int TECHDEFMETALS = 48;
    static final int TECHMAXSERIESRES = 49;
    static final int TECHSPICELEVEL1 = 50;
    static final int TECHSPICELEVEL2 = 51;
    static final int TECHSPICELEVEL3 = 52;
    static final int TECHSCALERELEVANT = 53;
    static final int TECHCONDIST = 54;
    static final int TECHUNCONDIST = 55;
    static final int TECHPALETTE = 56;
    static final int ARCCURVABLE = 57;
    static final int NODESHRINKSARCS = 58;
    static final int LAYER3DMODE = 59;
    static final int LAYER3DFACTOR = 60;
    public static final Variable.Key LAYER_KEY = Variable.newKey("EDTEC_layer");
    public static final Variable.Key OPTION_KEY = Variable.newKey("EDTEC_option");
    static final Variable.Key ARCSEQUENCE_KEY = Variable.newKey("EDTEC_arcsequence");
    static final Variable.Key NODESEQUENCE_KEY = Variable.newKey("EDTEC_nodesequence");
    static final Variable.Key LAYERSEQUENCE_KEY = Variable.newKey("EDTEC_layersequence");
    static final Variable.Key MINSIZEBOX_KEY = Variable.newKey("EDTEC_minbox");
    static final Variable.Key PORTNAME_KEY = Variable.newKey("EDTEC_portname");
    static final Variable.Key PORTANGLE_KEY = Variable.newKey("EDTEC_portangle");
    static final Variable.Key PORTRANGE_KEY = Variable.newKey("EDTEC_portrange");
    static final Variable.Key CONNECTION_KEY = Variable.newKey("EDTEC_connects");
    static final Variable.Key COLORMAP_KEY = Variable.newKey("EDTEC_colormap");
    static final Variable.Key DEPENDENTLIB_KEY = Variable.newKey("EDTEC_dependent_libraries");
    static final Variable.Key TRANSLAYER_KEY = Variable.newKey("EDTEC_transparent_layers");

    protected static void createSpecialText(Cell np, SpecialTextDescr[] table) {
        for (int i = 0; i < table.length; ++i) {
            table[i].ni = null;
        }
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Variable var = ni.getVar(OPTION_KEY);
            if (var == null) continue;
            Info.foundNodeForFunction(ni, (Integer)var.getObject(), table);
        }
        for (int i = 0; i < table.length; ++i) {
            if (table[i].ni != null) continue;
            table[i].ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(table[i].x, table[i].y), 0.0, 0.0, np);
            if (table[i].ni == null) {
                return;
            }
            String str = null;
            switch (table[i].funct) {
                case 46: {
                    str = "ShortName: " + (String)table[i].value;
                    break;
                }
                case 14: {
                    str = "Scale: " + (Double)table[i].value;
                    break;
                }
                case 47: {
                    str = "DefaultFoundry: " + (String)table[i].value;
                    break;
                }
                case 48: {
                    str = "Default Number Of Metals: " + (Integer)table[i].value;
                    break;
                }
                case 15: {
                    str = "Description: " + (String)table[i].value;
                    break;
                }
                case 38: {
                    str = "Minimum Resistance: " + (Double)table[i].value;
                    break;
                }
                case 39: {
                    str = "Minimum Capacitance: " + (Double)table[i].value;
                    break;
                }
                case 49: {
                    str = "Max Series Resistance: " + (Double)table[i].value;
                    break;
                }
                case 42: {
                    str = "Gate Shrinkage: " + (Double)table[i].value;
                    break;
                }
                case 43: {
                    str = "Gates Included in Resistance: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                    break;
                }
                case 44: {
                    str = "Parasitics Includes Ground: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                    break;
                }
                case 45: {
                    table[i].ni.newVar(TRANSLAYER_KEY, (Object)GeneralInfo.makeTransparentColorsLine((Color[])table[i].value));
                    str = "Transparent Colors";
                    break;
                }
                case 4: {
                    str = "Function: " + LayerInfo.makeLayerFunctionName((Layer.Function)((Object)table[i].value), table[i].extra);
                    break;
                }
                case 33: {
                    EGraphics desc = (EGraphics)table[i].value;
                    str = "Color: " + desc.getColor().getRed() + "," + desc.getColor().getGreen() + "," + desc.getColor().getBlue() + ", " + desc.getOpacity() + "," + (desc.getForeground() ? "on" : "off");
                    break;
                }
                case 1: {
                    EGraphics desc = (EGraphics)table[i].value;
                    str = "Transparency: " + (desc.getTransparentLayer() == 0 ? "none" : "layer-" + desc.getTransparentLayer());
                    break;
                }
                case 2: {
                    EGraphics desc = (EGraphics)table[i].value;
                    str = "Style: ";
                    if (desc.isPatternedOnDisplay()) {
                        EGraphics.Outline o = desc.getOutlined();
                        str = str + "Patterned/Outline=" + o.getName();
                    } else {
                        str = str + "Solid";
                    }
                    if (desc.isPatternedOnPrinter()) break;
                    str = str + ",PrintSolid";
                    break;
                }
                case 3: {
                    str = "CIF Layer: " + (String)table[i].value;
                    break;
                }
                case 20: {
                    str = "GDS-II Layer: " + (String)table[i].value;
                    break;
                }
                case 27: {
                    str = "SPICE Resistance: " + (Double)table[i].value;
                    break;
                }
                case 28: {
                    str = "SPICE Capacitance: " + (Double)table[i].value;
                    break;
                }
                case 29: {
                    str = "SPICE Edge Capacitance: " + (Double)table[i].value;
                    break;
                }
                case 31: {
                    str = "3D Height: " + (Double)table[i].value;
                    break;
                }
                case 32: {
                    str = "3D Thickness: " + (Double)table[i].value;
                    break;
                }
                case 41: {
                    str = "Coverage percent: " + (Double)table[i].value;
                    break;
                }
                case 9: {
                    str = "Function: " + ((ArcProto.Function)((Object)table[i].value)).toString();
                    break;
                }
                case 11: {
                    str = "Fixed-angle: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                    break;
                }
                case 12: {
                    str = "Wipes pins: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                    break;
                }
                case 13: {
                    str = "Extend arcs: " + ((Boolean)table[i].value != false ? "No" : "Yes");
                    break;
                }
                case 23: {
                    str = "Angle increment: " + (Integer)table[i].value;
                    break;
                }
                case 40: {
                    str = "Antenna Ratio: " + (Double)table[i].value;
                    break;
                }
                case 10: {
                    str = "Function: " + ((PrimitiveNode.Function)((Object)table[i].value)).toString();
                    break;
                }
                case 16: {
                    str = "Serpentine transistor: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                    break;
                }
                case 21: {
                    str = "Square node: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                    break;
                }
                case 22: {
                    str = "Invisible with 1 or 2 arcs: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                    break;
                }
                case 25: {
                    str = "Lockable: " + ((Boolean)table[i].value != false ? "Yes" : "No");
                }
            }
            table[i].ni.newDisplayVar(Artwork.ART_MESSAGE, str);
            table[i].ni.newVar(OPTION_KEY, (Object)new Integer(table[i].funct));
        }
    }

    private static void foundNodeForFunction(NodeInst ni, int func, SpecialTextDescr[] table) {
        for (int i = 0; i < table.length; ++i) {
            if (table[i].funct != func) continue;
            table[i].ni = ni;
            return;
        }
    }

    protected static void loadTableEntry(SpecialTextDescr[] table, int func, Object value) {
        for (int i = 0; i < table.length; ++i) {
            if (func != table[i].funct) continue;
            table[i].value = value;
            return;
        }
    }

    static Library[] getDependentLibraries(Library lib) {
        int i;
        ArrayList<Library> dependentLibs = new ArrayList<Library>();
        Variable var = lib.getVar(DEPENDENTLIB_KEY);
        if (var != null) {
            String[] libNames = (String[])var.getObject();
            for (i = 0; i < libNames.length; ++i) {
                String pt = libNames[i];
                Library dLib = Library.findLibrary(pt);
                if (dLib == null) {
                    System.out.println("Cannot find dependent technology library " + pt + ", ignoring");
                    continue;
                }
                if (dLib == lib) {
                    System.out.println("Library '" + lib.getName() + "' cannot depend on itself, ignoring dependency");
                    continue;
                }
                dependentLibs.add(dLib);
            }
        }
        dependentLibs.add(lib);
        Library[] theLibs = new Library[dependentLibs.size()];
        for (i = 0; i < dependentLibs.size(); ++i) {
            theLibs[i] = (Library)dependentLibs.get(i);
        }
        return theLibs;
    }

    static Cell[] findCellSequence(Library[] dependentlibs, String match, Variable.Key seqKey) {
        ArrayList<Cell> npList = new ArrayList<Cell>();
        for (int i = dependentlibs.length - 1; i >= 0; --i) {
            Library olderlib = dependentlibs[i];
            Iterator<Cell> it = olderlib.getCells();
            while (it.hasNext()) {
                Cell np = it.next();
                if (!np.getName().startsWith(match)) continue;
                boolean foundInLater = false;
                for (int j = i + 1; j < dependentlibs.length; ++j) {
                    Library laterLib = dependentlibs[j];
                    Iterator<Cell> oIt = laterLib.getCells();
                    while (oIt.hasNext()) {
                        Cell lNp = oIt.next();
                        if (!lNp.getName().equals(np.getName())) continue;
                        foundInLater = true;
                        if (!lNp.getRevisionDate().before(np.getRevisionDate())) break;
                        System.out.println("Warning: " + olderlib + " has newer " + np.getName() + " than " + laterLib);
                        break;
                    }
                    if (foundInLater) break;
                }
                if (foundInLater) continue;
                npList.add(np);
            }
        }
        Variable var = dependentlibs[dependentlibs.length - 1].getVar(seqKey);
        ArrayList<Cell> sequence = new ArrayList<Cell>();
        String[] sequenceNames = var != null ? (String[])var.getObject() : new String[]{};
        for (int i = 0; i < sequenceNames.length; ++i) {
            Cell foundCell = null;
            for (int l = 0; l < npList.size(); ++l) {
                Cell np = (Cell)npList.get(l);
                if (!np.getName().substring(match.length()).equals(sequenceNames[i])) continue;
                foundCell = np;
                break;
            }
            if (foundCell == null) continue;
            sequence.add(foundCell);
            npList.remove(foundCell);
        }
        for (Cell c : npList) {
            sequence.add(c);
        }
        Cell[] theCells = new Cell[sequence.size()];
        for (int i = 0; i < sequence.size(); ++i) {
            theCells[i] = (Cell)sequence.get(i);
        }
        return theCells;
    }

    static String getPortName(NodeInst ni) {
        Variable var = ni.getVar(PORTNAME_KEY);
        if (var != null) {
            return (String)var.getObject();
        }
        var = ni.getVar(NodeInst.NODE_NAME);
        if (var != null) {
            return (String)var.getObject();
        }
        return null;
    }

    static String getValueOnNode(NodeInst ni) {
        int colonPos;
        String initial = "";
        Variable var = ni.getVar(Artwork.ART_MESSAGE, String.class);
        if (var != null && (colonPos = (initial = (String)var.getObject()).indexOf(58)) > 0) {
            initial = initial.substring(colonPos + 2);
        }
        return initial;
    }

    protected static class SpecialTextDescr {
        NodeInst ni = null;
        Object value = null;
        int extra;
        double x;
        double y;
        int funct;

        protected SpecialTextDescr(double x, double y, int funct) {
            this.x = x;
            this.y = y;
            this.funct = funct;
        }
    }
}

