/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.PrimitiveNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;

public class CellBackup {
    public static final CellBackup[] NULL_ARRAY = new CellBackup[0];
    public static final ImmutableArrayList<CellBackup> EMPTY_LIST = new ImmutableArrayList<CellBackup>(NULL_ARRAY);
    static int cellBackupsCreated = 0;
    static int cellBackupsMemoized = 0;
    public final CellRevision cellRevision;
    private volatile Memoization m;
    private AbstractShapeBuilder.Shrinkage shrinkage;
    private ERectangle primitiveBounds;
    private static final Comparator<ImmutableExport> BY_ORIGINAL_PORT = new Comparator<ImmutableExport>(){

        @Override
        public int compare(ImmutableExport e1, ImmutableExport e2) {
            int result = e1.originalNodeId - e2.originalNodeId;
            if (result != 0) {
                return result;
            }
            result = e1.originalPortId.getChronIndex() - e2.originalPortId.getChronIndex();
            if (result != 0) {
                return result;
            }
            return e1.exportId.chronIndex - e2.exportId.chronIndex;
        }
    };

    private CellBackup(CellRevision cellRevision) {
        this.cellRevision = cellRevision;
        ++cellBackupsCreated;
    }

    public CellBackup(ImmutableCell d) {
        this(new CellRevision(d));
    }

    public CellBackup with(ImmutableCell d, long revisionDate, boolean modified, ImmutableNodeInst[] nodesArray, ImmutableArcInst[] arcsArray, ImmutableExport[] exportsArray) {
        CellRevision newRevision = this.cellRevision.with(d, revisionDate, modified, nodesArray, arcsArray, exportsArray);
        if (newRevision == this.cellRevision) {
            return this;
        }
        return new CellBackup(newRevision);
    }

    CellBackup withRenamedIds(IdMapper idMapper, CellName newGroupName) {
        CellRevision newRevision = this.cellRevision.withRenamedIds(idMapper, newGroupName);
        if (newRevision == this.cellRevision) {
            return this;
        }
        return new CellBackup(newRevision);
    }

    static CellBackup read(SnapshotReader reader) throws IOException {
        CellRevision newRevision = CellRevision.read(reader);
        return new CellBackup(newRevision);
    }

    public void check() {
        this.cellRevision.check();
        if (this.m != null) {
            this.m.check();
        }
    }

    public String toString() {
        return this.cellRevision.toString();
    }

    public Memoization getMemoization() {
        Memoization m = this.m;
        if (m != null) {
            return m;
        }
        this.m = new Memoization();
        return this.m;
    }

    public AbstractShapeBuilder.Shrinkage getShrinkage() {
        if (this.shrinkage == null) {
            this.shrinkage = new AbstractShapeBuilder.Shrinkage(this);
        }
        return this.shrinkage;
    }

    public ERectangle getPrimitiveBounds() {
        ERectangle primitiveBounds = this.primitiveBounds;
        if (primitiveBounds != null) {
            return primitiveBounds;
        }
        this.primitiveBounds = this.computePrimitiveBounds();
        return this.primitiveBounds;
    }

    public ERectangle computePrimitiveBounds() {
        ImmutableArrayList<ImmutableArcInst> arcs = this.cellRevision.arcs;
        if (arcs.isEmpty()) {
            return null;
        }
        int intMinX = Integer.MAX_VALUE;
        int intMinY = Integer.MAX_VALUE;
        int intMaxX = Integer.MIN_VALUE;
        int intMaxY = Integer.MIN_VALUE;
        int[] intCoords = new int[4];
        AbstractShapeBuilder.Shrinkage shrinkage = this.getShrinkage();
        BoundsBuilder boundsBuilder = new BoundsBuilder(shrinkage);
        for (ImmutableArcInst a : arcs) {
            if (a.genBoundsEasy(shrinkage, intCoords)) {
                int y2;
                int x2;
                int y1;
                int x1 = intCoords[0];
                if (x1 < intMinX) {
                    intMinX = x1;
                }
                if ((y1 = intCoords[1]) < intMinY) {
                    intMinY = y1;
                }
                if ((x2 = intCoords[2]) > intMaxX) {
                    intMaxX = x2;
                }
                if ((y2 = intCoords[3]) <= intMaxY) continue;
                intMaxY = y2;
                continue;
            }
            boundsBuilder.genShapeOfArc(a);
        }
        ERectangle bounds = boundsBuilder.makeBounds();
        if (bounds == null) {
            assert (intMinX <= intMaxX && intMinY <= intMaxY);
            int iw = intMaxX - intMinX;
            int ih = intMaxY - intMinY;
            return ERectangle.fromGrid(intMinX, intMinY, iw >= 0 ? (long)iw : (long)intMaxX - (long)intMinX, ih >= 0 ? (long)ih : (long)intMaxY - (long)intMinY);
        }
        if (intMinX > intMaxX) {
            return bounds;
        }
        long longMinX = Math.min(bounds.getGridMinX(), (long)intMinX);
        long longMinY = Math.min(bounds.getGridMinY(), (long)intMinY);
        long longMaxX = Math.max(bounds.getGridMaxX(), (long)intMaxX);
        long longMaxY = Math.max(bounds.getGridMaxY(), (long)intMaxY);
        return ERectangle.fromGrid(longMinX, longMinY, longMaxX - longMinX, longMaxY - longMinY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Memoization {
        public final int[] connections;
        private final ImmutableExport[] exportIndexByOriginalPort;
        private final BitSet wiped;

        Memoization() {
            int nodeId;
            ++cellBackupsMemoized;
            ImmutableArrayList<ImmutableNodeInst> nodes = CellBackup.this.cellRevision.nodes;
            ImmutableArrayList<ImmutableArcInst> arcs = CellBackup.this.cellRevision.arcs;
            int maxNodeId = -1;
            for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
                maxNodeId = Math.max(maxNodeId, ((ImmutableNodeInst)nodes.get((int)nodeIndex)).nodeId);
            }
            int[] connections = new int[arcs.size() * 2];
            int[] connectionsByNodeId = new int[maxNodeId + 1];
            for (ImmutableArcInst a : arcs) {
                int n = a.headNodeId;
                connectionsByNodeId[n] = connectionsByNodeId[n] + 1;
                int n2 = a.tailNodeId;
                connectionsByNodeId[n2] = connectionsByNodeId[n2] + 1;
            }
            int sum = 0;
            for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
                int start = sum;
                sum += connectionsByNodeId[nodeId];
                connectionsByNodeId[nodeId] = start;
            }
            for (int i = 0; i < arcs.size(); ++i) {
                ImmutableArcInst a = (ImmutableArcInst)arcs.get(i);
                int n = a.tailNodeId;
                int n3 = connectionsByNodeId[n];
                connectionsByNodeId[n] = n3 + 1;
                connections[n3] = i * 2;
                int n4 = a.headNodeId;
                int n5 = connectionsByNodeId[n4];
                connectionsByNodeId[n4] = n5 + 1;
                connections[n5] = i * 2 + 1;
            }
            sum = 0;
            for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
                sum = connectionsByNodeId[nodeId];
                int start = sum;
                if (sum - 1 <= start) continue;
                this.sortConnections(connections, start, sum - 1);
            }
            this.connections = connections;
            ImmutableExport[] exportIndexByOriginalPort = CellBackup.this.cellRevision.exports.toArray(new ImmutableExport[CellBackup.this.cellRevision.exports.size()]);
            Arrays.sort(exportIndexByOriginalPort, BY_ORIGINAL_PORT);
            this.exportIndexByOriginalPort = exportIndexByOriginalPort;
            BitSet wiped = new BitSet();
            for (ImmutableArcInst a : arcs) {
                if (!a.protoType.isWipable()) continue;
                wiped.set(a.tailNodeId);
                wiped.set(a.headNodeId);
            }
            for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
                ImmutableNodeInst n = (ImmutableNodeInst)nodes.get(nodeIndex);
                NodeProtoId np = n.protoId;
                if (np instanceof PrimitiveNode && ((PrimitiveNode)np).isArcsWipe()) continue;
                wiped.clear(n.nodeId);
            }
            this.wiped = wiped;
        }

        public boolean hasExports(int originalNodeId) {
            int startIndex = this.searchExportByOriginalPort(originalNodeId, 0);
            if (startIndex >= this.exportIndexByOriginalPort.length) {
                return false;
            }
            ImmutableExport e = this.exportIndexByOriginalPort[startIndex];
            return e.originalNodeId == originalNodeId;
        }

        public int getNumExports(int originalNodeId) {
            int startIndex;
            int j;
            for (j = startIndex = this.searchExportByOriginalPort(originalNodeId, 0); j < this.exportIndexByOriginalPort.length; ++j) {
                ImmutableExport e = this.exportIndexByOriginalPort[j];
                if (e.originalNodeId != originalNodeId) break;
            }
            return j - startIndex;
        }

        public Iterator<ImmutableExport> getExports(int originalNodeId) {
            int startIndex;
            int j;
            for (j = startIndex = this.searchExportByOriginalPort(originalNodeId, 0); j < this.exportIndexByOriginalPort.length; ++j) {
                ImmutableExport e = this.exportIndexByOriginalPort[j];
                if (e.originalNodeId != originalNodeId) break;
            }
            return ArrayIterator.iterator(this.exportIndexByOriginalPort, startIndex, j);
        }

        private int searchExportByOriginalPort(int originalNodeId, int originalChronIndex) {
            int low = 0;
            int high = this.exportIndexByOriginalPort.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                ImmutableExport e = this.exportIndexByOriginalPort[mid];
                int cmp = e.originalNodeId - originalNodeId;
                if (cmp == 0) {
                    int n = cmp = e.originalPortId.getChronIndex() >= originalChronIndex ? 1 : -1;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            return low;
        }

        public int searchConnectionByPort(int nodeId, int chronIndex) {
            int low = 0;
            int high = this.connections.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int con = this.connections[mid];
                ImmutableArcInst a = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con >>> 1);
                boolean end = (con & 1) != 0;
                int endNodeId = end ? a.headNodeId : a.tailNodeId;
                int cmp = endNodeId - nodeId;
                if (cmp == 0) {
                    PortProtoId portId = end ? a.headPortId : a.tailPortId;
                    cmp = portId.getChronIndex() - chronIndex;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            return low;
        }

        public ImmutableArrayList<ImmutableArcInst> getArcs() {
            return CellBackup.this.cellRevision.arcs;
        }

        public boolean isWiped(int nodeId) {
            return this.wiped.get(nodeId);
        }

        private void check() {
            assert (this.exportIndexByOriginalPort.length == CellBackup.this.cellRevision.exports.size());
            ImmutableExport prevE = null;
            for (ImmutableExport e : this.exportIndexByOriginalPort) {
                if (prevE != null) assert (BY_ORIGINAL_PORT.compare(prevE, e) < 0);
                assert (e == CellBackup.this.cellRevision.getExport(e.exportId));
                prevE = e;
            }
            assert (this.connections.length == CellBackup.this.cellRevision.arcs.size() * 2);
            for (int i = 1; i < this.connections.length; ++i) {
                assert (this.compareConnections(this.connections[i - 1], this.connections[i]) < 0);
            }
        }

        private void sortConnections(int[] connections, int l, int r) {
            ImmutableArrayList<ImmutableArcInst> arcs = CellBackup.this.cellRevision.arcs;
            while (l + 1 < r) {
                int x = connections[l + r >>> 1];
                ImmutableArcInst ax = (ImmutableArcInst)arcs.get(x >>> 1);
                boolean endx = (x & 1) != 0;
                PortProtoId portIdX = endx ? ax.headPortId : ax.tailPortId;
                int chronIndexX = portIdX.getChronIndex();
                int i = l;
                int j = r;
                while (true) {
                    PortProtoId portId;
                    int con = connections[i];
                    ImmutableArcInst a = (ImmutableArcInst)arcs.get(con >>> 1);
                    boolean end = (con & 1) != 0;
                    PortProtoId portProtoId = portId = end ? a.headPortId : a.tailPortId;
                    if (portId.getChronIndex() <= chronIndexX && (portId.getChronIndex() != chronIndexX || con < x)) {
                        ++i;
                        continue;
                    }
                    while (true) {
                        con = connections[j];
                        a = (ImmutableArcInst)arcs.get(con >>> 1);
                        end = (con & 1) != 0;
                        PortProtoId portProtoId2 = portId = end ? a.headPortId : a.tailPortId;
                        if (chronIndexX > portId.getChronIndex() || chronIndexX == portId.getChronIndex() && x >= con) break;
                        --j;
                    }
                    if (i <= j) {
                        int w = connections[i];
                        connections[i] = connections[j];
                        connections[j] = w;
                        ++i;
                        --j;
                    }
                    if (i > j) break;
                }
                if (j - l < r - i) {
                    this.sortConnections(connections, l, j);
                    l = i;
                    continue;
                }
                this.sortConnections(connections, i, r);
                r = j;
            }
            if (l + 1 == r) {
                int con1 = connections[l];
                int con2 = connections[r];
                ImmutableArcInst a1 = (ImmutableArcInst)arcs.get(con1 >>> 1);
                ImmutableArcInst a2 = (ImmutableArcInst)arcs.get(con2 >>> 1);
                boolean end1 = (con1 & 1) != 0;
                boolean end2 = (con2 & 1) != 0;
                PortProtoId portId1 = end1 ? a1.headPortId : a1.tailPortId;
                PortProtoId portId2 = end2 ? a2.headPortId : a2.tailPortId;
                int cmp = portId1.getChronIndex() - portId2.getChronIndex();
                if (cmp > 0 || cmp == 0 && con1 > con2) {
                    connections[l] = con2;
                    connections[r] = con1;
                }
            }
        }

        private int compareConnections(int con1, int con2) {
            boolean end2;
            int nodeId2;
            ImmutableArcInst a1 = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con1 >>> 1);
            ImmutableArcInst a2 = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con2 >>> 1);
            boolean end1 = (con1 & 1) != 0;
            int nodeId1 = end1 ? a1.headNodeId : a1.tailNodeId;
            int cmp = nodeId1 - (nodeId2 = (end2 = (con2 & 1) != 0) ? a2.headNodeId : a2.tailNodeId);
            if (cmp != 0) {
                return cmp;
            }
            PortProtoId portId1 = end1 ? a1.headPortId : a1.tailPortId;
            PortProtoId portId2 = end2 ? a2.headPortId : a2.tailPortId;
            cmp = portId1.getChronIndex() - portId2.getChronIndex();
            if (cmp != 0) {
                return cmp;
            }
            return con1 - con2;
        }
    }
}

