/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.utils;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOSRules
implements DRCRules {
    private Technology tech;
    public int numLayers;
    public int uTSize;
    public Double wideLimit;
    public String[] layerNames;
    public Double[] minWidth;
    public String[] minWidthRules;
    public Double[] conList;
    public String[] conListRules;
    public String[] conListNodes;
    public Double[] unConList;
    public String[] unConListRules;
    public String[] unConListNodes;
    public Double[] conListWide;
    public String[] conListWideRules;
    public Double[] unConListWide;
    public String[] unConListWideRules;
    public Double[] conListMulti;
    public String[] conListMultiRules;
    public Double[] unConListMulti;
    public String[] unConListMultiRules;
    public Double[] edgeList;
    public String[] edgeListRules;
    public Double[] minArea;
    public String[] minAreaRules;
    public Double[] slotSize;
    public String[] slotSizeRules;
    public int numNodes;
    public String[] nodeNames;
    public Double[] minNodeSize;
    public String[] minNodeSizeRules;
    public Double[] cutNodeSize;
    public String[] cutNodeSizeRules;
    public Double[] cutNodeSpa1D;
    public String[] cutNodeSpa1DRules;
    public Double[] cutNodeSpa2D;
    public String[] cutNodeSpa2DRules;
    public Double[] cutNodeSurround;
    public String[] cutNodeSurroundRules;
    public double transPolyOverhang;
    private int numberOfRules;
    private static final int MOSNORULE = -1;

    public MOSRules() {
    }

    private void setMinNodeSize(int index, String name, double width, double height) {
        this.minNodeSizeRules[index] = name;
        this.minNodeSize[index * 2] = width;
        this.minNodeSize[index * 2 + 1] = height;
    }

    public DRCTemplate getMinNodeSize(int index, int when) {
        double[] vals = new double[]{this.minNodeSize[index * 2], this.minNodeSize[index * 2 + 1]};
        DRCTemplate rule = new DRCTemplate(this.minNodeSizeRules[index], when, DRCTemplate.DRCRuleType.NODSIZ, 0.0, 0.0, null, null, vals, -1);
        return rule;
    }

    public MOSRules(Technology tech) {
        int i;
        PrimitiveNode np;
        this.numLayers = tech.getNumLayers();
        this.numNodes = tech.getNumNodes();
        int numIndices = this.numLayers + this.numNodes;
        this.uTSize = (numIndices * numIndices + numIndices) / 2;
        this.wideLimit = 0.0;
        this.tech = tech;
        this.layerNames = new String[this.numLayers];
        int j = 0;
        Iterator<Object> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            this.layerNames[j++] = layer.getName();
        }
        this.nodeNames = new String[this.numNodes];
        j = 0;
        it = tech.getNodes();
        while (it.hasNext()) {
            np = (PrimitiveNode)it.next();
            this.nodeNames[j++] = np.getName();
        }
        this.conList = new Double[this.uTSize];
        this.conListRules = new String[this.uTSize];
        this.conListNodes = new String[this.uTSize];
        this.unConList = new Double[this.uTSize];
        this.unConListRules = new String[this.uTSize];
        this.unConListNodes = new String[this.uTSize];
        this.conListWide = new Double[this.uTSize];
        this.conListWideRules = new String[this.uTSize];
        this.unConListWide = new Double[this.uTSize];
        this.unConListWideRules = new String[this.uTSize];
        this.conListMulti = new Double[this.uTSize];
        this.conListMultiRules = new String[this.uTSize];
        this.unConListMulti = new Double[this.uTSize];
        this.unConListMultiRules = new String[this.uTSize];
        this.edgeList = new Double[this.uTSize];
        this.edgeListRules = new String[this.uTSize];
        this.minWidth = new Double[this.numLayers];
        this.minWidthRules = new String[this.numLayers];
        this.minArea = new Double[this.numLayers];
        this.minAreaRules = new String[this.numLayers];
        this.slotSize = new Double[this.numLayers];
        this.slotSizeRules = new String[this.numLayers];
        for (i = 0; i < this.uTSize; ++i) {
            this.conList[i] = new Double(-1.0);
            this.conListRules[i] = "";
            this.unConList[i] = new Double(-1.0);
            this.unConListRules[i] = "";
            this.conListWide[i] = new Double(-1.0);
            this.conListWideRules[i] = "";
            this.unConListWide[i] = new Double(-1.0);
            this.unConListWideRules[i] = "";
            this.conListMulti[i] = new Double(-1.0);
            this.conListMultiRules[i] = "";
            this.unConListMulti[i] = new Double(-1.0);
            this.unConListMultiRules[i] = "";
            this.edgeList[i] = new Double(-1.0);
            this.edgeListRules[i] = "";
        }
        for (i = 0; i < this.numLayers; ++i) {
            this.minWidth[i] = new Double(-1.0);
            this.minWidthRules[i] = "";
            this.minArea[i] = new Double(-1.0);
            this.minAreaRules[i] = "";
            this.slotSize[i] = new Double(-1.0);
            this.slotSizeRules[i] = "";
        }
        this.minNodeSize = new Double[this.numNodes * 2];
        this.minNodeSizeRules = new String[this.numNodes];
        this.cutNodeSize = new Double[this.numNodes];
        this.cutNodeSizeRules = new String[this.numNodes];
        this.cutNodeSurround = new Double[this.numNodes];
        this.cutNodeSurroundRules = new String[this.numNodes];
        this.cutNodeSpa1D = new Double[this.numNodes];
        this.cutNodeSpa1DRules = new String[this.numNodes];
        this.cutNodeSpa2D = new Double[this.numNodes];
        this.cutNodeSpa2DRules = new String[this.numNodes];
        j = 0;
        Iterator<PrimitiveNode> it2 = tech.getNodes();
        while (it2.hasNext()) {
            np = it2.next();
            PrimitiveNode.NodeSizeRule minSizeRule = np.getMinSizeRule();
            if (minSizeRule == null) {
                minSizeRule = new PrimitiveNode.NodeSizeRule(0.0, 0.0, "");
            }
            this.minNodeSize[j * 2] = minSizeRule.getWidth();
            this.minNodeSize[j * 2 + 1] = minSizeRule.getHeight();
            this.minNodeSizeRules[j] = minSizeRule.getRuleName();
            this.cutNodeSizeRules[j] = "";
            this.cutNodeSize[j] = new Double(-1.0);
            this.cutNodeSurroundRules[j] = "";
            this.cutNodeSurround[j] = new Double(-1.0);
            this.cutNodeSpa1DRules[j] = "";
            this.cutNodeSpa1D[j] = new Double(-1.0);
            this.cutNodeSpa2DRules[j] = "";
            this.cutNodeSpa2D[j] = new Double(-1.0);
            ++j;
        }
    }

    @Override
    public int getRuleIndex(int index1, int index2) {
        return MOSRules.getRuleIndex(index1, index2, this.tech.getNumLayers());
    }

    public static int getRuleIndex(int index1, int index2, int numLayers) {
        if (index1 > index2) {
            int temp = index1;
            index1 = index2;
            index2 = temp;
        }
        int pIndex = (index1 + 1) * (index1 / 2) + (index1 & 1) * ((index1 + 1) / 2);
        pIndex = index2 + numLayers * index1 - pIndex;
        return pIndex;
    }

    public double getPolyOverhang() {
        return this.transPolyOverhang;
    }

    @Override
    public boolean isForbiddenNode(int nodeIndex, DRCTemplate.DRCRuleType type) {
        return false;
    }

    public static DRCRules makeSimpleRules(Technology tech, double[] conDist, double[] unConDist) {
        int i;
        MOSRules rules = new MOSRules(tech);
        if (conDist != null) {
            for (i = 0; i < conDist.length; ++i) {
                rules.conList[i] = conDist[i];
            }
        }
        if (unConDist != null) {
            for (i = 0; i < unConDist.length; ++i) {
                rules.unConList[i] = unConDist[i];
            }
        }
        rules.calculateNumberOfRules();
        return rules;
    }

    @Override
    public double getWorstSpacingDistance(int lastMetal) {
        assert (lastMetal == -1);
        double worstInteractionDistance = 0.0;
        for (int i = 0; i < this.uTSize; ++i) {
            double dist = this.unConList[i];
            if (dist > worstInteractionDistance) {
                worstInteractionDistance = dist;
            }
            if ((dist = this.unConListWide[i].doubleValue()) > worstInteractionDistance) {
                worstInteractionDistance = dist;
            }
            if (!((dist = this.unConListMulti[i].doubleValue()) > worstInteractionDistance)) continue;
            worstInteractionDistance = dist;
        }
        return worstInteractionDistance;
    }

    @Override
    public double getMaxSurround(Technology tech, Layer layer, double maxSize) {
        double worstLayerRule = -1.0;
        int layerIndex = layer.getIndex();
        int tot = tech.getNumLayers();
        double wide = this.wideLimit;
        for (int i = 0; i < tot; ++i) {
            int pIndex = this.getRuleIndex(layerIndex, i);
            double dist = this.unConList[pIndex];
            if (dist > worstLayerRule) {
                worstLayerRule = dist;
            }
            if (!(maxSize > wide) || !((dist = this.unConListWide[pIndex].doubleValue()) > worstLayerRule)) continue;
            worstLayerRule = dist;
        }
        return worstLayerRule;
    }

    @Override
    public List<DRCTemplate> getRules(Layer layer1, DRCTemplate.DRCRuleType type) {
        return null;
    }

    @Override
    public DRCTemplate getExtensionRule(Layer layer1, Layer layer2, boolean isGateExtension) {
        return null;
    }

    @Override
    public DRCTemplate getEdgeRule(Layer layer1, Layer layer2) {
        int pIndex = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        double[] dArray = new double[]{this.edgeList[pIndex]};
        double[] dist = dArray;
        if (dist[0] < 0.0) {
            return null;
        }
        return new DRCTemplate(this.edgeListRules[pIndex], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SPACINGE, 0.0, 0.0, null, null, dist, -1);
    }

    @Override
    public DRCTemplate getSpacingRule(Layer layer1, Geometric geo1, Layer layer2, Geometric geo2, boolean connected, int multiCut, double wideS, double length) {
        double dist;
        int pIndex = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        String n1 = DRCTemplate.getSpacingCombinedName(layer1, geo1);
        String n2 = DRCTemplate.getSpacingCombinedName(layer2, geo2);
        double[] bestDist = new double[]{-1.0};
        String rule = null;
        if (connected) {
            dist = this.conList[pIndex];
            boolean validName = true;
            if (this.conListNodes[pIndex] != null && !n1.equals(this.conListNodes[pIndex]) && !n2.equals(this.conListNodes[pIndex])) {
                validName = false;
            }
            if (validName && dist >= 0.0) {
                bestDist[0] = dist;
                rule = this.conListRules[pIndex];
            }
        } else {
            dist = this.unConList[pIndex];
            boolean validName = true;
            if (this.unConListNodes[pIndex] != null && !n1.equals(this.unConListNodes[pIndex]) && !n2.equals(this.unConListNodes[pIndex])) {
                validName = false;
            }
            if (validName && dist >= 0.0) {
                bestDist[0] = dist;
                rule = this.unConListRules[pIndex];
            }
        }
        if (wideS > this.wideLimit) {
            if (connected) {
                dist = this.conListWide[pIndex];
                if (dist >= 0.0) {
                    bestDist[0] = dist;
                    rule = this.conListWideRules[pIndex];
                }
            } else {
                dist = this.unConListWide[pIndex];
                if (dist >= 0.0) {
                    bestDist[0] = dist;
                    rule = this.unConListWideRules[pIndex];
                }
            }
        }
        if (multiCut == 1) {
            if (connected) {
                dist = this.conListMulti[pIndex];
                if (dist >= 0.0) {
                    bestDist[0] = dist;
                    rule = this.conListMultiRules[pIndex];
                }
            } else {
                dist = this.unConListMulti[pIndex];
                if (dist >= 0.0) {
                    bestDist[0] = dist;
                    rule = this.unConListMultiRules[pIndex];
                }
            }
        }
        if (bestDist[0] < 0.0) {
            return null;
        }
        return new DRCTemplate(rule, DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SPACING, 0.0, 0.0, bestDist, multiCut);
    }

    @Override
    public boolean isAnySpacingRule(Layer layer1, Layer layer2) {
        int pIndex = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
        if (this.conList[pIndex] >= 0.0) {
            return true;
        }
        if (this.unConList[pIndex] >= 0.0) {
            return true;
        }
        if (this.conListWide[pIndex] >= 0.0) {
            return true;
        }
        if (this.unConListWide[pIndex] >= 0.0) {
            return true;
        }
        if (this.conListMulti[pIndex] >= 0.0) {
            return true;
        }
        if (this.unConListMulti[pIndex] >= 0.0) {
            return true;
        }
        return this.edgeList[pIndex] >= 0.0;
    }

    @Override
    public boolean doesAllowMultipleWideRules(int index) {
        return this.unConListWide[index] == -1.0;
    }

    @Override
    public int getNumberOfRules() {
        return this.numberOfRules;
    }

    @Override
    public String[] getNodesWithRules() {
        return this.nodeNames;
    }

    @Override
    public void addRule(int index, DRCTemplate rule) {
        new Error("Not implemented");
    }

    @Override
    public void addRule(int index, DRCTemplate rule, DRCTemplate.DRCRuleType spacingCase, boolean wideRules) {
        if (rule.ruleType == DRCTemplate.DRCRuleType.NODSIZ) {
            this.setMinNodeSize(index, rule.ruleName, rule.getValue(0), rule.getValue(1));
        } else {
            block0 : switch (rule.ruleType) {
                case CONSPA: {
                    switch (spacingCase) {
                        case SPACING: {
                            if (!wideRules) {
                                this.conList[index] = rule.getValue(0);
                                this.conListRules[index] = rule.ruleName;
                                if (!(rule.maxWidth > 0.0)) break block0;
                                this.wideLimit = rule.maxWidth;
                                break;
                            }
                            this.conListWide[index] = rule.getValue(0);
                            this.conListWideRules[index] = rule.ruleName;
                            if (!(rule.maxWidth > 0.0)) break block0;
                            this.wideLimit = rule.maxWidth;
                            break;
                        }
                        case UCONSPA2D: {
                            this.conListMulti[index] = rule.getValue(0);
                            this.conListMultiRules[index] = rule.ruleName;
                            break;
                        }
                        case SPACINGE: {
                            this.edgeList[index] = rule.getValue(0);
                            this.edgeListRules[index] = rule.ruleName;
                            break;
                        }
                        default: {
                            System.out.println("Error in MOSRules.setSpacingRules");
                            break;
                        }
                    }
                    break;
                }
                case UCONSPA: {
                    switch (spacingCase) {
                        case SPACING: {
                            if (!wideRules) {
                                this.unConList[index] = rule.getValue(0);
                                this.unConListRules[index] = rule.ruleName;
                                if (!(rule.maxWidth > 0.0)) break block0;
                                this.wideLimit = rule.maxWidth;
                                break;
                            }
                            this.unConListWide[index] = rule.getValue(0);
                            this.unConListWideRules[index] = rule.ruleName;
                            if (!(rule.maxWidth > 0.0)) break block0;
                            this.wideLimit = rule.maxWidth;
                            break;
                        }
                        case UCONSPA2D: {
                            this.unConListMulti[index] = rule.getValue(0);
                            this.unConListMultiRules[index] = rule.ruleName;
                            break;
                        }
                        default: {
                            System.out.println("Error in MOSRules.setSpacingRules");
                            break;
                        }
                    }
                    break;
                }
                default: {
                    System.out.println("Error in MOSRules.setSpacingRules");
                }
            }
        }
    }

    @Override
    public void deleteRule(int index, DRCTemplate rule) {
        this.conListWide[index] = new Double(-1.0);
        this.conListWideRules[index] = "";
        this.unConListWide[index] = new Double(-1.0);
        this.unConListWideRules[index] = "";
    }

    @Override
    public void setSpacingRules(int index, List<DRCTemplate> newRules, DRCTemplate.DRCRuleType spacingCase, boolean wideRules) {
        for (DRCTemplate rule : newRules) {
            this.addRule(index, rule, spacingCase, false);
        }
    }

    @Override
    public List<DRCTemplate> getSpacingRules(int index, DRCTemplate.DRCRuleType type, boolean wideRules) {
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(2);
        switch (type) {
            case SPACING: {
                if (!wideRules) {
                    double[] dArray = new double[]{this.conList[index]};
                    double[] dist = dArray;
                    if (dist[0] >= 0.0) {
                        list.add(new DRCTemplate(this.conListRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.CONSPA, 0.0, 0.0, null, null, dist, -1));
                    }
                    dist[0] = this.unConList[index];
                    if (!(dist[0] >= 0.0)) break;
                    list.add(new DRCTemplate(this.unConListRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.UCONSPA, 0.0, 0.0, null, null, dist, -1));
                    break;
                }
                double[] dArray = new double[]{this.conListWide[index]};
                double[] dist = dArray;
                if (dist[0] >= 0.0) {
                    list.add(new DRCTemplate(this.conListWideRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.CONSPA, this.wideLimit, 0.0, null, null, dist, -1));
                }
                dist[0] = this.unConListWide[index];
                if (!(dist[0] >= 0.0)) break;
                list.add(new DRCTemplate(this.unConListWideRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.UCONSPA, this.wideLimit, 0.0, null, null, dist, -1));
                break;
            }
            case UCONSPA2D: {
                double[] dist = new double[]{this.conListMulti[index]};
                if (dist[0] >= 0.0) {
                    list.add(new DRCTemplate(this.conListMultiRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.CONSPA, 0.0, 0.0, null, null, dist, 1));
                }
                dist[0] = this.unConListMulti[index];
                if (!(dist[0] >= 0.0)) break;
                list.add(new DRCTemplate(this.unConListMultiRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.UCONSPA, 0.0, 0.0, null, null, dist, 1));
                break;
            }
            case SPACINGE: {
                double[] dist = new double[]{this.edgeList[index]};
                if (!(dist[0] >= 0.0)) break;
                list.add(new DRCTemplate(this.edgeListRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SPACINGE, 0.0, 0.0, null, null, dist, -1));
                break;
            }
            default: {
                System.out.println("Error in MOSRules.getSpacingRules");
            }
        }
        return list;
    }

    private void calculateNumberOfRules() {
        int i;
        int count = 0;
        for (i = 0; i < this.uTSize; ++i) {
            if (this.unConList[i] > -1.0) {
                ++count;
            }
            if (this.unConListWide[i] > -1.0) {
                ++count;
            }
            if (this.unConListMulti[i] > -1.0) {
                ++count;
            }
            if (this.conList[i] > -1.0) {
                ++count;
            }
            if (this.conListWide[i] > -1.0) {
                ++count;
            }
            if (this.conListMulti[i] > -1.0) {
                ++count;
            }
            if (!(this.edgeList[i] > -1.0)) continue;
            ++count;
        }
        for (i = 0; i < this.numLayers; ++i) {
            if (!(this.minWidth[i] > -1.0)) continue;
            ++count;
        }
        for (i = 0; i < this.minNodeSize.length; ++i) {
            if (!(this.minNodeSize[i] > -1.0)) continue;
            ++count;
        }
        this.numberOfRules = count;
    }

    @Override
    public DRCTemplate getMinValue(Layer layer, DRCTemplate.DRCRuleType type) {
        int index = layer.getIndex();
        switch (type) {
            case MINWID: {
                double[] dist = new double[]{this.minWidth[index]};
                if (dist[0] < 0.0) {
                    return null;
                }
                return new DRCTemplate(this.minWidthRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.MINWID, 0.0, 0.0, null, null, dist, -1);
            }
            case MINAREA: {
                double[] dist = new double[]{this.minArea[index]};
                if (dist[0] < 0.0) {
                    return null;
                }
                return new DRCTemplate(this.minAreaRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.MINAREA, 0.0, 0.0, null, null, dist, -1);
            }
            case SLOTSIZE: {
                double[] dist = new double[]{this.slotSize[index]};
                if (dist[0] < 0.0) {
                    return null;
                }
                return new DRCTemplate(this.slotSizeRules[index], DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SLOTSIZE, 0.0, 0.0, null, null, dist, -1);
            }
        }
        return null;
    }

    @Override
    public DRCTemplate getRule(int index, DRCTemplate.DRCRuleType type) {
        switch (type) {
            case MINWID: {
                double[] minSize = new double[]{this.minWidth[index], this.minWidth[index]};
                if (minSize[0] < 0.0) {
                    return null;
                }
                return new DRCTemplate(this.minWidthRules[index], DRCTemplate.DRCMode.ALL.mode(), type, 0.0, 0.0, null, null, minSize, -1);
            }
            case UCONSPA2D: {
                double[] cutSpa = new double[]{this.cutNodeSpa1D[index]};
                if (cutSpa[0] < 0.0) {
                    return null;
                }
                return new DRCTemplate(this.cutNodeSpa1DRules[index], DRCTemplate.DRCMode.ALL.mode(), type, 0.0, 0.0, null, null, cutSpa, -1);
            }
        }
        return null;
    }

    @Override
    public DRCTemplate getRule(int index, DRCTemplate.DRCRuleType type, String nodeName) {
        new Error("not implemented");
        return null;
    }

    @Override
    public void setMinValue(Layer layer, String name, double value, DRCTemplate.DRCRuleType type) {
        int index = layer.getIndex();
        if (value <= 0.0) {
            value = -1.0;
        }
        switch (type) {
            case MINWID: {
                this.minWidth[index] = value;
                this.minWidthRules[index] = name;
                break;
            }
            case MINAREA: {
                this.minArea[index] = value;
                this.minAreaRules[index] = name;
                break;
            }
            default: {
                System.out.println("Not implemented for " + (Object)((Object)type) + " in MOSRules.setMinValue");
            }
        }
    }

    @Override
    public void applyDRCOverrides(String override, Technology tech) {
        int startKey;
        int endKey;
        int pos = 0;
        int len = override.length();
        while (pos < len && (endKey = override.indexOf(58, startKey = pos)) >= 0) {
            int index;
            String key = override.substring(startKey, endKey);
            if (key.equals("c") || key.equals("cr") || key.equals("u") || key.equals("ur") || key.equals("cw") || key.equals("cwr") || key.equals("uw") || key.equals("uwr") || key.equals("cm") || key.equals("cmr") || key.equals("um") || key.equals("umr") || key.equals("e") || key.equals("er")) {
                Layer layer2;
                startKey = endKey + 1;
                Layer layer1 = Technology.getLayerFromOverride(override, startKey, '/', tech);
                if (layer1 == null || (startKey = override.indexOf(47, startKey)) < 0 || (layer2 = Technology.getLayerFromOverride(override, startKey + 1, '=', tech)) == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                index = this.getRuleIndex(layer1.getIndex(), layer2.getIndex());
                if (key.equals("c")) {
                    this.conList[index] = TextUtils.atof(newValue);
                } else if (key.equals("cr")) {
                    this.conListRules[index] = newValue;
                } else if (key.equals("u")) {
                    this.unConList[index] = TextUtils.atof(newValue);
                } else if (key.equals("ur")) {
                    this.unConListRules[index] = newValue;
                } else if (key.equals("cw")) {
                    this.conListWide[index] = TextUtils.atof(newValue);
                } else if (key.equals("cwr")) {
                    this.conListWideRules[index] = newValue;
                } else if (key.equals("uw")) {
                    this.unConListWide[index] = TextUtils.atof(newValue);
                } else if (key.equals("uwr")) {
                    this.unConListWideRules[index] = newValue;
                } else if (key.equals("cm")) {
                    this.conListMulti[index] = TextUtils.atof(newValue);
                } else if (key.equals("cmr")) {
                    this.conListMultiRules[index] = newValue;
                } else if (key.equals("um")) {
                    this.unConListMulti[index] = TextUtils.atof(newValue);
                } else if (key.equals("umr")) {
                    this.unConListMultiRules[index] = newValue;
                } else if (key.equals("e")) {
                    this.edgeList[index] = TextUtils.atof(newValue);
                } else if (key.equals("er")) {
                    this.edgeListRules[index] = newValue;
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("m") || key.equals("mr")) {
                startKey = endKey + 1;
                Layer layer = Technology.getLayerFromOverride(override, startKey, '=', tech);
                if (layer == null || (startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey + 1, endKey);
                int index2 = layer.getIndex();
                if (key.equals("m")) {
                    this.minWidth[index2] = TextUtils.atof(newValue);
                } else if (key.equals("mr")) {
                    this.minWidthRules[index2] = newValue;
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("n") || key.equals("nr")) {
                PrimitiveNode oNp;
                String nodeName;
                PrimitiveNode np;
                startKey = endKey + 1;
                int endPos = override.indexOf(61, startKey);
                if (endPos < 0 || (np = tech.findNodeProto(nodeName = override.substring(startKey, endPos))) == null) break;
                index = 0;
                Iterator<PrimitiveNode> it = tech.getNodes();
                while (it.hasNext() && (oNp = it.next()) != np) {
                    ++index;
                }
                if (key.equals("n")) {
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(47, startKey)) < 0) break;
                    String newValue1 = override.substring(startKey + 1, endKey);
                    int otherEndKey = override.indexOf(59, startKey);
                    if (otherEndKey < 0) break;
                    String newValue2 = override.substring(endKey + 1, otherEndKey);
                    this.minNodeSize[index * 2] = TextUtils.atof(newValue1);
                    this.minNodeSize[index * 2 + 1] = TextUtils.atof(newValue2);
                } else if (key.equals("nr")) {
                    if ((startKey = override.indexOf(61, startKey)) < 0 || (endKey = override.indexOf(59, startKey)) < 0) break;
                    this.minNodeSizeRules[index] = override.substring(startKey + 1, endKey);
                }
                pos = endKey + 1;
                continue;
            }
            if (key.equals("w")) {
                startKey = endKey + 1;
                if ((endKey = override.indexOf(59, startKey)) < 0) break;
                String newValue = override.substring(startKey, endKey);
                this.wideLimit = TextUtils.atof(newValue);
                pos = endKey + 1;
                continue;
            }
            endKey = override.indexOf(59, startKey);
            pos = endKey + 1;
        }
    }
}

