/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.gates.MoCMOSGenerator;
import com.sun.electric.tool.user.User;
import java.lang.reflect.Method;

public class GateRegression
extends Job {
    private TechType technology;
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    private static void allSizes(StdCellParams stdCell, TechType technology) {
        double minSz = 0.1;
        double maxSz = 200.0;
        for (double d = minSz; d < maxSz; d *= 10.0) {
            for (double x = d; x < Math.min(d * 10.0, maxSz); x *= 1.01) {
                GateRegression.aPass(x, stdCell, technology);
            }
        }
    }

    public static void aPass(double x, StdCellParams stdCell, TechType technology) {
        Technology cmos90;
        if (technology == TechType.MOCMOS || technology == TechType.TSMC180) {
            MoCMOSGenerator.generateAllGates(x, stdCell);
        }
        if ((cmos90 = Technology.getCMOS90Technology()) != null && technology == TechType.CMOS90) {
            try {
                Class<?> cmos90GeneratorClass = Class.forName("com.sun.electric.plugins.tsmc.gates90nm.CMOS90Generator");
                Class[] parameterTypes = new Class[]{Double.class, StdCellParams.class};
                Method generateMethod = cmos90GeneratorClass.getDeclaredMethod("generateAllGates", parameterTypes);
                generateMethod.invoke(null, new Double(x), stdCell);
            }
            catch (Exception e) {
                System.out.println("ERROR invoking the CMOS90 gate generator");
            }
        }
    }

    public boolean doIt() throws JobException {
        Library scratchLib = LayoutLib.openLibForWrite("scratch" + this.technology);
        GateRegression.runRegression(this.technology, scratchLib);
        return true;
    }

    public static int runRegression(TechType technology, Library scratchLib) {
        StdCellParams stdCell;
        System.out.println("begin Gate Regression");
        Technology cmos90 = Technology.getCMOS90Technology();
        if (cmos90 != null && technology == TechType.CMOS90) {
            stdCell = new StdCellParams(TechType.CMOS90);
            stdCell.setOutputLibrary(scratchLib);
            stdCell.enableNCC("purpleFour");
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setMaxMosWidth(1000.0);
        } else {
            stdCell = GateLayoutGenerator.dividerParams(technology);
            stdCell.setOutputLibrary(scratchLib);
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setSimpleName(false);
        }
        GateRegression.allSizes(stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() - 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() + 7.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() + 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() - 7.0);
        stdCell.setNmosWellHeight(50.0);
        stdCell.setPmosWellHeight(100.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setNmosWellHeight(100.0);
        stdCell.setPmosWellHeight(50.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setNmosWellHeight(70.0);
        stdCell.setPmosWellHeight(70.0);
        Cell gallery = Gallery.makeGallery(scratchLib);
        DrcRings.addDrcRings(gallery, FILTER, stdCell);
        LayoutLib.writeLibrary(scratchLib);
        System.out.println("done.");
        return 0;
    }

    public GateRegression(TechType techNm) {
        super("Run Gate regression", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.technology = techNm;
        Tech.setTechnology(techNm);
        this.startJob();
    }
}

