/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.DBMath;
import java.io.Serializable;

public class EdgeH
implements Serializable {
    private double multiplier;
    private double adder;
    private long gridAdder;

    public EdgeH(double multiplier, double adder) {
        this.multiplier = multiplier;
        this.setAdder(adder);
    }

    public EdgeH duplicate() {
        return new EdgeH(this.multiplier, this.adder);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EdgeH)) {
            return false;
        }
        EdgeH otherE = (EdgeH)other;
        return this.multiplier == otherE.multiplier && this.adder == otherE.adder;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public double getAdder() {
        return this.adder;
    }

    public long getGridAdder() {
        return this.gridAdder;
    }

    public boolean setAdder(double adder) {
        if (this.adder != adder) {
            this.gridAdder = DBMath.lambdaToGrid(adder);
            this.adder = DBMath.gridToLambda(this.gridAdder);
            return true;
        }
        return false;
    }

    public static EdgeH fromLeft(double amt) {
        return new EdgeH(-0.5, amt);
    }

    public static EdgeH fromRight(double amt) {
        return new EdgeH(0.5, -amt);
    }

    public static EdgeH fromCenter(double amt) {
        return new EdgeH(0.0, amt);
    }

    public static EdgeH makeLeftEdge() {
        return EdgeH.fromLeft(0.0);
    }

    public static EdgeH makeRightEdge() {
        return EdgeH.fromRight(0.0);
    }

    public static EdgeH makeCenter() {
        return EdgeH.fromCenter(0.0);
    }

    public String toString() {
        return "EdgeH(" + this.multiplier + "," + this.adder + ")";
    }
}

