/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardPanel;
import com.sun.electric.tool.user.tecEditWizard.WizardField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Metal
extends TechEditWizardPanel {
    private JPanel metal;
    private JLabel[] widthLabel;
    private JLabel[] spacingLabel;
    private JTextField[] spacing;
    private JTextField[] spacingRule;
    private JTextField[] width;
    private JTextField[] widthRule;
    private int numMetals;
    private TechEditWizard parent;

    public Metal(TechEditWizard parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.setTitle("Metal");
        this.setName("");
        this.metal = new JPanel();
        this.metal.setLayout(new GridBagLayout());
        JLabel heading = new JLabel("Metal Parameters");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.metal.add((Component)heading, gbc);
        JLabel image = new JLabel();
        image.setIcon(Resources.getResource(this.getClass(), "Metal.png"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.metal.add((Component)image, gbc);
        JButton addMetal = new JButton("Add Metal");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        addMetal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Metal.this.addMetal();
            }
        });
        this.metal.add((Component)addMetal, gbc);
        JButton removeMetal = new JButton("Remove Metal");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        removeMetal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Metal.this.removeMetal();
            }
        });
        this.metal.add((Component)removeMetal, gbc);
        JLabel l1 = new JLabel("Distance");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.metal.add((Component)l1, gbc);
        JLabel l2 = new JLabel("Rule Name");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.metal.add((Component)l2, gbc);
        JLabel nano = new JLabel("Distances are in nanometers");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 99;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.metal.add((Component)nano, gbc);
    }

    public JPanel getPanel() {
        return this.metal;
    }

    public String getName() {
        return "Metal";
    }

    public void init() {
        TechEditWizardData data = this.wizard.getTechEditData();
        this.numMetals = data.getNumMetalLayers();
        this.widthLabel = new JLabel[this.numMetals];
        this.width = new JTextField[this.numMetals];
        this.widthRule = new JTextField[this.numMetals];
        this.spacingLabel = new JLabel[this.numMetals];
        this.spacing = new JTextField[this.numMetals];
        this.spacingRule = new JTextField[this.numMetals];
        for (int i = 0; i < this.numMetals; ++i) {
            this.addMetalLayer(i);
            this.width[i].setText(Double.toString(data.getMetalWidth()[i].v));
            this.widthRule[i].setText(data.getMetalWidth()[i].rule);
            this.spacing[i].setText(Double.toString(data.getMetalSpacing()[i].v));
            this.spacingRule[i].setText(data.getMetalSpacing()[i].rule);
        }
    }

    private void addMetalLayer(int i) {
        this.widthLabel[i] = new JLabel("Metal-" + (i + 1) + " width (A):");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4 + i * 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.metal.add((Component)this.widthLabel[i], gbc);
        this.width[i] = new JTextField();
        this.width[i].setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4 + i * 2;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.metal.add((Component)this.width[i], gbc);
        this.widthRule[i] = new JTextField();
        this.widthRule[i].setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4 + i * 2;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.metal.add((Component)this.widthRule[i], gbc);
        this.spacingLabel[i] = new JLabel("Metal-" + (i + 1) + " spacing (B):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5 + i * 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 4, 4, 0);
        this.metal.add((Component)this.spacingLabel[i], gbc);
        this.spacing[i] = new JTextField();
        this.spacing[i].setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5 + i * 2;
        gbc.insets = new Insets(1, 0, 4, 2);
        this.metal.add((Component)this.spacing[i], gbc);
        this.spacingRule[i] = new JTextField();
        this.spacingRule[i].setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5 + i * 2;
        gbc.insets = new Insets(1, 0, 4, 2);
        this.metal.add((Component)this.spacingRule[i], gbc);
    }

    private void addMetal() {
        ++this.numMetals;
        JLabel[] newWidthLabel = new JLabel[this.numMetals];
        JTextField[] newWidth = new JTextField[this.numMetals];
        JTextField[] newWidthRule = new JTextField[this.numMetals];
        JLabel[] newSpacingLabel = new JLabel[this.numMetals];
        JTextField[] newSpacing = new JTextField[this.numMetals];
        JTextField[] newSpacingRule = new JTextField[this.numMetals];
        System.arraycopy(this.width, 0, newWidth, 0, this.numMetals - 1);
        System.arraycopy(this.widthLabel, 0, newWidthLabel, 0, this.numMetals - 1);
        System.arraycopy(this.widthRule, 0, newWidthRule, 0, this.numMetals - 1);
        System.arraycopy(this.spacingLabel, 0, newSpacingLabel, 0, this.numMetals - 1);
        System.arraycopy(this.spacing, 0, newSpacing, 0, this.numMetals - 1);
        System.arraycopy(this.spacingRule, 0, newSpacingRule, 0, this.numMetals - 1);
        this.widthLabel = newWidthLabel;
        this.width = newWidth;
        this.widthRule = newWidthRule;
        this.spacingLabel = newSpacingLabel;
        this.spacing = newSpacing;
        this.spacingRule = newSpacingRule;
        this.addMetalLayer(this.numMetals - 1);
        this.parent.pack();
    }

    private void removeMetal() {
        if (this.numMetals <= 1) {
            Job.getUserInterface().showErrorMessage("Cannot delete the last metal layer: must be at least one", "Illegal Operation");
            return;
        }
        --this.numMetals;
        this.metal.remove(this.widthLabel[this.numMetals]);
        this.metal.remove(this.width[this.numMetals]);
        this.metal.remove(this.widthRule[this.numMetals]);
        this.metal.remove(this.spacingLabel[this.numMetals]);
        this.metal.remove(this.spacing[this.numMetals]);
        this.metal.remove(this.spacingRule[this.numMetals]);
        this.parent.pack();
    }

    public void term() {
        TechEditWizardData data = this.wizard.getTechEditData();
        data.setNumMetalLayers(this.numMetals);
        for (int i = 0; i < this.numMetals; ++i) {
            data.setMetalWidth(i, new WizardField(TextUtils.atof(this.width[i].getText()), this.widthRule[i].getText()));
            data.setMetalSpacing(i, new WizardField(TextUtils.atof(this.spacing[i].getText()), this.spacingRule[i].getText()));
        }
    }
}

