/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Applicon860;
import com.sun.electric.tool.io.input.CIF;
import com.sun.electric.tool.io.input.DEF;
import com.sun.electric.tool.io.input.DXF;
import com.sun.electric.tool.io.input.EDIF;
import com.sun.electric.tool.io.input.GDS;
import com.sun.electric.tool.io.input.LEF;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.io.input.Spice;
import com.sun.electric.tool.io.input.Sue;
import com.sun.electric.tool.io.input.verilog.VerilogReader;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Input {
    protected static final int READ_BUFFER_SIZE = 65536;
    public static ErrorLogger errorLogger;
    private static boolean doChangesQuietly;
    private static boolean newLibraryCreated;
    protected String filePath;
    protected InputStream inputStream;
    protected LineNumberReader lineReader;
    protected DataInputStream dataInputStream;
    protected long fileLength;
    protected long byteCount;
    protected EditingPreferences ep = EditingPreferences.getThreadEditingPreferences();
    private String lineBuffer;
    private int lineBufferPosition;

    public static boolean isNewLibraryCreated() {
        return newLibraryCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library importLibrary(InputPreferences prefs, URL fileURL, FileType type, Library lib, Technology tech, Map<Library, Cell> currentCells, Job job) {
        if (fileURL == null) {
            return null;
        }
        StringBuffer errmsg = new StringBuffer();
        if (!TextUtils.URLExists(fileURL, errmsg)) {
            System.out.print(errmsg.toString());
            return null;
        }
        boolean bl = newLibraryCreated = lib == null;
        if (lib == null && type != FileType.EDIF) {
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            lib = Library.newInstance(libName, fileURL);
        }
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("File Import");
        File f = new File(fileURL.getPath());
        if (f != null && f.exists()) {
            LibDirs.readLibDirs(f.getParent());
        }
        try {
            Input.startProgressDialog("import", fileURL.getFile());
            if (prefs != null) {
                lib = prefs.doInput(fileURL, lib, tech, currentCells, job);
            }
        }
        finally {
            Input.stopProgressDialog();
            errorLogger.termLogging(true);
        }
        if (lib == null) {
            System.out.println("Error importing " + fileURL.getFile() + " as " + type + " format.");
        } else {
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
        }
        return lib;
    }

    public static InputPreferences getInputPreferences(FileType type, boolean factory) {
        if (!factory && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Current default Prefs can be accessed only from client thread");
        }
        if (type == FileType.APPLICON860) {
            return new Applicon860.Applicon860Preferences(factory);
        }
        if (type == FileType.CIF) {
            return new CIF.CIFPreferences(factory);
        }
        if (type == FileType.DAIS) {
            return new IOTool.DaisPreferences(factory, Input.isNewLibraryCreated());
        }
        if (type == FileType.DEF) {
            return new DEF.DEFPreferences(factory);
        }
        if (type == FileType.DXF) {
            return new DXF.DXFPreferences(factory);
        }
        if (type == FileType.EDIF) {
            return new EDIF.EDIFPreferences(factory);
        }
        if (type == FileType.GDS) {
            return new GDS.GDSPreferences(factory);
        }
        if (type == FileType.LEF) {
            return new LEF.LEFPreferences(factory);
        }
        if (type == FileType.SPICE) {
            return new Spice.SpicePreferences(factory);
        }
        if (type == FileType.SUE) {
            return new Sue.SuePreferences(factory);
        }
        if (type == FileType.VERILOG) {
            return new VerilogReader.VerilogPreferences(factory);
        }
        return null;
    }

    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        return lib;
    }

    protected boolean openBinaryInput(URL fileURL) {
        this.filePath = fileURL.getFile();
        try {
            URLConnection urlCon = fileURL.openConnection();
            String contentLength = urlCon.getHeaderField("content-length");
            this.fileLength = -1L;
            try {
                this.fileLength = Long.parseLong(contentLength);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.inputStream = urlCon.getInputStream();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + this.filePath);
            return true;
        }
        this.byteCount = 0L;
        BufferedInputStream bufStrm = new BufferedInputStream(this.inputStream, 65536);
        this.dataInputStream = new DataInputStream(bufStrm);
        return false;
    }

    protected boolean openStringsInput(String[] lines) {
        StringBuffer buffer = new StringBuffer();
        try {
            for (String l : lines) {
                String s = l + "\n";
                buffer.append(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileLength = lines.length;
        StringReader reader = new StringReader(buffer.toString());
        this.lineReader = new LineNumberReader(reader);
        return false;
    }

    protected boolean openTextInput(URL fileURL) {
        if (this.openBinaryInput(fileURL)) {
            return true;
        }
        InputStreamReader is = new InputStreamReader(this.inputStream);
        this.lineReader = new LineNumberReader(is);
        return false;
    }

    protected static void setProgressNote(String msg) {
        Job.getUserInterface().setProgressNote(msg);
    }

    protected static String getProgressNote() {
        return Job.getUserInterface().getProgressNote();
    }

    protected static void startProgressDialog(String type, String filePath) {
        Job.getUserInterface().startProgressDialog(type, filePath);
    }

    protected static void stopProgressDialog() {
        Job.getUserInterface().stopProgressDialog();
    }

    protected static void setProgressValue(int value) {
        Job.getUserInterface().setProgressValue(value);
    }

    protected void updateProgressDialog(int bytesRead) {
        this.byteCount += (long)bytesRead;
        if (this.fileLength == 0L) {
            return;
        }
        long pct = this.byteCount * 100L / this.fileLength;
        UserInterface ui = Job.getUserInterface();
        if (ui != null) {
            ui.setProgressValue((int)pct);
        }
    }

    protected void closeInput() {
        try {
            this.dataInputStream = null;
            if (this.lineReader != null) {
                this.lineReader.close();
                this.lineReader = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.lineReader.read()) == -1) {
                return null;
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected String getLineFromBinary() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.dataInputStream.read()) == -1) {
                return null;
            }
            if (c == 10 || c == 13) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected void initKeywordParsing() {
        this.lineBufferPosition = 0;
        this.lineBuffer = "";
    }

    protected String getRestOfLine() throws IOException {
        int next = this.lineBufferPosition + 1;
        String rest = next < this.lineBuffer.length() ? this.lineBuffer.substring(next, this.lineBuffer.length()) : "";
        this.lineBufferPosition = this.lineBuffer.length();
        this.readNewLine();
        return rest;
    }

    private void readNewLine() throws IOException {
        this.lineBuffer = this.lineReader.readLine();
        if (this.lineBuffer != null) {
            this.updateProgressDialog(this.lineBuffer.length());
            this.lineBuffer = this.preprocessLine(this.lineBuffer);
        }
        this.lineBufferPosition = 0;
    }

    protected String readWholeLine() throws IOException {
        this.readNewLine();
        return this.lineBuffer;
    }

    protected String getAKeyword() throws IOException {
        while (true) {
            char chr;
            if (this.lineBuffer == null) {
                return null;
            }
            if (this.lineBufferPosition >= this.lineBuffer.length()) {
                this.readNewLine();
                continue;
            }
            while (this.lineBufferPosition < this.lineBuffer.length() && ((chr = this.lineBuffer.charAt(this.lineBufferPosition)) == ' ' || chr == '\t')) {
                ++this.lineBufferPosition;
            }
            if (this.lineBufferPosition < this.lineBuffer.length()) break;
        }
        int start = this.lineBufferPosition;
        char chr = this.lineBuffer.charAt(this.lineBufferPosition);
        if (this.isBreakCharacter(chr)) {
            ++this.lineBufferPosition;
            return Character.toString(chr);
        }
        while (this.lineBufferPosition < this.lineBuffer.length() && (chr = this.lineBuffer.charAt(this.lineBufferPosition)) != ' ' && chr != '\t' && !this.isBreakCharacter(chr)) {
            ++this.lineBufferPosition;
        }
        return this.lineBuffer.substring(start, this.lineBufferPosition);
    }

    protected boolean isBreakCharacter(char chr) {
        return false;
    }

    protected String preprocessLine(String line) {
        return line;
    }

    public static boolean isChangeQuiet() {
        return doChangesQuietly;
    }

    public static boolean changesQuiet(boolean quiet) {
        Layout.changesQuiet(quiet);
        boolean formerQuiet = doChangesQuietly;
        doChangesQuietly = quiet;
        return formerQuiet;
    }

    protected boolean eofDuring(String when) {
        System.out.println("File " + this.filePath + ", line " + this.lineReader.getLineNumber() + ": End of file while reading " + when);
        return false;
    }

    static {
        doChangesQuietly = false;
        newLibraryCreated = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class InputPreferences
    implements Serializable {
        protected InputPreferences(boolean factory) {
            if (!factory && !SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("Current default Prefs can be accessed only from client thread");
            }
        }

        public void initFromUserDefaults() {
        }

        public abstract Library doInput(URL var1, Library var2, Technology var3, Map<Library, Cell> var4, Job var5);
    }
}

