/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClickZoomWireListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener {
    private static Preferences prefs = Preferences.userNodeForPackage(ClickZoomWireListener.class);
    private static long cancelMoveDelayMillis;
    private static long zoomInDelayMillis;
    private static boolean useFatWiringMode;
    private static boolean interactiveDRCDrag;
    private static final boolean debug = false;
    public static ClickZoomWireListener theOne;
    private int clickX;
    private int clickY;
    private int lastX;
    private int lastY;
    private Cell startCell;
    private double dbMoveStartX;
    private double dbMoveStartY;
    private double lastdbMouseX;
    private double lastdbMouseY;
    private Mode modeLeft = Mode.none;
    private Mode modeRight = Mode.none;
    private boolean specialSelect = false;
    private boolean invertSelection = false;
    private boolean another;
    private long leftMousePressedTimeStamp;
    private long rightMousePressedTimeStamp;
    private ElectricObject wiringTarget;
    private InteractiveRouter router = new SimpleWirer();
    private ElectricObject startObj;
    private ElectricObject endObj;
    private ArcProto currentArcWhenWiringPressed;
    private int mouseX;
    private int mouseY;
    private Highlight2 moveDelta;
    private Highlight2 moveDRC;
    private EventListener oldListener;
    private static final boolean isMac;
    private static final String cancelMoveDelayMillisPref = "cancelMoveDelayMillis";
    private static final String zoomInDelayMillisPref = "zoomInDelayMillis";
    private static final String useFatWiringModePref = "UseFatWiringMode";

    private ClickZoomWireListener() {
        this.router.setTool(User.getUserTool());
        ClickZoomWireListener.readPrefs();
    }

    public void setSpecialSelect() {
        this.specialSelect = true;
    }

    public void clearSpecialSelect() {
        this.specialSelect = false;
    }

    public boolean getStickyMove() {
        return false;
    }

    public void setRouter(InteractiveRouter router) {
        this.router = router;
    }

    public boolean getStickyWiring() {
        return true;
    }

    public Point2D getLastMouse() {
        return new Point2D.Double(this.mouseX, this.mouseY);
    }

    public void zoomBoxSingleShot(EventListener oldListener) {
        this.modeRight = Mode.zoomBoxSingleShot;
        this.modeLeft = Mode.zoomBoxSingleShot;
        this.oldListener = oldListener;
    }

    private boolean isLeftMouse(MouseEvent evt) {
        return isMac ? !evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16 : (evt.getModifiers() & 0x10) == 16;
    }

    public static boolean isRightMouse(InputEvent evt) {
        if (isMac) {
            if (evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16) {
                return true;
            }
            if ((evt.getModifiers() & 4) == 4) {
                return true;
            }
        } else if ((evt.getModifiers() & 4) == 4) {
            return true;
        }
        return false;
    }

    public static boolean isMiddleMouse(InputEvent evt) {
        return (evt.getModifiers() & 8) == 8;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            this.startCell = wnd.getCell();
            if (this.startCell == null) {
                return;
            }
            this.clickX = evt.getX();
            this.clickY = evt.getY();
            Point2D dbClick = wnd.screenToDatabase(this.clickX, this.clickY);
            this.lastdbMouseX = dbClick.getX();
            this.lastdbMouseY = dbClick.getY();
            boolean ctrlPressed = (evt.getModifiersEx() & 0x80) != 0;
            this.invertSelection = (evt.getModifiersEx() & 0x40) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.rightMousePressedTimeStamp = currentTime;
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    return;
                }
                if (!this.invertSelection) {
                    ElectricObject eobj1;
                    Highlight2 h1;
                    ArrayList<Highlight2> highlights = new ArrayList<Highlight2>();
                    for (Highlight2 h : highlighter.getHighlights()) {
                        ElectricObject eobj;
                        if (!h.isHighlightEOBJ() || !((eobj = h.getElectricObject()) instanceof PortInst) && !(eobj instanceof NodeInst) && !(eobj instanceof ArcInst)) continue;
                        highlights.add(h);
                    }
                    Iterator hIt = highlights.iterator();
                    if (highlights.size() == 2) {
                        h1 = (Highlight2)hIt.next();
                        Highlight2 h2 = (Highlight2)hIt.next();
                        ElectricObject eobj12 = h1.getElectricObject();
                        ElectricObject eobj2 = h2.getElectricObject();
                        if (eobj12 != null && eobj2 != null) {
                            this.modeRight = Mode.wiringConnect;
                            this.wiringTarget = null;
                            this.startObj = h1.getElectricObject();
                            this.endObj = h2.getElectricObject();
                            this.currentArcWhenWiringPressed = User.getUserTool().getCurrentArcProto();
                            EditWindow.gridAlign(dbClick);
                            this.router.highlightRoute(wnd, this.startCell, h1.getElectricObject(), h2.getElectricObject(), dbClick);
                            return;
                        }
                    }
                    if (highlights.size() == 1 && (eobj1 = (h1 = (Highlight2)hIt.next()).getElectricObject()) != null) {
                        this.modeRight = Mode.wiringFind;
                        this.endObj = null;
                        this.wiringTarget = null;
                        this.startObj = h1.getElectricObject();
                        this.router.startInteractiveRoute(wnd);
                        Highlight2 h2 = null;
                        if (!ctrlPressed) {
                            h2 = highlighter.findObject(dbClick, wnd, false, false, false, true, false, this.specialSelect, false);
                        }
                        if (h2 == null) {
                            this.endObj = null;
                            this.wiringTarget = null;
                        } else {
                            this.endObj = h2.getElectricObject();
                        }
                        this.currentArcWhenWiringPressed = User.getUserTool().getCurrentArcProto();
                        EditWindow.gridAlign(dbClick);
                        this.router.highlightRoute(wnd, this.startCell, h1.getElectricObject(), this.endObj, dbClick);
                        return;
                    }
                    System.out.println("Must start new arc from one node or arc; or wire two node/arcs together");
                    this.modeRight = Mode.none;
                    return;
                }
                wnd.setStartDrag(this.clickX, this.clickY);
                wnd.setEndDrag(this.clickX, this.clickY);
                wnd.setDoingAreaDrag();
                if (this.invertSelection && !ctrlPressed) {
                    this.modeRight = Mode.zoomOut;
                }
                if (ctrlPressed && this.invertSelection) {
                    highlighter.clear();
                    this.modeRight = Mode.drawBox;
                }
                return;
            }
            if (this.isLeftMouse(evt)) {
                if (this.modeLeft == Mode.zoomBoxSingleShot) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    return;
                }
                if (this.modeLeft == Mode.stickyMove) {
                    if (ctrlPressed) {
                        dbClick = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbClick, highlighter);
                    }
                    Point2D.Double dbDelta = new Point2D.Double(dbClick.getX() - this.dbMoveStartX, dbClick.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                        highlighter.setHighlightOffset(0, 0);
                        CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                        wnd.fullRepaint();
                    }
                    this.modeLeft = Mode.none;
                    return;
                }
                this.leftMousePressedTimeStamp = evt.getWhen();
                if (evt.getClickCount() == 2 && !ctrlPressed && !this.invertSelection && highlighter.getNumHighlights() >= 1) {
                    EditMenu.getInfoCommand(true);
                    return;
                }
                if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    highlighter.clear();
                    this.modeLeft = Mode.drawBox;
                    return;
                }
                if (!ctrlPressed && !this.invertSelection && highlighter.overHighlighted(wnd, this.clickX, this.clickY) != null) {
                    highlighter.finished();
                    this.dbMoveStartX = dbClick.getX();
                    this.dbMoveStartY = dbClick.getY();
                    this.moveDRC = null;
                    this.moveDelta = null;
                    this.modeLeft = Mode.move;
                } else {
                    Highlight2 h = highlighter.findObject(dbClick, wnd, false, ctrlPressed, this.invertSelection, true, false, this.specialSelect, true);
                    if (h == null) {
                        wnd.setStartDrag(this.clickX, this.clickY);
                        wnd.setEndDrag(this.clickX, this.clickY);
                        wnd.setDoingAreaDrag();
                        this.modeLeft = Mode.selectBox;
                    } else {
                        this.dbMoveStartX = dbClick.getX();
                        this.dbMoveStartY = dbClick.getY();
                        this.moveDRC = null;
                        this.moveDelta = null;
                        this.modeLeft = Mode.move;
                    }
                    this.mouseOver(dbClick, wnd);
                }
                return;
            }
            if (ClickZoomWireListener.isMiddleMouse(evt)) {
                this.lastX = evt.getX();
                this.lastY = evt.getY();
                return;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            int mouseX = evt.getX();
            int mouseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(mouseX, mouseY);
            this.lastdbMouseX = (int)dbMouse.getX();
            this.lastdbMouseY = (int)dbMouse.getY();
            boolean ctrlPressed = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    if (!wnd.isDoingAreaDrag()) {
                        wnd.setStartDrag(mouseX, mouseY);
                        wnd.setEndDrag(mouseX, mouseY);
                        wnd.setDoingAreaDrag();
                    }
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.zoomOut && currentTime - this.rightMousePressedTimeStamp > zoomInDelayMillis) {
                    this.modeRight = Mode.zoomBox;
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox) {
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    Highlight2 h3 = null;
                    if (!ctrlPressed) {
                        h3 = highlighter.findObject(dbMouse, wnd, false, false, false, true, false, this.specialSelect, false);
                    }
                    if (h3 == null) {
                        EditWindow.gridAlign(dbMouse);
                        this.endObj = null;
                        this.wiringTarget = null;
                    } else {
                        Iterator<Highlight2> hIt;
                        this.endObj = null;
                        if (this.wiringTarget != null) {
                            EditWindow.gridAlign(dbMouse);
                            List<Highlight2> underCursor = Highlighter.findAllInArea(highlighter, cell, false, true, true, false, this.specialSelect, false, new Rectangle2D.Double(dbMouse.getX(), dbMouse.getY(), 0.0, 0.0), wnd);
                            for (Highlight2 h : underCursor) {
                                ElectricObject eobj = h.getElectricObject();
                                if (eobj != this.wiringTarget) continue;
                                this.endObj = this.wiringTarget;
                                break;
                            }
                            if (this.endObj == null) {
                                this.wiringTarget = null;
                            }
                        }
                        if (this.endObj == null && (hIt = highlighter.getHighlights().iterator()).hasNext()) {
                            Highlight2 h2 = hIt.next();
                            this.endObj = h2.getElectricObject();
                        }
                        EditWindow.gridAlign(dbMouse);
                    }
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, null, dbMouse);
                }
            }
            if (this.isLeftMouse(evt)) {
                if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.zoomBoxSingleShot) {
                    wnd.setEndDrag(mouseX, mouseY);
                    wnd.repaint();
                }
                if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                    if (ctrlPressed) {
                        dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse, highlighter);
                    }
                    Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    Point screenDelta = wnd.deltaDatabaseToScreen(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                    highlighter.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                    WorstSpacing ws = new WorstSpacing();
                    List<Geometric> selected = highlighter.getHighlightedEObjs(true, true);
                    if (interactiveDRCDrag && selected.size() == 1) {
                        int i;
                        Poly[] polys;
                        Geometric g = selected.get(0);
                        Netlist nl = g.getParent().acquireUserNetlist();
                        if (g instanceof ArcInst) {
                            ArcInst ai = (ArcInst)g;
                            Network net = nl.getNetwork(ai, 0);
                            if (net != null) {
                                polys = ai.getProto().getTechnology().getShapeOfArc(ai);
                                for (i = 0; i < polys.length; ++i) {
                                    ws.findWorstSpacing(g, polys[i], net, dbDelta, nl);
                                }
                            }
                        } else {
                            NodeInst ni = (NodeInst)g;
                            if (!ni.isCellInstance()) {
                                AffineTransform trans = ni.rotateOut();
                                polys = ni.getProto().getTechnology().getShapeOfNode(ni, true, true, null);
                                for (i = 0; i < polys.length; ++i) {
                                    Network net;
                                    PortInst pi;
                                    PortProto pp = polys[i].getPort();
                                    if (pp == null || (pi = ni.findPortInstFromProto(pp)) == null || (net = nl.getNetwork(pi)) == null) continue;
                                    polys[i].transform(trans);
                                    ws.findWorstSpacing(g, polys[i], net, dbDelta, nl);
                                }
                            }
                        }
                    }
                    if (this.moveDelta != null) {
                        highlighter.remove(this.moveDelta);
                    }
                    if (this.moveDRC != null) {
                        highlighter.remove(this.moveDRC);
                    }
                    Technology tech = wnd.getCell().getTechnology();
                    String deltaMessage = "Moved (" + TextUtils.formatDistance(((Point2D)dbDelta).getX(), tech) + "," + TextUtils.formatDistance(((Point2D)dbDelta).getY(), tech) + ")";
                    WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                    StatusBar.setCoordinates(deltaMessage, wf);
                    if (ws.validSpacing()) {
                        Poly hPoly;
                        Geometric g;
                        boolean tooClose = ws.getSeparation() < ws.getMinSpacing();
                        String message = ws.getOneLayer().getName();
                        if (ws.getOneLayer() != ws.getOtherLayer()) {
                            message = message + " to " + ws.getOtherLayer().getName();
                        }
                        message = message + " spacing is " + TextUtils.formatDistance(ws.getSeparation(), tech);
                        if (tooClose) {
                            message = "ERROR! " + message + " MINIMUM IS " + TextUtils.formatDistance(ws.getMinSpacing(), tech);
                        }
                        if ((g = selected.get(0)) instanceof NodeInst) {
                            hPoly = Highlight2.getNodeInstOutline((NodeInst)g);
                        } else {
                            ArcInst ai = (ArcInst)g;
                            hPoly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
                        }
                        double minX = 0.0;
                        double maxY = 0.0;
                        Point2D[] points = hPoly.getPoints();
                        for (int i = 0; i < points.length; ++i) {
                            if (i == 0 || points[i].getX() < minX) {
                                minX = points[i].getX();
                            }
                            if (i != 0 && !(points[i].getY() > maxY)) continue;
                            maxY = points[i].getY();
                        }
                        this.moveDelta = highlighter.addMessage(cell, message, new Point2D.Double(minX + ((Point2D)dbDelta).getX(), maxY + ((Point2D)dbDelta).getY()));
                        Point2D.Double end1 = new Point2D.Double(ws.getOnePoint().getX() - ((Point2D)dbDelta).getX(), ws.getOnePoint().getY() - ((Point2D)dbDelta).getY());
                        Point2D.Double end2 = new Point2D.Double(ws.getOtherPoint().getX() - ((Point2D)dbDelta).getX(), ws.getOtherPoint().getY() - ((Point2D)dbDelta).getY());
                        this.moveDRC = highlighter.addLine(end1, end2, cell, tooClose);
                    }
                    wnd.repaint();
                }
            }
            if (ClickZoomWireListener.isMiddleMouse(evt)) {
                int newX = evt.getX();
                int newY = evt.getY();
                Point2D pt = wnd.getScheduledOffset();
                double scale = wnd.getScale();
                wnd.setOffset(new Point2D.Double(pt.getX() - (double)(newX - this.lastX) / scale, pt.getY() + (double)(newY - this.lastY) / scale));
                wnd.getSavedFocusBrowser().updateCurrentFocus();
                wnd.fullRepaint();
                this.lastX = newX;
                this.lastY = newY;
                return;
            }
            wnd.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            if (cell != this.startCell) {
                this.escapePressed(wnd);
                return;
            }
            int releaseX = evt.getX();
            int releaseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(releaseX, releaseY);
            boolean ctrlPressed = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                double scale;
                if (this.modeRight == Mode.zoomIn) {
                    scale = wnd.getScale();
                    wnd.setScale(scale * 2.0);
                    wnd.clearDoingAreaDrag();
                    wnd.getSavedFocusBrowser().saveCurrentFocus();
                    wnd.fullRepaint();
                }
                if (this.modeRight == Mode.zoomOut) {
                    scale = wnd.getScale();
                    wnd.setScale(scale / 2.0);
                    if (wnd.isInPlaceEdit()) {
                        wnd.getInPlaceTransformOut().transform(dbMouse, dbMouse);
                    }
                    wnd.setOffset(dbMouse);
                    wnd.clearDoingAreaDrag();
                    wnd.getSavedFocusBrowser().saveCurrentFocus();
                    wnd.fullRepaint();
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox || this.modeRight == Mode.zoomBoxSingleShot) {
                    Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                    Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                    double minSelX = Math.min(start.getX(), end.getX());
                    double maxSelX = Math.max(start.getX(), end.getX());
                    double minSelY = Math.min(start.getY(), end.getY());
                    double maxSelY = Math.max(start.getY(), end.getY());
                    boolean onePoint = true;
                    Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                    if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                        onePoint = false;
                    }
                    if (Math.abs(wnd.getStartDrag().getX() - wnd.getEndDrag().getX()) > 10.0 || Math.abs(wnd.getStartDrag().getY() - wnd.getEndDrag().getY()) > 10.0) {
                        onePoint = false;
                    }
                    if (this.modeRight == Mode.drawBox) {
                        highlighter.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
                    }
                    if (this.modeRight == Mode.zoomBoxSingleShot) {
                        if (!onePoint) {
                            wnd.focusScreen(bounds);
                        }
                        WindowFrame.setListener(this.oldListener);
                        if (this.modeLeft == Mode.zoomBoxSingleShot) {
                            this.modeLeft = Mode.none;
                        }
                    }
                    if (this.modeRight == Mode.zoomBox) {
                        if (onePoint) {
                            double scale2 = wnd.getScale();
                            wnd.setScale(scale2 / 2.0);
                            wnd.clearDoingAreaDrag();
                            wnd.getSavedFocusBrowser().saveCurrentFocus();
                            wnd.fullRepaint();
                        } else {
                            wnd.focusScreen(bounds);
                        }
                    }
                    highlighter.finished();
                    wnd.clearDoingAreaDrag();
                    wnd.repaint();
                }
                if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, null, dbMouse);
                    this.wiringTarget = null;
                }
                this.modeRight = Mode.none;
            }
            if (this.isLeftMouse(evt)) {
                long curTime = evt.getWhen();
                if ((this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) && curTime - this.leftMousePressedTimeStamp < cancelMoveDelayMillis) {
                    highlighter.setHighlightOffset(0, 0);
                    this.modeLeft = Mode.none;
                    if (this.moveDelta != null) {
                        highlighter.remove(this.moveDelta);
                    }
                    if (this.moveDRC != null) {
                        highlighter.remove(this.moveDRC);
                    }
                    wnd.repaint();
                    return;
                }
                if (this.getStickyMove() && this.modeLeft == Mode.move) {
                    this.modeLeft = Mode.stickyMove;
                } else {
                    if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.zoomBoxSingleShot) {
                        Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                        Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                        double minSelX = Math.min(start.getX(), end.getX());
                        double maxSelX = Math.max(start.getX(), end.getX());
                        double minSelY = Math.min(start.getY(), end.getY());
                        double maxSelY = Math.max(start.getY(), end.getY());
                        boolean onePoint = true;
                        Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                        if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                            onePoint = false;
                        }
                        if (Math.abs(wnd.getStartDrag().getX() - wnd.getEndDrag().getX()) > 10.0 || Math.abs(wnd.getStartDrag().getY() - wnd.getEndDrag().getY()) > 10.0) {
                            onePoint = false;
                        }
                        if (this.modeLeft == Mode.selectBox) {
                            if (!this.invertSelection) {
                                highlighter.clear();
                            }
                            highlighter.selectArea(wnd, minSelX, maxSelX, minSelY, maxSelY, this.invertSelection, this.specialSelect);
                        }
                        if (this.modeLeft == Mode.drawBox) {
                            highlighter.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
                        }
                        if (this.modeLeft == Mode.zoomBoxSingleShot) {
                            if (!onePoint) {
                                wnd.focusScreen(bounds);
                            }
                            WindowFrame.setListener(this.oldListener);
                            if (this.modeRight == Mode.zoomBoxSingleShot) {
                                this.modeRight = Mode.none;
                            }
                        }
                        highlighter.finished();
                        wnd.clearDoingAreaDrag();
                        wnd.repaint();
                    }
                    if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                        if (ctrlPressed) {
                            dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse, highlighter);
                        }
                        Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                        EditWindow.gridAlign(dbDelta);
                        if (this.moveDelta != null) {
                            highlighter.remove(this.moveDelta);
                        }
                        if (this.moveDRC != null) {
                            highlighter.remove(this.moveDRC);
                        }
                        if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                            highlighter.setHighlightOffset(0, 0);
                            CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                            wnd.fullRepaint();
                        }
                    }
                    this.modeLeft = Mode.none;
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            this.specialSelect = ToolBar.isSelectSpecial();
            Point2D dbMouse = wnd.screenToDatabase(this.mouseX, this.mouseY);
            if (this.modeLeft == Mode.stickyMove) {
                if (this.another) {
                    dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse, highlighter);
                }
                Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                EditWindow.gridAlign(dbDelta);
                Point screenDelta = wnd.deltaDatabaseToScreen((int)((Point2D)dbDelta).getX(), (int)((Point2D)dbDelta).getY());
                highlighter.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                wnd.repaint();
            }
            this.mouseOver(dbMouse, wnd);
        }
    }

    private void mouseOver(Point2D dbMouse, EditWindow wnd) {
        if (!User.isMouseOverHighlightingEnabled()) {
            return;
        }
        if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Highlighter mouseOverHighlighter = wnd.getMouseOverHighlighter();
        Highlighter tempHighlighter = new Highlighter(1, null);
        tempHighlighter.copyState(highlighter);
        Point screenMouse = wnd.databaseToScreen(dbMouse);
        Highlight2 found = null;
        if (!this.another && !this.invertSelection) {
            found = tempHighlighter.overHighlighted(wnd, (int)((Point2D)screenMouse).getX(), (int)((Point2D)screenMouse).getY());
        }
        if (found == null) {
            found = tempHighlighter.findObject(dbMouse, wnd, false, this.another, this.invertSelection, true, false, this.specialSelect, true);
        }
        tempHighlighter.clear();
        if (found != null) {
            tempHighlighter.addHighlight(found);
        }
        boolean changed = false;
        List<Highlight2> mouseOld = mouseOverHighlighter.getHighlights();
        List<Highlight2> mouseNew = tempHighlighter.getHighlights();
        if (mouseOld.size() == mouseNew.size()) {
            for (int i = 0; i < mouseOld.size(); ++i) {
                Highlight2 h2;
                Highlight2 h1 = mouseOld.get(i);
                if (h1.equals(h2 = mouseNew.get(i))) continue;
                changed = true;
                break;
            }
        } else {
            changed = true;
        }
        if (changed) {
            mouseOverHighlighter.copyState(tempHighlighter);
            mouseOverHighlighter.finished();
            wnd.repaint();
        }
        tempHighlighter.delete();
        tempHighlighter = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)e.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            wnd.getWindowFrame().getFrame().getStatusBar().highlightChanged(highlighter);
            WindowFrame.show3DHighlight();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean sideways = (evt.getModifiersEx() & 0x40) != 0;
            boolean sideways2 = (evt.getModifiersEx() & 0x80) != 0;
            int rotation = evt.getWheelRotation();
            if (sideways || sideways2) {
                ZoomAndPanListener.panXOrY(0, wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            } else {
                ZoomAndPanListener.panXOrY(1, wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean redrawMouseOver = false;
            if (chr == 27) {
                this.escapePressed(wnd);
            } else if (chr == 17) {
                if (!this.another) {
                    redrawMouseOver = true;
                }
                this.another = true;
            } else if (chr == 16) {
                if (!this.invertSelection) {
                    redrawMouseOver = true;
                }
                this.invertSelection = true;
            }
            if (redrawMouseOver) {
                this.mouseOver(wnd.screenToDatabase(this.mouseX, this.mouseY), wnd);
            }
        }
    }

    private void escapePressed(EditWindow wnd) {
        Highlighter highlighter = wnd.getHighlighter();
        if (this.modeRight == Mode.wiringConnect || this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
            this.router.cancelInteractiveRoute();
        }
        if (this.modeRight == Mode.zoomBox || this.modeRight == Mode.zoomBoxSingleShot || this.modeRight == Mode.zoomOut || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.selectBox) {
            wnd.clearDoingAreaDrag();
        }
        this.modeLeft = Mode.none;
        this.modeRight = Mode.none;
        highlighter.setHighlightOffset(0, 0);
        wnd.repaint();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean redrawMouseOver = false;
            if (chr == 17) {
                if (this.another) {
                    redrawMouseOver = true;
                }
                this.another = false;
            } else if (chr == 16) {
                if (this.invertSelection) {
                    redrawMouseOver = true;
                }
                this.invertSelection = false;
            }
            if (redrawMouseOver) {
                this.mouseOver(wnd.screenToDatabase(this.mouseX, this.mouseY), wnd);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    public static void moveSelected(double dX, double dY, boolean scaleMove, boolean scaleMove2) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Dimension2D arrowDistance = User.getAlignmentToGrid();
        dX *= arrowDistance.getWidth();
        dY *= arrowDistance.getHeight();
        int scaleX = User.getDefGridXBoldFrequency();
        int scaleY = User.getDefGridYBoldFrequency();
        if (scaleMove) {
            dX *= (double)scaleX;
            dY *= (double)scaleY;
        }
        if (scaleMove2) {
            dX *= (double)scaleX;
            dY *= (double)scaleY;
        }
        highlighter.setHighlightOffset(0, 0);
        if (wnd.isInPlaceEdit()) {
            Point2D.Double delta = new Point2D.Double(dX, dY);
            AffineTransform trans = wnd.getInPlaceTransformIn();
            double m00 = trans.getScaleX();
            double m01 = trans.getShearX();
            double m10 = trans.getShearY();
            double m11 = trans.getScaleY();
            AffineTransform justRot = new AffineTransform(m00, m10, m01, m11, 0.0, 0.0);
            justRot.transform(delta, delta);
            dX = ((Point2D)delta).getX();
            dY = ((Point2D)delta).getY();
        }
        CircuitChanges.manyMove(dX, dY);
        wnd.fullRepaint();
    }

    private static Point2D convertToOrthogonal(Point2D startPoint, Point2D mousePoint, Highlighter highlighter) {
        int orthoAngle = 90;
        List<Geometric> highObjs = highlighter.getHighlightedEObjs(true, true);
        for (Geometric geom : highObjs) {
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                Iterator<Connection> it = ni.getConnections();
                while (it.hasNext()) {
                    Connection con = it.next();
                    int thisAngle = ClickZoomWireListener.getAngleIncrement(con.getArc());
                    if (thisAngle >= orthoAngle) continue;
                    orthoAngle = thisAngle;
                }
                continue;
            }
            int thisAngle = ClickZoomWireListener.getAngleIncrement((ArcInst)geom);
            if (thisAngle >= orthoAngle) continue;
            orthoAngle = thisAngle;
        }
        if (orthoAngle == 0) {
            return mousePoint;
        }
        return InteractiveRouter.getClosestAngledPoint(startPoint, mousePoint, orthoAngle);
    }

    private static int getAngleIncrement(ArcInst ai) {
        int angle = ai.getAngle();
        if (angle % 900 == 0) {
            return 90;
        }
        if (angle % 450 == 0) {
            return 45;
        }
        if (angle % 300 == 0) {
            return 30;
        }
        return 90;
    }

    public void switchWiringTarget() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = wnd.getCell();
        if (this.modeRight == Mode.wiringToSpace) {
            this.modeRight = Mode.wiringFind;
        }
        if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
            Point2D.Double dbMouse = new Point2D.Double(this.lastdbMouseX, this.lastdbMouseY);
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.lastdbMouseX, this.lastdbMouseY, 0.0, 0.0);
            List<Highlight2> targets = Highlighter.findAllInArea(highlighter, wnd.getCell(), false, false, true, false, this.specialSelect, false, bounds, wnd);
            Iterator<Highlight2> it = targets.iterator();
            boolean found = false;
            if (this.wiringTarget == null) {
                this.wiringTarget = this.endObj;
            }
            while (it.hasNext()) {
                if (it.next().getElectricObject() != this.wiringTarget) continue;
                found = true;
                if (!it.hasNext()) {
                    this.modeRight = Mode.wiringToSpace;
                    this.wiringTarget = null;
                    break;
                }
                this.wiringTarget = it.next().getElectricObject();
                break;
            }
            if (!found) {
                it = targets.iterator();
                this.wiringTarget = it.hasNext() ? it.next().getElectricObject() : null;
            }
            if (this.modeRight == Mode.wiringToSpace) {
                this.endObj = null;
                System.out.println("Switching to 'ignore all wiring targets'");
                this.router.highlightRoute(wnd, cell, this.startObj, null, dbMouse);
                return;
            }
            if (this.endObj == this.wiringTarget) {
                return;
            }
            this.endObj = this.wiringTarget;
            if (this.wiringTarget == null) {
                System.out.println("Switching to wiring target 'none'");
            } else {
                System.out.println("Switching to wiring target '" + this.wiringTarget + "'");
            }
            this.router.highlightRoute(wnd, cell, this.startObj, this.wiringTarget, dbMouse);
        } else {
            this.setUseFatWiringMode(!this.getUseFatWiringMode());
            if (this.getUseFatWiringMode()) {
                System.out.println("Enabling fat wiring mode");
            } else {
                System.out.println("Disabling fat wiring mode");
            }
        }
    }

    public void wireTo(int layerNumber) {
        ElectricObject obj;
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        ArcProto ap = null;
        Technology tech = Technology.getCurrent();
        boolean found = false;
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ap = it.next();
            if (ap.isNotUsed()) continue;
            switch (layerNumber) {
                case 0: {
                    if (ap.getFunction() != ArcProto.Function.POLY1) break;
                    found = true;
                    break;
                }
                case 1: {
                    if (ap.getFunction() != ArcProto.Function.METAL1) break;
                    found = true;
                    break;
                }
                case 2: {
                    if (ap.getFunction() != ArcProto.Function.METAL2 && ap.getFunction() != ArcProto.Function.BUS) break;
                    found = true;
                    break;
                }
                case 3: {
                    if (ap.getFunction() != ArcProto.Function.METAL3) break;
                    found = true;
                    break;
                }
                case 4: {
                    if (ap.getFunction() != ArcProto.Function.METAL4) break;
                    found = true;
                    break;
                }
                case 5: {
                    if (ap.getFunction() != ArcProto.Function.METAL5) break;
                    found = true;
                    break;
                }
                case 6: {
                    if (ap.getFunction() != ArcProto.Function.METAL6) break;
                    found = true;
                    break;
                }
                case 7: {
                    if (ap.getFunction() != ArcProto.Function.METAL7) break;
                    found = true;
                    break;
                }
                case 8: {
                    if (ap.getFunction() != ArcProto.Function.METAL8) break;
                    found = true;
                    break;
                }
                case 9: {
                    if (ap.getFunction() != ArcProto.Function.METAL9) break;
                    found = true;
                }
            }
            if (!found) continue;
        }
        if (!found) {
            return;
        }
        if (highlighter.getNumHighlights() == 1 && cell != null && (obj = highlighter.getOneHighlight().getElectricObject()) instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            this.router.makeVerticalRoute(wnd, pi, ap);
        }
        User.getUserTool().setCurrentArcProto(ap);
    }

    public JPopupMenu selectPopupMenu(List<Highlight2> objects) {
        JPopupMenu popup = new JPopupMenu("Choose One");
        for (Highlight2 obj : objects) {
            JMenuItem m = new JMenuItem(obj.toString());
            m.addActionListener(this);
            popup.add(m);
        }
        return popup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public static void readPrefs() {
        cancelMoveDelayMillis = prefs.getLong(cancelMoveDelayMillisPref, ClickZoomWireListener.getFactoryCancelMoveDelayMillis());
        zoomInDelayMillis = prefs.getLong(zoomInDelayMillisPref, 120L);
        useFatWiringMode = prefs.getBoolean(useFatWiringModePref, true);
        interactiveDRCDrag = new DRC.DRCPreferences((boolean)false).interactiveDRCDrag;
    }

    public long getCancelMoveDelayMillis() {
        return cancelMoveDelayMillis;
    }

    public static long getFactoryCancelMoveDelayMillis() {
        return 200L;
    }

    public void setCancelMoveDelayMillis(long delay) {
        cancelMoveDelayMillis = delay;
        prefs.putLong(cancelMoveDelayMillisPref, delay);
    }

    public long getZoomInDelayMillis() {
        return zoomInDelayMillis;
    }

    public void setZoomInDelayMillis(long delay) {
        zoomInDelayMillis = delay;
        prefs.putLong(zoomInDelayMillisPref, delay);
    }

    public boolean getUseFatWiringMode() {
        return useFatWiringMode;
    }

    public void setUseFatWiringMode(boolean b) {
        useFatWiringMode = b;
        prefs.putBoolean(useFatWiringModePref, b);
    }

    static {
        theOne = new ClickZoomWireListener();
        isMac = Client.isOSMac();
    }

    private static class WorstSpacing {
        private boolean valid = false;
        private double separation;
        private double worstViolation;
        private double minSpacing;
        private Point2D worstFrom = new Point2D.Double(0.0, 0.0);
        private Point2D worstTo = new Point2D.Double(0.0, 0.0);
        private Layer layerFrom;
        private Layer layerTo;

        public boolean validSpacing() {
            return this.valid;
        }

        public double getSeparation() {
            return this.separation;
        }

        public double getMinSpacing() {
            return this.minSpacing;
        }

        public Layer getOneLayer() {
            return this.layerFrom;
        }

        public Layer getOtherLayer() {
            return this.layerTo;
        }

        public Point2D getOnePoint() {
            return this.worstFrom;
        }

        public Point2D getOtherPoint() {
            return this.worstTo;
        }

        public void findWorstSpacing(Geometric self, Poly poly, Network net, Point2D delta, Netlist nl) {
            Layer lay = poly.getLayer();
            if (lay == null) {
                return;
            }
            if (lay.isPseudoLayer()) {
                return;
            }
            if (lay.getFunction().isSubstrate()) {
                return;
            }
            Point2D[] points = poly.getPoints();
            for (int j = 0; j < points.length; ++j) {
                poly.setPoint(j, points[j].getX() + delta.getX(), points[j].getY() + delta.getY());
            }
            Rectangle2D bounds = poly.getBounds2D();
            double xS = bounds.getWidth();
            double yS = bounds.getHeight();
            double widRule = Math.min(xS, yS);
            double lenRule = Math.max(xS, yS);
            int multiCut = -1;
            double surround = DRC.getMaxSurround(lay, Double.MAX_VALUE);
            double worstInteractionDistance = surround * 5.0;
            Rectangle2D.Double searchBounds = new Rectangle2D.Double(bounds.getMinX() - worstInteractionDistance, bounds.getMinY() - worstInteractionDistance, bounds.getWidth() + worstInteractionDistance * 2.0, bounds.getHeight() + worstInteractionDistance * 2.0);
            Iterator<RTBounds> it = self.getParent().searchIterator(searchBounds);
            while (it.hasNext()) {
                Layer otherLay;
                Poly otherPoly;
                int i;
                Poly[] otherPolys;
                Geometric neighbor = (Geometric)it.next();
                if (neighbor == self) continue;
                if (neighbor instanceof NodeInst) {
                    NodeInst otherNi = (NodeInst)neighbor;
                    if (otherNi.isCellInstance()) continue;
                    AffineTransform trans = otherNi.rotateOut();
                    otherPolys = otherNi.getProto().getTechnology().getShapeOfNode(otherNi, true, true, null);
                    for (i = 0; i < otherPolys.length; ++i) {
                        DRCTemplate rule;
                        Network otherNet;
                        PortInst pi;
                        PortProto pp;
                        otherPoly = otherPolys[i];
                        otherLay = otherPoly.getLayer();
                        if (otherLay == null || otherLay.isPseudoLayer() || otherLay.getFunction().isSubstrate() || lay.getTechnology() != otherLay.getTechnology() || (pp = otherPoly.getPort()) == null || (pi = otherNi.findPortInstFromProto(pp)) == null || (otherNet = nl.getNetwork(pi)) == null || net == otherNet || (rule = DRC.getSpacingRule(lay, null, otherLay, null, false, multiCut, widRule, lenRule)) == null) continue;
                        double dist = rule.getValue(0);
                        otherPoly.transform(trans);
                        double sep = poly.separation(otherPoly);
                        if (this.valid && sep - dist >= this.worstViolation) continue;
                        this.valid = true;
                        this.worstViolation = sep - dist;
                        this.separation = sep;
                        this.minSpacing = dist;
                        this.layerFrom = lay;
                        this.layerTo = otherLay;
                        this.findClosestPoints(poly, otherPoly);
                    }
                    continue;
                }
                ArcInst otherAi = (ArcInst)neighbor;
                Network otherNet = nl.getNetwork(otherAi, 0);
                if (otherNet == null || net == otherNet) continue;
                otherPolys = otherAi.getProto().getTechnology().getShapeOfArc(otherAi);
                for (i = 0; i < otherPolys.length; ++i) {
                    DRCTemplate rule;
                    otherPoly = otherPolys[i];
                    otherLay = otherPoly.getLayer();
                    if (otherLay == null || otherLay.isPseudoLayer() || otherLay.getFunction().isSubstrate() || (rule = DRC.getSpacingRule(lay, null, otherLay, null, true, multiCut, widRule, lenRule)) == null) continue;
                    double dist = rule.getValue(0);
                    double sep = poly.separation(otherPoly);
                    if (this.valid && sep - dist >= this.worstViolation) continue;
                    this.valid = true;
                    this.worstViolation = sep - dist;
                    this.separation = sep;
                    this.minSpacing = dist;
                    this.layerFrom = lay;
                    this.layerTo = otherLay;
                    this.findClosestPoints(poly, otherPoly);
                }
            }
        }

        private void findClosestPoints(Poly from, Poly to) {
            double pd;
            Rectangle2D fromBox = from.getBox();
            Rectangle2D toBox = to.getBox();
            if (fromBox != null && toBox != null) {
                if (fromBox.getMinX() < toBox.getMaxX() && fromBox.getMaxX() > toBox.getMinX()) {
                    double xPos = (Math.max(fromBox.getMinX(), toBox.getMinX()) + Math.min(fromBox.getMaxX(), toBox.getMaxX())) / 2.0;
                    if (fromBox.getMinY() > toBox.getMaxY()) {
                        this.worstFrom.setLocation(xPos, fromBox.getMinY());
                        this.worstTo.setLocation(xPos, toBox.getMaxY());
                        return;
                    }
                    if (toBox.getMinY() > fromBox.getMaxY()) {
                        this.worstFrom.setLocation(xPos, fromBox.getMaxY());
                        this.worstTo.setLocation(xPos, toBox.getMinY());
                        return;
                    }
                    return;
                }
                if (fromBox.getMinY() < toBox.getMaxY() && fromBox.getMaxY() > toBox.getMinY()) {
                    double yPos = (Math.max(fromBox.getMinY(), toBox.getMinY()) + Math.min(fromBox.getMaxY(), toBox.getMaxY())) / 2.0;
                    if (fromBox.getMinX() > toBox.getMaxX()) {
                        this.worstFrom.setLocation(fromBox.getMinX(), yPos);
                        this.worstTo.setLocation(toBox.getMaxX(), yPos);
                        return;
                    }
                    if (toBox.getMinX() > fromBox.getMaxX()) {
                        this.worstFrom.setLocation(fromBox.getMaxX(), yPos);
                        this.worstTo.setLocation(toBox.getMinX(), yPos);
                        return;
                    }
                    return;
                }
            }
            double minPD = 0.0;
            Point2D[] fromPoints = from.getPoints();
            for (int f = 0; f < fromPoints.length; ++f) {
                Point2D c = to.closestPoint(fromPoints[f]);
                pd = c.distance(fromPoints[f]);
                if (f != 0 && pd >= minPD) continue;
                minPD = pd;
                this.worstFrom.setLocation(fromPoints[f]);
            }
            minPD = 0.0;
            Point2D[] toPoints = to.getPoints();
            for (int t = 0; t < toPoints.length; ++t) {
                pd = this.worstFrom.distance(toPoints[t]);
                if (t != 0 && pd >= minPD) continue;
                minPD = pd;
                this.worstTo.setLocation(toPoints[t]);
            }
        }
    }

    private static class Mode {
        private final String name;
        public static final Mode none = new Mode("none");
        public static final Mode move = new Mode("move");
        public static final Mode stickyMove = new Mode("stickyMove");
        public static final Mode drawBox = new Mode("drawBox");
        public static final Mode zoomBox = new Mode("zoomBox");
        public static final Mode zoomBoxSingleShot = new Mode("zoomBoxSingleShot");
        public static final Mode zoomIn = new Mode("zoomIn");
        public static final Mode zoomOut = new Mode("zoomOut");
        public static final Mode selectBox = new Mode("selectBox");
        public static final Mode wiringConnect = new Mode("wiring");
        public static final Mode wiringFind = new Mode("wiringFind");
        public static final Mode wiringToSpace = new Mode("wiringToSpace");
        public static final Mode stickyWiring = new Mode("stickyWiring");

        public Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

