/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TopLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Commit {
    public static void commitAllLibraries() {
        ArrayList<Library> libs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk() || lib.getName().equals("spiceparts")) continue;
            libs.add(lib);
        }
        Commit.commit(libs, null);
    }

    public static void commit(Library lib) {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(lib);
        Commit.commit(libs, null);
    }

    public static void commit(Cell cell) {
        ArrayList<Cell> cellsCommitted = new ArrayList<Cell>();
        cellsCommitted.add(cell);
        Commit.commit(null, cellsCommitted);
    }

    public static void commit(List<Library> libs, List<Cell> cells) {
        String[] choices;
        int choice;
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        CVSLibrary.LibsCells bad = CVSLibrary.notFromDELIB(cells);
        if (bad.cells.size() > 0) {
            CVS.showError("Error: the following Cells are not part of a DELIB library and cannot be acted upon individually", "CVS Commit Error", bad.libs, bad.cells);
            return;
        }
        bad = CVSLibrary.getNotInCVS(libs, cells);
        if (bad.libs.size() > 0 || bad.cells.size() > 0) {
            CVS.showError("Error: the following Libraries and Cells are not in CVS", "CVS Commit error", bad.libs, bad.cells);
            return;
        }
        bad = CVSLibrary.getModified(libs, cells);
        if ((bad.libs.size() > 0 || bad.cells.size() > 0) && (choice = CVS.askForChoice("Warning: Unsaved changes will not be committed!  For:", "CVS Commit Warning!", bad.libs, bad.cells, choices = new String[]{"Continue Anyway", "Cancel"}, choices[1])) == 1) {
            return;
        }
        CVSLibrary.LibsCells good = CVSLibrary.consolidate(libs, cells);
        String lastCommitMessage = CVS.getCVSLastCommitMessage();
        String commitMessage = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Commit message: ", lastCommitMessage);
        if (commitMessage == null) {
            return;
        }
        if (!commitMessage.equals(lastCommitMessage)) {
            CVS.setCVSLastCommitMessage(commitMessage);
        }
        new CommitJob(commitMessage, good.libs, good.cells).startJob();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommitJob
    extends Job {
        private String message;
        private List<Library> libsToCommit;
        private List<Cell> cellsToCommit;
        private int exitVal;
        private int backupScheme;
        private String cvsProgram = CVS.getCVSProgram();
        private String repository = CVS.getRepository();

        private CommitJob(String message, List<Library> libsToCommit, List<Cell> cellsToCommit) {
            super("CVS Commit", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.message = message;
            this.libsToCommit = libsToCommit;
            this.cellsToCommit = cellsToCommit;
            this.exitVal = -1;
            if (this.libsToCommit == null) {
                this.libsToCommit = new ArrayList<Library>();
            }
            if (this.cellsToCommit == null) {
                this.cellsToCommit = new ArrayList<Cell>();
            }
            this.backupScheme = IOTool.getBackupRedundancy();
        }

        @Override
        public boolean doIt() throws JobException {
            Update.StatusResult result;
            String useDir = CVS.getUseDir(this.libsToCommit, this.cellsToCommit);
            StringBuffer libs = CVS.getLibraryFiles(this.libsToCommit, useDir);
            StringBuffer cells = CVS.getCellFiles(this.cellsToCommit, useDir);
            StringBuffer headerFiles = CVS.getHeaderFilesForCommit(this.libsToCommit, this.cellsToCommit, useDir);
            String commitFiles = libs + " " + headerFiles + " " + cells;
            if (commitFiles.trim().equals("")) {
                System.out.println("Nothing to commit");
                this.exitVal = 0;
                return true;
            }
            if (!headerFiles.toString().trim().equals("") && (result = Update.update(this.cvsProgram, this.repository, headerFiles.toString(), useDir, Update.UpdateEnum.UPDATE)).getExitVal() == 0) {
                List<Library> headerlibs = result.getLibraryHeaderFiles(State.CONFLICT);
                for (Library lib : headerlibs) {
                    Output.writeLibrary(lib, FileType.DELIB, false, true, true, this.backupScheme);
                }
            }
            this.exitVal = CVS.runCVSCommandWithQuotes(this.cvsProgram, this.repository, "-q commit -m \"" + this.message + "\" " + commitFiles, "Committing files to CVS", useDir, System.out);
            System.out.println("Commit complete");
            this.fieldVariableChanged("exitVal");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.exitVal != 0) {
                Job.getUserInterface().showErrorMessage("CVS Commit Failed!  Please see messages window (exit status " + this.exitVal + ")", "CVS Commit Failed!");
                return;
            }
            for (Library lib : this.libsToCommit) {
                CVSLibrary.setEditing(lib, false);
                if (CVSLibrary.getState(lib) == State.REMOVED) {
                    CVSLibrary.setState(lib, State.UNKNOWN);
                    continue;
                }
                CVSLibrary.setState(lib, State.NONE);
            }
            if (this.cellsToCommit != null) {
                for (Cell cell : this.cellsToCommit) {
                    CVSLibrary.setEditing(cell, false);
                    if (CVSLibrary.getState(cell) == State.REMOVED) {
                        CVSLibrary.setState(cell, State.UNKNOWN);
                        continue;
                    }
                    CVSLibrary.setState(cell, State.NONE);
                }
            }
        }
    }
}

