/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightArea;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircuitChanges {
    private static double lastRotationAmount = 90.0;

    private CircuitChanges() {
    }

    public static void rotateObjects(int amount) {
        List<Geometric> highs;
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (amount == 0) {
            String val = JOptionPane.showInputDialog("Amount to rotate", (Object)new Double(lastRotationAmount));
            if (val == null) {
                return;
            }
            double fAmount = TextUtils.atof(val);
            if (fAmount == 0.0) {
                System.out.println("Null rotation amount");
                return;
            }
            lastRotationAmount = fAmount;
            amount = (int)(fAmount * 10.0);
        }
        if ((highs = MenuCommands.getSelectedObjects(true, true)).size() == 0) {
            System.out.println("Cannot rotate: nothing is selected");
            return;
        }
        new CircuitChangeJobs.RotateSelected(cell, highs, amount, false, false);
    }

    public static void mirrorObjects(boolean horizontally) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = wf.getContent().getCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.RotateSelected(cell, MenuCommands.getSelectedObjects(true, true), 0, true, horizontally);
    }

    public static void alignToGrid() {
        List<Geometric> selected = MenuCommands.getSelectedObjects(true, true);
        HashSet<NodeInst> selectedNodes = new HashSet<NodeInst>();
        for (Geometric geom : selected) {
            if (!(geom instanceof NodeInst)) continue;
            selectedNodes.add((NodeInst)geom);
        }
        ArrayList<NodeInst> addedNodes = new ArrayList<NodeInst>();
        for (Geometric geom : selected) {
            NodeInst tail;
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            NodeInst head = ai.getHead().getPortInst().getNodeInst();
            if (!selectedNodes.contains(head)) {
                addedNodes.add(head);
                selectedNodes.add(head);
            }
            if (selectedNodes.contains(tail = ai.getTail().getPortInst().getNodeInst())) continue;
            addedNodes.add(tail);
            selectedNodes.add(tail);
        }
        for (NodeInst ni : addedNodes) {
            selected.add(ni);
        }
        if (selected.size() == 0) {
            System.out.println("Must select something before aligning it to the grid");
            return;
        }
        Dimension2D alignment = User.getAlignmentToGrid();
        if (alignment.getWidth() <= 0.0 || alignment.getHeight() <= 0.0) {
            System.out.println("No alignment given: set Alignment Options first");
            return;
        }
        new CircuitChangeJobs.AlignObjects(selected, alignment);
    }

    public static void alignNodes(boolean horizontal, int direction) {
        Rectangle2D bounds;
        NodeInst ni;
        int i;
        Cell np = WindowFrame.needCurCell();
        if (np == null) {
            return;
        }
        List<Geometric> list = MenuCommands.getSelectedObjects(true, true);
        if (list.size() == 0) {
            System.out.println("First select objects to move");
            return;
        }
        for (Geometric geom : list) {
            if (geom.getParent() == np) continue;
            System.out.println("All moved objects must be in the same cell");
            return;
        }
        ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
        for (Geometric geom : list) {
            if (!(geom instanceof NodeInst)) continue;
            nodes.add((NodeInst)geom);
        }
        int total = nodes.size();
        if (total == 0) {
            return;
        }
        NodeInst[] nis = new NodeInst[total];
        double[] dCX = new double[total];
        double[] dCY = new double[total];
        for (int i2 = 0; i2 < total; ++i2) {
            nis[i2] = (NodeInst)nodes.get(i2);
        }
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        for (i = 0; i < total; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            if (i == 0) {
                lX = bounds.getMinX();
                hX = bounds.getMaxX();
                lY = bounds.getMinY();
                hY = bounds.getMaxY();
                continue;
            }
            if (bounds.getMinX() < lX) {
                lX = bounds.getMinX();
            }
            if (bounds.getMaxX() > hX) {
                hX = bounds.getMaxX();
            }
            if (bounds.getMinY() < lY) {
                lY = bounds.getMinY();
            }
            if (!(bounds.getMaxY() > hY)) continue;
            hY = bounds.getMaxY();
        }
        block14: for (i = 0; i < total; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            dCY[i] = 0.0;
            dCX[i] = 0.0;
            if (horizontal) {
                switch (direction) {
                    case 0: {
                        dCX[i] = lX - bounds.getMinX();
                        break;
                    }
                    case 1: {
                        dCX[i] = hX - bounds.getMaxX();
                        break;
                    }
                    case 2: {
                        dCX[i] = (lX + hX) / 2.0 - bounds.getCenterX();
                    }
                }
                continue;
            }
            switch (direction) {
                case 0: {
                    dCY[i] = hY - bounds.getMaxY();
                    continue block14;
                }
                case 1: {
                    dCY[i] = lY - bounds.getMinY();
                    continue block14;
                }
                case 2: {
                    dCY[i] = (lY + hY) / 2.0 - bounds.getCenterY();
                }
            }
        }
        new CircuitChangeJobs.AlignNodes(nis, dCX, dCY);
    }

    public static void arcRigidCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.RIGID, CircuitChanges.getHighlighted());
    }

    public static void arcNotRigidCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.NONRIGID, CircuitChanges.getHighlighted());
    }

    public static void arcFixedAngleCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.FIXEDANGLE, CircuitChanges.getHighlighted());
    }

    public static void arcNotFixedAngleCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.NONFIXEDANGLE, CircuitChanges.getHighlighted());
    }

    public static void arcDirectionalCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.DIRECTIONAL, CircuitChanges.getHighlighted());
    }

    public static void arcHeadExtendCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.HEADEXTEND, CircuitChanges.getHighlighted());
    }

    public static void arcTailExtendCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ChangeArcProperties(cell, CircuitChangeJobs.ChangeArcEnum.TAILEXTEND, CircuitChanges.getHighlighted());
    }

    public static void toggleNegatedCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ToggleNegationJob(cell, CircuitChanges.getHighlighted());
    }

    public static List<Highlight> getHighlighted() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return new ArrayList<Highlight>();
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return new ArrayList<Highlight>();
        }
        return highlighter.getHighlights();
    }

    public static void ripBus() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> list = MenuCommands.getSelectedArcs();
        if (list.size() == 0) {
            System.out.println("Must select bus arcs to rip into individual signals");
            return;
        }
        new CircuitChangeJobs.RipTheBus(cell, list);
    }

    public static void deleteSelected() {
        Highlight high;
        MessagesWindow mw = TopLevel.getMessagesWindow();
        if (mw.isFocusOwner()) {
            mw.clear(false);
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            ww.deleteSelectedSignals();
            return;
        }
        if (WindowFrame.getListener() == OutlineListener.theOne) {
            OutlineListener.theOne.deletePoint();
            return;
        }
        boolean highlightedArea = ToolBar.getSelectMode() == ToolBar.SelectMode.AREA;
        List<Highlight> highlights = highlighter.getHighlights();
        if (highlights.size() == 1 && (high = highlights.get(0)) instanceof HighlightArea) {
            highlightedArea = true;
        }
        if (highlightedArea) {
            EditWindow wnd = EditWindow.getCurrent();
            Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
            if (bounds == null) {
                System.out.println("Nothing is selected");
                return;
            }
            new CircuitChangeJobs.DeleteSelectedGeometry(cell, bounds);
        } else {
            boolean formerMoveWithText = User.isMoveNodeWithExport();
            Pref.delayPrefFlushing();
            User.setMoveNodeWithExport(false);
            List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
            List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
            User.setMoveNodeWithExport(formerMoveWithText);
            Pref.resumePrefFlushing();
            if (highlightedText.size() == 0 && highlighted.size() == 0) {
                return;
            }
            new CircuitChangeJobs.DeleteSelected(cell, highlightedText, highlighted, User.isReconstructArcsAndExportsToDeletedCells());
        }
    }

    public static void cellCenterToCenterOfSelection() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, false) != 0) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            return;
        }
        new CircuitChangeJobs.CellCenterToCenterOfSelection(cell, new EPoint(bounds.getCenterX(), bounds.getCenterY()));
    }

    public static void deleteArcsOnSelected(boolean both) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, false) != 0) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        HashSet<NodeInst> selectedNodes = new HashSet<NodeInst>();
        for (Geometric g : highlighter.getHighlightedEObjs(true, false)) {
            selectedNodes.add((NodeInst)g);
        }
        HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
        for (NodeInst ni : selectedNodes) {
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                ArcInst ai = con.getArc();
                if (both && (!selectedNodes.contains(ai.getHeadPortInst().getNodeInst()) || !selectedNodes.contains(ai.getTailPortInst().getNodeInst()))) continue;
                arcsToDelete.add(ai);
            }
        }
        if (arcsToDelete.size() == 0) {
            System.out.println("There are no arcs on the selected nodes that can be deleted");
            return;
        }
        new CircuitChangeJobs.DeleteArcs(arcsToDelete);
    }

    public static boolean deleteCell(Cell cell, boolean confirm, boolean quiet) {
        int response;
        if (cell.isInUse("delete", quiet, true)) {
            return false;
        }
        if (confirm && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to delete " + cell + "?", "Delete Cell Dialog", 0)) != 0) {
            return false;
        }
        CircuitChanges.cleanCellRef(cell);
        new CellChangeJobs.DeleteCell(cell);
        return true;
    }

    public static void cleanCellRef(Cell cell) {
        Library lib = cell.getLibrary();
        if (cell == lib.getCurCell()) {
            lib.setCurCell(null);
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (content == null || content.getCell() != cell) continue;
            if (!(content instanceof EditWindow)) {
                wf.setCellWindow(null, null);
                continue;
            }
            content.setCell(null, null, null);
            content.fullRepaint();
        }
    }

    public static void renameCellInJob(Cell cell, String newName) {
        int response;
        String newGroupCell = null;
        HashSet<Cell> set = new HashSet<Cell>();
        Iterator<Cell> it = cell.getLibrary().getCells();
        while (it.hasNext()) {
            Cell oCell = it.next();
            if (!oCell.getName().equalsIgnoreCase(newName) || oCell.getCellGroup() == cell.getCellGroup()) continue;
            int response2 = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Also place the cell into the \"" + oCell.getCellGroup().getName() + "\" group?");
            if (response2 != 0) break;
            newGroupCell = oCell.getName();
            break;
        }
        set.add(cell);
        if (cell.getNumVersions() > 1 && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Also rename previous versions of the cell \"" + cell.getName() + "\" ?")) == 0) {
            Iterator<Cell> it2 = cell.getVersions();
            while (it2.hasNext()) {
                set.add(it2.next());
            }
        }
        for (Cell c : set) {
            new CellChangeJobs.RenameCell(c, newName, newGroupCell);
        }
    }

    public static void renameCellGroupInJob(Cell.CellGroup cellGroup, String newName) {
        new CellChangeJobs.RenameCellGroup(cellGroup.getCells().next(), newName);
    }

    public static void graphCellsFromCell() {
        Cell top = WindowFrame.needCurCell();
        if (top == null) {
            return;
        }
        new CellChangeJobs.GraphCells(top);
    }

    public static void graphCellsInLibrary() {
        new CellChangeJobs.GraphCells(null);
    }

    public static void graphLibraries() {
        new CellChangeJobs.GraphLibraries();
    }

    public static void packageIntoCell() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell curCell = wnd.getCell();
        if (curCell == null) {
            System.out.println("No cell in this window");
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must first select circuitry to package");
            return;
        }
        String newCellName = JOptionPane.showInputDialog("New cell name:", (Object)curCell.getName());
        if (newCellName == null) {
            return;
        }
        newCellName = newCellName + curCell.getView().getAbbreviationExtension();
        HashSet<Geometric> whatToPackage = new HashSet<Geometric>();
        List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
        for (Geometric geom : highlighted) {
            whatToPackage.add(geom);
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            whatToPackage.add(ai.getHeadPortInst().getNodeInst());
            whatToPackage.add(ai.getTailPortInst().getNodeInst());
        }
        new CellChangeJobs.PackageCell(curCell, whatToPackage, newCellName);
    }

    public static void extractCells(int depth) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (depth < 0) {
            String obj = JOptionPane.showInputDialog("Number of levels to extract", (Object)"1");
            if (obj != null) {
                depth = TextUtils.atoi(obj);
            }
            if (depth <= 0) {
                return;
            }
        }
        List<NodeInst> selected = MenuCommands.getSelectedNodes();
        ArrayList<NodeInst> instances = new ArrayList<NodeInst>();
        for (NodeInst ni : selected) {
            if (!ni.isCellInstance()) continue;
            instances.add(ni);
        }
        if (instances.size() == 0) {
            System.out.println("No cell instances are selected...no extraction done");
            return;
        }
        new CellChangeJobs.ExtractCellInstances(cell, instances, depth, User.isExtractCopiesExports(), User.isIncrementRightmostIndex(), false);
    }

    public static void cleanupPinsCommand(boolean everywhere) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (everywhere) {
            boolean cleaned = false;
            for (Library lib : Library.getVisibleLibraries()) {
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    if (!CircuitChanges.cleanupCell(cell, false, highlighter)) continue;
                    cleaned = true;
                }
            }
            if (!cleaned) {
                System.out.println("Nothing to clean");
            }
        } else {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return;
            }
            CircuitChanges.cleanupCell(cell, true, highlighter);
        }
    }

    private static boolean cleanupCell(Cell cell, boolean justThis, Highlighter highlighter) {
        Connection con;
        HashSet<NodeInst> pinsToRemove = new HashSet<NodeInst>();
        List<CircuitChangeJobs.Reconnect> pinsToPassThrough = CircuitChangeJobs.getPinsToPassThrough(cell);
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.getFunction().isPin() || ni.hasExports() || ni.hasConnections()) continue;
            boolean hasDisplayable = false;
            Iterator<Variable> vIt = ni.getVariables();
            while (vIt.hasNext()) {
                Variable var = vIt.next();
                if (!var.isDisplay()) continue;
                hasDisplayable = true;
                break;
            }
            if (hasDisplayable) continue;
            pinsToRemove.add(ni);
        }
        HashMap<NodeInst, EPoint> pinsToScale = new HashMap<NodeInst, EPoint>();
        Iterator<NodeInst> it2 = cell.getNodes();
        while (it2.hasNext()) {
            double overSizeY;
            NodeInst ni = it2.next();
            if (!ni.getFunction().isPin()) continue;
            double overSizeX = ni.getXSize() - ni.getProto().getDefWidth();
            if (overSizeX < 0.0) {
                overSizeX = 0.0;
            }
            if ((overSizeY = ni.getYSize() - ni.getProto().getDefHeight()) < 0.0) {
                overSizeY = 0.0;
            }
            if (overSizeX == 0.0 && overSizeY == 0.0) continue;
            boolean arcsInCenter = true;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                con = cIt.next();
                ArcInst ai = con.getArc();
                if (ai.getHeadPortInst().getNodeInst() == ni) {
                    if (ai.getHeadLocation().getX() != ni.getAnchorCenterX()) {
                        arcsInCenter = false;
                        break;
                    }
                    if (ai.getHeadLocation().getY() != ni.getAnchorCenterY()) {
                        arcsInCenter = false;
                        break;
                    }
                }
                if (ai.getTailPortInst().getNodeInst() != ni) continue;
                if (ai.getTailLocation().getX() != ni.getAnchorCenterX()) {
                    arcsInCenter = false;
                    break;
                }
                if (ai.getTailLocation().getY() == ni.getAnchorCenterY()) continue;
                arcsInCenter = false;
                break;
            }
            if (!arcsInCenter) continue;
            double overSizeArc = 0.0;
            Iterator<Connection> cIt2 = ni.getConnections();
            while (cIt2.hasNext()) {
                Connection con2 = cIt2.next();
                ArcInst ai = con2.getArc();
                double overSize = ai.getLambdaBaseWidth() - ai.getProto().getDefaultLambdaBaseWidth();
                if (overSize < 0.0) {
                    overSize = 0.0;
                }
                if (!(overSize > overSizeArc)) continue;
                overSizeArc = overSize;
            }
            if (overSizeArc >= overSizeX && overSizeArc >= overSizeY) continue;
            double dSX = 0.0;
            double dSY = 0.0;
            if (overSizeArc < overSizeX) {
                dSX = overSizeX - overSizeArc;
            }
            if (overSizeArc < overSizeY) {
                dSY = overSizeY - overSizeArc;
            }
            pinsToScale.put(ni, new EPoint(-dSX, -dSY));
        }
        ArrayList<NodeInst> textToMove = new ArrayList<NodeInst>();
        Iterator<NodeInst> it3 = cell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = it3.next();
            Point2D pt = ni.invisiblePinWithOffsetText(false);
            if (pt == null) continue;
            textToMove.add(ni);
        }
        int overSizePins = 0;
        Iterator<NodeInst> it4 = cell.getNodes();
        while (it4.hasNext()) {
            NodeInst ni = it4.next();
            if (!ni.getFunction().isPin()) continue;
            boolean nodeIsBad = false;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con3 = cIt.next();
                ArcInst ai = con3.getArc();
                Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.FILLED);
                Iterator<Connection> oCIt = ni.getConnections();
                while (oCIt.hasNext()) {
                    Poly oPoly;
                    double dist;
                    Connection oCon = oCIt.next();
                    ArcInst oAi = oCon.getArc();
                    if (ai.getArcId() <= oAi.getArcId() || (dist = poly.separation(oPoly = oAi.makeLambdaPoly(oAi.getGridBaseWidth(), Poly.Type.FILLED))) <= 0.0) continue;
                    nodeIsBad = true;
                    break;
                }
                if (!nodeIsBad) continue;
                break;
            }
            if (!nodeIsBad) continue;
            if (justThis) {
                highlighter.addElectricObject(ni, cell);
            }
            ++overSizePins;
        }
        HashSet<ArcInst> arcsToKill = new HashSet<ArcInst>();
        Iterator<ArcInst> ait = cell.getArcs();
        while (ait.hasNext()) {
            ArcInst ai = ait.next();
            int arcId = ai.getArcId();
            if (arcsToKill.contains(ai)) continue;
            PortInst pi = ai.getHeadPortInst();
            Iterator<Connection> it5 = pi.getConnections();
            while (it5.hasNext()) {
                int otherEnd;
                PortInst oPi;
                con = it5.next();
                ArcInst oAi = con.getArc();
                if (oAi.getArcId() >= arcId || ai.getProto() != oAi.getProto() || (oPi = oAi.getPortInst(otherEnd = 1 - con.getEndIndex())) != ai.getTailPortInst()) continue;
                arcsToKill.add(oAi);
            }
        }
        int zeroSize = 0;
        int negSize = 0;
        Iterator<NodeInst> it6 = cell.getNodes();
        while (it6.hasNext()) {
            NodeInst ni = it6.next();
            if (ni.getProto() == Generic.tech().cellCenterNode || ni.getProto() == Generic.tech().invisiblePinNode || ni.getProto() == Generic.tech().universalPinNode || ni.getProto() == Generic.tech().essentialBoundsNode) continue;
            double sX = ni.getLambdaBaseXSize();
            double sY = ni.getLambdaBaseYSize();
            if (sX > 0.0 && sY > 0.0 || sX > 0.0 || sY > 0.0 && ni.getProto().getTechnology() == Artwork.tech() || sX == 0.0 && sY == 0.0 && ni.getFunction().isPin()) continue;
            if (justThis) {
                highlighter.addElectricObject(ni, cell);
            }
            if (sX < 0.0 || sY < 0.0) {
                ++negSize;
                continue;
            }
            ++zeroSize;
        }
        if (pinsToRemove.size() == 0 && pinsToPassThrough.size() == 0 && pinsToScale.size() == 0 && zeroSize == 0 && negSize == 0 && textToMove.size() == 0 && overSizePins == 0 && arcsToKill.size() == 0) {
            if (justThis) {
                System.out.println("Nothing to clean");
            }
            return false;
        }
        new CircuitChangeJobs.CleanupChanges(cell, justThis, pinsToRemove, pinsToPassThrough, pinsToScale, textToMove, arcsToKill, zeroSize, negSize, overSizePins);
        return true;
    }

    public static void showNonmanhattanCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        HashSet<Cell> cellsSeen = new HashSet<Cell>();
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                Iterator<ArcInst> aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = aIt.next();
                    ArcProto ap = ai.getProto();
                    if (ap.getTechnology() == Generic.tech() || ap.getTechnology() == Artwork.tech() || ap.getTechnology() == Schematics.tech()) continue;
                    Variable var = ai.getVar(ImmutableArcInst.ARC_RADIUS);
                    if (var != null) {
                        cellsSeen.add(cell);
                    }
                    if (ai.getHeadLocation().getX() == ai.getTailLocation().getX() || ai.getHeadLocation().getY() == ai.getTailLocation().getY()) continue;
                    cellsSeen.add(cell);
                }
                Iterator<NodeInst> nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = nIt.next();
                    if (ni.getAngle() % 900 == 0) continue;
                    cellsSeen.add(cell);
                }
            }
        }
        int i = 0;
        Iterator<ArcInst> aIt = curCell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            ArcProto ap = ai.getProto();
            if (ap.getTechnology() == Generic.tech() || ap.getTechnology() == Artwork.tech() || ap.getTechnology() == Schematics.tech()) continue;
            boolean nonMan = false;
            Variable var = ai.getVar(ImmutableArcInst.ARC_RADIUS);
            if (var != null) {
                nonMan = true;
            }
            if (ai.getHeadLocation().getX() != ai.getTailLocation().getX() && ai.getHeadLocation().getY() != ai.getTailLocation().getY()) {
                nonMan = true;
            }
            if (!nonMan) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ai, curCell);
            ++i;
        }
        Iterator<NodeInst> nIt = curCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (ni.getAngle() % 900 == 0) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ni, curCell);
            ++i;
        }
        if (i == 0) {
            System.out.println("No nonmanhattan objects in this cell");
        } else {
            highlighter.finished();
            System.out.println(i + " objects are not manhattan in this cell");
        }
        Iterator<Library> lIt2 = Library.getLibraries();
        while (lIt2.hasNext()) {
            Library lib = lIt2.next();
            if (lib.isHidden()) continue;
            int numBad = 0;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                if (!cellsSeen.contains(cell) || cell == curCell) continue;
                ++numBad;
            }
            if (numBad == 0) continue;
            if (lib == Library.getCurrent()) {
                int cellsFound = 0;
                String infstr = "";
                Iterator<Cell> cIt2 = lib.getCells();
                while (cIt2.hasNext()) {
                    Cell cell = cIt2.next();
                    if (cell == curCell || !cellsSeen.contains(cell)) continue;
                    if (cellsFound > 0) {
                        infstr = infstr + " ";
                    }
                    infstr = infstr + cell.describe(true);
                    ++cellsFound;
                }
                if (cellsFound == 1) {
                    System.out.println("Found nonmanhattan geometry in cell " + infstr);
                    continue;
                }
                System.out.println("Found nonmanhattan geometry in these cells: " + infstr);
                continue;
            }
            System.out.println("Found nonmanhattan geometry in " + lib);
        }
    }

    public static void showPureLayerCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        int i = 0;
        Iterator<NodeInst> nIt = curCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (ni.getFunction() != PrimitiveNode.Function.NODE) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ni, curCell);
            ++i;
        }
        if (i == 0) {
            System.out.println("No pure layer nodes in this cell");
        } else {
            highlighter.finished();
            System.out.println(i + " pure layer nodes in this cell");
        }
    }

    public static void shortenArcsCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new CircuitChangeJobs.ShortenArcs(cell, MenuCommands.getSelectedArcs());
    }

    public static void showRedundantPureLayerNodes() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        LayerVisibility lv = wnd.getLayerVisibility();
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        HashSet<NodeInst> redundantPures = new HashSet<NodeInst>();
        Iterator<Layer> it = cell.getTechnology().getLayers();
        while (it.hasNext()) {
            PrimitiveNode pNp;
            Layer lay = it.next();
            if (!lv.isVisible(lay) || (pNp = lay.getPureLayerNode()) == null) continue;
            ArrayList<NodeInst> allPures = new ArrayList<NodeInst>();
            HashMap<NodeInst, Double> pureAreas = new HashMap<NodeInst, Double>();
            RTNode root = RTNode.makeTopLevel();
            Iterator<NodeInst> nIt = cell.getNodes();
            while (nIt.hasNext()) {
                double area;
                NodeInst ni = nIt.next();
                if (ni.getProto() != pNp) continue;
                allPures.add(ni);
                Point2D[] points = ni.getTrace();
                if (points == null) {
                    area = ni.getXSize() * ni.getYSize();
                } else {
                    boolean hasGaps = false;
                    for (int i = 0; i < points.length; ++i) {
                        if (points[i] != null) continue;
                        hasGaps = true;
                        break;
                    }
                    if (hasGaps) {
                        area = 0.0;
                        int start = 0;
                        for (int i = 0; i < points.length; ++i) {
                            if (i != points.length - 1 && points[i + 1] != null) continue;
                            Point2D[] segment = new Point2D[i - start + 1];
                            for (int j = start; j <= i; ++j) {
                                segment[j - start] = points[j];
                            }
                            area += GenMath.getAreaOfPoints(segment);
                            start = i + 2;
                        }
                    } else {
                        area = GenMath.getAreaOfPoints(points);
                    }
                }
                pureAreas.put(ni, new Double(area));
                root = RTNode.linkGeom(null, root, ni);
            }
            block5: for (NodeInst ni : allPures) {
                Double nodeArea = (Double)pureAreas.get(ni);
                Rectangle2D nodeRect = ni.getBounds();
                RTNode.Search sea = new RTNode.Search(nodeRect, root, false);
                while (sea.hasNext()) {
                    Poly[] neighborPolys;
                    Poly neighborPoly;
                    Double neighborArea;
                    NodeInst neighbor = (NodeInst)sea.next();
                    if (neighbor == ni || (neighborArea = (Double)pureAreas.get(neighbor)) < nodeArea || redundantPures.contains(neighbor) || !(neighborPoly = (neighborPolys = neighbor.getProto().getTechnology().getShapeOfNode(neighbor))[0]).contains(nodeRect)) continue;
                    redundantPures.add(ni);
                    continue block5;
                }
            }
        }
        wnd.clearHighlighting();
        for (NodeInst ni : redundantPures) {
            wnd.addElectricObject(ni, cell);
        }
        wnd.finishedHighlighting();
        System.out.println("Highlighted " + redundantPures.size() + " redundant pure-layer nodes");
    }

    public static boolean isBox(Point2D[] points) {
        if (points.length != 4) {
            if (points.length == 5) {
                if (points[0].getX() != points[4].getX() || points[0].getY() != points[4].getY()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (points[0].getX() == points[1].getX() && points[2].getX() == points[3].getX() && points[0].getY() == points[3].getY() && points[1].getY() == points[2].getY()) {
            return true;
        }
        return points[0].getX() == points[3].getX() && points[1].getX() == points[2].getX() && points[0].getY() == points[1].getY() && points[2].getY() == points[3].getY();
    }

    public static void newVersionOfCell(Cell cell) {
        int status = Project.getCellStatus(cell);
        if (status != 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is part of a project.  To get a new version of it, check it out.", "Cannot Make New Version", 0);
            return;
        }
        new CellChangeJobs.NewCellVersion(cell);
    }

    public static void manyMove(double dX, double dY) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = wf.getContent().getCell();
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        List<Highlight> highlighted = highlighter.getHighlights();
        int nonCellCenterCount = 0;
        Highlight cellCenterHighlight = null;
        ArrayList<ElectricObject> highlightedEObjs = new ArrayList<ElectricObject>();
        for (Highlight h : highlighted) {
            if (!h.isHighlightEOBJ()) continue;
            ElectricObject eObj = h.getElectricObject();
            highlightedEObjs.add(eObj);
            if (eObj instanceof NodeInst) {
                NodeInst ni = (NodeInst)eObj;
                if (ni.getProto() == Generic.tech().cellCenterNode) {
                    cellCenterHighlight = h;
                    continue;
                }
                ++nonCellCenterCount;
                continue;
            }
            ++nonCellCenterCount;
        }
        if (cellCenterHighlight != null && nonCellCenterCount != 0) {
            System.out.println("Cannot move the Cell-center along with other objects.  Cell-center will not be moved.");
            highlighted.remove(cellCenterHighlight);
        }
        List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
        if (!highlightedEObjs.isEmpty() || !highlightedText.isEmpty()) {
            new CircuitChangeJobs.ManyMove(cell, highlightedEObjs, highlightedText, dX, dY);
        }
    }

    public static void DoExpandCommands(boolean unExpand, int amount) {
        List<NodeInst> list;
        if (amount < 0) {
            String obj = JOptionPane.showInputDialog("Number of levels to " + (unExpand ? "unexpand" : "expand"), (Object)"1");
            if (obj != null) {
                amount = TextUtils.atoi(obj);
            }
            if (amount <= 0) {
                return;
            }
        }
        if ((list = MenuCommands.getSelectedNodes()).isEmpty()) {
            return;
        }
        Cell cell = list.get(0).getParent();
        for (NodeInst ni : list) {
            assert (ni.getParent() == cell);
            if (!ni.isCellInstance()) continue;
            if (!unExpand) {
                CircuitChanges.doExpand(cell, ni.getD(), amount, 0);
                continue;
            }
            if (!ni.isExpanded()) continue;
            CircuitChanges.doUnExpand(cell, ni.getD(), amount);
        }
        EditWindow.expansionChanged(cell);
        EditWindow.clearSubCellCache();
        EditWindow.repaintAllContents();
    }

    private static void doExpand(Cell parent, ImmutableNodeInst n, int amount, int sofar) {
        if (!parent.isExpanded(n.nodeId)) {
            parent.setExpanded(n.nodeId, true);
            if (++sofar >= amount) {
                return;
            }
        }
        if (!n.isCellInstance()) {
            return;
        }
        EDatabase database = parent.getDatabase();
        Cell cell = (Cell)n.protoId.inDatabase(database);
        for (ImmutableNodeInst subN : cell.backupUnsafe().cellRevision.nodes) {
            Cell subCell;
            if (!subN.isCellInstance() || (subCell = (Cell)subN.protoId.inDatabase(database)).isIconOf(cell)) continue;
            CircuitChanges.doExpand(cell, subN, amount, sofar);
        }
    }

    private static int doUnExpand(Cell parent, ImmutableNodeInst n, int amount) {
        if (!parent.isExpanded(n.nodeId)) {
            return 0;
        }
        if (!n.isCellInstance()) {
            return 1;
        }
        EDatabase database = parent.getDatabase();
        int depth = 0;
        Cell cell = (Cell)n.protoId.inDatabase(database);
        for (ImmutableNodeInst subN : cell.backupUnsafe().cellRevision.nodes) {
            Cell subCell;
            if (!subN.isCellInstance() || (subCell = (Cell)subN.protoId.inDatabase(database)).isIconOf(cell) || !cell.isExpanded(subN.nodeId)) continue;
            depth = Math.max(depth, CircuitChanges.doUnExpand(cell, subN, amount));
        }
        if (depth < amount) {
            parent.setExpanded(n.nodeId, false);
        }
        return depth + 1;
    }

    public static void listLibrariesCommand() {
        System.out.println("----- Libraries: -----");
        int k = 0;
        for (Library lib : Library.getVisibleLibraries()) {
            Cell subCell;
            NodeInst ni;
            Iterator<NodeInst> nIt;
            Cell cell;
            Iterator<Cell> cIt;
            if (lib.isHidden()) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append(lib.getName());
            if (lib.isChanged()) {
                infstr.append("*");
                ++k;
            }
            if (lib.getLibFile() != null) {
                infstr.append(" (disk file: " + lib.getLibFile() + ")");
            }
            System.out.println(infstr.toString());
            HashSet<String> dummyLibs = new HashSet<String>();
            HashSet<Library> markedLibs = new HashSet<Library>();
            Iterator<Cell> cIt2 = lib.getCells();
            while (cIt2.hasNext()) {
                Cell cell2 = cIt2.next();
                Iterator<NodeInst> nIt2 = cell2.getNodes();
                while (nIt2.hasNext()) {
                    NodeInst ni2 = nIt2.next();
                    if (!ni2.isCellInstance()) continue;
                    Cell subCell2 = (Cell)ni2.getProto();
                    String pt = subCell2.getVarValue(LibraryFiles.IO_TRUE_LIBRARY, String.class);
                    if (pt != null) {
                        dummyLibs.add(pt);
                    }
                    markedLibs.add(subCell2.getLibrary());
                }
            }
            Iterator<Library> lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                Library oLib = lIt.next();
                if (oLib == lib || !markedLibs.contains(oLib)) continue;
                System.out.println("   Makes use of cells in " + oLib);
                infstr = new StringBuffer();
                infstr.append("      These cells make reference to that library:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        ni = nIt.next();
                        if (!ni.isCellInstance() || (subCell = (Cell)ni.getProto()).getLibrary() != oLib) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
            for (String dummyLibName : dummyLibs) {
                System.out.println("   Has dummy cells that should be in library " + dummyLibName);
                infstr = new StringBuffer();
                infstr.append("      Instances of these dummy cells are in:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        String libName;
                        ni = nIt.next();
                        if (!ni.isCellInstance() || !dummyLibName.equals(libName = (subCell = (Cell)ni.getProto()).getVarValue(LibraryFiles.IO_TRUE_LIBRARY, String.class))) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
        }
        if (k != 0) {
            System.out.println("   (* means library has changed)");
        }
    }

    public static void renameCurrentTechnology() {
        Technology tech = Technology.getCurrent();
        String techName = tech.getTechName();
        String val = JOptionPane.showInputDialog("New Name of Technology " + techName + ":", (Object)techName);
        if (val == null) {
            return;
        }
        if (val.equals(techName)) {
            return;
        }
        new CircuitChangeJobs.RenameTechnology(tech, val);
    }

    public static void renameLibrary(Library lib) {
        String val = JOptionPane.showInputDialog("New Name of Library:", (Object)lib.getName());
        if (val == null) {
            return;
        }
        new CircuitChangeJobs.RenameLibrary(lib, val);
    }

    public static void checkAndRepairCommand(boolean repair) {
        new CircuitChangeJobs.CheckAndRepairJob(repair);
    }

    public static void findUnusedLibraryFiles() {
        HashMap<String, ArrayList<String>> directories = new HashMap<String, ArrayList<String>>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            ArrayList<String> filesInDir;
            String fileName;
            URL libFile;
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            String dirName = lib.getLibFile().getFile();
            File file = TextUtils.getFile(lib.getLibFile());
            if (file == null || (libFile = LibFile.getLibFile(fileName = file.getName())) != null && libFile.getFile().equals(dirName)) continue;
            int crop = dirName.lastIndexOf(fileName);
            if (crop > 0) {
                dirName = dirName.substring(0, crop);
            }
            if ((filesInDir = (ArrayList<String>)directories.get(dirName)) == null) {
                filesInDir = new ArrayList<String>();
                directories.put(dirName, filesInDir);
            }
            filesInDir.add(fileName);
        }
        if (directories.size() == 0) {
            System.out.println("Before running this command, you must read some libraries from disk.");
            System.out.println("The command will then examine the disk to see if there are other libraries that were not read in");
            return;
        }
        for (String dirName : directories.keySet()) {
            File dirFile = new File(dirName);
            boolean firstInDir = true;
            if (!dirFile.isDirectory()) continue;
            List filesInDir = (List)directories.get(dirName);
            String[] files = dirFile.list();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                String file = files[i].toLowerCase();
                if (!file.endsWith(".jelib") && !file.endsWith(".elib") && !file.endsWith(".delib") || filesInDir.contains(files[i])) continue;
                if (firstInDir) {
                    System.out.println("Directory " + dirName + " has these unused library files:");
                }
                firstInDir = false;
                System.out.println("   " + files[i]);
            }
        }
    }

    public static void removeUnusedLayers(Library lib) {
    }
}

