/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;

public class SmartSpiceOut
extends Simulate {
    SmartSpiceOut() {
    }

    protected void readSimulationOutput(Stimuli sd, URL fileURL, Cell cell) throws IOException {
        if (this.openBinaryInput(fileURL)) {
            return;
        }
        SmartSpiceOut.startProgressDialog("SmartSpice output", fileURL.getFile());
        this.readRawSmartSpiceFile(cell, sd);
        SmartSpiceOut.stopProgressDialog();
        this.closeInput();
    }

    private void readRawSmartSpiceFile(Cell cell, Stimuli sd) throws IOException {
        String line;
        boolean first = true;
        int signalCount = -1;
        String[] signalNames = null;
        int rowCount = -1;
        AnalogAnalysis an = null;
        double[][] values = null;
        block0: while ((line = this.getLineFromBinary()) != null) {
            int j;
            int colonPos;
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a SMARTSPICE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
            }
            if ((colonPos = line.indexOf(58)) < 0) continue;
            String keyWord = line.substring(0, colonPos);
            String restOfLine = line.substring(colonPos + 1).trim();
            if (keyWord.equals("No. Variables")) {
                signalCount = TextUtils.atoi(restOfLine) - 1;
                continue;
            }
            if (keyWord.equals("No. Points")) {
                rowCount = TextUtils.atoi(restOfLine);
                continue;
            }
            if (keyWord.equals("Variables")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                an = new AnalogAnalysis(sd, AnalogAnalysis.ANALYSIS_SIGNALS, false);
                sd.setCell(cell);
                signalNames = new String[signalCount];
                values = new double[signalCount][rowCount];
                for (int i = 0; i <= signalCount; ++i) {
                    int nameEnd;
                    int nameStart;
                    int indexOnLine;
                    if (i != 0) {
                        restOfLine = this.getLineFromBinary();
                        if (restOfLine == null) continue block0;
                        restOfLine = restOfLine.trim();
                    }
                    if ((indexOnLine = TextUtils.atoi(restOfLine)) != i) {
                        System.out.println("Warning: Variable " + i + " has number " + indexOnLine);
                    }
                    for (nameStart = 0; nameStart < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameStart)); ++nameStart) {
                    }
                    while (nameStart < restOfLine.length() && Character.isWhitespace(restOfLine.charAt(nameStart))) {
                        ++nameStart;
                    }
                    for (nameEnd = nameStart; nameEnd < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameEnd)); ++nameEnd) {
                    }
                    String name = restOfLine.substring(nameStart, nameEnd);
                    if (name.startsWith("v(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    }
                    if (i == 0) {
                        if (name.equals("time")) continue;
                        System.out.println("Warning: the first variable (the sweep variable) should be time, is '" + name + "'");
                        continue;
                    }
                    signalNames[i - 1] = name;
                }
                continue;
            }
            if (keyWord.equals("Values")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                if (rowCount < 0) {
                    System.out.println("Missing point count in file");
                    return;
                }
                an.buildCommonTime(rowCount);
                for (j = 0; j < rowCount && (line = this.getLineFromBinary()) != null; ++j) {
                    int spacePos;
                    if (TextUtils.atoi(line) != j) {
                        System.out.println("Warning: data point " + j + " has number " + TextUtils.atoi(line));
                    }
                    if ((spacePos = line.indexOf(32)) >= 0) {
                        line = line.substring(spacePos + 1);
                    }
                    double time = TextUtils.atof(line.trim());
                    an.setCommonTime(j, time);
                    for (int i = 0; i < signalCount && (line = this.getLineFromBinary()) != null; ++i) {
                        double value;
                        values[i][j] = value = TextUtils.atof(line.trim());
                    }
                }
            }
            if (!keyWord.equals("Binary")) continue;
            if (signalCount < 0) {
                System.out.println("Missing variable count in file");
                return;
            }
            if (rowCount < 0) {
                System.out.println("Missing point count in file");
                return;
            }
            an.buildCommonTime(rowCount);
            for (j = 0; j < rowCount; ++j) {
                long lval = this.dataInputStream.readLong();
                lval = Long.reverseBytes(lval);
                double time = Double.longBitsToDouble(lval);
                an.setCommonTime(j, time);
                for (int i = 0; i < signalCount; ++i) {
                    double value = 0.0;
                    lval = this.dataInputStream.readLong();
                    lval = Long.reverseBytes(lval);
                    values[i][j] = value = Double.longBitsToDouble(lval);
                }
            }
        }
        for (int i = 0; i < signalCount; ++i) {
            String name = signalNames[i];
            int lastDotPos = name.lastIndexOf(46);
            String context = null;
            if (lastDotPos >= 0) {
                context = name.substring(0, lastDotPos);
                name = name.substring(lastDotPos + 1);
            }
            an.addSignal((String)signalNames[i], context, values[i]);
        }
    }
}

