/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected1;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected1.Debug;
import com.sun.electric.tool.placement.forceDirected1.metric.BBMetric;
import com.sun.electric.tool.placement.forceDirected1.metrics.PAMetric;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementForceDirectedTeam5
extends PlacementFrame {
    public int maxRuntime = 60;
    public int numThreads = 4;
    public boolean printDebugInformation = true;
    Heuristic p;
    double overlapWeightingFactor;
    private List<PlacementFrame.PlacementNode> nodesToPlace;
    List<PlacementFrame.PlacementNetwork> allNetworks;
    private Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>> connectivityMap;
    Point2D.Double centerOfMass;
    private double[] forceX;
    private double[] forceY;
    double[][] cellCount;
    private double mirrorGain;
    public BBMetric bb;
    public BBMetric bbPartial;
    String teamName = "team 5";
    String studentName1 = "Thomas Hauck";
    String studentName2 = "Andreas Wagner";
    String algorithmType = "force directed";
    private Thread[] task;
    private WorkerThread[] worker;
    private CyclicBarrier barrier;
    private long timeoutStart;
    private long timeoutEnd;
    private long timeoutLevel;
    private Debug dbg = null;

    @Override
    public String getAlgorithmName() {
        return "Force-Directed-1";
    }

    public void setBenchmarkValues(int runtime, int threads, boolean debug) {
        this.maxRuntime = runtime;
        this.numThreads = threads;
        this.printDebugInformation = debug;
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, String cellName) {
        this.initTimeout(0);
        this.bb = new BBMetric();
        this.bbPartial = new BBMetric();
        this.dbg = new Debug();
        if (this.printDebugInformation) {
            this.bb.setBenchmarkValues(nodesToPlace, allNetworks);
            this.dbg.tick();
            this.dbg.tick();
        }
        this.nodesToPlace = nodesToPlace;
        this.allNetworks = allNetworks;
        this.p = new Heuristic(nodesToPlace);
        this.overlapWeightingFactor = 0.0;
        this.centerOfMass = new Point2D.Double();
        this.forceX = new double[nodesToPlace.size()];
        this.forceY = new double[nodesToPlace.size()];
        this.cellCount = new double[this.p.max_rows][this.p.max_rows];
        if (this.printDebugInformation) {
            this.dbg.println("=== FORCE-DIRECTED =====================");
        }
        this.buildConnectivityMap(allNetworks);
        this.randomPlaceDonut(this.p.donut_inner, this.p.donut_inner / 4.0);
        if (this.printDebugInformation) {
            this.dbg.tack("Initialization");
        }
        this.swapNodes();
        if (this.printDebugInformation) {
            this.dbg.println("Threads", this.numThreads);
            this.dbg.println("Nodes", nodesToPlace.size());
            this.dbg.tick();
        }
        this.initTimeout(1);
        this.startThreads();
        this.waitThreads();
        if (this.printDebugInformation) {
            this.dbg.tack("Phase1", true);
        }
        this.overlapWeightingFactor = 1.0;
        PAMetric chipArea = new PAMetric(nodesToPlace, allNetworks);
        boolean overlap = true;
        int i = 0;
        double whRatio = 1.0;
        this.calculateCenterOfMass();
        this.initTimeout(2);
        for (i = 0; overlap && i < this.p.max_resolve && this.checkTimeout(); ++i) {
            chipArea.compute();
            whRatio = chipArea.getWidth() / chipArea.getHeight();
            overlap = nodesToPlace.size() > 3000 || nodesToPlace.size() > 1000 && nodesToPlace.size() < 3000 && this.maxRuntime < 120 ? this.resolveOverlapsFast(this.overlapWeightingFactor, whRatio) : this.resolveOverlaps(this.overlapWeightingFactor, whRatio);
        }
        if (this.printDebugInformation) {
            this.dbg.println("Number of resolve Steps: " + i);
            this.dbg.tack("Phase2");
            this.dbg.println("=== after resolve Overlap ==============================");
            this.dbg.println(this.bb.toString());
        }
        this.initTimeout(3);
        this.iterativeFindOrientations(nodesToPlace);
        if (this.printDebugInformation) {
            this.dbg.println("=== after rotation/mirroring ======================");
            this.dbg.println(this.bb.toString());
        }
        this.initTimeout(4);
        this.fillEmptyBins();
        if (this.printDebugInformation) {
            this.dbg.println("=== after fillEmptyBins ======================");
            this.dbg.println(this.bb.toString());
        }
        this.initTimeout(5);
        this.shakeNodes();
        if (this.printDebugInformation) {
            this.dbg.println("=== after shakeNodes ======================");
            this.dbg.println(this.bb.toString());
            this.dbg.println("=== FINAL placement ======================");
            this.dbg.tack("Total");
            this.dbg.println(this.bb.toString());
            this.dbg.flush();
        }
    }

    private void calculateForces(int firstIndex, int lastIndex) {
        PlacementFrame.PlacementNode node1;
        int i;
        for (i = firstIndex; i <= lastIndex && this.checkTimeout(); ++i) {
            this.forceX[i] = 0.0;
            this.forceY[i] = 0.0;
            node1 = this.nodesToPlace.get(i);
            Map<PlacementFrame.PlacementNode, GenMath.MutableInteger> destMap = this.connectivityMap.get(node1);
            if (destMap == null) continue;
            for (Map.Entry<PlacementFrame.PlacementNode, GenMath.MutableInteger> srcEntry : destMap.entrySet()) {
                PlacementFrame.PlacementNode node2 = srcEntry.getKey();
                int n = i;
                this.forceX[n] = this.forceX[n] + (node2.getPlacementX() - node1.getPlacementX()) * (double)destMap.get(node2).intValue();
                int n2 = i;
                this.forceY[n2] = this.forceY[n2] + (node2.getPlacementY() - node1.getPlacementY()) * (double)destMap.get(node2).intValue();
            }
        }
        for (i = firstIndex; i <= lastIndex && this.checkTimeout(); ++i) {
            int y;
            node1 = this.nodesToPlace.get(i);
            int x = this.getCol(node1);
            if (!(this.cellCount[x][y = this.getRow(node1)] > this.p.areaPerCell)) continue;
            try {
                if (this.cellCount[x - 1][y] < this.p.areaPerCell) {
                    int n = i;
                    this.forceX[n] = this.forceX[n] - Math.min(5.0 * this.p.spread_force, this.cellCount[x][y] / this.p.areaPerCell * (-this.p.spread_force * this.cellCount[x - 1][y] / this.p.areaPerCell + this.p.spread_force));
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                if (this.cellCount[x + 1][y] < this.p.areaPerCell) {
                    int n = i;
                    this.forceX[n] = this.forceX[n] + Math.min(5.0 * this.p.spread_force, this.cellCount[x][y] / this.p.areaPerCell * (-this.p.spread_force * this.cellCount[x + 1][y] / this.p.areaPerCell + this.p.spread_force));
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                if (this.cellCount[x][y - 1] < this.p.areaPerCell) {
                    int n = i;
                    this.forceY[n] = this.forceY[n] - Math.min(5.0 * this.p.spread_force, this.cellCount[x][y] / this.p.areaPerCell * (-this.p.spread_force * this.cellCount[x][y - 1] / this.p.areaPerCell + this.p.spread_force));
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                if (!(this.cellCount[x][y + 1] < this.p.areaPerCell)) continue;
                int n = i;
                this.forceY[n] = this.forceY[n] + Math.min(5.0 * this.p.spread_force, this.cellCount[x][y] / this.p.areaPerCell * (-this.p.spread_force * this.cellCount[x][y + 1] / this.p.areaPerCell + this.p.spread_force));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
    }

    private void count() {
        for (int i = 0; i < this.p.max_rows; ++i) {
            for (int j = 0; j < this.p.max_rows; ++j) {
                this.cellCount[i][j] = 0.0;
            }
        }
        for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
            double[] dArray = this.cellCount[this.getCol(node)];
            int n = this.getRow(node);
            dArray[n] = dArray[n] + Math.min(this.p.areaPerCell, node.getHeight() * node.getWidth());
        }
    }

    int getCol(PlacementFrame.PlacementNode node) {
        int x = (int)(node.getPlacementX() * (double)this.p.max_rows / this.p.spread_length);
        if (x < 0) {
            x = 0;
        } else if (x >= this.p.max_rows) {
            x = this.p.max_rows - 1;
        }
        return x;
    }

    int getRow(PlacementFrame.PlacementNode node) {
        int y = (int)(node.getPlacementY() * (double)this.p.max_rows / this.p.spread_length);
        if (y < 0) {
            y = 0;
        } else if (y >= this.p.max_rows) {
            y = this.p.max_rows - 1;
        }
        return y;
    }

    private void moveCells(double weightingFactor) {
        int size = this.nodesToPlace.size();
        for (int i = 0; i < size; ++i) {
            PlacementFrame.PlacementNode node = this.nodesToPlace.get(i);
            node.setPlacement(node.getPlacementX() + this.forceX[i] * weightingFactor, node.getPlacementY() + this.forceY[i] * weightingFactor);
        }
    }

    private void calculateCenterOfMass() {
        double x = 0.0;
        double y = 0.0;
        double mass = 0.0;
        double totalMass = 0.0;
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            PlacementFrame.PlacementNode node = this.nodesToPlace.get(i);
            mass = node.getHeight() * node.getWidth();
            x += node.getPlacementX() * mass;
            y += node.getPlacementY() * mass;
            totalMass += mass;
        }
        this.centerOfMass.setLocation(x / totalMass, y / totalMass);
    }

    boolean resolveOverlaps(double overlapWeightingFactor, double shapeRatio) {
        boolean isOverlapping = false;
        Point2D.Double overlap = new Point2D.Double();
        double lowerBound = 0.6;
        double upperBound = 1.8;
        int size = this.nodesToPlace.size();
        for (int i = 0; i < size && this.checkTimeout(); ++i) {
            PlacementFrame.PlacementNode node1 = this.nodesToPlace.get(i);
            for (int j = i + 1; j < size && this.checkTimeout(); ++j) {
                PlacementFrame.PlacementNode node2 = this.nodesToPlace.get(j);
                if (this.getOverlap(node1, node2, overlap) == 0.0) continue;
                isOverlapping = true;
                double distNode1 = Math.abs(this.centerOfMass.x - node1.getPlacementX()) + Math.abs(this.centerOfMass.y - node1.getPlacementY());
                double distNode2 = Math.abs(this.centerOfMass.x - node2.getPlacementX()) + Math.abs(this.centerOfMass.y - node2.getPlacementY());
                double sigma1 = 0.0;
                double sigma2 = 0.0;
                if (distNode1 > distNode2) {
                    if (overlap.y / overlap.x > 0.6) {
                        sigma1 = (node1.getPlacementX() - this.centerOfMass.x) / distNode1;
                    }
                    if (overlap.y / overlap.x < 1.8) {
                        sigma2 = (node1.getPlacementY() - this.centerOfMass.y) / distNode1;
                    }
                    if (shapeRatio > 1.0) {
                        sigma1 *= 0.1;
                    } else if (shapeRatio < 1.0) {
                        sigma2 *= 0.1;
                    }
                    node1.setPlacement(node1.getPlacementX() + overlapWeightingFactor * sigma1 * this.p.W, node1.getPlacementY() + sigma2 * this.p.H);
                    continue;
                }
                if (overlap.y / overlap.x > 0.6) {
                    sigma1 = (node2.getPlacementX() - this.centerOfMass.x) / distNode2;
                }
                if (overlap.y / overlap.x < 1.8) {
                    sigma2 = (node2.getPlacementY() - this.centerOfMass.y) / distNode2;
                }
                if (shapeRatio > 1.0) {
                    sigma1 *= 0.1;
                } else if (shapeRatio < 1.0) {
                    sigma2 *= 0.1;
                }
                node2.setPlacement(node2.getPlacementX() + overlapWeightingFactor * sigma1 * this.p.W, node2.getPlacementY() + sigma2 * this.p.H);
            }
        }
        return isOverlapping;
    }

    boolean resolveOverlapsFast(double overlapWeightingFactor, double shapeRatio) {
        boolean isOverlapping = false;
        Point2D.Double overlap = new Point2D.Double();
        int size = this.nodesToPlace.size();
        for (int i = 0; i < size && this.checkTimeout(); ++i) {
            PlacementFrame.PlacementNode node1 = this.nodesToPlace.get(i);
            for (int j = i + 1; j < size && this.checkTimeout(); ++j) {
                double distNode2;
                PlacementFrame.PlacementNode node2 = this.nodesToPlace.get(j);
                if (this.getOverlap(node1, node2, overlap) == 0.0) continue;
                isOverlapping = true;
                double distNode1 = Math.abs(this.centerOfMass.x - node1.getPlacementX()) + Math.abs(this.centerOfMass.y - node1.getPlacementY());
                if (distNode1 > (distNode2 = Math.abs(this.centerOfMass.x - node2.getPlacementX()) + Math.abs(this.centerOfMass.y - node2.getPlacementY()))) {
                    if (Math.random() >= 0.5) {
                        node1.setPlacement(node1.getPlacementX() + 1.00001 * overlap.x * Math.signum(this.centerOfMass.x - node1.getPlacementX()), node1.getPlacementY());
                        continue;
                    }
                    node1.setPlacement(node1.getPlacementX(), node1.getPlacementY() + 1.00001 * overlap.y * Math.signum(this.centerOfMass.y - node1.getPlacementY()));
                    continue;
                }
                if (Math.random() >= 0.5) {
                    node2.setPlacement(node2.getPlacementX() + 1.00001 * overlap.x * Math.signum(this.centerOfMass.x - node2.getPlacementX()), node2.getPlacementY());
                    continue;
                }
                node2.setPlacement(node2.getPlacementX(), node2.getPlacementY() + 1.00001 * overlap.y * Math.signum(this.centerOfMass.y - node2.getPlacementY()));
            }
        }
        return isOverlapping;
    }

    private void randomPlaceDonut(double innerSize, double border) {
        Random rand = new Random(1L);
        for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
            double posY;
            double posX;
            do {
                posX = rand.nextDouble() * (2.0 * border + innerSize);
                posY = rand.nextDouble() * (2.0 * border + innerSize);
            } while (posX > border && posX < innerSize + border && posY > border && posY < innerSize + border);
            node.setPlacement(posX, posY);
        }
    }

    private double getMobilityFactor() {
        double avg = 0.0;
        double max = 0.0;
        double vectorLength = 0.0;
        int size = this.forceX.length;
        for (int i = 0; i < size; ++i) {
            vectorLength = Math.abs(this.forceX[i]) + Math.abs(this.forceY[i]);
            avg += vectorLength;
            if (!(vectorLength > max)) continue;
            max = vectorLength;
        }
        avg /= (double)this.forceX.length;
        if (max == 0.0) {
            max = 1.0;
        }
        return avg / (this.p.spread_slowdown * max);
    }

    private double getOverlap(PlacementFrame.PlacementNode node1, PlacementFrame.PlacementNode node2, Point2D.Double out) {
        double diffX = Math.abs(node1.getPlacementX() - node2.getPlacementX());
        double diffY = Math.abs(node1.getPlacementY() - node2.getPlacementY());
        double overlapX = Math.min(0.0, diffX - (node1.getWidth() + node2.getWidth()) / 2.0);
        double overlapY = Math.min(0.0, diffY - (node1.getHeight() + node2.getHeight()) / 2.0);
        out.setLocation(overlapX, overlapY);
        return overlapX * overlapY;
    }

    private void buildConnectivityMap(List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.connectivityMap = new HashMap<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>>();
        for (int i = 0; i < allNetworks.size(); ++i) {
            List<PlacementFrame.PlacementPort> currentPortList = allNetworks.get(i).getPortsOnNet();
            PlacementFrame.PlacementPort previousPlacementPort = null;
            for (int j = 0; j < currentPortList.size(); ++j) {
                PlacementFrame.PlacementPort currentPlacementPort = currentPortList.get(j);
                if (previousPlacementPort != null) {
                    this.incrementMap(previousPlacementPort.getPlacementNode(), currentPlacementPort.getPlacementNode());
                    this.incrementMap(currentPlacementPort.getPlacementNode(), previousPlacementPort.getPlacementNode());
                }
                previousPlacementPort = currentPlacementPort;
            }
        }
    }

    private void incrementMap(PlacementFrame.PlacementNode plNode1, PlacementFrame.PlacementNode plNode2) {
        GenMath.MutableInteger mi;
        Map<PlacementFrame.PlacementNode, GenMath.MutableInteger> destMap = this.connectivityMap.get(plNode1);
        if (destMap == null) {
            destMap = new HashMap<PlacementFrame.PlacementNode, GenMath.MutableInteger>();
            this.connectivityMap.put(plNode1, destMap);
        }
        if ((mi = destMap.get(plNode2)) == null) {
            mi = new GenMath.MutableInteger(0);
            destMap.put(plNode2, mi);
        }
        mi.increment();
    }

    private void startThreads() {
        this.task = new Thread[this.numThreads];
        this.worker = new WorkerThread[this.numThreads];
        this.barrier = new CyclicBarrier(this.numThreads, new JoinThread());
        int first = 0;
        int delta = this.nodesToPlace.size() / this.numThreads;
        for (int i = 0; i < this.numThreads; ++i) {
            if (i == this.numThreads - 1) {
                delta = this.nodesToPlace.size() - first;
            }
            this.worker[i] = new WorkerThread(first, first + delta - 1);
            this.task[i] = new Thread(this.worker[i]);
            this.task[i].start();
            first += delta;
        }
    }

    private void syncThreads() {
        try {
            this.barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    private void waitThreads() {
        for (Thread t : this.task) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.printDebugInformation) {
            for (int i = 0; i < this.numThreads; ++i) {
                this.worker[i].dbg.flush("=== THREAD-" + i + " ===========================");
                this.task[i] = null;
                this.worker[i] = null;
            }
            this.barrier = null;
        }
    }

    private void initTimeout(int phase) {
        switch (phase) {
            case 0: {
                this.timeoutStart = System.currentTimeMillis();
                this.timeoutEnd = this.timeoutStart + (long)(this.maxRuntime * 1000);
                this.timeoutLevel = this.timeoutStart + (long)((double)(this.maxRuntime * 1000) * 0.1);
                break;
            }
            case 1: {
                this.timeoutLevel = this.timeoutStart + (long)((double)(this.maxRuntime * 1000) * 0.5);
                break;
            }
            case 2: {
                this.timeoutLevel = this.timeoutStart + (long)((double)(this.maxRuntime * 1000) * 0.95);
                break;
            }
            case 3: {
                this.timeoutLevel = this.timeoutStart + (long)((double)(this.maxRuntime * 1000) * 0.55);
                break;
            }
            case 4: {
                this.timeoutLevel = this.timeoutStart + (long)((double)(this.maxRuntime * 1000) * 0.6);
                break;
            }
            case 5: {
                this.timeoutLevel = this.timeoutEnd;
            }
        }
    }

    private boolean checkTimeout() {
        return System.currentTimeMillis() < this.timeoutLevel;
    }

    public void setDebugger(Debug dbg) {
        this.dbg = dbg;
    }

    private void iterativeFindOrientations(List<PlacementFrame.PlacementNode> nodesToRotate) {
        if (!this.checkTimeout()) {
            return;
        }
        do {
            this.mirrorGain = 0.0;
            this.findOrientations(nodesToRotate);
        } while (this.mirrorGain > 0.0);
    }

    private void findOrientations(List<PlacementFrame.PlacementNode> nodesToRotate) {
        if (!this.checkTimeout()) {
            return;
        }
        for (int i = 0; i < nodesToRotate.size() && this.checkTimeout(); ++i) {
            PlacementFrame.PlacementNode currentNode = nodesToRotate.get(i);
            List<PlacementFrame.PlacementNetwork> currentNetworks = this.getNetworks(currentNode);
            this.bbPartial.setBenchmarkValues(this.nodesToPlace, currentNetworks);
            LinkedList<PlacementFrame.PlacementNetwork> connectedNetworks = new LinkedList<PlacementFrame.PlacementNetwork>();
            LinkedList<Point2D.Double> srcPoints = new LinkedList<Point2D.Double>();
            for (int j = 0; j < currentNode.getPorts().size(); ++j) {
                connectedNetworks.add(currentNode.getPorts().get(j).getPlacementNetwork());
                srcPoints.add(this.getAbsolutePositionOf(currentNode.getPorts().get(j)));
            }
            double lengthNoMirror = this.bbPartial.compute();
            int currentRotation = currentNode.getPlacementOrientation().getAngle();
            boolean isXMirrored = currentNode.getPlacementOrientation().isXMirrored();
            boolean isYMirrored = currentNode.getPlacementOrientation().isYMirrored();
            currentNode.setOrientation(Orientation.fromJava(currentRotation, !isXMirrored, isYMirrored));
            double lengthXMirror = this.bbPartial.compute();
            currentNode.setOrientation(Orientation.fromJava(currentRotation, isXMirrored, !isYMirrored));
            double lengthYMirror = this.bbPartial.compute();
            currentNode.setOrientation(Orientation.fromJava(currentRotation, !isXMirrored, !isYMirrored));
            double lengthXYMirror = this.bbPartial.compute();
            if (lengthNoMirror <= lengthXMirror && lengthNoMirror <= lengthYMirror && lengthNoMirror <= lengthXYMirror) {
                currentNode.setOrientation(Orientation.fromJava(currentRotation, isXMirrored, isYMirrored));
                continue;
            }
            if (lengthXMirror <= lengthNoMirror && lengthXMirror <= lengthYMirror && lengthXMirror <= lengthXYMirror) {
                currentNode.setOrientation(Orientation.fromJava(currentRotation, !isXMirrored, isYMirrored));
                this.mirrorGain += lengthNoMirror - lengthXMirror;
                continue;
            }
            if (lengthYMirror <= lengthNoMirror && lengthYMirror <= lengthXMirror && lengthYMirror <= lengthXYMirror) {
                currentNode.setOrientation(Orientation.fromJava(currentRotation, isXMirrored, !isYMirrored));
                this.mirrorGain += lengthNoMirror - lengthYMirror;
                continue;
            }
            this.mirrorGain += lengthNoMirror - lengthXYMirror;
        }
    }

    private void fillEmptyBins() {
        if (!this.checkTimeout()) {
            return;
        }
        ArrayList<Point2D.Double> emptyBins = new ArrayList<Point2D.Double>();
        for (int i = 0; i < this.cellCount.length; ++i) {
            for (int j = 0; j < this.cellCount.length; ++j) {
                if (this.cellCount[i][j] != 0.0) continue;
                emptyBins.add(new Point2D.Double(((double)i + 0.5) * Math.sqrt(this.p.areaPerCell), ((double)j + 0.5) * Math.sqrt(this.p.areaPerCell)));
            }
        }
        while (this.checkTimeout()) {
            int nodeNumber = (int)(Math.random() * (double)this.nodesToPlace.size());
            int destNumber = (int)(Math.random() * (double)emptyBins.size());
            List<PlacementFrame.PlacementNetwork> currentNetworks = this.getNetworks(this.nodesToPlace.get(nodeNumber));
            this.bbPartial.setBenchmarkValues(this.nodesToPlace, currentNetworks);
            double oldMetric = this.bbPartial.compute();
            PlacementFrame.PlacementNode currentNode = this.nodesToPlace.get(nodeNumber);
            double oldX = currentNode.getPlacementX();
            double oldY = currentNode.getPlacementY();
            currentNode.setPlacement(((Point2D.Double)emptyBins.get((int)destNumber)).x + Math.random() * Math.sqrt(this.p.areaPerCell), ((Point2D.Double)emptyBins.get((int)destNumber)).y + Math.random() * Math.sqrt(this.p.areaPerCell));
            double newMetric = this.bbPartial.compute();
            boolean overlap = false;
            for (int z = 0; z < this.nodesToPlace.size(); ++z) {
                if (z == nodeNumber || this.getOverlap(currentNode, this.nodesToPlace.get(z), new Point2D.Double(0.0, 0.0)) == 0.0) continue;
                overlap = true;
            }
            if (!(newMetric >= oldMetric) && !overlap) continue;
            currentNode.setPlacement(oldX, oldY);
        }
    }

    private void shakeNodes() {
        if (!this.checkTimeout()) {
            return;
        }
        while (this.checkTimeout()) {
            int nodeNumber = (int)(Math.random() * (double)this.nodesToPlace.size());
            List<PlacementFrame.PlacementNetwork> currentNetworks = this.getNetworks(this.nodesToPlace.get(nodeNumber));
            this.bbPartial.setBenchmarkValues(this.nodesToPlace, currentNetworks);
            double oldMetric = this.bbPartial.compute();
            PlacementFrame.PlacementNode currentNode = this.nodesToPlace.get(nodeNumber);
            double step = 1.0;
            boolean badMove = false;
            int randomDirection = (int)(Math.random() * 8.0);
            while (step >= 1.0) {
                double oldX = currentNode.getPlacementX();
                double oldY = currentNode.getPlacementY();
                switch (randomDirection) {
                    case 0: {
                        currentNode.setPlacement(oldX + step, oldY);
                        break;
                    }
                    case 1: {
                        currentNode.setPlacement(oldX - step, oldY);
                        break;
                    }
                    case 2: {
                        currentNode.setPlacement(oldX, oldY + step);
                        break;
                    }
                    case 3: {
                        currentNode.setPlacement(oldX, oldY - step);
                        break;
                    }
                    case 4: {
                        currentNode.setPlacement(oldX + step, oldY + step);
                        break;
                    }
                    case 5: {
                        currentNode.setPlacement(oldX + step, oldY - step);
                        break;
                    }
                    case 6: {
                        currentNode.setPlacement(oldX - step, oldY + step);
                        break;
                    }
                    case 7: {
                        currentNode.setPlacement(oldX - step, oldY - step);
                    }
                }
                double newMetric = this.bbPartial.compute();
                boolean overlap = false;
                for (int z = 0; z < this.nodesToPlace.size(); ++z) {
                    if (z == nodeNumber || this.getOverlap(currentNode, this.nodesToPlace.get(z), new Point2D.Double(0.0, 0.0)) == 0.0) continue;
                    overlap = true;
                }
                if (newMetric >= oldMetric || overlap) {
                    badMove = true;
                    currentNode.setPlacement(oldX, oldY);
                    step /= 2.0;
                    continue;
                }
                if (!badMove) {
                    step *= 2.0;
                }
                oldMetric = newMetric;
            }
        }
    }

    private void swapNodes() {
        if (!this.checkTimeout()) {
            return;
        }
        for (int i = 0; i < this.nodesToPlace.size() && this.checkTimeout(); ++i) {
            PlacementFrame.PlacementNode currentNode = this.nodesToPlace.get(i);
            double oldX1 = currentNode.getPlacementX();
            double oldY1 = currentNode.getPlacementY();
            for (int j = i + 1; j < this.nodesToPlace.size() && this.checkTimeout(); ++j) {
                PlacementFrame.PlacementNode swapNode = this.nodesToPlace.get(j);
                List<PlacementFrame.PlacementNetwork> currentNetworks = this.getNetworks(currentNode, swapNode);
                this.bbPartial.setBenchmarkValues(this.nodesToPlace, currentNetworks);
                double oldMetric = this.bbPartial.compute();
                double oldX2 = swapNode.getPlacementX();
                double oldY2 = swapNode.getPlacementY();
                currentNode.setPlacement(oldX2, oldY2);
                swapNode.setPlacement(oldX1, oldY1);
                double newMetric = this.bbPartial.compute();
                if (newMetric < oldMetric) continue;
                currentNode.setPlacement(oldX1, oldY1);
                swapNode.setPlacement(oldX2, oldY2);
            }
        }
    }

    private List<PlacementFrame.PlacementNetwork> getNetworks(PlacementFrame.PlacementNode node) {
        HashSet<PlacementFrame.PlacementNetwork> set = new HashSet<PlacementFrame.PlacementNetwork>();
        for (PlacementFrame.PlacementPort p : node.getPorts()) {
            if (p.getPlacementNetwork() == null) continue;
            set.add(p.getPlacementNetwork());
        }
        ArrayList<PlacementFrame.PlacementNetwork> result = new ArrayList<PlacementFrame.PlacementNetwork>();
        result.addAll(set);
        return result;
    }

    private List<PlacementFrame.PlacementNetwork> getNetworks(PlacementFrame.PlacementNode node1, PlacementFrame.PlacementNode node2) {
        HashSet<PlacementFrame.PlacementNetwork> set = new HashSet<PlacementFrame.PlacementNetwork>();
        for (PlacementFrame.PlacementPort p : node1.getPorts()) {
            if (p.getPlacementNetwork() == null) continue;
            set.add(p.getPlacementNetwork());
        }
        for (PlacementFrame.PlacementPort p : node2.getPorts()) {
            if (p.getPlacementNetwork() == null) continue;
            set.add(p.getPlacementNetwork());
        }
        ArrayList<PlacementFrame.PlacementNetwork> result = new ArrayList<PlacementFrame.PlacementNetwork>();
        result.addAll(set);
        return result;
    }

    private Point2D.Double getAbsolutePositionOf(PlacementFrame.PlacementPort placementPort) {
        return new Point2D.Double(placementPort.getRotatedOffX() + placementPort.getPlacementNode().getPlacementX(), placementPort.getRotatedOffY() + placementPort.getPlacementNode().getPlacementY());
    }

    private class JoinThread
    implements Runnable {
        private JoinThread() {
        }

        public void run() {
            PlacementForceDirectedTeam5.this.count();
            PlacementForceDirectedTeam5.this.moveCells(PlacementForceDirectedTeam5.this.getMobilityFactor());
        }
    }

    private class WorkerThread
    implements Runnable {
        private int firstIndex;
        private int lastIndex;
        public Debug dbg = new Debug();

        public WorkerThread(int firstNode, int lastNode) {
            this.firstIndex = firstNode;
            this.lastIndex = lastNode;
        }

        public void run() {
            for (int i = 0; i < PlacementForceDirectedTeam5.this.p.max_iterations && PlacementForceDirectedTeam5.this.checkTimeout(); ++i) {
                PlacementForceDirectedTeam5.this.calculateForces(this.firstIndex, this.lastIndex);
                PlacementForceDirectedTeam5.this.syncThreads();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Heuristic {
        public int max_iterations = 2000;
        public int max_resolve = 5000;
        public int max_rows = 15;
        public double donut_inner = 2500.0;
        public double spread_length = 3750.0;
        public double spread_force = 400.0;
        public double spread_slowdown = 20.0;
        public double W;
        public double H;
        public double totalArea;
        public double areaPerCell;

        public Heuristic(List<PlacementFrame.PlacementNode> nodesToPlace) {
            this.calculateStatistics(nodesToPlace);
            this.heuristic1(nodesToPlace);
        }

        private void heuristic1(List<PlacementFrame.PlacementNode> nodesToPlace) {
            int nodes = nodesToPlace.size();
            this.max_rows = (int)(16.0 + Math.sqrt((double)nodes / 5.3));
            this.donut_inner = Math.sqrt(this.totalArea);
            this.spread_length = 1.5 * this.donut_inner;
            this.spread_slowdown = 5.0;
            if (this.totalArea < 200.0) {
                this.spread_force = 40.0;
            }
            if (nodesToPlace.size() > 500) {
                this.spread_force = 2500.0;
            }
            if (nodesToPlace.size() > 2000) {
                this.spread_force = 8000.0;
            }
            if (PlacementForceDirectedTeam5.this.printDebugInformation) {
                System.out.println("Heuristic3: max_rows=" + this.max_rows);
                System.out.println("total Area: " + this.totalArea);
            }
        }

        private void calculateStatistics(List<PlacementFrame.PlacementNode> nodesToPlace) {
            this.getMinDimensions(nodesToPlace);
            this.totalArea = this.getTotalArea(nodesToPlace);
            this.areaPerCell = this.totalArea / (double)(this.max_rows * this.max_rows);
        }

        private double getTotalArea(List<PlacementFrame.PlacementNode> nodesToPlace) {
            double area = 0.0;
            for (int i = 0; i < nodesToPlace.size(); ++i) {
                area += nodesToPlace.get(i).getWidth() * nodesToPlace.get(i).getHeight();
            }
            return area;
        }

        private void getMinDimensions(List<PlacementFrame.PlacementNode> nodesToPlace) {
            this.W = Double.MAX_VALUE;
            this.H = Double.MAX_VALUE;
            for (PlacementFrame.PlacementNode node : nodesToPlace) {
                if (node.getWidth() > 0.0) {
                    this.W = Math.min(node.getWidth(), this.W);
                }
                if (!(node.getHeight() > 0.0)) continue;
                this.H = Math.min(node.getHeight(), this.H);
            }
        }
    }
}

