/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class IconParameters
implements Serializable {
    int inputSide = 0;
    int outputSide = 1;
    int bidirSide = 2;
    int pwrSide = 3;
    int gndSide = 3;
    int clkSide = 0;
    int topRot = 0;
    int bottomRot = 0;
    int leftRot = 0;
    int rightRot = 0;

    public static IconParameters makeInstance(boolean userDefaults) {
        return new IconParameters(userDefaults);
    }

    private IconParameters(boolean userDefaults) {
        if (userDefaults) {
            this.initFromUserDefaults();
        }
    }

    public void initFromUserDefaults() {
        this.inputSide = User.getIconGenInputSide();
        this.outputSide = User.getIconGenOutputSide();
        this.bidirSide = User.getIconGenBidirSide();
        this.pwrSide = User.getIconGenPowerSide();
        this.gndSide = User.getIconGenGroundSide();
        this.clkSide = User.getIconGenClockSide();
        this.topRot = User.getIconGenTopRot();
        this.bottomRot = User.getIconGenBottomRot();
        this.leftRot = User.getIconGenLeftRot();
        this.rightRot = User.getIconGenRightRot();
    }

    public Cell makeIconForCell(Cell curCell) throws JobException {
        double ySize;
        double xSize;
        EditingPreferences ep = curCell.getEditingPreferences();
        String iconCellName = curCell.getName() + "{ic}";
        Cell iconCell = Cell.makeInstance(curCell.getLibrary(), iconCellName);
        if (iconCell == null) {
            throw new JobException("Cannot create Icon cell " + iconCellName);
        }
        iconCell.setWantExpanded();
        int leftSide = 0;
        int rightSide = 0;
        int bottomSide = 0;
        int topSide = 0;
        HashMap<Export, Integer> portIndex = new HashMap<Export, Integer>();
        HashMap<Export, Integer> portSide = new HashMap<Export, Integer>();
        HashMap<Export, Integer> portRotation = new HashMap<Export, Integer>();
        ArrayList<Export> exportList = new ArrayList<Export>();
        Iterator<PortProto> it = curCell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (pp.isBodyOnly()) continue;
            exportList.add(pp);
        }
        ep.getClass();
        if (false) {
            Export pp;
            int i;
            int i2;
            Collections.sort(exportList, new ExportsByAngle());
            int numExports = exportList.size();
            topSide = bottomSide = numExports / 4;
            rightSide = bottomSide;
            leftSide = bottomSide;
            if (leftSide + rightSide + topSide + bottomSide < numExports) {
                ++leftSide;
            }
            if (leftSide + rightSide + topSide + bottomSide < numExports) {
                ++rightSide;
            }
            if (leftSide + rightSide + topSide + bottomSide < numExports) {
                ++topSide;
            }
            HashMap<Export, EPoint> portCenters = new HashMap<Export, EPoint>();
            for (int i3 = 0; i3 < numExports; ++i3) {
                Export pp2 = (Export)exportList.get(i3);
                portCenters.put(pp2, pp2.getOriginalPort().getCenter());
            }
            ERectangle bounds = curCell.getBounds();
            Point2D.Double leftPoint = new Point2D.Double(bounds.getCenterX() - bounds.getWidth(), bounds.getCenterY());
            Point2D.Double rightPoint = new Point2D.Double(bounds.getCenterX() + bounds.getWidth(), bounds.getCenterY());
            Point2D.Double topPoint = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY() + bounds.getWidth());
            Point2D.Double bottomPoint = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY() - bounds.getWidth());
            Point2D[] sidePoints = new Point2D[numExports];
            int fill = 0;
            for (i2 = 0; i2 < leftSide; ++i2) {
                sidePoints[fill++] = leftPoint;
            }
            for (i2 = 0; i2 < topSide; ++i2) {
                sidePoints[fill++] = topPoint;
            }
            for (i2 = 0; i2 < rightSide; ++i2) {
                sidePoints[fill++] = rightPoint;
            }
            for (i2 = 0; i2 < bottomSide; ++i2) {
                sidePoints[fill++] = bottomPoint;
            }
            double[] totDist = new double[numExports];
            for (int i4 = 0; i4 < numExports; ++i4) {
                totDist[i4] = 0.0;
                for (int j = 0; j < numExports; ++j) {
                    Point2D ppCtr = (Point2D)portCenters.get(exportList.get((j + i4) % numExports));
                    double dist = ppCtr.distance(sidePoints[j]);
                    int n = i4;
                    totDist[n] = totDist[n] + dist;
                }
            }
            double bestDist = Double.MAX_VALUE;
            int bestIndex = -1;
            for (i = 0; i < numExports; ++i) {
                if (!(totDist[i] < bestDist)) continue;
                bestDist = totDist[i];
                bestIndex = i;
            }
            for (i = 0; i < leftSide; ++i) {
                pp = (Export)exportList.get((i + bestIndex) % numExports);
                portSide.put(pp, new Integer(0));
                portIndex.put(pp, new Integer(leftSide - i - 1));
                portRotation.put(pp, new Integer(this.leftRot));
            }
            for (i = 0; i < topSide; ++i) {
                pp = (Export)exportList.get((i + leftSide + bestIndex) % numExports);
                portSide.put(pp, new Integer(2));
                portIndex.put(pp, new Integer(topSide - i - 1));
                portRotation.put(pp, new Integer(this.topRot));
            }
            for (i = 0; i < rightSide; ++i) {
                pp = (Export)exportList.get((i + leftSide + topSide + bestIndex) % numExports);
                portSide.put(pp, new Integer(1));
                portIndex.put(pp, new Integer(i));
                portRotation.put(pp, new Integer(this.rightRot));
            }
            for (i = 0; i < bottomSide; ++i) {
                pp = (Export)exportList.get((i + leftSide + topSide + rightSide + bestIndex) % numExports);
                portSide.put(pp, new Integer(3));
                portIndex.put(pp, new Integer(i));
                portRotation.put(pp, new Integer(this.bottomRot));
            }
        } else {
            ep.getClass();
            for (Export pp : exportList) {
                int index = this.iconPosition(pp);
                portSide.put(pp, new Integer(index));
                switch (index) {
                    case 0: {
                        portIndex.put(pp, new Integer(leftSide++));
                        break;
                    }
                    case 1: {
                        portIndex.put(pp, new Integer(rightSide++));
                        break;
                    }
                    case 2: {
                        portIndex.put(pp, new Integer(topSide++));
                        break;
                    }
                    case 3: {
                        portIndex.put(pp, new Integer(bottomSide++));
                    }
                }
                int rotation = ViewChanges.iconTextRotation(pp);
                portRotation.put(pp, new Integer(rotation));
            }
        }
        ep.getClass();
        if (false) {
            ep.getClass();
            xSize = curCell.getDefWidth();
            ySize = curCell.getDefHeight();
        } else {
            double d = Math.max(Math.max(leftSide, rightSide), 5);
            ep.getClass();
            ySize = d * 2.0;
            double d2 = Math.max(Math.max(topSide, bottomSide), 3);
            ep.getClass();
            xSize = d2 * 2.0;
        }
        NodeInst bbNi = null;
        ep.getClass();
        bbNi = NodeInst.newInstance(Artwork.tech().openedThickerPolygonNode, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
        if (bbNi == null) {
            return null;
        }
        Point2D[] boxOutline = new EPoint[5];
        ep.getClass();
        if (false) {
            ep.getClass();
            boxOutline[0] = new EPoint(curCell.getBounds().getMinX(), curCell.getBounds().getMinY());
            boxOutline[1] = new EPoint(curCell.getBounds().getMinX(), curCell.getBounds().getMaxY());
            boxOutline[2] = new EPoint(curCell.getBounds().getMaxX(), curCell.getBounds().getMaxY());
            boxOutline[3] = new EPoint(curCell.getBounds().getMaxX(), curCell.getBounds().getMinY());
            boxOutline[4] = new EPoint(curCell.getBounds().getMinX(), curCell.getBounds().getMinY());
        } else {
            boxOutline[0] = new EPoint(-xSize / 2.0, -ySize / 2.0);
            boxOutline[1] = new EPoint(-xSize / 2.0, ySize / 2.0);
            boxOutline[2] = new EPoint(xSize / 2.0, ySize / 2.0);
            boxOutline[3] = new EPoint(xSize / 2.0, -ySize / 2.0);
            boxOutline[4] = new EPoint(-xSize / 2.0, -ySize / 2.0);
        }
        bbNi.setTrace(boxOutline);
        TextDescriptor textDescriptor = TextDescriptor.getAnnotationTextDescriptor();
        ep.getClass();
        TextDescriptor td = textDescriptor.withRelSize(2.0);
        bbNi.newVar(Schematics.SCHEM_FUNCTION, (Object)curCell.getName(), td);
        int total = 0;
        for (Export pp : exportList) {
            int rotation;
            int portPosition = (Integer)portIndex.get(pp);
            int index = (Integer)portSide.get(pp);
            ep.getClass();
            double spacing = 2.0;
            double xPos = 0.0;
            double yPos = 0.0;
            double xBBPos = 0.0;
            double yBBPos = 0.0;
            ep.getClass();
            if (false) {
                ep.getClass();
                xBBPos = xPos = pp.getOriginalPort().getCenter().getX();
                yBBPos = yPos = pp.getOriginalPort().getCenter().getY();
            } else {
                switch (index) {
                    case 0: {
                        xBBPos = -xSize / 2.0;
                        ep.getClass();
                        xPos = xBBPos - 2.0;
                        if (leftSide * 2 < rightSide) {
                            ep.getClass();
                            spacing = 2.0 * 2.0;
                        }
                        yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(leftSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        break;
                    }
                    case 1: {
                        xBBPos = xSize / 2.0;
                        ep.getClass();
                        xPos = xBBPos + 2.0;
                        if (rightSide * 2 < leftSide) {
                            ep.getClass();
                            spacing = 2.0 * 2.0;
                        }
                        yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(rightSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        break;
                    }
                    case 2: {
                        if (topSide * 2 < bottomSide) {
                            ep.getClass();
                            spacing = 2.0 * 2.0;
                        }
                        xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(topSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        yBBPos = ySize / 2.0;
                        ep.getClass();
                        yPos = yBBPos + 2.0;
                        break;
                    }
                    case 3: {
                        if (bottomSide * 2 < topSide) {
                            ep.getClass();
                            spacing = 2.0 * 2.0;
                        }
                        xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(bottomSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        yBBPos = -ySize / 2.0;
                        ep.getClass();
                        yPos = yBBPos - 2.0;
                    }
                }
            }
            if (!IconParameters.makeIconExport(pp, index, xPos, yPos, xBBPos, yBBPos, iconCell, rotation = ((Integer)portRotation.get(pp)).intValue())) continue;
            ++total;
        }
        ep.getClass();
        return iconCell;
    }

    private int iconPosition(Export pp) {
        PortCharacteristic character = pp.getCharacteristic();
        if (pp.isPower()) {
            character = PortCharacteristic.PWR;
        }
        if (pp.isGround()) {
            character = PortCharacteristic.GND;
        }
        if (character == PortCharacteristic.IN) {
            return this.inputSide;
        }
        if (character == PortCharacteristic.OUT) {
            return this.outputSide;
        }
        if (character == PortCharacteristic.BIDIR) {
            return this.bidirSide;
        }
        if (character == PortCharacteristic.PWR) {
            return this.pwrSide;
        }
        if (character == PortCharacteristic.GND) {
            return this.gndSide;
        }
        if (character.isClock()) {
            return this.clkSide;
        }
        return this.inputSide;
    }

    public static boolean makeIconExport(Export pp, int index, double xPos, double yPos, double xBBPos, double yBBPos, Cell np, int textRotation) {
        PortInst tail;
        PortInst head;
        ArcInst ai;
        double hei;
        double wid;
        NodeInst ni;
        EditingPreferences ep = pp.getEditingPreferences();
        PrimitiveNode pinType = Generic.tech().universalPinNode;
        double pinSizeX = 0.0;
        double pinSizeY = 0.0;
        ep.getClass();
        if (true) {
            pinType = Schematics.tech().busPinNode;
            pinSizeX = pinType.getDefWidth();
            pinSizeY = pinType.getDefHeight();
        }
        ArcProto wireType = Schematics.tech().wire_arc;
        if (pp.getBasePort().connectsTo(Schematics.tech().bus_arc) && pp.getNameKey().isBus()) {
            wireType = Schematics.tech().bus_arc;
            pinType = Schematics.tech().busPinNode;
            pinSizeX = pinType.getDefWidth();
            pinSizeY = pinType.getDefHeight();
        }
        ep.getClass();
        NodeInst pinNi = NodeInst.newInstance(pinType, new Point2D.Double(xPos, yPos), pinSizeX, pinSizeY, np);
        if (pinNi == null) {
            return false;
        }
        PortInst pi = pinNi.getOnlyPortInst();
        Export port = Export.newInstance(np, pi, pp.getName(), pp.getCharacteristic(), null);
        if (port != null) {
            TextDescriptor td = port.getTextDescriptor(Export.EXPORT_NAME);
            if (textRotation != 0) {
                td = td.withRotation(AbstractTextDescriptor.Rotation.getRotationAt(textRotation));
            }
            ep.getClass();
            block0 : switch (0) {
                case 0: {
                    td = td.withPos(AbstractTextDescriptor.Position.CENT);
                    break;
                }
                case 1: {
                    switch (index) {
                        case 0: {
                            td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                            break;
                        }
                        case 1: {
                            td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                            break;
                        }
                        case 2: {
                            td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                            break;
                        }
                        case 3: {
                            td = td.withPos(AbstractTextDescriptor.Position.UP);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (index) {
                        case 0: {
                            td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                            break block0;
                        }
                        case 1: {
                            td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                            break block0;
                        }
                        case 2: {
                            td = td.withPos(AbstractTextDescriptor.Position.UP);
                            break block0;
                        }
                        case 3: {
                            td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                        }
                    }
                }
            }
            port.setTextDescriptor(Export.EXPORT_NAME, td);
            double xOffset = 0.0;
            double yOffset = 0.0;
            ep.getClass();
            int loc = 1;
            ep.getClass();
            switch (loc) {
                case 0: {
                    xOffset = xBBPos - xPos;
                    yOffset = yBBPos - yPos;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    xOffset = (xPos + xBBPos) / 2.0 - xPos;
                    yOffset = (yPos + yBBPos) / 2.0 - yPos;
                }
            }
            port.setOff(Export.EXPORT_NAME, xOffset, yOffset);
            ep.getClass();
            port.setAlwaysDrawn(false);
            port.copyVarsFrom(pp);
        }
        ep.getClass();
        pinType = wireType.findPinProto();
        if (pinType == Schematics.tech().busPinNode) {
            pinType = Generic.tech().invisiblePinNode;
        }
        if ((ni = NodeInst.newInstance(pinType, new Point2D.Double(xBBPos, yBBPos), wid = pinType.getDefWidth(), hei = pinType.getDefHeight(), np)) != null && (ai = ArcInst.makeInstance(wireType, head = ni.getOnlyPortInst(), tail = pinNi.getOnlyPortInst(), new Point2D.Double(xBBPos, yBBPos), new Point2D.Double(xPos, yPos), null)) != null && wireType == Schematics.tech().bus_arc) {
            ai.setHeadExtended(false);
            ai.setTailExtended(false);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExportsByAngle
    implements Comparator<Export> {
        private ExportsByAngle() {
        }

        @Override
        public int compare(Export p1, Export p2) {
            double angle2;
            Cell cell = p1.getParent();
            ERectangle bounds = cell.getBounds();
            Point2D.Double cellCtr = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            EPoint p1Ctr = p1.getOriginalPort().getCenter();
            EPoint p2Ctr = p2.getOriginalPort().getCenter();
            double angle1 = DBMath.figureAngleRadians(cellCtr, p1Ctr);
            if (angle1 < (angle2 = DBMath.figureAngleRadians(cellCtr, p2Ctr))) {
                return 1;
            }
            if (angle1 > angle2) {
                return -1;
            }
            return 0;
        }
    }
}

