/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.LayerId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerCoverageTool
extends Tool {
    protected static LayerCoverageTool tool = new LayerCoverageTool();

    private LayerCoverageTool() {
        super("coverage");
    }

    public static LayerCoverageTool getLayerCoverageTool() {
        return tool;
    }

    public static List<Object> layerCoverageCommand(LCMode func, GeometryHandler.GHMode mode, Cell curCell, boolean startJob, LayerCoveragePreferences lcp) {
        Job.Type jobType = func == LCMode.MERGE || func == LCMode.IMPLANT ? Job.Type.CHANGE : Job.Type.SERVER_EXAMINE;
        LayerCoverageJob job = new LayerCoverageJob(curCell, jobType, func, mode, null, null, lcp);
        if (!startJob) {
            try {
                job.doIt();
            }
            catch (Exception e) {
                // empty catch block
            }
            return job.nodesAdded;
        }
        job.startJob();
        return null;
    }

    public static Map<Layer, Double> layerCoverageCommand(Cell cell, GeometryHandler.GHMode mode, boolean startJob, LayerCoveragePreferences lcp) {
        if (cell == null) {
            return null;
        }
        double techScale = cell.getTechnology().getScale();
        double width = lcp.widthInMicrons / techScale;
        double height = lcp.heightInMicrons / techScale;
        double deltaX = lcp.deltaXInMicrons / techScale;
        double deltaY = lcp.deltaYInMicrons / techScale;
        ERectangle bbox = cell.getBounds();
        if (width > ((RectangularShape)bbox).getWidth()) {
            width = ((RectangularShape)bbox).getWidth();
        }
        if (height > ((RectangularShape)bbox).getHeight()) {
            height = ((RectangularShape)bbox).getHeight();
        }
        Map<Layer, Double> map2 = null;
        AreaCoverageJob job = new AreaCoverageJob(cell, mode, width, height, deltaX, deltaY, lcp);
        if (startJob) {
            job.startJob();
        } else {
            try {
                job.doIt();
                map2 = job.getDataInfo();
            }
            catch (JobException e) {
                // empty catch block
            }
        }
        return map2;
    }

    public static Rectangle2D getGeometryOnNetwork(Cell exportCell, PortInst pi, Layer layer, LayerCoveragePreferences lcp) {
        Netlist netlist = exportCell.getNetlist();
        Network net = netlist.getNetwork(pi);
        HashSet<Network> nets = new HashSet<Network>();
        nets.add(net);
        GeometryOnNetwork geoms = new GeometryOnNetwork(exportCell, nets, 1.0, false, layer, lcp);
        Rectangle2D bnd = pi.getBounds();
        LayerCoverageJob job = new LayerCoverageJob(exportCell, Job.Type.SERVER_EXAMINE, LCMode.NETWORK, GeometryHandler.GHMode.ALGO_SWEEP, geoms, new Point2D.Double(bnd.getX(), bnd.getY()), lcp);
        try {
            job.doIt();
        }
        catch (JobException e) {
            e.printStackTrace();
        }
        List list2 = job.nodesAdded;
        Rectangle2D rect = null;
        if (list2.size() != 1) {
            System.out.println("Problem here");
        } else {
            PolyBase poly = (PolyBase)list2.toArray()[0];
            rect = poly.getBounds2D();
        }
        return rect;
    }

    public static GeometryOnNetwork listGeometryOnNetworks(Cell cell, Set<Network> nets, boolean startJob, GeometryHandler.GHMode mode, LayerCoveragePreferences lcp) {
        if (cell == null || nets == null || nets.isEmpty()) {
            return null;
        }
        double lambda = 1.0;
        GeometryOnNetwork geoms = new GeometryOnNetwork(cell, nets, lambda, startJob, null, lcp);
        LayerCoverageJob job = new LayerCoverageJob(cell, Job.Type.SERVER_EXAMINE, LCMode.NETWORK, mode, geoms, null, lcp);
        if (startJob) {
            job.startJob();
        } else {
            try {
                ((Job)job).doIt();
            }
            catch (JobException e) {
                // empty catch block
            }
        }
        return geoms;
    }

    public static boolean testAll() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeometryOnNetwork
    implements Serializable {
        public final Cell cell;
        protected Set<Network> nets;
        private double lambda;
        private boolean printable;
        private Layer onlyThisLayer;
        private ArrayList<Layer> layers;
        private ArrayList<Double> areas;
        private ArrayList<Double> halfPerimeters;
        private double totalWire;
        private double totalArea;
        private LayerCoveragePreferences lcp;
        TransistorInfo p_gate;
        TransistorInfo n_gate;
        TransistorInfo p_active;
        TransistorInfo n_active;

        public GeometryOnNetwork(Cell cell, Set<Network> nets, double lambda, boolean printable, Layer onlyThisLayer, LayerCoveragePreferences lcp) {
            this.lcp = lcp;
            this.cell = cell;
            this.nets = nets;
            this.lambda = lambda;
            this.onlyThisLayer = onlyThisLayer;
            this.layers = new ArrayList();
            this.areas = new ArrayList();
            this.halfPerimeters = new ArrayList();
            this.printable = printable;
            this.totalWire = 0.0;
            this.totalArea = 0.0;
            this.p_gate = new TransistorInfo();
            this.n_gate = new TransistorInfo();
            this.p_active = new TransistorInfo();
            this.n_active = new TransistorInfo();
        }

        public double getTotalWireLength() {
            return this.totalWire;
        }

        protected void setTotalArea(double area) {
            this.totalArea = area;
        }

        public TransistorInfo getPGate() {
            return this.p_gate;
        }

        public TransistorInfo getNGate() {
            return this.n_gate;
        }

        public TransistorInfo getPActive() {
            return this.p_active;
        }

        public TransistorInfo getNActive() {
            return this.n_active;
        }

        public List<Layer> getLayers() {
            return this.layers;
        }

        public List<Double> getAreas() {
            return this.areas;
        }

        public List<Double> getHalfPerimeters() {
            return this.halfPerimeters;
        }

        private void addLayer(Layer layer, double area, double halfperimeter) {
            assert (layer != null);
            if (this.onlyThisLayer != null && layer != this.onlyThisLayer) {
                return;
            }
            this.layers.add(layer);
            this.areas.add(new Double(area));
            this.halfPerimeters.add(new Double(halfperimeter));
            Layer.Function func = layer.getFunction();
            if (func.isPoly() && !func.isGatePoly() || func.isMetal()) {
                this.totalWire += halfperimeter;
            }
        }

        public boolean analyzeCoverage(Rectangle2D bbox, ErrorLogger errorLogger) {
            this.totalArea = bbox.getHeight() * bbox.getWidth() / (this.lambda * this.lambda);
            boolean foundError = false;
            for (int i = 0; i < this.layers.size(); ++i) {
                double minV;
                Layer layer = this.layers.get(i);
                Double area = this.areas.get(i);
                double percentage = area / this.totalArea * 100.0;
                if (!(percentage < (minV = this.lcp.getAreaCoverage(layer)))) continue;
                String msg = "Error area coverage " + layer.getName() + " min value = " + minV + " actual value = " + percentage;
                PolyBase poly = new PolyBase(bbox);
                errorLogger.logError(msg, poly, this.cell, layer.getIndex());
                foundError = true;
            }
            return foundError;
        }

        public void print() {
            if (!this.printable) {
                return;
            }
            if (this.nets != null) {
                for (Network net : this.nets) {
                    System.out.println("For " + net + " in " + this.cell + ":");
                }
            }
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = this.layers.get(i);
                double area = this.areas.get(i);
                double halfperim = this.halfPerimeters.get(i);
                System.out.println("\tLayer " + layer.getName() + ":\t area " + TextUtils.formatDouble(area) + "(" + TextUtils.formatDouble(area / this.totalArea * 100.0) + "%)" + "\t half-perimeter " + TextUtils.formatDouble(halfperim) + "\t ratio " + TextUtils.formatDouble(area / halfperim));
            }
            if (this.totalWire > 0.0) {
                System.out.println("Total wire length = " + TextUtils.formatDouble(this.totalWire / this.lambda));
            }
            if (this.totalArea > 0.0) {
                System.out.println("Total cell area = " + TextUtils.formatDouble(this.totalArea));
            }
        }
    }

    public static class TransistorInfo
    implements Serializable {
        public double area;
        public double width;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LayerVisitor
    extends HierarchyEnumerator.Visitor {
        private Job parentJob;
        private GeometryHandler tree;
        private Set<NodeInst> deleteList;
        private final LCMode function;
        private Map<Layer, Set<PolyBase>> originalPolygons;
        private Set<Network> netSet;
        private Rectangle2D origBBox;
        private Area origBBoxArea;
        private Layer onlyThisLayer;
        private GeometryOnNetwork geoms;

        public LayerVisitor(Job job, GeometryHandler t, Set<NodeInst> delList, LCMode func, Map<Layer, Set<PolyBase>> original, Set<Network> netSet, Rectangle2D bBox, Layer onlyThisLayer, GeometryOnNetwork geoms) {
            this.parentJob = job;
            this.tree = t;
            this.deleteList = delList;
            this.function = func;
            this.originalPolygons = original;
            this.netSet = netSet;
            this.origBBox = bBox;
            this.origBBoxArea = bBox != null ? new Area(this.origBBox) : null;
            this.onlyThisLayer = onlyThisLayer;
            this.geoms = geoms;
        }

        private boolean isValidFunction(Layer layer, LCMode function) {
            if (this.onlyThisLayer != null && layer != this.onlyThisLayer) {
                return false;
            }
            Layer.Function func = layer.getFunction();
            switch (function) {
                case MERGE: 
                case NETWORK: {
                    return true;
                }
                case IMPLANT: {
                    return func.isSubstrate();
                }
                case AREA: {
                    return func.isPoly() || func.isMetal();
                }
            }
            return false;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        private boolean doesIntersectBoundingBox(Rectangle2D rect, HierarchyEnumerator.CellInfo info) {
            if (this.origBBox == null) {
                return true;
            }
            PolyBase polyRect = new PolyBase(rect);
            polyRect.transform(info.getTransformToRoot());
            rect = polyRect.getBounds2D();
            return rect.intersects(this.origBBox);
        }

        private boolean isJobAborted() {
            return this.parentJob != null && this.parentJob.checkAbort();
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.isJobAborted()) {
                return false;
            }
            Cell curCell = info.getCell();
            Netlist netlist = info.getNetlist();
            if (!this.doesIntersectBoundingBox(curCell.getBounds(), info)) {
                return false;
            }
            boolean found = this.netSet == null;
            Iterator<Comparable> it = netlist.getNetworks();
            while (!found && it.hasNext()) {
                if (this.isJobAborted()) {
                    return false;
                }
                Network parentNet = (Network)it.next();
                HierarchyEnumerator.CellInfo cinfo = info;
                boolean netFound = false;
                while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                    parentNet = cinfo.getNetworkInParent(parentNet);
                    cinfo = cinfo.getParentInfo();
                }
                found = netFound;
            }
            if (!found) {
                return false;
            }
            it = curCell.getArcs();
            while (it.hasNext()) {
                Poly[] polyList;
                ArcInst arc = (ArcInst)it.next();
                int width = netlist.getBusWidth(arc);
                found = this.netSet == null;
                for (int i = 0; !found && i < width; ++i) {
                    Network parentNet = netlist.getNetwork(arc, i);
                    HierarchyEnumerator.CellInfo cinfo = info;
                    boolean netFound = false;
                    while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                        parentNet = cinfo.getNetworkInParent(parentNet);
                        cinfo = cinfo.getParentInfo();
                    }
                    found = netFound;
                }
                if (!found) continue;
                ArcProto arcType = arc.getProto();
                Technology tech = arcType.getTechnology();
                for (Poly poly : polyList = tech.getShapeOfArc(arc)) {
                    Layer layer = poly.getLayer();
                    boolean value2 = this.isValidFunction(layer, this.function);
                    if (!value2) continue;
                    poly.transform(info.getTransformToRoot());
                    poly.roundPoints();
                    this.storeOriginalPolygons(layer, poly);
                    Shape pnode = LayerVisitor.cropGeometry(poly, this.origBBoxArea);
                    if (pnode == null) continue;
                    this.tree.add(layer, pnode);
                }
            }
            return true;
        }

        private void storeOriginalPolygons(Layer layer, PolyBase poly) {
            if (this.function != LCMode.IMPLANT) {
                return;
            }
            Set<PolyBase> polySet = this.originalPolygons.get(layer);
            if (polySet == null) {
                polySet = new HashSet<PolyBase>();
                this.originalPolygons.put(layer, polySet);
            }
            polySet.add(poly);
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            PrimitiveNode.Function fun;
            if (this.isJobAborted()) {
                return false;
            }
            NodeInst node = no.getNodeInst();
            if (NodeInst.isSpecialNode(node)) {
                return false;
            }
            boolean inside = this.doesIntersectBoundingBox(node.getBounds(), info);
            if (node.isCellInstance()) {
                return inside;
            }
            if (!inside) {
                return false;
            }
            if (node.isPrimtiveSubstrateNode()) {
                if (info.isRootCell()) {
                    this.deleteList.add(node);
                }
                return false;
            }
            Technology tech = node.getProto().getTechnology();
            Poly[] polyList = tech.getShapeOfNode(node, true, false, null);
            AffineTransform transform2 = node.rotateOut();
            boolean includedNode = false;
            for (int i = 0; i < polyList.length; ++i) {
                Poly poly = polyList[i];
                if (this.netSet != null) {
                    PortProto subPP = poly.getPort();
                    Network parentNet = info.getNetlist().getNetwork(node, subPP, 0);
                    HierarchyEnumerator.CellInfo cinfo = info;
                    boolean netFound = false;
                    while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                        parentNet = cinfo.getNetworkInParent(parentNet);
                        cinfo = cinfo.getParentInfo();
                    }
                    if (!netFound) continue;
                }
                includedNode = true;
                Layer layer = poly.getLayer();
                boolean value2 = this.isValidFunction(layer, this.function);
                if (!value2 || poly.getPoints().length < 3) continue;
                poly.transform(transform2);
                poly.transform(info.getTransformToRoot());
                poly.roundPoints();
                this.storeOriginalPolygons(layer, poly);
                Shape pnode = LayerVisitor.cropGeometry(poly, this.origBBoxArea);
                if (pnode == null) continue;
                this.tree.add(layer, pnode);
            }
            if (includedNode && this.geoms != null && (fun = node.getFunction()).isTransistor()) {
                TransistorSize ts;
                if (fun.isNTypeTransistor()) {
                    ts = node.getTransistorSize(info.getContext());
                    this.geoms.n_active.area += ts.getDoubleArea();
                    this.geoms.n_active.width += ts.getDoubleWidth();
                    this.geoms.n_gate.area += ts.getDoubleArea();
                    this.geoms.n_gate.width += ts.getDoubleWidth();
                } else if (fun.isPTypeTransistor()) {
                    ts = node.getTransistorSize(info.getContext());
                    this.geoms.p_active.area += ts.getDoubleArea();
                    this.geoms.p_active.width += ts.getDoubleWidth();
                    this.geoms.p_gate.area += ts.getDoubleArea();
                    this.geoms.p_gate.width += ts.getDoubleWidth();
                }
            }
            return true;
        }

        private static Shape cropGeometry(Shape origGeom, Area bBoxArea) {
            Shape pnode = origGeom;
            if (bBoxArea != null) {
                Area tmpA = new Area(pnode);
                tmpA.intersect(bBoxArea);
                if (tmpA.isEmpty()) {
                    return null;
                }
                pnode = tmpA;
            }
            return pnode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LCMode {
        AREA,
        MERGE,
        IMPLANT,
        NETWORK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AreaCoverageJob
    extends Job {
        private Cell curCell;
        private double deltaX;
        private double deltaY;
        private double width;
        private double height;
        private GeometryHandler.GHMode mode;
        private Map<Layer, Double> internalMap;
        private LayerCoveragePreferences lcp;

        public AreaCoverageJob(Cell cell, GeometryHandler.GHMode mode, double width, double height, double deltaX, double deltaY, LayerCoveragePreferences lcp) {
            super("Layer Coverage", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.mode = mode;
            this.width = width;
            this.height = height;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.lcp = lcp;
            this.setReportExecutionFlag(true);
        }

        @Override
        public boolean doIt() throws JobException {
            ErrorLogger errorLogger = ErrorLogger.newInstance("Area Coverage");
            ERectangle bBoxOrig = this.curCell.getBounds();
            double maxY = ((RectangularShape)bBoxOrig).getMaxY();
            double maxX = ((RectangularShape)bBoxOrig).getMaxX();
            if (this.deltaX <= 0.0) {
                this.deltaX = ((RectangularShape)bBoxOrig).getWidth();
            }
            if (this.deltaY <= 0.0) {
                this.deltaY = ((RectangularShape)bBoxOrig).getHeight();
            }
            if (this.width <= 0.0) {
                this.width = ((RectangularShape)bBoxOrig).getWidth();
            }
            if (this.height <= 0.0) {
                this.height = ((RectangularShape)bBoxOrig).getHeight();
            }
            this.internalMap = new HashMap<Layer, Double>();
            for (double posY = bBoxOrig.getMinY(); posY < maxY; posY += this.deltaY) {
                for (double posX = bBoxOrig.getMinX(); posX < maxX; posX += this.deltaX) {
                    Rectangle2D.Double box = new Rectangle2D.Double(posX, posY, this.width, this.height);
                    GeometryOnNetwork geoms = new GeometryOnNetwork(this.curCell, null, 1.0, true, null, this.lcp);
                    System.out.println("Calculating Coverage on cell '" + this.curCell.getName() + "' for area (" + DBMath.round(posX) + "," + DBMath.round(posY) + ") (" + DBMath.round(box.getMaxX()) + "," + DBMath.round(box.getMaxY()) + ")");
                    LayerCoverageData data2 = new LayerCoverageData(this, this.curCell, LCMode.AREA, this.mode, geoms, box, null, this.lcp);
                    if (!data2.doIt()) {
                        return false;
                    }
                    geoms.analyzeCoverage(box, errorLogger);
                    for (int i = 0; i < geoms.layers.size(); ++i) {
                        Layer layer = (Layer)geoms.layers.get(i);
                        Double area = (Double)geoms.areas.get(i);
                        Double oldV = this.internalMap.get(layer);
                        double newV = area;
                        if (oldV != null) {
                            newV += oldV.doubleValue();
                        }
                        this.internalMap.put(layer, new Double(newV));
                    }
                }
            }
            errorLogger.termLogging(true);
            return true;
        }

        public Map<Layer, Double> getDataInfo() {
            return this.internalMap;
        }
    }

    private static class LayerCoverageJob
    extends Job {
        private Cell cell;
        private LCMode func;
        private GeometryHandler.GHMode mode;
        private GeometryOnNetwork geoms;
        private List<Object> nodesAdded;
        private Point2D overlapPoint;
        private LayerCoveragePreferences lcp;

        public LayerCoverageJob(Cell cell, Job.Type jobType, LCMode func, GeometryHandler.GHMode mode, GeometryOnNetwork geoms, Point2D overlapPoint, LayerCoveragePreferences lcp) {
            super("Layer Coverage on " + cell, User.getUserTool(), jobType, null, null, Job.Priority.USER);
            this.cell = cell;
            this.func = func;
            this.mode = mode;
            this.geoms = geoms;
            this.overlapPoint = overlapPoint;
            this.lcp = lcp;
            this.setReportExecutionFlag(true);
        }

        public boolean doIt() throws JobException {
            LayerCoverageData data2 = new LayerCoverageData(this, this.cell, this.func, this.mode, this.geoms, null, this.overlapPoint, this.lcp);
            boolean done = data2.doIt();
            if (this.func == LCMode.IMPLANT || this.func == LCMode.NETWORK && this.geoms != null) {
                this.nodesAdded = new ArrayList<Object>();
                this.nodesAdded.addAll(data2.getNodesToHighlight());
                if (this.func == LCMode.IMPLANT) {
                    this.fieldVariableChanged("nodesAdded");
                }
            }
            return done;
        }

        public void terminateOK() {
            if (this.func == LCMode.IMPLANT) {
                EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
                if (wnd == null) {
                    return;
                }
                if (this.nodesAdded == null) {
                    return;
                }
                for (Object node : this.nodesAdded) {
                    wnd.addElectricObject((NodeInst)node, this.cell);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerCoverageData {
        private Cell curCell;
        private Job parentJob;
        private LCMode function;
        private GeometryHandler.GHMode mode;
        private GeometryOnNetwork geoms;
        private Rectangle2D bBox;
        private List<Object> nodesToExamine = new ArrayList<Object>();
        private Point2D overlapPoint;

        LayerCoverageData(Job parentJob, Cell cell, LCMode func, GeometryHandler.GHMode mode, GeometryOnNetwork geoms, Rectangle2D bBox, Point2D overlapPoint, LayerCoveragePreferences lcp) {
            this.parentJob = parentJob;
            this.curCell = cell;
            this.mode = mode;
            this.function = func;
            this.geoms = geoms;
            this.bBox = bBox;
            this.overlapPoint = overlapPoint;
            if (func == LCMode.AREA && this.geoms == null) {
                this.geoms = new GeometryOnNetwork(this.curCell, null, 1.0, true, null, lcp);
            }
        }

        List<Object> getNodesToHighlight() {
            return this.nodesToExamine;
        }

        boolean doIt() {
            GeometryHandler tree = GeometryHandler.createGeometryHandler(this.mode, this.curCell.getTechnology().getNumLayers());
            HashMap<Layer, Set<PolyBase>> originalPolygons = new HashMap<Layer, Set<PolyBase>>();
            HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
            Set<Network> netSet = null;
            Layer onlyThisLayer = null;
            Netlist.ShortResistors shortResistors = Netlist.ShortResistors.NO;
            if (this.geoms != null) {
                netSet = this.geoms.nets;
                if (this.geoms.nets != null && !this.geoms.nets.isEmpty()) {
                    Iterator<Network> nIt = this.geoms.nets.iterator();
                    shortResistors = nIt.next().getNetlist().getShortResistors();
                    while (nIt.hasNext()) {
                        Netlist.ShortResistors sh = nIt.next().getNetlist().getShortResistors();
                        if (sh == shortResistors) continue;
                        throw new IllegalArgumentException("shortResistors");
                    }
                }
                onlyThisLayer = this.geoms.onlyThisLayer;
            }
            LayerVisitor visitor = new LayerVisitor(this.parentJob, tree, nodesToDelete, this.function, originalPolygons, netSet, this.bBox, onlyThisLayer, this.geoms);
            HierarchyEnumerator.enumerateCell(this.curCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor, shortResistors);
            tree.postProcess(true);
            switch (this.function) {
                case MERGE: 
                case IMPLANT: {
                    boolean noNewNodes = true;
                    boolean isMerge = this.function == LCMode.MERGE;
                    for (Layer layer : tree.getKeySet()) {
                        Collection<PolyBase> set = tree.getObjects(layer, !isMerge, true);
                        Object[] polyArray = null;
                        if (this.function == LCMode.IMPLANT) {
                            Set polySet = (Set)originalPolygons.get(layer);
                            polyArray = polySet.toArray();
                        }
                        ArrayList<Rectangle2D> newImplants = new ArrayList<Rectangle2D>();
                        for (PolyBase polyB : set) {
                            Point2D[] points = polyB.getPoints();
                            Rectangle2D rect = polyB.getBounds2D();
                            if (isMerge) {
                                if (polyArray != null) {
                                    Object poly;
                                    boolean foundOrigPoly = false;
                                    Object[] arr$ = polyArray;
                                    int len$ = arr$.length;
                                    for (int i$ = 0; i$ < len$ && !(foundOrigPoly = polyB.polySame((PolyBase)(poly = arr$[i$]))); ++i$) {
                                    }
                                    if (foundOrigPoly) continue;
                                }
                                Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                                PrimitiveNode priNode = layer.getPureLayerNode();
                                NodeInst node = NodeInst.makeInstance(priNode, center, rect.getWidth(), rect.getHeight(), this.curCell);
                                this.nodesToExamine.add(node);
                                Point2D[] ePoints = new EPoint[points.length];
                                for (int j = 0; j < points.length; ++j) {
                                    ePoints[j] = new EPoint(points[j].getX(), points[j].getY());
                                }
                                node.setTrace(ePoints);
                            } else {
                                newImplants.add(rect);
                            }
                            noNewNodes = false;
                        }
                        if (this.function != LCMode.IMPLANT) continue;
                        DRCTemplate rule = DRC.getSpacingRule(layer, null, layer, null, false, -1, 10.0, 100.0);
                        if (rule != null) {
                            double dist = rule.getValue(0);
                            for (int i = 0; i < newImplants.size(); ++i) {
                                Rectangle2D r = (Rectangle2D)newImplants.get(i);
                                boolean merged = false;
                                for (int j = i + 1; j < newImplants.size(); ++j) {
                                    Rectangle2D oR = (Rectangle2D)newImplants.get(j);
                                    if (r.getMinX() - dist > oR.getMaxX() || oR.getMinX() - dist > r.getMaxX() || r.getMinY() - dist > oR.getMaxY() || oR.getMinY() - dist > r.getMaxY()) continue;
                                    double lx = Math.min(r.getMinX(), oR.getMinX());
                                    double hx = Math.max(r.getMaxX(), oR.getMaxX());
                                    double ly = Math.min(r.getMinY(), oR.getMinY());
                                    double hy = Math.max(r.getMaxY(), oR.getMaxY());
                                    r.setRect(lx, ly, hx - lx, hy - ly);
                                    newImplants.remove(j);
                                    merged = true;
                                    break;
                                }
                                if (!merged) continue;
                                --i;
                            }
                        }
                        PrimitiveNode priNode = layer.getPureLayerNode();
                        for (Rectangle2D r : newImplants) {
                            if (polyArray != null) {
                                Object poly;
                                PolyBase pb;
                                Rectangle2D pbRect;
                                boolean covered = false;
                                Object[] arr$ = polyArray;
                                int len$ = arr$.length;
                                for (int i$ = 0; !(i$ >= len$ || (pbRect = (pb = (PolyBase)(poly = arr$[i$])).getBox()) != null && (covered = pbRect.contains(r))); ++i$) {
                                }
                                if (covered) continue;
                            }
                            Point2D.Double center = new Point2D.Double(r.getCenterX(), r.getCenterY());
                            NodeInst node = NodeInst.makeInstance(priNode, center, r.getWidth(), r.getHeight(), this.curCell);
                            this.nodesToExamine.add(node);
                            node.setHardSelect();
                        }
                    }
                    this.curCell.killNodes(nodesToDelete);
                    if (!noNewNodes) break;
                    System.out.println("No new areas added");
                    break;
                }
                case AREA: 
                case NETWORK: {
                    double lambdaSqr = 1.0;
                    ERectangle bbox = this.curCell.getBounds();
                    double totalArea = ((RectangularShape)bbox).getHeight() * ((RectangularShape)bbox).getWidth() / lambdaSqr;
                    ArrayList<Layer> list2 = new ArrayList<Layer>(tree.getKeySet());
                    Collections.sort(list2, Layer.layerSortByName);
                    for (Layer layer : list2) {
                        Collection<PolyBase> set = tree.getObjects(layer, false, true);
                        if (this.geoms != null && this.geoms.onlyThisLayer != null) {
                            if (layer != this.geoms.onlyThisLayer) continue;
                            if (this.overlapPoint == null) {
                                this.nodesToExamine.addAll(set);
                            } else {
                                for (PolyBase p : set) {
                                    if (!p.contains(this.overlapPoint)) continue;
                                    this.nodesToExamine.add(p);
                                }
                            }
                        }
                        double layerArea = 0.0;
                        double perimeter = 0.0;
                        for (PolyBase poly : set) {
                            layerArea += poly.getArea();
                            perimeter += poly.getPerimeter();
                        }
                        layerArea /= lambdaSqr;
                        perimeter /= 2.0;
                        if (this.geoms != null) {
                            this.geoms.addLayer(layer, layerArea, perimeter);
                            continue;
                        }
                        System.out.println("Layer " + layer.getName() + " covers " + TextUtils.formatDouble(layerArea) + " square lambda (" + TextUtils.formatDouble(layerArea / totalArea * 100.0) + "%)");
                    }
                    this.geoms.setTotalArea(totalArea);
                    if (this.geoms != null) {
                        this.geoms.print();
                        break;
                    }
                    System.out.println("Cell is " + TextUtils.formatDouble(totalArea) + " square lambda");
                    break;
                }
                default: {
                    System.out.println("Error in LayerCoverage: function not implemented");
                }
            }
            return true;
        }
    }

    public static class LayerCoveragePreferences
    extends PrefPackage {
        public static final double DEFAULT_AREA_COVERAGE = 10.0;
        private static final double defaultSize = 50000.0;
        private static final String EXTRACT_NODE = "tool/extract";
        private static final String KEY_COVERAGE = "AreaCoverageJobOf";
        private final transient TechPool techPool;
        public Map<LayerId, Double> areaCoverage = new HashMap<LayerId, Double>();
        @PrefPackage.DoublePref(node="tool/extract", key="DeltaX", factory=50000.0)
        public double deltaXInMicrons;
        @PrefPackage.DoublePref(node="tool/extract", key="DeltaY", factory=50000.0)
        public double deltaYInMicrons;
        @PrefPackage.DoublePref(node="tool/extract", key="Width", factory=50000.0)
        public double widthInMicrons;
        @PrefPackage.DoublePref(node="tool/extract", key="Height", factory=50000.0)
        public double heightInMicrons;
        public SeaOfGates.SeaOfGatesOptions seaIfGatesPrefs;

        public LayerCoveragePreferences(boolean factory) {
            this(factory, TechPool.getThreadTechPool());
            this.seaIfGatesPrefs = new SeaOfGates.SeaOfGatesOptions();
            if (!factory) {
                this.seaIfGatesPrefs.getOptionsFromPreferences();
            }
        }

        private LayerCoveragePreferences(boolean factory, TechPool techPool) {
            super(factory);
            this.techPool = techPool;
            if (factory) {
                return;
            }
            Preferences techPrefs = LayerCoveragePreferences.getPrefRoot().node("technology/technologies");
            for (Technology tech : techPool.values()) {
                Iterator<Layer> it = tech.getLayers();
                while (it.hasNext()) {
                    Layer layer = it.next();
                    LayerId layerId = layer.getId();
                    double factoryValue = 10.0;
                    double value2 = techPrefs.getDouble(this.getKey(KEY_COVERAGE, layerId), factoryValue);
                    if (value2 == factoryValue) continue;
                    this.areaCoverage.put(layerId, value2);
                }
            }
        }

        public void putPrefs(Preferences prefRoot, boolean removeDefaults) {
            super.putPrefs(prefRoot, removeDefaults);
            Preferences techPrefs = prefRoot.node("technology/technologies");
            for (Technology tech : this.techPool.values()) {
                Iterator<Layer> it = tech.getLayers();
                while (it.hasNext()) {
                    double value2;
                    Layer layer = it.next();
                    LayerId layerId = layer.getId();
                    String key = this.getKey(KEY_COVERAGE, layerId);
                    double factoryValue = 10.0;
                    Double valueObj = this.areaCoverage.get(layerId);
                    double d = value2 = valueObj != null ? valueObj : factoryValue;
                    if (removeDefaults && value2 == factoryValue) {
                        techPrefs.remove(key);
                        continue;
                    }
                    techPrefs.putDouble(key, value2);
                }
            }
        }

        public double getAreaCoverage(Layer layer) {
            Double valueObj = this.areaCoverage.get(layer.getId());
            return valueObj != null ? valueObj : 10.0;
        }

        public void setAreaCoverageInfo(Layer layer, double area) {
            if (area == 10.0) {
                this.areaCoverage.remove(layer.getId());
            } else {
                this.areaCoverage.put(layer.getId(), area);
            }
        }

        public void reset() {
            this.areaCoverage.clear();
            this.heightInMicrons = 50000.0;
            this.widthInMicrons = 50000.0;
            this.deltaYInMicrons = 50000.0;
            this.deltaXInMicrons = 50000.0;
        }
    }
}

