/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.bookshelf;

import com.sun.electric.tool.io.input.bookshelf.BookshelfInputParser;
import com.sun.electric.tool.io.input.bookshelf.BookshelfNodes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookshelfWeights
implements BookshelfInputParser<Void> {
    private String nodesFile;

    public BookshelfWeights(String nodesFile) {
        this.nodesFile = nodesFile;
    }

    @Override
    public Void parse() throws IOException {
        String line;
        BufferedReader rin;
        try {
            File file = new File(this.nodesFile);
            FileReader freader = new FileReader(file);
            rin = new BufferedReader(freader);
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: Cannot find Bookshelf Weights file: " + this.nodesFile);
            return null;
        }
        while ((line = rin.readLine()) != null) {
            if (!line.startsWith("   ")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int i = 0;
            String node = null;
            int weight = 1;
            while (tokenizer.hasMoreElements()) {
                if (i == 0) {
                    node = tokenizer.nextToken();
                } else if (i == 1) {
                    weight = Integer.parseInt(tokenizer.nextToken());
                } else {
                    tokenizer.nextToken();
                }
                ++i;
            }
            BookshelfNodes.BookshelfNode bn = BookshelfNodes.BookshelfNode.findNode(node);
            if (bn == null) continue;
            bn.setWeight(weight);
        }
        return null;
    }
}

