/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subcircuit
extends Part {
    private final int[] pinCoeffs;
    private final Map<Wire, Integer> wireToCoeffSum;
    private final SubcircuitInfo subcircuitInfo;

    private String getPortName(int i) {
        return this.subcircuitInfo.getPortName(i);
    }

    private Map<Wire, Integer> computeWireToCoeffSum(Wire[] pins, int[] coeffs) {
        HashMap<Wire, Integer> wireToCoeffs = new HashMap<Wire, Integer>();
        for (int i = 0; i < pins.length; ++i) {
            Wire w = pins[i];
            int coeff = this.pinCoeffs[i];
            Integer coeffSum = (Integer)wireToCoeffs.get(w);
            if (coeffSum == null) {
                coeffSum = new Integer(0);
            }
            coeffSum = coeffSum + coeff;
            wireToCoeffs.put(w, coeffSum);
        }
        return wireToCoeffs;
    }

    @Override
    public String valueDescription() {
        return "";
    }

    @Override
    public int[] getPinCoeffs() {
        return this.pinCoeffs;
    }

    @Override
    public boolean parallelMerge(Part p, NccOptions nccOpt) {
        Job.error(true, "we never parallel merge subcircuits so don't call this method");
        return false;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        Job.error(true, "we never parallel merge subcircuits so don't call this method");
        int hc = this.pins.length;
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.pinCoeffs[i];
        }
        hc += this.getClass().hashCode();
        return new Integer(hc += this.subcircuitInfo.getID());
    }

    @Override
    public String typeString() {
        return this.subcircuitInfo.getName();
    }

    @Override
    public int typeCode() {
        return this.type().ordinal() + (this.subcircuitInfo.getID() << Part.TYPE_FIELD_WIDTH);
    }

    @Override
    public PinType getPinTypeOfNthPin(int n) {
        PinType[] pinTypes = this.subcircuitInfo.getPinTypes();
        return pinTypes[n];
    }

    @Override
    public String connectionDescription(Wire w) {
        String msg = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (msg.length() != 0) {
                msg = msg + ',';
            }
            msg = msg + this.getPortName(i);
        }
        return msg;
    }

    @Override
    public String connectionDescription(int maxCon) {
        String msg = "";
        for (int i = 0; i < maxCon && i < this.pins.length; ++i) {
            if (msg.length() != 0) {
                msg = msg + " ";
            }
            msg = msg + this.getPortName(i) + "=" + this.pins[i].getName();
        }
        return msg;
    }

    @Override
    public int getHashFor(Wire w) {
        Integer coeffSum = this.wireToCoeffSum.get(w);
        Job.error(coeffSum == null, "Wire not found");
        return coeffSum * this.getCode();
    }

    public Subcircuit(NccNameProxy.PartNameProxy instName, SubcircuitInfo subcircuitInfo, Wire[] pins) {
        super(instName, PrimitiveNode.Function.UNKNOWN, pins);
        this.subcircuitInfo = subcircuitInfo;
        this.pinCoeffs = subcircuitInfo.getPortCoeffs();
        this.wireToCoeffSum = this.computeWireToCoeffSum(pins, this.pinCoeffs);
    }

    public static class SubcircuitPinType
    implements PinType {
        private int typeCode;
        private int portIndex;
        private String description;

        public SubcircuitPinType(int typeCode, int portIndex, String description) {
            this.typeCode = typeCode;
            this.portIndex = portIndex;
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }
}

