/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore3;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore3.BenchmarkRouter;
import com.sun.electric.tool.routing.experimentalLeeMoore3.CouldNotCalculateVirtualTerminalException;
import com.sun.electric.tool.routing.experimentalLeeMoore3.DataGrid;
import com.sun.electric.tool.routing.experimentalLeeMoore3.DistanceRatingFunction;
import com.sun.electric.tool.routing.experimentalLeeMoore3.ForcedDirectionRatingFunction;
import com.sun.electric.tool.routing.experimentalLeeMoore3.Gridpoint;
import com.sun.electric.tool.routing.experimentalLeeMoore3.OutOfBoundsRatingFunction;
import com.sun.electric.tool.routing.experimentalLeeMoore3.Rating;
import com.sun.electric.tool.routing.experimentalLeeMoore3.RatingFunction;
import com.sun.electric.tool.routing.experimentalLeeMoore3.RatingNotFoundException;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RoutingFrameLeeMoore
extends BenchmarkRouter {
    private static final boolean DEBUG = false;
    private static final boolean PARALLEL = true;
    static final boolean GLOBALDETAILEDROUTING = false;
    private Cell cell;
    private Rectangle2D cellBounds;
    private RoutingFrame.RoutingLayer[] metalLayers;
    private int numMetalLayers;
    private double globalGridGranularity;
    private double detailedGridGranularity;
    private Wavefront dummyDetailedWavefront;
    private MetalVias[] metalVias;
    private Map<RoutingFrame.RoutingLayer, RTNode> metalBlockages;
    private Map<RoutingFrame.RoutingLayer, RTNode> viaBlockages;
    RatingFunction[] ratingFunctionsForDetailed = new RatingFunction[]{new DistanceRatingFunction(), new OutOfBoundsRatingFunction(), new ForcedDirectionRatingFunction()};
    RatingFunction[] ratingFunctionsForGlobal = new RatingFunction[]{new DistanceRatingFunction(), new OutOfBoundsRatingFunction(), new ForcedDirectionRatingFunction()};
    private ThreadPoolExecutor workerThreadsExecutor;
    private ArrayBlockingQueue<Runnable> inQueue;
    private ArrayBlockingQueue<Wavefront> outQueue;

    @Override
    public String getAlgorithmName() {
        return "Lee/Moore - 3";
    }

    @Override
    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        if (this.maxRuntime.getTempIntValue() <= 0) {
            this.maxRuntime.setTempIntValue(800);
        }
        long timeStart = System.currentTimeMillis();
        int maxPoolSize = this.numThreads.getTempIntValue();
        maxPoolSize = maxPoolSize > 0 ? maxPoolSize : 4;
        int poolSize = maxPoolSize > 1 ? maxPoolSize / 2 : 1;
        long keepAliveTime = 10L;
        this.inQueue = new ArrayBlockingQueue(40);
        this.outQueue = new ArrayBlockingQueue(40);
        this.workerThreadsExecutor = new ThreadPoolExecutor(poolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, this.inQueue);
        Job.getUserInterface().startProgressDialog("Collect startup information", null);
        Job.getUserInterface().setProgressNote("Initialize design roules");
        if (this.initializeDesignRules(allLayers, allContacts)) {
            return;
        }
        Job.getUserInterface().setProgressNote("Set up data structures");
        this.cell = cell;
        this.cellBounds = this.cell.getBounds();
        double x2 = this.cellBounds.getMaxX() - this.cellBounds.getMinX();
        double y = this.cellBounds.getMaxY() - this.cellBounds.getMinY();
        this.globalGridGranularity = 1.0 / ((x2 < y ? x2 : y) / 32.0);
        this.detailedGridGranularity = this.globalGridGranularity * 32.0;
        this.dummyDetailedWavefront = new Wavefront(segmentsToRoute.get(0), this.detailedGridGranularity, this.cellBounds, this.ratingFunctionsForDetailed, false);
        this.metalBlockages = new HashMap<RoutingFrame.RoutingLayer, RTNode>();
        this.viaBlockages = new HashMap<RoutingFrame.RoutingLayer, RTNode>();
        for (RoutingFrame.RoutingGeometry rg : blockages) {
            RoutingFrame.RoutingLayer l = rg.getLayer();
            Rectangle2D rect = rg.getBounds();
            if (l.isMetal()) {
                this.addRectangle(rect, l, rg.getNetID());
                continue;
            }
            this.addVia(new Point2D.Double(rect.getCenterX(), rect.getCenterY()), l, rg.getNetID());
        }
        this.addBlockagesAtPorts(segmentsToRoute);
        Job.getUserInterface().stopProgressDialog();
        Job.getUserInterface().startProgressDialog("Routing segments", null);
        int numSegments = segmentsToRoute.size();
        int prevNetId = numSegments > 0 ? segmentsToRoute.get(0).getNetID() : -1;
        for (int i = 0; i < numSegments; ++i) {
            Wavefront w;
            Job.getUserInterface().setProgressValue((int)((double)i / (double)numSegments * 100.0));
            Job.getUserInterface().setProgressNote("Routing segment " + (i + 1) + " of " + numSegments + ".");
            RoutingFrame.RoutingSegment currentSegment = segmentsToRoute.get(i);
            try {
                if (prevNetId != currentSegment.getNetID()) {
                    while (this.outQueue.size() != 0 || this.workerThreadsExecutor.getQueue().size() != 0) {
                        this.dequeueWavefrontJob();
                    }
                }
                if (this.workerThreadsExecutor.getQueue().size() > 39 || this.outQueue.size() > 30) {
                    this.dequeueWavefrontJob();
                }
                Wavefront w2 = new Wavefront(currentSegment, 0.2, this.cellBounds, this.ratingFunctionsForDetailed, false);
                this.enqueueWavefrontJob(w2);
            }
            catch (CouldNotCalculateVirtualTerminalException e2) {
                if (this.enableOutput.getTempBooleanValue()) {
                    System.out.print(i + ": (unable to calculate virtual Terminals) ");
                }
                w = new Wavefront(currentSegment, 0.2, this.cellBounds, this.ratingFunctionsForDetailed, false);
                this.enqueueWavefrontJob(w);
            }
            catch (RatingNotFoundException e) {
                if (this.enableOutput.getTempBooleanValue()) {
                    System.out.print(i + ": (global backtracking did not find rating) ");
                }
                w = new Wavefront(currentSegment, 0.2, this.cellBounds, this.ratingFunctionsForDetailed, false);
                this.enqueueWavefrontJob(w);
            }
            prevNetId = currentSegment.getNetID();
            if ((System.currentTimeMillis() - timeStart) / 1000L <= (long)this.maxRuntime.getTempIntValue()) continue;
            if (!this.enableOutput.getTempBooleanValue()) break;
            System.out.println("Routing aborted. Maximum execution time (" + this.maxRuntime.getTempIntValue() + " seconds) reached.");
            break;
        }
        while (this.outQueue.size() != 0 || this.workerThreadsExecutor.getQueue().size() != 0) {
            this.dequeueWavefrontJob();
        }
        Job.getUserInterface().stopProgressDialog();
    }

    private void enqueueWavefrontJob(Wavefront w) {
        boolean submitToWorkpool = false;
        do {
            try {
                this.workerThreadsExecutor.execute(new WavefrontExecutor(w));
                submitToWorkpool = true;
            }
            catch (RejectedExecutionException e) {
                try {
                    Wavefront doneWavefront = this.outQueue.take();
                    if (!doneWavefront.foundRoute) continue;
                    new Backtracking(doneWavefront).routeIt();
                }
                catch (InterruptedException e1) {
                    if (!this.enableOutput.getTempBooleanValue()) continue;
                    e1.printStackTrace();
                }
            }
        } while (!submitToWorkpool);
    }

    private void dequeueWavefrontJob() {
        block3: {
            try {
                Wavefront w = this.outQueue.take();
                if (w.foundRoute) {
                    new Backtracking(w).routeIt();
                }
            }
            catch (InterruptedException e) {
                if (!this.enableOutput.getTempBooleanValue()) break block3;
                e.printStackTrace();
            }
        }
    }

    public Wavefront[] doGlobalRouting(RoutingFrame.RoutingSegment globalSegment) throws CouldNotCalculateVirtualTerminalException, RatingNotFoundException {
        Wavefront globalWF = new Wavefront(globalSegment, this.globalGridGranularity, this.cellBounds, this.ratingFunctionsForGlobal, false, true);
        globalWF.propagate();
        ExperimentalGlobalBacktracking backtracking = new ExperimentalGlobalBacktracking(globalWF);
        List<ExperimentalGlobalBacktracking.Point> globalSections = backtracking.routeIt();
        ArrayList<Rectangle2D> detailedSegmentBounds = new ArrayList<Rectangle2D>();
        for (ExperimentalGlobalBacktracking.Point p : globalSections) {
            detailedSegmentBounds.add(this.getBoundsForGridPoint(p, globalWF));
        }
        Wavefront[] detailedWavefronts = this.calcVirtualTerminals(detailedSegmentBounds.toArray(new Rectangle2D[0]), globalSegment, backtracking, globalWF);
        return detailedWavefronts;
    }

    public Rectangle2D getBoundsForGridPoint(ExperimentalGlobalBacktracking.Point p, Wavefront wf) {
        double segmentSize = (this.cellBounds.getMaxY() - this.cellBounds.getMinY()) / 32.0;
        double diffToBorder = (this.cellBounds.getMaxY() - this.cellBounds.getMinY()) / 32.0 / 2.0;
        double min2 = 1.0E-8;
        double sizeOfRect = (double)((long)((segmentSize - min2) * 1.0E8)) / 1.0E8;
        Rectangle2D.Double rect = new Rectangle2D.Double(wf.toGrid(p.x) - diffToBorder + min2, wf.toGrid(p.y) - diffToBorder + min2, sizeOfRect, sizeOfRect);
        return rect;
    }

    public Rectangle2D getBoundsForGridPoint(Point2D p, Wavefront wf) {
        double segmentSize = (this.cellBounds.getMaxY() - this.cellBounds.getMinY()) / 32.0;
        double diffToBorder = (this.cellBounds.getMaxY() - this.cellBounds.getMinY()) / 32.0 / 2.0;
        double min2 = 1.0E-8;
        double sizeOfRect = (double)((long)((segmentSize - min2) * 1.0E8)) / 1.0E8;
        Rectangle2D.Double rect = new Rectangle2D.Double(wf.toGrid(p.getX()) - diffToBorder + min2, wf.toGrid(p.getY()) - diffToBorder + min2, sizeOfRect, sizeOfRect);
        return rect;
    }

    public Wavefront[] calcVirtualTerminals(Rectangle2D[] detailedSegmentBounds, RoutingFrame.RoutingSegment globalSegment, ExperimentalGlobalBacktracking dummy, Wavefront dummyWF) throws CouldNotCalculateVirtualTerminalException {
        Wavefront[] detailedSegments = new Wavefront[detailedSegmentBounds.length];
        Point2D startPoint = null;
        Point2D finishPoint = null;
        Point2D nextStartPoint = null;
        startPoint = globalSegment.getFinishEnd().getLocation();
        int i = 0;
        while (i + 1 < detailedSegmentBounds.length) {
            boolean blockage = false;
            double rnd = Math.random();
            for (int j = 0; j < 5; ++j) {
                double tmp = (rnd + 0.2 * (double)j) / 1.0;
                Point2D[] points = this.calcPointsForVirtualTerminals(detailedSegmentBounds[i], detailedSegmentBounds[i + 1], tmp);
                finishPoint = points[0];
                nextStartPoint = points[1];
                double minWidth = globalSegment.getWidestArcAtStart();
                RoutingFrame.RoutingLayer currentLayer = globalSegment.getStartLayers().get(0);
                double surround = currentLayer.getMinSpacing(currentLayer);
                double metalSpacing = Math.max(currentLayer.getMinWidth(), minWidth) / 2.0;
                blockage = false;
                for (Point2D p : points) {
                    LMBound block = this.getMetalBlockage(globalSegment.getNetID(), currentLayer.getMetalNumber(), metalSpacing, metalSpacing, surround, p.getX(), p.getY());
                    if (block == null) continue;
                    if (j == 4) {
                        throw new CouldNotCalculateVirtualTerminalException();
                    }
                    blockage = true;
                    break;
                }
                if (!blockage) break;
            }
            detailedSegments[i] = new Wavefront(globalSegment, startPoint, finishPoint, globalSegment.getStartLayers().get(0), globalSegment.getStartLayers().get(0), this.detailedGridGranularity, detailedSegmentBounds[i], this.ratingFunctionsForDetailed, false, false);
            startPoint = nextStartPoint;
            ++i;
        }
        finishPoint = globalSegment.getStartEnd().getLocation();
        detailedSegments[detailedSegmentBounds.length - 1] = new Wavefront(globalSegment, startPoint, finishPoint, globalSegment.getStartLayers().get(0), globalSegment.getFinishLayers().get(0), this.detailedGridGranularity, detailedSegmentBounds[detailedSegmentBounds.length - 1], this.ratingFunctionsForDetailed, false, false);
        return detailedSegments;
    }

    private Point2D[] calcPointsForVirtualTerminals(Rectangle2D firstSementBounds, Rectangle2D secondSementBounds, double randomDouble) {
        double crossingXforp1 = 0.0;
        double crossingXforp2 = 0.0;
        double crossingYforp1 = 0.0;
        double crossingYforp2 = 0.0;
        Point2D.Double finishPoint = null;
        Point2D.Double nextStartPoint = null;
        if (firstSementBounds.getMinX() == secondSementBounds.getMinX()) {
            boolean firstSmaller;
            boolean bl = firstSmaller = firstSementBounds.getMaxY() < secondSementBounds.getMaxY();
            if (firstSmaller) {
                crossingYforp1 = firstSementBounds.getMaxY();
                crossingYforp2 = secondSementBounds.getMinY();
            } else {
                crossingYforp1 = firstSementBounds.getMinY();
                crossingYforp2 = secondSementBounds.getMaxY();
            }
            double xCoord = (double)((long)((firstSementBounds.getMaxX() - firstSementBounds.getMinX()) * randomDouble * 1.0E8)) / 1.0E8;
            xCoord += firstSementBounds.getMinX();
            xCoord = this.dummyDetailedWavefront.toGrid(xCoord);
            crossingYforp1 = this.dummyDetailedWavefront.toGrid(crossingYforp1);
            crossingYforp2 = this.dummyDetailedWavefront.toGrid(crossingYforp2);
            finishPoint = new Point2D.Double(xCoord, crossingYforp1);
            nextStartPoint = new Point2D.Double(xCoord, crossingYforp2);
        } else {
            boolean firstSmaller;
            boolean bl = firstSmaller = firstSementBounds.getMaxX() < secondSementBounds.getMaxX();
            if (firstSmaller) {
                crossingXforp1 = firstSementBounds.getMaxX();
                crossingXforp2 = secondSementBounds.getMinX();
            } else {
                crossingXforp1 = firstSementBounds.getMinX();
                crossingXforp2 = secondSementBounds.getMaxX();
            }
            double yCoord = (double)((long)((firstSementBounds.getMaxY() - firstSementBounds.getMinY()) * randomDouble * 1.0E8)) / 1.0E8;
            yCoord += firstSementBounds.getMinY();
            yCoord = this.dummyDetailedWavefront.toGrid(yCoord);
            crossingYforp1 = this.dummyDetailedWavefront.toGrid(crossingXforp1);
            crossingYforp2 = this.dummyDetailedWavefront.toGrid(crossingXforp2);
            finishPoint = new Point2D.Double(crossingXforp1, yCoord);
            nextStartPoint = new Point2D.Double(crossingXforp2, yCoord);
        }
        return new Point2D[]{finishPoint, nextStartPoint};
    }

    private boolean initializeDesignRules(List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts) {
        this.numMetalLayers = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            ++this.numMetalLayers;
        }
        this.metalLayers = new RoutingFrame.RoutingLayer[this.numMetalLayers];
        int metNo = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            this.metalLayers[metNo++] = rl;
        }
        this.metalVias = new MetalVias[this.numMetalLayers - 1];
        for (int i = 0; i < this.numMetalLayers - 1; ++i) {
            this.metalVias[i] = new MetalVias();
        }
        block3: for (RoutingFrame.RoutingContact rc : allContacts) {
            for (int i = 0; i < this.numMetalLayers - 1; ++i) {
                if ((rc.getFirstLayer() != this.metalLayers[i] || rc.getSecondLayer() != this.metalLayers[i + 1]) && (rc.getSecondLayer() != this.metalLayers[i] || rc.getFirstLayer() != this.metalLayers[i + 1])) continue;
                this.metalVias[i].addVia(rc);
                continue block3;
            }
        }
        for (int i = 0; i < this.numMetalLayers; ++i) {
            if (this.metalLayers[i] == null) {
                if (this.enableOutput.getTempBooleanValue()) {
                    System.out.println("ERROR: Cannot find layer for Metal " + (i + 1));
                }
                return true;
            }
            if (i >= this.numMetalLayers - 1 || this.metalVias[i].getVias().size() != 0) continue;
            if (this.enableOutput.getTempBooleanValue()) {
                System.out.println("ERROR: Cannot find contact node between Metal " + (i + 1) + " and Metal " + (i + 2));
            }
            return true;
        }
        return false;
    }

    private LMBound getMetalBlockage(int netID, int metNo, double halfWidth, double halfHeight, double surround, double x2, double y) {
        RoutingFrame.RoutingLayer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalBlockages.get(layer);
        if (rtree == null) {
            return null;
        }
        double lX = x2 - halfWidth - surround;
        double hX = x2 + halfWidth + surround;
        double lY = y - halfHeight - surround;
        double hY = y + halfHeight + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        try {
            RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
            while (sea.hasNext()) {
                LMBound sBound = (LMBound)sea.next();
                if (sBound.getNetID() == netID) continue;
                return sBound;
            }
        }
        catch (NullPointerException e) {
            return new LMBound(new Rectangle2D.Double(), -1);
        }
        return null;
    }

    private void addBlockagesAtPorts(List<RoutingFrame.RoutingSegment> segmentsToRoute) {
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            this.addBlockage(rs.getStartEnd().getLocation(), rs.getStartLayers(), rs.getStartLayers().get(0).getMinWidth() + 2.0, rs.getNetID());
            this.addBlockage(rs.getFinishEnd().getLocation(), rs.getFinishLayers(), rs.getFinishLayers().get(0).getMinWidth() + 2.0, rs.getNetID());
        }
    }

    private void addBlockage(Point2D loc, List<RoutingFrame.RoutingLayer> layers, double minWidth, int netID) {
        int lowMetal = -1;
        int highMetal = -1;
        for (RoutingFrame.RoutingLayer rl : layers) {
            int level = rl.getMetalNumber();
            if (lowMetal < 0) {
                lowMetal = highMetal = level;
                continue;
            }
            lowMetal = Math.min(lowMetal, level);
            highMetal = Math.max(highMetal, level);
        }
        if (lowMetal < 0) {
            return;
        }
        for (int via = lowMetal - 2; via < highMetal; ++via) {
            if (via < 0 || via >= this.numMetalLayers - 1) continue;
            MetalVia mv = this.metalVias[via].getVias().get(0);
            for (RoutingFrame.RoutingGeometry rg : mv.via.getGeometry()) {
                Rectangle2D.Double bounds = new Rectangle2D.Double(loc.getX() - minWidth, loc.getY() - minWidth, 2.0 * minWidth, 2.0 * minWidth);
                this.addRectangle(bounds, rg.getLayer(), netID);
            }
        }
    }

    private void addRectangle(Rectangle2D bounds, RoutingFrame.RoutingLayer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.metalBlockages.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.metalBlockages.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new LMBound(bounds, netID))) != root2) {
            this.metalBlockages.put(layer, newRoot);
        }
    }

    private void addVia(Point2D loc, RoutingFrame.RoutingLayer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.viaBlockages.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.viaBlockages.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new LMVia(loc, netID))) != root2) {
            this.viaBlockages.put(layer, newRoot);
        }
    }

    private static class LMVia
    implements RTBounds {
        private Point2D loc;
        private int netID;

        LMVia(Point2D loc, int netID) {
            this.loc = loc;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
        }

        public String toString() {
            return "LMVia on net " + this.netID;
        }
    }

    private static class LMBound
    implements RTBounds {
        private Rectangle2D bound;
        private int netID;

        LMBound(Rectangle2D bound, int netID) {
            this.bound = bound;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return this.bound;
        }

        public int getNetID() {
            return this.netID;
        }
    }

    private static class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            RoutingFrame.RoutingContact pn1 = mv1.via;
            RoutingFrame.RoutingContact pn2 = mv2.via;
            double sz1 = pn1.getDefWidth() * pn1.getDefHeight();
            if (sz1 < (sz2 = pn2.getDefWidth() * pn2.getDefHeight())) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    private static class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(RoutingFrame.RoutingContact pn) {
            this.vias.add(new MetalVia(pn));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        RoutingFrame.RoutingContact via;

        MetalVia(RoutingFrame.RoutingContact v) {
            this.via = v;
        }
    }

    private class WavefrontExecutor
    implements Runnable {
        private Wavefront w;

        public WavefrontExecutor(Wavefront w) {
            this.w = w;
        }

        @Override
        public void run() {
            block2: {
                this.w.propagate();
                try {
                    RoutingFrameLeeMoore.this.outQueue.put(this.w);
                }
                catch (InterruptedException e) {
                    if (!RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) break block2;
                    e.printStackTrace();
                }
            }
        }
    }

    private class ExperimentalGlobalBacktracking {
        private Wavefront w;
        private double granularity;
        private double stepsize;

        public ExperimentalGlobalBacktracking(Wavefront w) {
            this.w = w;
            this.granularity = w.getGranularity();
            this.stepsize = 1.0 / this.granularity;
        }

        public List<Point> routeIt() throws RatingNotFoundException {
            ArrayList<Point> points = new ArrayList<Point>();
            double x2 = this.w.xGridFinish;
            double y = this.w.yGridFinish;
            int z = this.w.zFinish;
            int zLast = this.w.zFinish;
            int lastRating = 0;
            Rating tmp = this.w.grid[z].getRating(x2, y);
            if (tmp != null) {
                lastRating = tmp.getRating();
            } else {
                if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                    System.out.println("Backtracking did not find a route (Nullpointer Rating)!");
                }
                throw new RatingNotFoundException();
            }
            block8: while (x2 != this.w.xGridStart || y != this.w.yGridStart || z != this.w.zStart) {
                if (z == zLast) {
                    points.add(new Point(x2, y, z));
                }
                for (int i = 0; i < 6; ++i) {
                    double dx = 0.0;
                    double dy = 0.0;
                    int dz = 0;
                    switch (i) {
                        case 0: {
                            dy = this.stepsize;
                            break;
                        }
                        case 1: {
                            dx = this.stepsize;
                            break;
                        }
                        case 2: {
                            dy = -this.stepsize;
                            break;
                        }
                        case 3: {
                            dx = -this.stepsize;
                            break;
                        }
                        case 4: {
                            dz = -1;
                            break;
                        }
                        case 5: {
                            dz = 1;
                        }
                    }
                    if (z + dz < 0 || z + dz >= RoutingFrameLeeMoore.this.numMetalLayers) continue;
                    Rating r = this.w.grid[z + dz].getRating(this.toGrid(x2 + dx), this.toGrid(y + dy));
                    if (r == null || r.getRating() >= lastRating) {
                        if (i != 5) continue;
                        if (!RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) break block8;
                        System.out.println("Backtracking did not find a route!");
                        break block8;
                    }
                    zLast = z;
                    lastRating = r.getRating();
                    x2 = this.toGrid(x2 + dx);
                    y = this.toGrid(y + dy);
                    z += dz;
                    continue block8;
                }
            }
            if (z != zLast) {
                points.add(new Point(this.w.xStart, this.w.yStart, zLast, z));
            } else {
                points.add(new Point(this.w.xStart, this.w.yStart, z));
            }
            return points;
        }

        private double toGrid(double d) {
            return (double)Math.round(d * this.granularity) * this.stepsize;
        }

        protected class Point {
            double x;
            double y;

            Point(double x2, double y, int zLast, int z) {
                this.x = x2;
                this.y = y;
            }

            Point(double x2, double y, int z) {
                this.x = x2;
                this.y = y;
            }
        }
    }

    private class Backtracking {
        private Wavefront w;
        private double granularity;
        private double stepsize;

        public Backtracking(Wavefront w) {
            this.w = w;
            this.granularity = w.getGranularity();
            this.stepsize = 1.0 / this.granularity;
        }

        public void routeIt() {
            Point p2;
            ArrayList<Point> points = new ArrayList<Point>();
            double x2 = this.w.xGridFinish;
            double y = this.w.yGridFinish;
            double xLast = x2;
            double yLast = y;
            double xNextToLast = xLast;
            double yNextToLast = yLast;
            int z = this.w.zFinish;
            int zLast = this.w.zFinish;
            points.add(new Point(this.w.xFinish, this.w.yFinish, z));
            int lastRating = 0;
            Rating tmp = this.w.grid[z].getRating(x2, y);
            if (tmp == null) {
                if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                    System.out.println("Backtracking did not find a route (Nullpointer Rating)!");
                }
                return;
            }
            lastRating = tmp.getRating();
            Rating r = tmp;
            block8: while (x2 != this.w.xGridStart || y != this.w.yGridStart || z != this.w.zStart) {
                if (z != zLast) {
                    points.add(new Point(x2, y, zLast, z));
                } else if (x2 != xNextToLast && y != yNextToLast) {
                    points.add(new Point(xLast, yLast, z));
                }
                for (int i = 0; i < 6; ++i) {
                    double dx = 0.0;
                    double dy = 0.0;
                    int dz = 0;
                    switch (i) {
                        case 0: {
                            dy = this.stepsize;
                            break;
                        }
                        case 1: {
                            dx = this.stepsize;
                            break;
                        }
                        case 2: {
                            dy = -this.stepsize;
                            break;
                        }
                        case 3: {
                            dx = -this.stepsize;
                            break;
                        }
                        case 4: {
                            dz = -1;
                            break;
                        }
                        case 5: {
                            dz = 1;
                        }
                    }
                    if (z + dz < 0 || z + dz >= RoutingFrameLeeMoore.this.numMetalLayers) continue;
                    r = this.w.grid[z + dz].getRating(this.toGrid(x2 + dx), this.toGrid(y + dy));
                    if (r == null || r.getRating() > lastRating) {
                        if (i != 5) continue;
                        if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                            System.out.println("Backtracking did not find a route!");
                        }
                        return;
                    }
                    xNextToLast = xLast;
                    xLast = x2;
                    yNextToLast = yLast;
                    yLast = y;
                    zLast = z;
                    lastRating = r.getRating();
                    x2 = this.toGrid(x2 + dx);
                    y = this.toGrid(y + dy);
                    z += dz;
                    continue block8;
                }
            }
            if (z != zLast) {
                points.add(new Point(this.w.xStart, this.w.yStart, zLast, z));
            } else {
                points.add(new Point(this.w.xStart, this.w.yStart, z));
            }
            int size2 = points.size();
            if (size2 == 2) {
                Point p1 = (Point)points.get(0);
                p2 = (Point)points.get(1);
                if (p1.x != p2.x && p1.y != p2.y) {
                    points.add(1, new Point(p1.x, p2.y, p1.z));
                }
            } else if (size2 == 3) {
                Point p = (Point)points.get(1);
                if (Math.abs(p.x - this.w.xFinish) < Math.abs(p.y - this.w.yFinish)) {
                    p.x = this.w.xFinish;
                    p.y = this.w.yStart;
                } else {
                    p.x = this.w.xStart;
                    p.y = this.w.yFinish;
                }
            } else if (size2 == 4) {
                Point p1 = (Point)points.get(1);
                p2 = (Point)points.get(2);
                if (Math.abs(p1.x - this.w.xFinish) < Math.abs(p1.y - this.w.yFinish)) {
                    p1.x = this.w.xFinish;
                    if (p2.x != p1.x && p2.y != p1.y) {
                        p2.x = p1.x;
                        p2.y = this.w.yStart;
                    } else {
                        p2.x = this.w.xStart;
                    }
                } else {
                    p1.y = this.w.yFinish;
                    if (p2.x != p1.x && p2.y != p1.y) {
                        p2.y = p1.y;
                        p2.x = this.w.xStart;
                    } else {
                        p2.y = this.w.yStart;
                    }
                }
            } else if (size2 > 4) {
                Point p;
                Point p3;
                Point p1 = (Point)points.get(1);
                p2 = (Point)points.get(size2 - 2);
                boolean adjustX = false;
                boolean adjustY = false;
                if (Math.abs(p1.x - this.w.xFinish) < Math.abs(p1.y - this.w.yFinish)) {
                    p1.x = this.w.xFinish;
                    p3 = (Point)points.get(2);
                    if (p1.isVia || p3.x != p1.x && p3.y != p1.y) {
                        adjustX = true;
                    }
                } else {
                    p1.y = this.w.yFinish;
                    p3 = (Point)points.get(2);
                    if (p1.isVia || p3.x != p1.x && p3.y != p1.y) {
                        adjustY = true;
                    }
                }
                if (adjustX || adjustY) {
                    x2 = p1.x;
                    y = p1.y;
                    int i = 2;
                    while (true) {
                        p1 = (Point)points.get(i);
                        if (p1.x == x2 || p1.y == y || i == size2 - 1) break;
                        if (adjustX) {
                            p1.x = this.w.xFinish;
                        } else {
                            p1.y = this.w.yFinish;
                        }
                        if (!p1.isVia) break;
                        x2 = p1.x;
                        y = p1.y;
                        ++i;
                    }
                }
                adjustY = false;
                adjustX = false;
                if (Math.abs(p2.x - this.w.xStart) < Math.abs(p2.y - this.w.yStart)) {
                    p2.x = this.w.xStart;
                    p = (Point)points.get(size2 - 3);
                    if (p2.isVia || p.x != p2.x && p.y != p2.y) {
                        adjustX = true;
                    }
                } else {
                    p2.y = this.w.yStart;
                    p = (Point)points.get(size2 - 3);
                    if (p2.isVia || p.x != p2.x && p.y != p2.y) {
                        adjustY = true;
                    }
                }
                if (adjustX || adjustY) {
                    x2 = p2.x;
                    y = p2.y;
                    int i = size2 - 3;
                    while (true) {
                        p2 = (Point)points.get(i);
                        if (p2.x == x2 || p2.y == y || i == 0) break;
                        if (adjustX) {
                            p2.x = this.w.xStart;
                        } else {
                            p2.y = this.w.yStart;
                        }
                        if (!p2.isVia) break;
                        x2 = p2.x;
                        y = p2.y;
                        --i;
                    }
                }
            }
            RoutingFrame.RoutePoint rpCurrent = null;
            RoutingFrame.RoutePoint rpLast = null;
            RoutingFrame.RoutePoint rpFix = null;
            RoutingFrame.RoutingLayer l = null;
            int i = 0;
            for (Point p : points) {
                RoutingFrame.RoutingContact pin;
                if (i == 0) {
                    pin = RoutingFrame.RoutingContact.FINISHPOINT;
                    l = RoutingFrameLeeMoore.this.metalLayers[p.z];
                } else if (i == points.size() - 1) {
                    pin = RoutingFrame.RoutingContact.STARTPOINT;
                    l = RoutingFrameLeeMoore.this.metalLayers[p.z];
                } else if (p.isVia) {
                    pin = ((RoutingFrameLeeMoore)RoutingFrameLeeMoore.this).metalVias[Math.min((int)p.z, (int)p.zLast)].getVias().get((int)0).via;
                    l = RoutingFrameLeeMoore.this.metalLayers[p.zLast];
                } else {
                    l = RoutingFrameLeeMoore.this.metalLayers[p.z];
                    pin = l.getPin();
                }
                rpCurrent = new RoutingFrame.RoutePoint(pin, new Point2D.Double(p.x, p.y), 0);
                if (p.isVia) {
                    this.addWireEndVia(rpCurrent);
                } else {
                    this.addWireEnd(rpCurrent);
                }
                if (i == 0 && p.isVia) {
                    rpFix = new RoutingFrame.RoutePoint(((RoutingFrameLeeMoore)RoutingFrameLeeMoore.this).metalVias[Math.min((int)p.z, (int)p.zLast)].getVias().get((int)0).via, new Point2D.Double(p.x, p.y), 0);
                    this.addWireEndVia(rpFix);
                    l = RoutingFrameLeeMoore.this.metalLayers[p.zLast];
                    this.addWire(l, l.getMinWidth(), rpCurrent, rpFix, this.w.netID);
                    rpCurrent = rpFix;
                } else if (i == points.size() - 1 && p.isVia) {
                    rpFix = new RoutingFrame.RoutePoint(((RoutingFrameLeeMoore)RoutingFrameLeeMoore.this).metalVias[Math.min((int)p.z, (int)p.zLast)].getVias().get((int)0).via, new Point2D.Double(p.x, p.y), 0);
                    this.addWireEndVia(rpFix);
                    l = RoutingFrameLeeMoore.this.metalLayers[p.zLast];
                    this.addWire(l, l.getMinWidth(), rpLast, rpFix, this.w.netID);
                    rpLast = rpFix;
                    l = RoutingFrameLeeMoore.this.metalLayers[p.z];
                }
                if (rpLast != null) {
                    this.addWire(l, l.getMinWidth(), rpLast, rpCurrent, this.w.netID);
                }
                rpLast = rpCurrent;
                ++i;
            }
        }

        private double toGrid(double d) {
            return (double)Math.round(d * this.granularity) * this.stepsize;
        }

        private void addWireEnd(RoutingFrame.RoutePoint p) {
            this.w.segment.addWireEnd(p);
        }

        private void addWireEndVia(RoutingFrame.RoutePoint p) {
            this.w.segment.addWireEnd(p);
            RoutingFrame.RoutingContact rc = p.getContact();
            Point2D loc = p.getLocation();
            Rectangle2D rect = this.makeArcBox(loc, loc, rc.getViaSpacing() * 4.0);
            RoutingFrameLeeMoore.this.addRectangle(rect, rc.getFirstLayer(), -this.w.netID);
            RoutingFrameLeeMoore.this.addRectangle(rect, rc.getSecondLayer(), -this.w.netID);
        }

        private RoutingFrame.RouteWire addWire(RoutingFrame.RoutingLayer l, double width, RoutingFrame.RoutePoint from2, RoutingFrame.RoutePoint to2, int netID) {
            RoutingFrame.RouteWire rw = new RoutingFrame.RouteWire(l, from2, to2, width);
            this.w.segment.addWire(rw);
            Rectangle2D box = this.makeArcBox(from2.getLocation(), to2.getLocation(), width);
            if (box != null) {
                RoutingFrameLeeMoore.this.addRectangle(box, l, netID);
            }
            return rw;
        }

        private Rectangle2D makeArcBox(Point2D from2, Point2D to2, double width) {
            double w2 = width / 2.0;
            int angle = DBMath.figureAngle(from2, to2);
            switch (angle) {
                case 0: 
                case 1800: {
                    double y = to2.getY();
                    double x1 = to2.getX();
                    double x2 = from2.getX();
                    return new Rectangle2D.Double(Math.min(x1, x2) - w2, y - w2, Math.abs(x1 - x2) + width, width);
                }
                case 900: 
                case 2700: {
                    double x2 = to2.getX();
                    double y1 = to2.getY();
                    double y2 = from2.getY();
                    return new Rectangle2D.Double(x2 - w2, Math.min(y1, y2) - w2, width, Math.abs(y1 - y2) + width);
                }
            }
            if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                System.out.println("ERROR: Angle not allowed!");
            }
            return null;
        }

        private class Point {
            double x;
            double y;
            int zLast;
            int z;
            boolean isVia = false;

            Point(double x2, double y, int zLast, int z) {
                this.x = x2;
                this.y = y;
                this.zLast = zLast;
                this.z = z;
                this.isVia = true;
            }

            Point(double x2, double y, int z) {
                this.x = x2;
                this.y = y;
                this.z = z;
            }
        }
    }

    private class Wavefront {
        private boolean debug;
        RoutingFrame.RoutingSegment segment;
        private RoutingFrame.RoutingLayer rlStart;
        private RoutingFrame.RoutingLayer rlFinish;
        private double xStart;
        private double yStart;
        double xGridStart;
        double yGridStart;
        int zStart;
        double xFinish;
        double yFinish;
        double xGridFinish;
        double yGridFinish;
        int zFinish;
        private String netName;
        private int netID;
        RatingFunction[] ratingFunctions;
        private double granularity;
        private double stepsize;
        private Rectangle2D bounds;
        boolean foundRoute;
        boolean runInGlobalMode;
        private int maxPointsLimit;
        DataGrid[] grid;
        PriorityQueue<Gridpoint> pointsToVisit;

        Wavefront(RoutingFrame.RoutingSegment s, double granularity, Rectangle2D bounds, RatingFunction[] ratingFunctions, boolean debug) {
            this.rlStart = s.getStartLayers().get(0);
            this.rlFinish = s.getFinishLayers().get(0);
            this.xStart = s.getStartEnd().getLocation().getX();
            this.yStart = s.getStartEnd().getLocation().getY();
            this.xFinish = s.getFinishEnd().getLocation().getX();
            this.yFinish = s.getFinishEnd().getLocation().getY();
            this.init(s, granularity, bounds, ratingFunctions, debug, false);
        }

        Wavefront(RoutingFrame.RoutingSegment s, Point2D startPoint, Point2D finishPoint, RoutingFrame.RoutingLayer startLayer, RoutingFrame.RoutingLayer finishLayer, double granularity, Rectangle2D bounds, RatingFunction[] ratingFunctions, boolean debug, boolean runInGlobalMode) {
            this.rlStart = startLayer;
            this.rlFinish = finishLayer;
            this.xStart = startPoint.getX();
            this.yStart = startPoint.getY();
            this.xFinish = finishPoint.getX();
            this.yFinish = finishPoint.getY();
            this.init(s, granularity, bounds, ratingFunctions, debug, runInGlobalMode);
        }

        Wavefront(RoutingFrame.RoutingSegment s, double granularity, Rectangle2D bounds, RatingFunction[] ratingFunctions, boolean debug, boolean runInGlobalMode) {
            this.rlStart = s.getStartLayers().get(0);
            this.rlFinish = s.getFinishLayers().get(0);
            this.xStart = s.getStartEnd().getLocation().getX();
            this.yStart = s.getStartEnd().getLocation().getY();
            this.xFinish = s.getFinishEnd().getLocation().getX();
            this.yFinish = s.getFinishEnd().getLocation().getY();
            this.init(s, granularity, bounds, ratingFunctions, debug, runInGlobalMode);
        }

        private void init(RoutingFrame.RoutingSegment s, double granularity, Rectangle2D bounds, RatingFunction[] ratingFunctions, boolean debug, boolean runInGlobalMode) {
            this.granularity = granularity;
            this.stepsize = 1.0 / granularity;
            this.bounds = bounds;
            this.runInGlobalMode = runInGlobalMode;
            this.ratingFunctions = ratingFunctions;
            this.segment = s;
            this.debug = debug;
            this.netName = this.segment.getNetName();
            this.netID = this.segment.getNetID();
            this.foundRoute = false;
            this.xGridStart = this.toGrid(this.xStart);
            this.yGridStart = this.toGrid(this.yStart);
            this.xGridFinish = this.toGrid(this.xFinish);
            this.yGridFinish = this.toGrid(this.yFinish);
            this.zStart = this.rlStart.getMetalNumber() - 1;
            this.zFinish = this.rlFinish.getMetalNumber() - 1;
            this.grid = new DataGrid[RoutingFrameLeeMoore.this.numMetalLayers];
            for (int i = 0; i < RoutingFrameLeeMoore.this.numMetalLayers; ++i) {
                this.grid[i] = new DataGrid();
            }
            this.pointsToVisit = new PriorityQueue();
            this.pointsToVisit.add(new Gridpoint(this.xGridStart, this.yGridStart, this.zStart, null));
            this.grid[this.zStart].visit(this.xGridStart, this.yGridStart, new Rating());
            double tmp = DBMath.distBetweenPoints(this.segment.getStartEnd().getLocation(), this.segment.getFinishEnd().getLocation());
            this.maxPointsLimit = (int)(tmp * this.granularity * 1800.0);
        }

        private void printInfo() {
            if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                System.out.println((this.runInGlobalMode ? "global" : "detailed") + " Wavefront \"" + this.netName + "\" started at (" + TextUtils.formatDouble(this.xStart) + ", " + TextUtils.formatDouble(this.yStart) + ", " + this.zStart + ") heading for (" + TextUtils.formatDouble(this.xFinish) + ", " + TextUtils.formatDouble(this.yFinish) + ", " + this.zFinish + ")" + " - NetID=" + this.netID + ", " + "Thread ID: " + Thread.currentThread().getId());
            }
        }

        private void propagate() {
            this.printInfo();
            double x2 = this.xStart;
            double y = this.yStart;
            int z = this.zStart;
            RTNode blockages = (RTNode)RoutingFrameLeeMoore.this.metalBlockages.get(this.rlStart);
            double minWidth = RoutingFrameLeeMoore.this.metalLayers[this.zFinish].getMinWidth();
            double minSpacing = RoutingFrameLeeMoore.this.metalLayers[this.zFinish].getMinSpacing(RoutingFrameLeeMoore.this.metalLayers[this.zFinish]);
            double halfWidth = minWidth / 2.0;
            LMBound block = RoutingFrameLeeMoore.this.getMetalBlockage(this.netID, this.zFinish, halfWidth, halfWidth, minSpacing, this.xGridFinish, this.yGridFinish);
            if (block != null) {
                if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                    System.out.println("There is a blockage at the finish point. Wavefront will not start.");
                }
                return;
            }
            Gridpoint curPoint = null;
            int counter = 0;
            while ((curPoint = this.pointsToVisit.poll()) != null) {
                if (++counter > this.maxPointsLimit) {
                    if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                        System.out.println("Wavefront did not find finish point (maximum number of visited points (" + this.maxPointsLimit + ") reached).");
                    }
                    return;
                }
                x2 = curPoint.getX();
                y = curPoint.getY();
                z = curPoint.getZ();
                if (this.debug) {
                    this.segment.addWireEnd(new RoutingFrame.RoutePoint(RoutingFrameLeeMoore.this.metalLayers[z].getPin(), new Point2D.Double(x2, y), 0));
                }
                if (z == this.zFinish && x2 == this.xGridFinish && y == this.yGridFinish) {
                    this.foundRoute = true;
                    if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue() && this.debug) {
                        System.out.println("routing found");
                        System.out.println("Visited " + counter + " Grid Points.");
                    }
                    return;
                }
                for (int i = 0; i < 6; ++i) {
                    double dx = 0.0;
                    double dy = 0.0;
                    int dz = 0;
                    switch (i) {
                        case 0: {
                            dy = this.stepsize;
                            break;
                        }
                        case 1: {
                            dx = this.stepsize;
                            break;
                        }
                        case 2: {
                            dy = -this.stepsize;
                            break;
                        }
                        case 3: {
                            dx = -this.stepsize;
                            break;
                        }
                        case 4: {
                            dz = -1;
                            break;
                        }
                        case 5: {
                            dz = 1;
                        }
                    }
                    double nextX = this.toGrid(x2 + dx);
                    double nextY = this.toGrid(y + dy);
                    int nextZ = z + dz;
                    if (nextZ < 0 || nextZ >= RoutingFrameLeeMoore.this.numMetalLayers || this.grid[nextZ].isPointVisited(nextX, nextY) || !this.runInGlobalMode && (block = RoutingFrameLeeMoore.this.getMetalBlockage(this.netID, nextZ, halfWidth = ((minWidth = RoutingFrameLeeMoore.this.metalLayers[nextZ].getMinWidth()) + this.stepsize) / 2.0, halfWidth, minSpacing = RoutingFrameLeeMoore.this.metalLayers[nextZ].getMinSpacing(RoutingFrameLeeMoore.this.metalLayers[nextZ]), nextX, nextY)) != null) continue;
                    Gridpoint nextPoint = new Gridpoint(nextX, nextY, nextZ, curPoint);
                    for (RatingFunction f2 : this.ratingFunctions) {
                        f2.doRating(nextPoint, curPoint, this.xFinish, this.yFinish, blockages, this.bounds);
                    }
                    nextPoint.getRating().calcRating();
                    this.pointsToVisit.add(nextPoint);
                    this.grid[nextZ].visit(nextX, nextY, nextPoint.getRating());
                }
            }
            if (RoutingFrameLeeMoore.this.enableOutput.getTempBooleanValue()) {
                System.out.println("Wavefront did not find finish point (stuck).");
            }
        }

        public double getGranularity() {
            return this.granularity;
        }

        private double toGrid(double d) {
            return (double)Math.round(d * this.granularity) * this.stepsize;
        }
    }
}

