/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.debug;

import com.sun.electric.tool.util.concurrent.debug.IDebug;
import com.sun.electric.tool.util.concurrent.runtime.WorkerStrategy;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Set;

public class LoadBalancing
implements IDebug {
    private static LoadBalancing instance = new LoadBalancing();
    private Set<WorkerStrategy> workers = ConcurrentCollectionFactory.createConcurrentHashSet();

    private LoadBalancing() {
    }

    public static LoadBalancing getInstance() {
        return instance;
    }

    public void registerWorker(WorkerStrategy worker) {
        this.workers.add(worker);
    }

    public void reset() {
        this.workers.clear();
    }

    @Override
    public void printStatistics() {
        Set<WorkerStrategy> workersLocalCopy = ConcurrentCollectionFactory.copySetToConcurrent(this.workers);
        int sum2 = 0;
        Iterator<WorkerStrategy> it = workersLocalCopy.iterator();
        while (it.hasNext()) {
            sum2 += it.next().getExecutedCounter();
        }
        double mean = (double)sum2 / (double)workersLocalCopy.size();
        double[] varField = new double[workersLocalCopy.size()];
        int i = 0;
        for (WorkerStrategy worker : workersLocalCopy) {
            System.out.print(worker);
            System.out.print(" - ");
            varField[i] = (double)worker.getExecutedCounter() / (double)sum2;
            System.out.println(this.getPercentageString(varField[i]));
            ++i;
        }
        double dev = this.standardDeviation(varField);
        System.out.print("mean value");
        System.out.print(" - ");
        System.out.println(this.getPercentageString(mean / (double)sum2));
        System.out.print("deviation");
        System.out.print(" - ");
        System.out.println(this.getPercentageString(dev));
    }

    private double varianceEqualDistribution(double[] values2, double mean) {
        double var = 0.0;
        for (int i = 0; i < values2.length; ++i) {
            var += Math.pow(values2[i] - mean, 2.0);
        }
        return var / (double)values2.length;
    }

    private double varianceEqualDistribution(double[] values2) {
        double mean = this.meanEqualDistribution(values2);
        return this.varianceEqualDistribution(values2, mean);
    }

    private double meanEqualDistribution(double[] values2) {
        double mean = 0.0;
        for (int i = 0; i < values2.length; ++i) {
            mean += values2[i];
        }
        return mean / (double)values2.length;
    }

    private double standardDeviation(double[] values2) {
        double var = this.varianceEqualDistribution(values2);
        return Math.sqrt(var);
    }

    private String getPercentageString(double value2) {
        StringBuilder builder = new StringBuilder();
        DecimalFormat df2 = new DecimalFormat("##0.00");
        builder.append(df2.format(value2 * 100.0));
        builder.append("%");
        return builder.toString();
    }
}

