/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;
import java.math.BigInteger;
import java.util.BitSet;

public class BitVector {
    private final int numBits;
    private BitSet bitSet;
    private BitSet valid;
    private String name;
    public static int noNameSeverity = 1;

    public BitVector(int numBits) {
        this(numBits, "unnamed");
        Infrastructure.error(noNameSeverity, "Warning: creating unnamed length-" + numBits + " bit vector, use " + "two-parameter BitVector constructor instead");
    }

    public BitVector(int numBits, String name) {
        if (numBits < 0) {
            Infrastructure.fatal("Bad BitVector length " + numBits + ", must be non-negative");
        }
        this.numBits = numBits;
        this.bitSet = new BitSet(numBits);
        this.valid = new BitSet(numBits);
        this.name = name;
    }

    public BitVector(String bitString2) {
        this(bitString2.length());
        this.put(0, bitString2);
    }

    public BitVector(String bitString2, String name) {
        this(bitString2.length(), name);
        this.put(0, bitString2);
    }

    public BitVector(BitVector b) {
        this(b.getState(), b.getName());
    }

    public BitVector(int[] bitArray, String name) {
        this(bitArray.length, name);
        this.put(0, bitArray);
    }

    public int getNumBits() {
        return this.numBits;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getState() {
        StringBuffer buf = new StringBuffer(this.numBits);
        for (int ind = 0; ind < this.numBits; ++ind) {
            if (!this.valid.get(ind)) {
                buf.append("-");
                continue;
            }
            if (this.get(ind)) {
                buf.append("1");
                continue;
            }
            buf.append("0");
        }
        return buf.toString();
    }

    public String toString() {
        return this.getName() + ": " + this.getState();
    }

    public BigInteger toBigInteger() {
        this.checkRange(0, this.numBits, true);
        BigInteger out = BigInteger.ZERO;
        for (int ind = 0; ind < this.numBits; ++ind) {
            if (!this.get(ind)) continue;
            out = out.or(BigInteger.ONE.shiftLeft(this.numBits - ind - 1));
        }
        return out;
    }

    public BigInteger toLittleInteger() {
        this.checkRange(0, this.numBits, true);
        BigInteger out = BigInteger.ZERO;
        for (int ind = 0; ind < this.numBits; ++ind) {
            if (!this.get(ind)) continue;
            out = out.or(BigInteger.ONE.shiftLeft(ind));
        }
        return out;
    }

    public int[] toIntArray() {
        int[] array = new int[this.numBits];
        for (int ind = 0; ind < this.numBits; ++ind) {
            array[ind] = !this.valid.get(ind) ? -1 : (this.get(ind) ? 1 : 0);
        }
        return array;
    }

    public boolean isValid(int bitIndex) {
        this.checkIndex(bitIndex, false);
        return this.valid.get(bitIndex);
    }

    public void invalidate(int bitIndex) {
        this.checkIndex(bitIndex, false);
        this.valid.clear(bitIndex);
    }

    public void invalidate() {
        for (int ind = 0; ind < this.numBits; ++ind) {
            this.invalidate(ind);
        }
    }

    public boolean get(int bitIndex) {
        this.checkIndex(bitIndex, true);
        return this.bitSet.get(bitIndex);
    }

    public void flip(int bitIndex) {
        this.checkIndex(bitIndex, true);
        this.bitSet.flip(bitIndex);
    }

    public void flip(int fromIndex, int nbits) {
        this.checkRange(fromIndex, nbits, true);
        for (int bitIndex = fromIndex; bitIndex < fromIndex + nbits; ++bitIndex) {
            this.flip(bitIndex);
        }
    }

    public void clear(int bitIndex) {
        this.checkIndex(bitIndex, false);
        this.bitSet.clear(bitIndex);
        this.valid.set(bitIndex);
    }

    public void set(int bitIndex) {
        this.checkIndex(bitIndex, false);
        this.bitSet.set(bitIndex);
        this.valid.set(bitIndex);
    }

    public void set(int bitIndex, boolean value2) {
        this.checkIndex(bitIndex, false);
        this.bitSet.set(bitIndex, value2);
        this.valid.set(bitIndex);
    }

    public void set(int fromIndex, int nbits, boolean value2) {
        this.checkRange(fromIndex, nbits, false);
        this.bitSet.set(fromIndex, fromIndex + nbits, value2);
        this.valid.set(fromIndex, fromIndex + nbits);
    }

    public BitVector get(int fromIndex, int nbits) {
        this.checkRange(fromIndex, nbits, true);
        return this.getIndiscriminate(fromIndex, nbits);
    }

    public BitVector getIndiscriminate(int fromIndex, int nbits) {
        this.checkRange(fromIndex, nbits, false);
        BitVector result2 = new BitVector(nbits, "bits [" + fromIndex + ":" + (fromIndex + nbits - 1) + "] of " + this.getName());
        result2.bitSet = this.bitSet.get(fromIndex, fromIndex + nbits);
        result2.valid = this.valid.get(fromIndex, fromIndex + nbits);
        return result2;
    }

    public void put(int fromIndex, BitVector source) {
        int nbits = source.getNumBits();
        this.checkRange(fromIndex, nbits, false);
        source.checkRange(0, nbits, true);
        this.putIndiscriminate(fromIndex, source);
    }

    public void putIndiscriminate(int fromIndex, BitVector source) {
        int nbits = source.getNumBits();
        this.checkRange(fromIndex, nbits, false);
        source.checkRange(0, nbits, false);
        for (int ind = 0; ind < nbits; ++ind) {
            if (!source.isValid(ind)) {
                this.invalidate(fromIndex + ind);
                continue;
            }
            if (source.get(ind)) {
                this.set(fromIndex + ind);
                continue;
            }
            this.clear(fromIndex + ind);
        }
    }

    public void put(int fromIndex, String inp) {
        int length = inp.length();
        if (length == 0) {
            return;
        }
        this.checkRange(fromIndex, length, false);
        for (int ind = 0; ind < length; ++ind) {
            char character = inp.charAt(ind);
            if (character == '1') {
                this.set(fromIndex + ind);
                continue;
            }
            if (character == '0') {
                this.clear(fromIndex + ind);
                continue;
            }
            Infrastructure.fatal("Bad character " + character + " in bit string " + inp + ", only '0' and '1' are allowed for put method.");
        }
    }

    public void put(int fromIndex, int[] array) {
        int length = array.length;
        if (length == 0) {
            return;
        }
        this.checkRange(fromIndex, length, false);
        for (int ind = 0; ind < length; ++ind) {
            int i = array[ind];
            if (i == 1) {
                this.set(fromIndex + ind);
                continue;
            }
            if (i == 0) {
                this.clear(fromIndex + ind);
                continue;
            }
            Infrastructure.fatal("Bad value " + i + " in int[] " + array.toString() + ", only 0 and 1 are allowed for put method.");
        }
    }

    public void put(int fromIndex, int nbits, BigInteger inp) {
        this.checkRange(fromIndex, nbits, false);
        for (int ind = 0; ind < nbits; ++ind) {
            BigInteger bit = inp.shiftRight(nbits - ind - 1);
            if ((bit = bit.and(BigInteger.ONE)).equals(BigInteger.ONE)) {
                this.set(fromIndex + ind);
                continue;
            }
            if (bit.equals(BigInteger.ZERO)) {
                this.clear(fromIndex + ind);
                continue;
            }
            Infrastructure.fatal("Programming error: bad bit value " + bit + " in BigInteger " + inp);
        }
    }

    public void putLittle(int fromIndex, int nbits, BigInteger inp) {
        this.checkRange(fromIndex, nbits, false);
        for (int ind = 0; ind < nbits; ++ind) {
            BigInteger bit = inp.shiftRight(ind);
            if ((bit = bit.and(BigInteger.ONE)).equals(BigInteger.ONE)) {
                this.set(fromIndex + ind);
                continue;
            }
            if (bit.equals(BigInteger.ZERO)) {
                this.clear(fromIndex + ind);
                continue;
            }
            Infrastructure.fatal("Programming error: bad bit value " + bit + " in BigInteger " + inp);
        }
    }

    public int cardinality() {
        int numGoodBits = this.valid.cardinality();
        if (numGoodBits < this.numBits) {
            Infrastructure.fatal("Only " + numGoodBits + " out of " + this.numBits + " bits valid in BitVector '" + this.getName() + "'.  Can only count cardinality of" + " a fully-valid (i.e. initialized) BitVector.");
        }
        return this.bitSet.cardinality();
    }

    public boolean isEmpty() {
        this.checkRange(0, this.getNumBits(), true);
        return this.bitSet.isEmpty();
    }

    public boolean isInvalid() {
        this.checkRange(0, this.getNumBits(), false);
        return this.valid.isEmpty();
    }

    private void fatalIfAnyBitInvalid(String op) {
        for (int i = 0; i < this.getNumBits(); ++i) {
            if (this.isValid(i)) continue;
            Infrastructure.fatal(op + " operand contains invalid bits");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitVector)) {
            return false;
        }
        String s1 = this.getState();
        String s2 = ((BitVector)o).getState();
        return s1.equals(s2);
    }

    public int hashCode() {
        return this.getState().hashCode();
    }

    public BitVector cat(BitVector b) {
        String s = this.getState() + b.getState();
        return new BitVector(s, "cat");
    }

    public BitVector not() {
        BitVector r = new BitVector(this);
        r.flip(0, r.getNumBits());
        return r;
    }

    public BitVector and(BitVector b) {
        BitVector a = this;
        int lenA = a.getNumBits();
        int lenB = b.getNumBits();
        int l = Math.max(lenA, lenB);
        BitVector ans = new BitVector(l, "and");
        int aNdx = lenA - 1;
        int bNdx = lenB - 1;
        for (int i = l - 1; i >= 0; --i) {
            if (!a.isValid(aNdx) || !b.isValid(bNdx)) {
                ans.invalidate(i);
            } else {
                boolean av = a.get(aNdx);
                boolean bv = b.get(bNdx);
                boolean ansv = av && bv;
                ans.set(i, ansv);
            }
            if (aNdx > 0) {
                --aNdx;
            }
            if (bNdx <= 0) continue;
            --bNdx;
        }
        return ans;
    }

    public BitVector bitReverse() {
        int l = this.getNumBits();
        BitVector ans = new BitVector(l, "bitReverse");
        int j = l - 1;
        int i = 0;
        while (i < l) {
            if (this.isValid(i)) {
                ans.set(j, this.get(i));
            }
            ++i;
            --j;
        }
        return ans;
    }

    public void setFromLong(long longValue) {
        for (int i = this.getNumBits() - 1; i >= 0; --i) {
            this.set(i, (longValue & 1L) == 1L);
            longValue >>= 1;
        }
    }

    public void setFromBigInteger(BigInteger bigValue) {
        BigInteger ONE = BigInteger.ONE;
        for (int i = this.getNumBits() - 1; i >= 0; --i) {
            this.set(i, bigValue.and(ONE).equals(ONE));
            bigValue = bigValue.shiftRight(1);
        }
    }

    public BitVector add(BitVector bv) {
        this.fatalIfAnyBitInvalid("add");
        bv.fatalIfAnyBitInvalid("add");
        int len = Math.max(this.getNumBits(), bv.getNumBits());
        BitVector ans = new BitVector(len, "add");
        BigInteger a = this.toBigInteger();
        BigInteger b = bv.toBigInteger();
        ans.setFromBigInteger(a.add(b));
        return ans;
    }

    public BitVector subtract(BitVector bv) {
        this.fatalIfAnyBitInvalid("subtract");
        bv.fatalIfAnyBitInvalid("subtract");
        int len = Math.max(this.getNumBits(), bv.getNumBits());
        BitVector ans = new BitVector(len, "subtract");
        BigInteger a = this.toBigInteger();
        BigInteger b = bv.toBigInteger();
        ans.setFromBigInteger(a.subtract(b));
        return ans;
    }

    public BitVector shiftRight(int n) {
        this.fatalIfAnyBitInvalid("shiftRight");
        int len = this.getNumBits();
        BitVector ans = new BitVector(len, "shiftRight");
        for (int i = 0; i < len; ++i) {
            int j = Math.max(0, i - n);
            if (!this.isValid(j)) continue;
            ans.set(i, this.get(j));
        }
        return ans;
    }

    public long toLong() {
        this.fatalIfAnyBitInvalid("toLong");
        BigInteger big = this.toBigInteger();
        return big.longValue();
    }

    public boolean equalsLong(long v) {
        this.fatalIfAnyBitInvalid("equalsLong");
        int len = Math.max(64, this.getNumBits());
        BitVector a = new BitVector(len, "equalsLong a");
        BitVector b = new BitVector(len, "equalsLong b");
        a.setFromBigInteger(this.toBigInteger());
        b.setFromLong(v);
        return a.equals(b);
    }

    public BitVector rotateLeft(int amountToRotate) {
        int len = this.getNumBits();
        BitVector ans = new BitVector(len, "rotateLeft");
        for (int i = 0; i < len; ++i) {
            int j = (i + len - amountToRotate) % len;
            if (!this.isValid(i)) continue;
            ans.set(j, this.get(i));
        }
        return ans;
    }

    public BitVector rotateRight(int amountToRotate) {
        int len = this.getNumBits();
        BitVector ans = new BitVector(len, "rotateLeft");
        for (int i = 0; i < len; ++i) {
            int j = (i + len + amountToRotate) % len;
            if (!this.isValid(i)) continue;
            ans.set(j, this.get(i));
        }
        return ans;
    }

    private void checkIndex(int bitIndex, boolean checkValidity) {
        if (bitIndex < 0 || bitIndex > this.numBits) {
            Infrastructure.fatal("Bit index " + bitIndex + " outside allowed range of 0.." + this.numBits + " in BitVector " + this.toString());
        }
        if (checkValidity && !this.valid.get(bitIndex)) {
            this.printInvalidError(bitIndex);
        }
    }

    private void printInvalidError(int bitIndex) {
        Infrastructure.fatal("Attempt to access the bit at position " + bitIndex + " in BitVector '" + this.getName() + "', which is in the 'invalid' state.  " + "Bits must be explicitly set before being read.  " + "This error probably indicates incorrect " + "initialization of the BitVector.  " + "The BitVector state is " + this.getState());
    }

    private void checkRange(int fromIndex, int nbits, boolean checkValidity) {
        if (nbits <= 0) {
            Infrastructure.fatal("Attempt to read " + nbits + " bits, number must be positive");
        }
        if (fromIndex + nbits > this.numBits) {
            Infrastructure.fatal("Attempt to read past the end of BitVector '" + this.getName() + "', which has length " + this.numBits + ": fromIndex=" + fromIndex + ", nbits=" + nbits);
        }
        if (checkValidity) {
            for (int ind = fromIndex; ind < fromIndex + nbits; ++ind) {
                if (this.valid.get(ind)) continue;
                this.printInvalidError(ind);
            }
        }
    }

    public static void main(String[] args) {
        BitVector b1 = new BitVector(7, "b1");
        if (args.length > 0) {
            b1.put(0, args[0]);
        } else {
            b1.put(0, "1101");
        }
        System.out.print(b1 + ": bitSet=" + b1.bitSet);
        System.out.println(", length=" + b1.numBits + ", size=" + b1.bitSet.size());
        System.out.println("3 bits starting at 1: " + b1.get(1, 3));
        b1.set(2);
        b1.clear(1);
        System.out.println("After setting 2, clearing 1: " + b1);
        String b2String = args.length > 1 ? args[1] : "1001";
        BitVector b2 = new BitVector(b2String.length(), "b2");
        b2.put(0, b2String);
        b1.put(2, b2);
        System.out.println("inserted " + b2 + " at position 2: " + b1);
        b1.put(2, "010");
        System.out.println("inserted 3 bits 010 at position 2: " + b1);
        BitVector b3 = new BitVector(40, "b3");
        BigInteger biggy = new BigInteger("3");
        b3.set(0, b3.getNumBits(), false);
        b3.put(0, 2, biggy);
        System.out.println("biggy = " + biggy + ", b3 = " + b3.getState() + ", biggy2 = " + b3.toBigInteger() + " (" + b3.toLittleInteger() + ")");
        biggy = new BigInteger("536870912");
        b3.put(3, 30, biggy);
        System.out.println("biggy = " + biggy + ", b3 = " + b3.getState() + ", biggy2 = " + b3.toBigInteger() + " (" + b3.toLittleInteger() + ")");
        BitVector b4 = new BitVector(10, "b4");
        biggy = new BigInteger("512");
        b4.put(0, 10, biggy);
        System.out.println("biggy = " + biggy + ", b4 = " + b4.getState() + ", biggy2 = " + b4.toBigInteger() + " (" + b4.toLittleInteger() + ")");
        biggy = new BigInteger("11");
        b4.putLittle(2, 5, biggy);
        System.out.println("biggy = " + biggy + ", b4 = " + b4.getState() + ", biggy2 = " + b4.toBigInteger() + " (" + b4.toLittleInteger() + ")");
        System.out.println("Convenience constructor: " + new BitVector("101", "convenience"));
    }
}

