/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.EDimension;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SeaOfGatesCell
extends EDialog {
    private SeaOfGates.SeaOfGatesCellParameters sogp;
    private JList arcsList;
    private JList gridPointsList;
    private JList netsList;
    private JList layersList;
    private DefaultListModel arcsModel;
    private DefaultListModel gridPointsModel;
    private DefaultListModel netsModel;
    private DefaultListModel layersModel;
    private Technology curTech;
    private static SeaOfGatesCell theDialog = null;
    private boolean fixedValuesChanging = false;
    private boolean defaultOverridesChanging = false;
    private boolean perLayerOverridesChanging = false;
    private JPanel entireCell;
    private JPanel gridArbitrary;
    private JPanel gridControl;
    private JPanel gridFixed;
    private JPanel individualLayers;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton ok;
    private JButton sogAddLayerToNet;
    private JButton sogAddNet;
    private JScrollPane sogArcList;
    private JCheckBox sogAvoidLayer;
    private JTextField sogContactExclusionPat;
    private JTextField sogContactInclusionPat;
    private JTextField sogDefSpacing;
    private JTextField sogDefWidth;
    private JButton sogDrawGrid;
    private JButton sogExportData;
    private JCheckBox sogFavorLayer;
    private JTextField sogFixedOffset;
    private JTextField sogFixedSpacing;
    private JButton sogGridAllDown;
    private JButton sogGridAllUp;
    private JRadioButton sogGridArbitrary;
    private JRadioButton sogGridFixed;
    private JButton sogGridIndDelete;
    private JButton sogGridIndDown;
    private JButton sogGridIndNew;
    private JScrollPane sogGridIndScroll;
    private JButton sogGridIndUp;
    private JLabel sogGridLabel;
    private JRadioButton sogGridNone;
    private JButton sogGridOffsetDown;
    private JButton sogGridOffsetUp;
    private JButton sogGridSpacingDown;
    private JButton sogGridSpacingUp;
    private ButtonGroup sogGridType;
    private JRadioButton sogHorOddVerEven;
    private ButtonGroup sogHorVerChoices;
    private JComboBox sogHorVerUsage;
    private JButton sogImportData;
    private JScrollPane sogLayerList;
    private JTextField sogLayerSpacingOverride;
    private JTextField sogLayerWidthOverride;
    private JScrollPane sogNetList;
    private JTextField sogNetName;
    private JCheckBox sogNoRotatedContacts;
    private JCheckBox sogNoSteinerTrees;
    private JButton sogRemoveLayerFromNet;
    private JButton sogRemoveNet;
    private JCheckBox sogShowGrid;
    private JComboBox sogTechList;
    private JRadioButton sogVerOddHorEven;

    public static void showSeaOfGatesCellDialog() {
        EditWindow wnd = EditWindow.needCurrent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell selected for SoG Cell Properties Dialog");
            return;
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new SeaOfGatesCell(jf);
        }
        SeaOfGatesCell.theDialog.sogTechList.removeAllItems();
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            SeaOfGatesCell.theDialog.sogTechList.addItem(tech.getTechName());
        }
        if (cell != null) {
            SeaOfGatesCell.theDialog.jLabel1.setText("Sea-of-Gates Properties for Cell " + cell.describe(false));
            SeaOfGatesCell.theDialog.sogp = new SeaOfGates.SeaOfGatesCellParameters(cell);
            SeaOfGatesCell.theDialog.curTech = Technology.getCurrent();
            theDialog.loadDialog();
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    private SeaOfGatesCell(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.sogExportData.setEnabled(false);
        this.arcsModel = new DefaultListModel();
        this.arcsList = new JList(this.arcsModel);
        this.arcsList.setSelectionMode(0);
        this.arcsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SeaOfGatesCell.this.arcClicked();
            }
        });
        this.sogArcList.setViewportView(this.arcsList);
        this.netsModel = new DefaultListModel();
        this.netsList = new JList(this.netsModel);
        this.netsList.setSelectionMode(2);
        this.netsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SeaOfGatesCell.this.redrawArcOverridesList();
            }
        });
        this.sogNetList.setViewportView(this.netsList);
        this.layersModel = new DefaultListModel();
        this.layersList = new JList(this.layersModel);
        this.layersList.setSelectionMode(2);
        this.layersList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SeaOfGatesCell.this.loadWidthSpacingOverrides();
            }
        });
        this.sogLayerList.setViewportView(this.layersList);
        this.sogGridAllUp.setBorderPainted(false);
        this.sogGridAllDown.setBorderPainted(false);
        this.sogGridIndUp.setBorderPainted(false);
        this.sogGridIndDown.setBorderPainted(false);
        this.sogGridSpacingUp.setBorderPainted(false);
        this.sogGridSpacingDown.setBorderPainted(false);
        this.sogGridOffsetUp.setBorderPainted(false);
        this.sogGridOffsetDown.setBorderPainted(false);
        this.sogHorVerUsage.addItem("Favor");
        this.sogHorVerUsage.addItem("Force");
        this.sogHorVerUsage.addItem("Ignore");
        this.gridPointsModel = new DefaultListModel();
        this.gridPointsList = new JList(this.gridPointsModel);
        this.gridPointsList.setSelectionMode(0);
        this.gridPointsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SeaOfGatesCell.this.gridPointClicked();
            }
        });
        this.sogGridIndScroll.setViewportView(this.gridPointsList);
        this.sogTechList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.techChanged();
            }
        });
        this.sogAddNet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.addNetworkName();
            }
        });
        this.sogRemoveNet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.removeNetworkName();
            }
        });
        this.sogAddLayerToNet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.addLayerToNet();
            }
        });
        this.sogRemoveLayerFromNet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.removeLayerFromNet();
            }
        });
        this.sogDrawGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.drawGrid();
            }
        });
        this.sogHorVerUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.horVerChanged();
            }
        });
        this.sogVerOddHorEven.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.horVerChanged();
            }
        });
        this.sogHorOddVerEven.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.horVerChanged();
            }
        });
        this.sogGridNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.gridTypeChanged();
            }
        });
        this.sogGridFixed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.gridTypeChanged();
            }
        });
        this.sogGridArbitrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.gridTypeChanged();
            }
        });
        this.sogFavorLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.favorClicked();
            }
        });
        this.sogAvoidLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.preventClicked();
            }
        });
        ContactDocumentListener contactDocumentListener = new ContactDocumentListener();
        this.sogContactInclusionPat.getDocument().addDocumentListener(contactDocumentListener);
        this.sogContactExclusionPat.getDocument().addDocumentListener(contactDocumentListener);
        MainDocumentListener mainDocumentListener = new MainDocumentListener();
        this.sogDefWidth.getDocument().addDocumentListener(mainDocumentListener);
        this.sogDefSpacing.getDocument().addDocumentListener(mainDocumentListener);
        OverrideDocumentListener overrideDocumentListener = new OverrideDocumentListener();
        this.sogLayerWidthOverride.getDocument().addDocumentListener(overrideDocumentListener);
        this.sogLayerSpacingOverride.getDocument().addDocumentListener(overrideDocumentListener);
        this.sogNoSteinerTrees.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.steinerTreesChanged();
            }
        });
        this.sogNoRotatedContacts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.rotatedContactsChanged();
            }
        });
        this.sogShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.updateGridDisplay(true);
            }
        });
        this.sogGridIndUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.moveGridLines(1, false);
            }
        });
        this.sogGridIndDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.moveGridLines(-1, false);
            }
        });
        this.sogGridAllUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.moveGridLines(1, true);
            }
        });
        this.sogGridAllDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.moveGridLines(-1, true);
            }
        });
        this.sogGridSpacingUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.shiftGridSpacing(1);
            }
        });
        this.sogGridSpacingDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.shiftGridSpacing(-1);
            }
        });
        this.sogGridOffsetUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.shiftGridOffset(1);
            }
        });
        this.sogGridOffsetDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.shiftGridOffset(-1);
            }
        });
        this.sogGridIndDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.deleteGridLine();
            }
        });
        this.sogGridIndNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.addGridLine();
            }
        });
        this.sogFixedSpacing.getDocument().addDocumentListener(new FixedGridDocumentListener());
        this.sogFixedOffset.getDocument().addDocumentListener(new FixedGridDocumentListener());
    }

    private void loadDialog() {
        this.sogNoSteinerTrees.setSelected(this.sogp.isSteinerDone());
        if (this.sogp.isHorizontalEven()) {
            this.sogVerOddHorEven.setSelected(true);
        } else {
            this.sogHorOddVerEven.setSelected(true);
        }
        if (this.sogp.isForceHorVer()) {
            this.sogHorVerUsage.setSelectedIndex(1);
        } else if (this.sogp.isFavorHorVer()) {
            this.sogHorVerUsage.setSelectedIndex(0);
        } else {
            this.sogHorVerUsage.setSelectedIndex(2);
        }
        this.sogContactInclusionPat.setText(this.sogp.getAcceptOnlyPrimitives());
        this.sogContactExclusionPat.setText(this.sogp.getIgnorePrimitives());
        this.sogNoRotatedContacts.setSelected(!this.sogp.isContactsRotate());
        this.sogTechList.setSelectedItem(this.curTech.getTechName());
        this.loadNets();
        this.loadWidthSpacingOverrides();
    }

    private void loadNets() {
        this.netsModel.clear();
        Set<String> nets = this.sogp.getNetsToRoute();
        for (String netName : nets) {
            this.netsModel.addElement(netName);
        }
        if (nets.size() > 0) {
            this.netsList.setSelectedIndex(0);
        } else {
            this.netsList.setSelectedIndex(-1);
        }
    }

    private ArcProto getCurrentlySelectedArc() {
        String str = (String)this.arcsList.getSelectedValue();
        if (str == null) {
            return null;
        }
        int pos = str.indexOf(32);
        if (pos >= 0) {
            str = str.substring(0, pos);
        }
        ArcProto ap = this.curTech.findArcProto(str);
        return ap;
    }

    private void steinerTreesChanged() {
        this.sogp.setSteinerDone(this.sogNoSteinerTrees.isSelected());
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void rotatedContactsChanged() {
        this.sogp.setContactsRotate(!this.sogNoRotatedContacts.isSelected());
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void horVerChanged() {
        switch (this.sogHorVerUsage.getSelectedIndex()) {
            case 0: {
                this.sogp.setForceHorVer(false);
                this.sogp.setFavorHorVer(true);
                break;
            }
            case 1: {
                this.sogp.setForceHorVer(true);
                this.sogp.setFavorHorVer(true);
                break;
            }
            case 2: {
                this.sogp.setForceHorVer(false);
                this.sogp.setFavorHorVer(false);
            }
        }
        this.sogp.setHorizontalEven(this.sogVerOddHorEven.isSelected());
        this.updateGridDisplay(false);
        this.arcClicked();
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void favorClicked() {
        ArcProto ap = this.getCurrentlySelectedArc();
        this.sogp.setFavored(ap, this.sogFavorLayer.isSelected());
        this.setArcLine(ap, this.makeArcLine(ap));
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void preventClicked() {
        ArcProto ap = this.getCurrentlySelectedArc();
        this.sogp.setPrevented(ap, this.sogAvoidLayer.isSelected());
        this.setArcLine(ap, this.makeArcLine(ap));
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void contactPatternChanged() {
        this.sogp.setAcceptOnlyPrimitive(this.sogContactInclusionPat.getText().trim());
        this.sogp.setIgnorePrimitive(this.sogContactExclusionPat.getText().trim());
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void defaultOverridesChanged() {
        if (this.defaultOverridesChanging) {
            return;
        }
        ArcProto ap = this.getCurrentlySelectedArc();
        String val = this.sogDefWidth.getText().trim();
        Double w = null;
        if (val.length() > 0) {
            w = new Double(TextUtils.atof(val));
        }
        this.sogp.setDefaultWidthOverride(ap, w);
        val = this.sogDefSpacing.getText().trim();
        Double s = null;
        if (val.length() > 0) {
            s = new Double(TextUtils.atof(val));
        }
        this.sogp.setDefaultSpacingOverride(ap, s);
        this.setArcLine(ap, this.makeArcLine(ap));
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void layerOverridesChanged() {
        if (this.perLayerOverridesChanging) {
            return;
        }
        if (this.sogp == null) {
            return;
        }
        Object[] netNames = this.netsList.getSelectedValues();
        if (netNames == null || netNames.length != 1) {
            return;
        }
        String netName = (String)netNames[0];
        if (netName == null || netName.length() == 0) {
            return;
        }
        Object[] arcNames = this.layersList.getSelectedValues();
        if (arcNames == null || arcNames.length != 1) {
            return;
        }
        String arcName = (String)arcNames[0];
        if (arcName == null) {
            return;
        }
        int spacePos = arcName.indexOf(32);
        if (spacePos >= 0) {
            arcName = arcName.substring(0, spacePos);
        }
        ArcProto ap = this.curTech.findArcProto(arcName);
        String val = this.sogLayerWidthOverride.getText().trim();
        Double w = null;
        if (val.length() > 0) {
            w = new Double(TextUtils.atof(val));
        }
        this.sogp.setWidthOverrideForArcOnNet(netName, ap, w);
        val = this.sogLayerSpacingOverride.getText().trim();
        Double s = null;
        if (val.length() > 0) {
            s = new Double(TextUtils.atof(val));
        }
        this.sogp.setSpacingOverrideForArcOnNet(netName, ap, s);
        this.setArcOverrideLine(ap, this.makeArcOnNetworkLine(netName, ap));
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void setArcOverrideLine(ArcProto ap, String line) {
        for (int i = 0; i < this.layersModel.getSize(); ++i) {
            ArcProto listAP;
            String listLine = (String)this.layersModel.get(i);
            int pos = listLine.indexOf(32);
            if (pos >= 0) {
                listLine = listLine.substring(0, pos);
            }
            if ((listAP = this.curTech.findArcProto(listLine)) != ap) continue;
            this.layersModel.set(i, line);
            break;
        }
    }

    private void setArcLine(ArcProto ap, String line) {
        for (int i = 0; i < this.arcsModel.getSize(); ++i) {
            ArcProto listAP;
            String listLine = (String)this.arcsModel.get(i);
            int pos = listLine.indexOf(32);
            if (pos >= 0) {
                listLine = listLine.substring(0, pos);
            }
            if ((listAP = this.curTech.findArcProto(listLine)) != ap) continue;
            this.arcsModel.set(i, line);
            break;
        }
    }

    private List<Double> getCoordinates() {
        ArcProto ap = this.getCurrentlySelectedArc();
        String newGrid = this.sogp.getGrid(ap);
        ArrayList<Double> coords = new ArrayList<Double>();
        if (newGrid != null) {
            String[] parts = newGrid.split(",");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i].trim();
                if (part.length() == 0) continue;
                double val = TextUtils.atof(part);
                coords.add(new Double(val));
            }
        }
        return coords;
    }

    private String makeArcLine(ArcProto ap) {
        String line = ap.getName();
        boolean extras = false;
        if (this.sogp.isPrevented(ap)) {
            line = extras ? line + ", " : line + " (";
            line = line + "avoid";
            extras = true;
        }
        if (this.sogp.isFavored(ap)) {
            line = extras ? line + ", " : line + " (";
            line = line + "favor";
            extras = true;
        }
        if (this.sogp.getDefaultWidthOverride(ap) != null) {
            line = extras ? line + ", " : line + " (";
            line = line + "width=" + TextUtils.formatDouble(this.sogp.getDefaultWidthOverride(ap));
            extras = true;
        }
        if (this.sogp.getDefaultSpacingOverride(ap) != null) {
            line = extras ? line + ", " : line + " (";
            line = line + "spacing=" + TextUtils.formatDouble(this.sogp.getDefaultSpacingOverride(ap));
            extras = true;
        }
        if (extras) {
            line = line + ")";
        }
        return line;
    }

    private String makeArcOnNetworkLine(String netName, ArcProto ap) {
        String line = ap.getName();
        List<ArcProto> arcs = this.sogp.getArcsOnNet(netName);
        line = arcs == null || arcs.size() == 0 ? (this.sogp.isPrevented(ap) ? line + " (excluded by default" : line + " (included by default") : (this.sogp.getArcsOnNet(netName).contains(ap) ? line + " (include" : line + " (excluded");
        SeaOfGates.SeaOfGatesArcProperties sogap = this.sogp.getOverridesForArcsOnNet(netName, ap);
        if (sogap != null) {
            if (sogap.getWidthOverride() != null) {
                line = line + ", width=" + TextUtils.formatDouble(sogap.getWidthOverride());
            }
            if (sogap.getSpacingOverride() != null) {
                line = line + ", spacing=" + TextUtils.formatDouble(sogap.getSpacingOverride());
            }
        }
        line = line + ")";
        return line;
    }

    private void redrawArcOverridesList() {
        if (this.sogp == null) {
            return;
        }
        this.layersModel.clear();
        Object[] netNames = this.netsList.getSelectedValues();
        if (netNames == null || netNames.length != 1) {
            return;
        }
        String netName = (String)netNames[0];
        int index = this.netsList.getSelectedIndex();
        if (netName != null && netName.length() > 0) {
            Iterator<ArcProto> it = this.curTech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (!ap.getFunction().isMetal()) continue;
                this.layersModel.addElement(this.makeArcOnNetworkLine(netName, ap));
            }
        }
        this.netsList.setSelectedIndex(index);
    }

    private void loadWidthSpacingOverrides() {
        ArcProto ap;
        SeaOfGates.SeaOfGatesArcProperties sogap;
        this.perLayerOverridesChanging = true;
        this.sogLayerWidthOverride.setText("");
        this.sogLayerSpacingOverride.setText("");
        this.sogLayerWidthOverride.setEnabled(false);
        this.sogLayerSpacingOverride.setEnabled(false);
        this.perLayerOverridesChanging = false;
        if (this.sogp == null) {
            return;
        }
        Object[] netNames = this.netsList.getSelectedValues();
        if (netNames == null || netNames.length != 1) {
            return;
        }
        String netName = (String)netNames[0];
        if (netName == null || netName.length() == 0) {
            return;
        }
        Object[] arcNames = this.layersList.getSelectedValues();
        if (arcNames == null || arcNames.length != 1) {
            return;
        }
        String arcName = (String)arcNames[0];
        if (arcName == null) {
            return;
        }
        this.sogLayerWidthOverride.setEnabled(true);
        this.sogLayerSpacingOverride.setEnabled(true);
        int spacePos = arcName.indexOf(32);
        if (spacePos >= 0) {
            arcName = arcName.substring(0, spacePos);
        }
        if ((sogap = this.sogp.getOverridesForArcsOnNet(netName, ap = this.curTech.findArcProto(arcName))) == null) {
            return;
        }
        this.perLayerOverridesChanging = true;
        if (sogap.getWidthOverride() != null) {
            this.sogLayerWidthOverride.setText(TextUtils.formatDouble(sogap.getWidthOverride()));
        }
        if (sogap.getSpacingOverride() != null) {
            this.sogLayerSpacingOverride.setText(TextUtils.formatDouble(sogap.getSpacingOverride()));
        }
        this.perLayerOverridesChanging = false;
    }

    private void arcClicked() {
        if (this.sogp == null) {
            return;
        }
        ArcProto ap = this.getCurrentlySelectedArc();
        if (ap == null) {
            return;
        }
        this.sogAvoidLayer.setSelected(this.sogp.isPrevented(ap));
        this.sogFavorLayer.setSelected(this.sogp.isFavored(ap));
        this.defaultOverridesChanging = true;
        if (this.sogp.getDefaultWidthOverride(ap) == null) {
            this.sogDefWidth.setText("");
        } else {
            this.sogDefWidth.setText(TextUtils.formatDouble(this.sogp.getDefaultWidthOverride(ap)));
        }
        if (this.sogp.getDefaultSpacingOverride(ap) == null) {
            this.sogDefSpacing.setText("");
        } else {
            this.sogDefSpacing.setText(TextUtils.formatDouble(this.sogp.getDefaultSpacingOverride(ap)));
        }
        this.defaultOverridesChanging = false;
        this.setGridLabel(ap);
        this.gridPointsModel.clear();
        List<Double> coords = this.getCoordinates();
        if (coords.size() == 0) {
            this.sogGridNone.setSelected(true);
            this.setFixedGridEnabled(false);
            this.setArbitraryGridEnabled(false);
        } else {
            if (coords.size() == 2) {
                this.setFixedGridEnabled(true);
                this.setArbitraryGridEnabled(false);
                this.sogGridFixed.setSelected(true);
                double v1 = coords.get(0);
                double v2 = coords.get(1);
                this.fixedValuesChanging = true;
                this.sogFixedSpacing.setText(TextUtils.formatDouble(v2 - v1));
                this.sogFixedOffset.setText(TextUtils.formatDouble(v1));
                this.fixedValuesChanging = false;
            } else {
                this.setFixedGridEnabled(false);
                this.setArbitraryGridEnabled(true);
                this.sogGridArbitrary.setSelected(true);
                this.fixedValuesChanging = true;
                this.sogFixedSpacing.setText("");
                this.sogFixedOffset.setText("");
                this.fixedValuesChanging = false;
            }
            this.loadArbitraryPoints(coords);
        }
        if (this.gridPointsModel.getSize() > 0) {
            this.gridPointsList.setSelectedIndex(0);
        } else {
            this.gridPointsList.setSelectedIndex(-1);
        }
        this.redrawArcOverridesList();
        this.updateGridDisplay(true);
    }

    private void gridTypeChanged() {
        if (this.sogGridNone.isSelected()) {
            this.setFixedGridEnabled(false);
            this.setArbitraryGridEnabled(false);
            this.fixedValuesChanging = true;
            this.sogFixedSpacing.setText("");
            this.sogFixedOffset.setText("");
            this.fixedValuesChanging = false;
            this.gridPointsModel.clear();
            this.gridPointsList.setSelectedIndex(-1);
            this.saveGridValues();
        } else if (this.sogGridFixed.isSelected()) {
            this.setFixedGridEnabled(true);
            this.setArbitraryGridEnabled(false);
            List<Double> coords = this.getCoordinates();
            double v1 = 0.0;
            double v2 = 0.0;
            if (coords.size() > 0) {
                v1 = coords.get(0);
            }
            v2 = coords.size() > 1 ? coords.get(1) : v1 + 10.0;
            this.fixedValuesChanging = true;
            this.sogFixedSpacing.setText(TextUtils.formatDouble(v2 - v1));
            this.fixedValuesChanging = false;
            this.sogFixedOffset.setText(TextUtils.formatDouble(v1));
        } else {
            this.setFixedGridEnabled(false);
            this.setArbitraryGridEnabled(true);
            List<Double> coords = this.getCoordinates();
            this.gridPointsModel.clear();
            this.loadArbitraryPoints(coords);
            if (this.gridPointsModel.getSize() > 0) {
                this.gridPointsList.setSelectedIndex(0);
            } else {
                this.gridPointsList.setSelectedIndex(-1);
            }
            if (coords.size() != 2) {
                this.fixedValuesChanging = true;
                this.sogFixedSpacing.setText("");
                this.sogFixedOffset.setText("");
                this.fixedValuesChanging = false;
            }
        }
    }

    private void loadArbitraryPoints(List<Double> coords) {
        double lastVal = 0.0;
        for (int i = 0; i < coords.size(); ++i) {
            double val = coords.get(i);
            String elVal = TextUtils.formatDouble(val);
            if (i > 0) {
                elVal = elVal + " (+" + TextUtils.formatDouble(val - lastVal) + ")";
            }
            this.gridPointsModel.addElement(elVal);
            lastVal = val;
        }
    }

    private void setFixedGridEnabled(boolean enabled) {
        TitledBorder b = (TitledBorder)this.gridFixed.getBorder();
        b.setTitleColor(enabled ? Color.black : Color.GRAY);
        this.sogFixedSpacing.setEnabled(enabled);
        this.sogFixedOffset.setEnabled(enabled);
        this.jLabel6.setEnabled(enabled);
        this.jLabel8.setEnabled(enabled);
        this.sogGridSpacingUp.setEnabled(enabled);
        this.sogGridSpacingDown.setEnabled(enabled);
        this.sogGridOffsetUp.setEnabled(enabled);
        this.sogGridOffsetDown.setEnabled(enabled);
    }

    private void setArbitraryGridEnabled(boolean enabled) {
        TitledBorder b = (TitledBorder)this.gridArbitrary.getBorder();
        b.setTitleColor(enabled ? Color.black : Color.GRAY);
        this.gridPointsList.setEnabled(enabled);
        this.jLabel3.setEnabled(enabled);
        this.jLabel4.setEnabled(enabled);
        this.sogDrawGrid.setEnabled(enabled);
        this.sogGridAllUp.setEnabled(enabled);
        this.sogGridAllDown.setEnabled(enabled);
        this.sogGridIndUp.setEnabled(enabled);
        this.sogGridIndDown.setEnabled(enabled);
        this.sogGridIndDelete.setEnabled(enabled);
        this.sogGridIndNew.setEnabled(enabled);
    }

    private void fixedGridValuesChanged() {
        if (this.fixedValuesChanging) {
            return;
        }
        double v1 = TextUtils.atof(this.sogFixedSpacing.getText());
        double v2 = TextUtils.atof(this.sogFixedOffset.getText());
        this.gridPointsModel.clear();
        this.gridPointsModel.addElement(TextUtils.formatDouble(v2));
        this.gridPointsModel.addElement(TextUtils.formatDouble(v2 + v1) + " (+" + TextUtils.formatDouble(v1) + ")");
        this.saveGridValues();
    }

    private void shiftGridSpacing(int dir) {
        if (!this.isTechnologyLoaded()) {
            return;
        }
        double v1 = TextUtils.atof(this.sogFixedSpacing.getText()) + (double)dir;
        double v2 = TextUtils.atof(this.sogFixedOffset.getText());
        this.fixedValuesChanging = true;
        this.sogFixedSpacing.setText(TextUtils.formatDouble(v1));
        this.fixedValuesChanging = false;
        this.gridPointsModel.clear();
        this.gridPointsModel.addElement(TextUtils.formatDouble(v2));
        this.gridPointsModel.addElement(TextUtils.formatDouble(v2 + v1) + " (+" + TextUtils.formatDouble(v1) + ")");
        this.saveGridValues();
    }

    private void shiftGridOffset(int dir) {
        if (!this.isTechnologyLoaded()) {
            return;
        }
        double v1 = TextUtils.atof(this.sogFixedSpacing.getText());
        double v2 = TextUtils.atof(this.sogFixedOffset.getText()) + (double)dir;
        this.fixedValuesChanging = true;
        this.sogFixedOffset.setText(TextUtils.formatDouble(v2));
        this.fixedValuesChanging = false;
        this.gridPointsModel.clear();
        this.gridPointsModel.addElement(TextUtils.formatDouble(v2));
        this.gridPointsModel.addElement(TextUtils.formatDouble(v2 + v1) + " (+" + TextUtils.formatDouble(v1) + ")");
        this.saveGridValues();
    }

    private void setGridLabel(ArcProto ap) {
        Boolean isHor = this.getGridHorizontal(ap);
        if (isHor == null) {
            this.sogGridLabel.setText("Grid:");
        } else if (isHor.booleanValue()) {
            this.sogGridLabel.setText("Horizontal Grid:");
        } else {
            this.sogGridLabel.setText("Vertical Grid:");
        }
    }

    private Boolean getGridHorizontal(ArcProto ap) {
        if (this.sogHorVerUsage.getSelectedIndex() == 2) {
            return null;
        }
        Boolean isHor = Boolean.TRUE;
        if (this.sogVerOddHorEven.isSelected()) {
            if (ap.getFunction().getLevel() % 2 != 0) {
                isHor = Boolean.FALSE;
            }
        } else if (ap.getFunction().getLevel() % 2 == 0) {
            isHor = Boolean.FALSE;
        }
        return isHor;
    }

    private void techChanged() {
        String techName = (String)this.sogTechList.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.curTech = tech;
        this.arcsModel.clear();
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (!ap.getFunction().isMetal()) continue;
            this.arcsModel.addElement(this.makeArcLine(ap));
        }
        this.arcsList.setSelectedIndex(0);
        this.arcClicked();
    }

    private void addNetworkName() {
        String netName = this.sogNetName.getText().trim();
        if (netName.length() == 0) {
            Job.getUserInterface().showErrorMessage("No Network Name Entered", "Type a Net name first.");
            return;
        }
        Set<String> nets = this.sogp.getNetsToRoute();
        if (nets.contains(netName)) {
            Job.getUserInterface().showErrorMessage("Duplicate Network Name", "The name (" + netName + ") is already in the list.");
            return;
        }
        Set<String> allNetNames = this.getAllNetNames();
        if (!allNetNames.contains(netName)) {
            Job.getUserInterface().showErrorMessage("Network name " + netName + " was not found in the current cell. Adding to the list anyway.", "Unknown network name");
        }
        this.sogp.addNetToRoute(netName);
        this.loadNets();
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void removeNetworkName() {
        Object[] netNames = this.netsList.getSelectedValues();
        if (netNames == null || netNames.length == 0) {
            Job.getUserInterface().showErrorMessage("No Network Name Selected", "Click on a name from the above list to delete it.");
            return;
        }
        for (int i = 0; i < netNames.length; ++i) {
            this.sogp.removeNetToRoute((String)netNames[i]);
        }
        this.loadNets();
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void addLayerToNet() {
        String netName = null;
        Object[] netNames = this.netsList.getSelectedValues();
        if (netNames != null && netNames.length == 1) {
            netName = (String)netNames[0];
        }
        if (netName == null) {
            Job.getUserInterface().showErrorMessage("Click on a net name from the above list before adding a layer.", "No Network Name Selected");
            return;
        }
        Object[] arcNames = this.layersList.getSelectedValues();
        if (arcNames == null || arcNames.length == 0) {
            Job.getUserInterface().showErrorMessage("Click on a layer name from the above list before adding to the selected network.", "No Layer Name Selected");
            return;
        }
        for (int i = 0; i < arcNames.length; ++i) {
            String arcName = (String)arcNames[i];
            int spacePos = arcName.indexOf(32);
            if (spacePos >= 0) {
                arcName = arcName.substring(0, spacePos);
            }
            ArcProto ap = this.curTech.findArcProto(arcName);
            this.sogp.addArcToNet(netName, ap);
        }
        this.redrawArcOverridesList();
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void removeLayerFromNet() {
        String netName = null;
        Object[] netNames = this.netsList.getSelectedValues();
        if (netNames != null && netNames.length == 1) {
            netName = (String)netNames[0];
        }
        if (netName == null) {
            Job.getUserInterface().showErrorMessage("Click on a net name from the above list before removing a layer.", "No Network Name Selected");
            return;
        }
        Object[] arcNames = this.layersList.getSelectedValues();
        if (arcNames == null || arcNames.length == 0) {
            Job.getUserInterface().showErrorMessage("Click on a layer name from the above list to remove it from the selected network.", "No Layer Name Selected");
            return;
        }
        for (int i = 0; i < arcNames.length; ++i) {
            String arcName = (String)arcNames[i];
            int spacePos = arcName.indexOf(32);
            if (spacePos >= 0) {
                arcName = arcName.substring(0, spacePos);
            }
            ArcProto ap = this.curTech.findArcProto(arcName);
            List<ArcProto> arcs = this.sogp.getArcsOnNet(netName);
            if (arcs == null || arcs.size() == 0) {
                Iterator<ArcProto> it = this.curTech.getArcs();
                while (it.hasNext()) {
                    ArcProto apIt = it.next();
                    if (apIt == ap) continue;
                    this.sogp.addArcToNet(netName, apIt);
                }
                continue;
            }
            this.sogp.removeArcFromNet(netName, ap);
        }
        this.redrawArcOverridesList();
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void gridPointClicked() {
        this.updateGridDisplay(true);
    }

    private void moveGridLines(int dir, boolean moveAll) {
        if (!this.isTechnologyLoaded()) {
            return;
        }
        EDimension dim = User.getAlignmentToGrid();
        if (moveAll) {
            double lastVal = 0.0;
            for (int i = 0; i < this.gridPointsModel.getSize(); ++i) {
                double val = TextUtils.atof((String)this.gridPointsModel.get(i)) + dim.getHeight() * (double)dir;
                String elVal = TextUtils.formatDouble(val);
                if (i > 0) {
                    elVal = elVal + " (+" + TextUtils.formatDouble(val - lastVal) + ")";
                }
                this.gridPointsModel.set(i, elVal);
                lastVal = val;
            }
        } else {
            int index = this.gridPointsList.getSelectedIndex();
            double v = TextUtils.atof((String)this.gridPointsModel.get(index)) + dim.getHeight() * (double)dir;
            this.gridPointsModel.set(index, v + "");
            this.sortGridPoints();
        }
        this.saveGridValues();
        this.updateGridDisplay(false);
    }

    private void sortGridPoints() {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i = 0; i < this.gridPointsModel.getSize(); ++i) {
            double v = TextUtils.atof((String)this.gridPointsModel.get(i));
            vals.add(new Double(v));
        }
        Collections.sort(vals);
        double lastVal = 0.0;
        for (int i = 0; i < this.gridPointsModel.getSize(); ++i) {
            double val = (Double)vals.get(i);
            String elVal = TextUtils.formatDouble(val);
            if (i > 0) {
                elVal = elVal + " (+" + TextUtils.formatDouble(val - lastVal) + ")";
            }
            this.gridPointsModel.set(i, elVal);
            lastVal = val;
        }
    }

    private boolean isTechnologyLoaded() {
        if (this.curTech == null) {
            System.out.println("You must load a cell with a valid technology first");
            return false;
        }
        return true;
    }

    private void addGridLine() {
        if (!this.isTechnologyLoaded()) {
            return;
        }
        String str = Job.getUserInterface().askForInput("Grid Line Coordinate(s):", "Make New Grid Lines (comma-separated list)", "0");
        if (str == null) {
            return;
        }
        String[] parts = str.split(",");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            if (part.length() == 0) continue;
            double vInsert = TextUtils.atof(part);
            this.insertGridLine(vInsert);
        }
        this.saveGridValues();
        this.updateGridDisplay(false);
    }

    private void insertGridLine(double vInsert) {
        boolean inserted = false;
        double lastVal = 0.0;
        for (int i = 0; i < this.gridPointsModel.getSize(); ++i) {
            double v = TextUtils.atof((String)this.gridPointsModel.get(i));
            if (vInsert <= v) {
                String elVal = TextUtils.formatDouble(vInsert);
                if (i > 0) {
                    elVal = elVal + " (+" + TextUtils.formatDouble(vInsert - lastVal) + ")";
                }
                this.gridPointsModel.add(i, elVal);
                if (i < this.gridPointsModel.getSize() - 1) {
                    double nextV = TextUtils.atof((String)this.gridPointsModel.get(i + 1));
                    elVal = TextUtils.formatDouble(nextV) + " (+" + TextUtils.formatDouble(nextV - vInsert) + ")";
                    this.gridPointsModel.add(i + 1, elVal);
                }
                this.gridPointsList.setSelectedIndex(i);
                inserted = true;
                break;
            }
            lastVal = v;
        }
        if (!inserted) {
            String elVal = TextUtils.formatDouble(vInsert);
            if (this.gridPointsModel.getSize() > 0) {
                elVal = elVal + " (+" + TextUtils.formatDouble(vInsert - lastVal) + ")";
            }
            this.gridPointsModel.addElement(elVal);
            this.gridPointsList.setSelectedIndex(this.gridPointsModel.getSize() - 1);
        }
    }

    private void deleteGridLine() {
        if (!this.isTechnologyLoaded()) {
            return;
        }
        int index = this.gridPointsList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.gridPointsModel.remove(index);
        this.sortGridPoints();
        if (index >= this.gridPointsModel.getSize()) {
            --index;
        }
        this.gridPointsList.setSelectedIndex(index);
        this.saveGridValues();
        this.updateGridDisplay(false);
    }

    private void drawGrid() {
        WindowFrame.ElectricEventListener oldListener = WindowFrame.getListener();
        Cursor oldCursor = TopLevel.getCurrentCursor();
        WindowFrame.ElectricEventListener newListener = oldListener;
        if (newListener == null || !(newListener instanceof PlaceGridLineListener)) {
            TopLevel.setCurrentCursor(ToolBar.outlineCursor);
            newListener = new PlaceGridLineListener(oldListener, oldCursor, this);
            WindowFrame.setListener(newListener);
        }
    }

    private void saveGridValues() {
        ArcProto ap = this.getCurrentlySelectedArc();
        String newGrid = "";
        for (int i = 0; i < this.gridPointsModel.getSize(); ++i) {
            String elVal = (String)this.gridPointsModel.get(i);
            int spacePos = elVal.indexOf(32);
            if (spacePos >= 0) {
                elVal = elVal.substring(0, spacePos);
            }
            if (newGrid.length() > 0) {
                newGrid = newGrid + ",";
            }
            newGrid = newGrid + elVal;
        }
        this.sogp.setGrid(ap, newGrid);
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private void updateGridDisplay(boolean force2) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter h = wnd.getRulerHighlighter();
        h.clear();
        if (this.sogShowGrid.isSelected()) {
            boolean hor = true;
            boolean ver = true;
            ArcProto ap = this.getCurrentlySelectedArc();
            Boolean isHor = this.getGridHorizontal(ap);
            if (isHor != null) {
                if (isHor.booleanValue()) {
                    ver = false;
                } else {
                    hor = false;
                }
            }
            if (this.gridPointsModel.getSize() >= 2) {
                Cell cell = wnd.getCell();
                int prev = (int)(TextUtils.atof((String)this.gridPointsModel.get(0)) * wnd.getScale());
                boolean spreadOut = false;
                for (int i = 1; i < this.gridPointsModel.getSize(); ++i) {
                    int val = (int)(TextUtils.atof((String)this.gridPointsModel.get(i)) * wnd.getScale());
                    if (Math.abs(val - prev) > 3) {
                        spreadOut = true;
                        break;
                    }
                    prev = val;
                }
                if (spreadOut) {
                    Rectangle2D bounds = wnd.getDisplayedBounds();
                    double offset = TextUtils.atof((String)this.gridPointsModel.get(0));
                    double range2 = TextUtils.atof((String)this.gridPointsModel.get(this.gridPointsModel.getSize() - 1)) - offset;
                    int index = this.gridPointsList.getSelectedIndex();
                    if (range2 > 0.0) {
                        boolean thick;
                        Point2D.Double end;
                        Point2D.Double start;
                        double val;
                        int i;
                        Color col;
                        int startInd;
                        double v;
                        double high;
                        double low;
                        if (hor) {
                            low = Math.floor((bounds.getMinY() - offset) / range2) * range2;
                            high = Math.ceil((bounds.getMaxY() - offset) / range2) * range2;
                            for (v = low; v <= high; v += range2) {
                                startInd = 0;
                                col = Color.WHITE;
                                if (bounds.getCenterY() >= v + offset && bounds.getCenterY() < v + offset + range2) {
                                    col = Color.RED;
                                } else if (v != low) {
                                    startInd = 1;
                                }
                                for (i = startInd; i < this.gridPointsModel.getSize(); ++i) {
                                    val = TextUtils.atof((String)this.gridPointsModel.get(i));
                                    start = new Point2D.Double(bounds.getMinX(), v + val);
                                    end = new Point2D.Double(bounds.getMaxX(), v + val);
                                    thick = false;
                                    if (col == Color.red && i == index) {
                                        thick = true;
                                    }
                                    h.addLine(start, end, cell, thick, col, false);
                                }
                            }
                        }
                        if (ver) {
                            low = Math.floor((bounds.getMinX() - offset) / range2) * range2;
                            high = Math.ceil((bounds.getMaxX() - offset) / range2) * range2;
                            for (v = low; v <= high; v += range2) {
                                startInd = 0;
                                col = Color.WHITE;
                                if (bounds.getCenterX() >= v + offset && bounds.getCenterX() < v + offset + range2) {
                                    col = Color.RED;
                                } else if (v != low) {
                                    startInd = 1;
                                }
                                for (i = startInd; i < this.gridPointsModel.getSize(); ++i) {
                                    val = TextUtils.atof((String)this.gridPointsModel.get(i));
                                    start = new Point2D.Double(v + val, bounds.getMinY());
                                    end = new Point2D.Double(v + val, bounds.getMaxY());
                                    thick = false;
                                    if (col == Color.red && i == index) {
                                        thick = true;
                                    }
                                    h.addLine(start, end, cell, thick, col, false);
                                }
                            }
                        }
                    }
                }
            }
        }
        h.finished();
        if (force2) {
            wnd.repaint();
        }
    }

    private void exportData() {
        Job.getUserInterface().showErrorMessage("Not yet implemented", "Cannot export data yet.");
    }

    private void importData() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, "Routing control file", null);
        if (fileName == null) {
            return;
        }
        this.sogp.importData(fileName, this.curTech);
        Set<String> netNames = this.sogp.getNetsToRoute();
        if (netNames != null) {
            Set<String> allNetNames = this.getAllNetNames();
            String error = null;
            for (String netName : netNames) {
                if (allNetNames.contains(netName)) continue;
                error = error == null ? "" : error + ", ";
                error = error + netName;
            }
            if (error != null) {
                Job.getUserInterface().showErrorMessage("These network names were not found in the current cell: " + error, "Unknown network names");
            }
        }
        this.loadDialog();
        new UpdateSeaOfGatesCell(this.sogp);
    }

    private Set<String> getAllNetNames() {
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        Netlist nl = cell.getNetlist();
        HashSet<String> allNetNames = new HashSet<String>();
        Iterator<Network> it = nl.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            Iterator<String> nIt = net.getNames();
            while (nIt.hasNext()) {
                String name = nIt.next();
                allNetNames.add(name);
            }
        }
        return allNetNames;
    }

    private void done() {
        this.setVisible(false);
    }

    @Override
    protected void escapePressed() {
        this.done();
    }

    private void initComponents() {
        this.sogHorVerChoices = new ButtonGroup();
        this.sogGridType = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.individualLayers = new JPanel();
        this.sogArcList = new JScrollPane();
        this.sogAvoidLayer = new JCheckBox();
        this.sogFavorLayer = new JCheckBox();
        this.gridControl = new JPanel();
        this.sogGridNone = new JRadioButton();
        this.sogGridFixed = new JRadioButton();
        this.sogGridArbitrary = new JRadioButton();
        this.sogShowGrid = new JCheckBox();
        this.sogGridLabel = new JLabel();
        this.gridFixed = new JPanel();
        this.jLabel6 = new JLabel();
        this.sogFixedSpacing = new JTextField();
        this.jLabel8 = new JLabel();
        this.sogFixedOffset = new JTextField();
        this.sogGridSpacingUp = new JButton();
        this.sogGridSpacingDown = new JButton();
        this.sogGridOffsetUp = new JButton();
        this.sogGridOffsetDown = new JButton();
        this.gridArbitrary = new JPanel();
        this.sogDrawGrid = new JButton();
        this.sogGridIndScroll = new JScrollPane();
        this.sogGridAllUp = new JButton();
        this.sogGridAllDown = new JButton();
        this.sogGridIndUp = new JButton();
        this.sogGridIndDown = new JButton();
        this.sogGridIndDelete = new JButton();
        this.sogGridIndNew = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.sogDefWidth = new JTextField();
        this.jLabel9 = new JLabel();
        this.sogDefSpacing = new JTextField();
        this.entireCell = new JPanel();
        this.sogNoSteinerTrees = new JCheckBox();
        this.sogHorOddVerEven = new JRadioButton();
        this.sogVerOddHorEven = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.sogHorVerUsage = new JComboBox();
        this.jLabel2 = new JLabel();
        this.sogTechList = new JComboBox();
        this.sogNoRotatedContacts = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.sogContactInclusionPat = new JTextField();
        this.jLabel16 = new JLabel();
        this.sogContactExclusionPat = new JTextField();
        this.jPanel1 = new JPanel();
        this.sogNetList = new JScrollPane();
        this.sogLayerList = new JScrollPane();
        this.jLabel10 = new JLabel();
        this.sogNetName = new JTextField();
        this.jLabel11 = new JLabel();
        this.sogAddNet = new JButton();
        this.jLabel12 = new JLabel();
        this.sogLayerWidthOverride = new JTextField();
        this.jLabel13 = new JLabel();
        this.sogLayerSpacingOverride = new JTextField();
        this.sogAddLayerToNet = new JButton();
        this.sogRemoveLayerFromNet = new JButton();
        this.sogRemoveNet = new JButton();
        this.jLabel14 = new JLabel();
        this.jPanel2 = new JPanel();
        this.ok = new JButton();
        this.sogImportData = new JButton();
        this.sogExportData = new JButton();
        this.setTitle("Sea-of-Gates Cell Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SeaOfGatesCell.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("Sea-of-Gates Properties for Cell XXX");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.individualLayers.setBorder(BorderFactory.createTitledBorder("Default Layer Control"));
        this.individualLayers.setLayout(new GridBagLayout());
        this.sogArcList.setMinimumSize(new Dimension(24, 100));
        this.sogArcList.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.individualLayers.add((Component)this.sogArcList, gridBagConstraints);
        this.sogAvoidLayer.setText("Avoid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.individualLayers.add((Component)this.sogAvoidLayer, gridBagConstraints);
        this.sogFavorLayer.setText("Favor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.individualLayers.add((Component)this.sogFavorLayer, gridBagConstraints);
        this.gridControl.setLayout(new GridBagLayout());
        this.sogGridType.add(this.sogGridNone);
        this.sogGridNone.setText("None");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.gridControl.add((Component)this.sogGridNone, gridBagConstraints);
        this.sogGridType.add(this.sogGridFixed);
        this.sogGridFixed.setText("Fixed");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.gridControl.add((Component)this.sogGridFixed, gridBagConstraints);
        this.sogGridType.add(this.sogGridArbitrary);
        this.sogGridArbitrary.setText("Arbitrary");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.gridControl.add((Component)this.sogGridArbitrary, gridBagConstraints);
        this.sogShowGrid.setText("Show");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.gridControl.add((Component)this.sogShowGrid, gridBagConstraints);
        this.sogGridLabel.setText("Grid:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.gridControl.add((Component)this.sogGridLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        this.individualLayers.add((Component)this.gridControl, gridBagConstraints);
        this.gridFixed.setBorder(BorderFactory.createTitledBorder("Fixed Grid Control"));
        this.gridFixed.setLayout(new GridBagLayout());
        this.jLabel6.setText("Spacing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.gridFixed.add((Component)this.jLabel6, gridBagConstraints);
        this.sogFixedSpacing.setColumns(7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.gridFixed.add((Component)this.sogFixedSpacing, gridBagConstraints);
        this.jLabel8.setText("Offset:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.gridFixed.add((Component)this.jLabel8, gridBagConstraints);
        this.sogFixedOffset.setColumns(7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.gridFixed.add((Component)this.sogFixedOffset, gridBagConstraints);
        this.sogGridSpacingUp.setIcon(Resources.getResource(this.getClass(), "IconIncrement.gif"));
        this.sogGridSpacingUp.setToolTipText("Move all grid lines up or right");
        this.sogGridSpacingUp.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.gridFixed.add((Component)this.sogGridSpacingUp, gridBagConstraints);
        this.sogGridSpacingDown.setIcon(Resources.getResource(this.getClass(), "IconDecrement.gif"));
        this.sogGridSpacingDown.setToolTipText("Move all grid lines down or left");
        this.sogGridSpacingDown.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.gridFixed.add((Component)this.sogGridSpacingDown, gridBagConstraints);
        this.sogGridOffsetUp.setIcon(Resources.getResource(this.getClass(), "IconIncrement.gif"));
        this.sogGridOffsetUp.setToolTipText("Move grid line up or right");
        this.sogGridOffsetUp.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.gridFixed.add((Component)this.sogGridOffsetUp, gridBagConstraints);
        this.sogGridOffsetDown.setIcon(Resources.getResource(this.getClass(), "IconDecrement.gif"));
        this.sogGridOffsetDown.setToolTipText("Move grid line down or left");
        this.sogGridOffsetDown.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.gridFixed.add((Component)this.sogGridOffsetDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.individualLayers.add((Component)this.gridFixed, gridBagConstraints);
        this.gridArbitrary.setBorder(BorderFactory.createTitledBorder("Arbitrary Grid Control"));
        this.gridArbitrary.setLayout(new GridBagLayout());
        this.sogDrawGrid.setIcon(Resources.getResource(this.getClass(), "IconDraw.gif"));
        this.sogDrawGrid.setToolTipText("Draw grid line");
        this.sogDrawGrid.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gridArbitrary.add((Component)this.sogDrawGrid, gridBagConstraints);
        this.sogGridIndScroll.setMinimumSize(new Dimension(50, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.gridArbitrary.add((Component)this.sogGridIndScroll, gridBagConstraints);
        this.sogGridAllUp.setIcon(Resources.getResource(this.getClass(), "IconIncrement.gif"));
        this.sogGridAllUp.setToolTipText("Move all grid lines up or right");
        this.sogGridAllUp.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.gridArbitrary.add((Component)this.sogGridAllUp, gridBagConstraints);
        this.sogGridAllDown.setIcon(Resources.getResource(this.getClass(), "IconDecrement.gif"));
        this.sogGridAllDown.setToolTipText("Move all grid lines down or left");
        this.sogGridAllDown.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.gridArbitrary.add((Component)this.sogGridAllDown, gridBagConstraints);
        this.sogGridIndUp.setIcon(Resources.getResource(this.getClass(), "IconIncrement.gif"));
        this.sogGridIndUp.setToolTipText("Move grid line up or right");
        this.sogGridIndUp.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.gridArbitrary.add((Component)this.sogGridIndUp, gridBagConstraints);
        this.sogGridIndDown.setIcon(Resources.getResource(this.getClass(), "IconDecrement.gif"));
        this.sogGridIndDown.setToolTipText("Move grid line down or left");
        this.sogGridIndDown.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.gridArbitrary.add((Component)this.sogGridIndDown, gridBagConstraints);
        this.sogGridIndDelete.setIcon(Resources.getResource(this.getClass(), "IconDelete.gif"));
        this.sogGridIndDelete.setToolTipText("Delete grid line");
        this.sogGridIndDelete.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gridArbitrary.add((Component)this.sogGridIndDelete, gridBagConstraints);
        this.sogGridIndNew.setIcon(Resources.getResource(this.getClass(), "IconNew.gif"));
        this.sogGridIndNew.setToolTipText("Make new grid line");
        this.sogGridIndNew.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gridArbitrary.add((Component)this.sogGridIndNew, gridBagConstraints);
        this.jLabel3.setText("All:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.gridArbitrary.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Current:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.gridArbitrary.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.individualLayers.add((Component)this.gridArbitrary, gridBagConstraints);
        this.jLabel5.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.individualLayers.add((Component)this.jLabel5, gridBagConstraints);
        this.sogDefWidth.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.individualLayers.add((Component)this.sogDefWidth, gridBagConstraints);
        this.jLabel9.setText("Spacing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.individualLayers.add((Component)this.jLabel9, gridBagConstraints);
        this.sogDefSpacing.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.individualLayers.add((Component)this.sogDefSpacing, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.individualLayers, gridBagConstraints);
        this.entireCell.setBorder(BorderFactory.createTitledBorder("For Entire Cell"));
        this.entireCell.setLayout(new GridBagLayout());
        this.sogNoSteinerTrees.setText("Do not make Steiner Trees (already done)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.entireCell.add((Component)this.sogNoSteinerTrees, gridBagConstraints);
        this.sogHorVerChoices.add(this.sogHorOddVerEven);
        this.sogHorOddVerEven.setText("Horizontal: M1,3,5...   Vertical: M2,4,6...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.entireCell.add((Component)this.sogHorOddVerEven, gridBagConstraints);
        this.sogHorVerChoices.add(this.sogVerOddHorEven);
        this.sogVerOddHorEven.setText("Vertical: M1,3,5...   Horizontal: M2,4,6...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.entireCell.add((Component)this.sogVerOddHorEven, gridBagConstraints);
        this.jLabel7.setText("Alternating Metal Layer Usage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.entireCell.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.entireCell.add((Component)this.sogHorVerUsage, gridBagConstraints);
        this.jLabel2.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.entireCell.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.entireCell.add((Component)this.sogTechList, gridBagConstraints);
        this.sogNoRotatedContacts.setText("Do not place rotated contacts");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.entireCell.add((Component)this.sogNoRotatedContacts, gridBagConstraints);
        this.jLabel15.setText("Contact inclusion pattern:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 4, 0, 4);
        this.entireCell.add((Component)this.jLabel15, gridBagConstraints);
        this.sogContactInclusionPat.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 0, 4);
        this.entireCell.add((Component)this.sogContactInclusionPat, gridBagConstraints);
        this.jLabel16.setText("Contact exclusion pattern:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.entireCell.add((Component)this.jLabel16, gridBagConstraints);
        this.sogContactExclusionPat.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.entireCell.add((Component)this.sogContactExclusionPat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.entireCell, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Nets to Route"));
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.sogNetList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.sogLayerList, gridBagConstraints);
        this.jLabel10.setText("Layers for Selected Net (if empty, use default):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(15, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel10, gridBagConstraints);
        this.sogNetName.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.sogNetName, gridBagConstraints);
        this.jLabel11.setText("Net name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel11, gridBagConstraints);
        this.sogAddNet.setText("Add Net");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.sogAddNet, gridBagConstraints);
        this.jLabel12.setText("Layer width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanel1.add((Component)this.jLabel12, gridBagConstraints);
        this.sogLayerWidthOverride.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.sogLayerWidthOverride, gridBagConstraints);
        this.jLabel13.setText("Layer spacing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanel1.add((Component)this.jLabel13, gridBagConstraints);
        this.sogLayerSpacingOverride.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.sogLayerSpacingOverride, gridBagConstraints);
        this.sogAddLayerToNet.setText("Add Layer to Net");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.sogAddLayerToNet, gridBagConstraints);
        this.sogRemoveLayerFromNet.setText("Remove Layer from Net");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.sogRemoveLayerFromNet, gridBagConstraints);
        this.sogRemoveNet.setText("Remove Net");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.sogRemoveNet, gridBagConstraints);
        this.jLabel14.setText("If this list is empty, route all nets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.jPanel1.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.ok.setText("Done");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.ok, gridBagConstraints);
        this.sogImportData.setText("Import...");
        this.sogImportData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.sogImportDataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.sogImportData, gridBagConstraints);
        this.sogExportData.setText("Export...");
        this.sogExportData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeaOfGatesCell.this.sogExportDataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.sogExportData, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void ok(ActionEvent evt) {
        this.done();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void sogExportDataActionPerformed(ActionEvent evt) {
        this.exportData();
    }

    private void sogImportDataActionPerformed(ActionEvent evt) {
        this.importData();
    }

    private static class UpdateSeaOfGatesCell
    extends Job {
        private SeaOfGates.SeaOfGatesCellParameters sogp;

        private UpdateSeaOfGatesCell(SeaOfGates.SeaOfGatesCellParameters sogp) {
            super("Update Sea-of-Gates Cell Properties", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.sogp = sogp;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            this.sogp.saveParameters(ep);
            return true;
        }
    }

    public static class PlaceGridLineListener
    implements WindowFrame.ElectricEventListener {
        private WindowFrame.ElectricEventListener oldListener;
        private Cursor oldCursor;
        private SeaOfGatesCell dialog;

        private PlaceGridLineListener(WindowFrame.ElectricEventListener oldListener, Cursor oldCursor, SeaOfGatesCell dialog) {
            this.oldListener = oldListener;
            this.oldCursor = oldCursor;
            this.dialog = dialog;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!(evt.getSource() instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create node: this window has no cell in it");
                return;
            }
            this.finished(wnd);
            ArcProto ap = this.dialog.getCurrentlySelectedArc();
            Boolean isHor = this.dialog.getGridHorizontal(ap);
            if (isHor != null) {
                double val;
                Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
                EditWindow.gridAlign(pt);
                double d = val = isHor != false ? pt.getY() : pt.getX();
                if (this.dialog.gridPointsModel.getSize() >= 2) {
                    double lowest = TextUtils.atof((String)this.dialog.gridPointsModel.get(0));
                    double highest = TextUtils.atof((String)this.dialog.gridPointsModel.get(this.dialog.gridPointsModel.getSize() - 1));
                    double range2 = highest - lowest;
                    if (range2 > 0.0) {
                        Rectangle2D bounds = wnd.getDisplayedBounds();
                        if (isHor.booleanValue()) {
                            double low = Math.floor((bounds.getMinY() - lowest) / range2) * range2;
                            double high = Math.ceil((bounds.getMaxY() - lowest) / range2) * range2;
                            for (double v = low; v <= high; v += range2) {
                                if (bounds.getCenterY() < v + lowest || bounds.getCenterY() >= v + lowest + range2) continue;
                                val -= v;
                                break;
                            }
                        } else {
                            double low = Math.floor((bounds.getMinX() - lowest) / range2) * range2;
                            double high = Math.ceil((bounds.getMaxX() - lowest) / range2) * range2;
                            for (double v = low; v <= high; v += range2) {
                                if (bounds.getCenterX() < v + lowest || bounds.getCenterX() >= v + lowest + range2) continue;
                                val -= v;
                                break;
                            }
                        }
                    }
                }
                this.dialog.insertGridLine(val);
            }
        }

        private void finished(EditWindow wnd) {
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                highlighter.finished();
            }
            WindowFrame.setListener(this.oldListener);
            TopLevel.setCurrentCursor(this.oldCursor);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            this.showGridLine(evt);
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            this.showGridLine(evt);
        }

        private void showGridLine(MouseEvent evt) {
            if (!(evt.getSource() instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            Rectangle2D bounds = wnd.getDisplayedBounds();
            Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(pt);
            boolean drawHor = true;
            boolean drawVer = true;
            ArcProto ap = this.dialog.getCurrentlySelectedArc();
            Boolean isHor = this.dialog.getGridHorizontal(ap);
            if (isHor != null) {
                if (isHor.booleanValue()) {
                    drawVer = false;
                } else {
                    drawHor = false;
                }
            }
            if (drawHor) {
                highlighter.addLine(new Point2D.Double(bounds.getMinX(), pt.getY()), new Point2D.Double(bounds.getMaxX(), pt.getY()), cell, true, Color.RED, false);
            }
            if (drawVer) {
                highlighter.addLine(new Point2D.Double(pt.getX(), bounds.getMinY()), new Point2D.Double(pt.getX(), bounds.getMaxY()), cell, true, Color.RED, false);
            }
            highlighter.finished();
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 65 || chr == 27) {
                this.finished(EditWindow.getCurrent());
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent e) {
        }
    }

    private class FixedGridDocumentListener
    implements DocumentListener {
        private FixedGridDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.fixedGridValuesChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.fixedGridValuesChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.fixedGridValuesChanged();
        }
    }

    private class OverrideDocumentListener
    implements DocumentListener {
        private OverrideDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.layerOverridesChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.layerOverridesChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.layerOverridesChanged();
        }
    }

    private class MainDocumentListener
    implements DocumentListener {
        private MainDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.defaultOverridesChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.defaultOverridesChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.defaultOverridesChanged();
        }
    }

    private class ContactDocumentListener
    implements DocumentListener {
        private ContactDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.contactPatternChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.contactPatternChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SeaOfGatesCell.this.contactPatternChanged();
        }
    }
}

