/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.Node;
import com.sun.electric.tool.routing.experimentalAStar1.SplayTree;
import java.util.Random;

public class PriorityQueue {
    SplayTree tree = new SplayTree();

    public void clear() {
        this.tree.clear();
    }

    public void add(Node node) {
        Node equalNode = this.tree.find(node);
        if (equalNode == null) {
            node.children[0] = null;
            node.children[1] = null;
            this.tree.insert(node);
        } else {
            node.children[1] = equalNode.children[1];
            if (equalNode.children[1] != null) {
                equalNode.children[1].children[0] = node;
            }
            equalNode.children[1] = node;
            node.children[0] = equalNode;
        }
    }

    public Node remove() {
        Node firstNode = this.tree.findMin();
        if (firstNode == null) {
            return null;
        }
        if (firstNode.children[1] == null) {
            this.tree.remove(firstNode);
            return firstNode;
        }
        Node result2 = firstNode.children[1];
        firstNode.children[1] = result2.children[1];
        if (result2.children[1] != null) {
            result2.children[1].children[0] = firstNode;
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public void decreaseKey(Node node, int newKey) {
        if (node.children[0] != null) {
            node.children[0].children[1] = node.children[1];
            if (node.children[1] != null) {
                node.children[1].children[0] = node.children[0];
            }
        } else {
            this.tree.remove(node);
            Node next2 = node.children[1];
            if (next2 != null) {
                next2.children[0] = null;
                this.tree.insert(next2);
            }
        }
        node.f = newKey;
        this.add(node);
    }

    public static void main(String[] args) throws Exception {
        int i;
        PriorityQueue queue = new PriorityQueue();
        long seed = System.currentTimeMillis();
        System.out.printf("Seed: %d\n", seed);
        Random r = new Random(seed);
        int[] testValues = new int[50000];
        Node[] testNodes = new Node[testValues.length];
        for (i = 0; i < testValues.length; ++i) {
            testValues[i] = r.nextInt(1000000);
        }
        for (i = 0; i < testValues.length; ++i) {
            Node node = new Node();
            node.initialize(1, 2, 3);
            node.childCount = (byte)-1;
            node.children[0] = node;
            node.children[1] = node;
            node.f = testValues[i];
            queue.add(node);
            testNodes[i] = node;
        }
        for (i = 100; i < testValues.length; i += 19) {
            queue.decreaseKey(testNodes[i], testNodes[i].f - 1);
            queue.decreaseKey(testNodes[i - 1], testNodes[i - 1].f - 12345);
        }
        int previousValue = Integer.MIN_VALUE;
        int count2 = 0;
        while (!queue.isEmpty()) {
            ++count2;
            Node node = queue.remove();
            if (node.f < previousValue) {
                throw new Exception("Wrong order");
            }
            previousValue = node.f;
        }
        if (count2 != testValues.length) {
            throw new Exception("Wrong value count: " + count2);
        }
        System.out.println("ok");
    }
}

