/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SpecialProperties {
    public static int doubleClickOnNode(EditWindow wnd, NodeInst ni) {
        if (ni.getProto() == Schematics.tech().resistorNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Resistance", Schematics.SCHEM_RESISTANCE, AbstractTextDescriptor.Unit.RESISTANCE);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech().capacitorNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Capacitance", Schematics.SCHEM_CAPACITANCE, AbstractTextDescriptor.Unit.CAPACITANCE);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech().inductorNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Inductance", Schematics.SCHEM_INDUCTANCE, AbstractTextDescriptor.Unit.INDUCTANCE);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech().diodeNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Diode area", Schematics.SCHEM_DIODE, null);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech().transistorNode || ni.getProto() == Schematics.tech().transistor4Node) {
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRA4PNP || fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRAPNP) {
                NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Transistor area", Schematics.ATTR_AREA, null);
                if (npd.wantMore()) {
                    return -1;
                }
                return 1;
            }
            TransistorPropertiesDialog tpd = new TransistorPropertiesDialog(wnd, ni);
            if (tpd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech().globalNode) {
            GlobalPropertiesDialog gpd = new GlobalPropertiesDialog(wnd, ni);
            if (gpd.wantMore()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private static class TransistorPropertiesDialog
    extends EDialog {
        private JTextField valueWid;
        private JTextField valueLen;
        private JComboBox comboWid;
        private JComboBox comboLen;
        private boolean cancelHit;
        private boolean moreHit;

        private TransistorPropertiesDialog(EditWindow wnd, NodeInst ni) {
            super((Frame)null, true);
            String tWid = "";
            CodeExpression.Code cWid = CodeExpression.Code.NONE;
            Variable varWid = ni.getVar(Schematics.ATTR_WIDTH);
            if (varWid != null) {
                tWid = varWid.getObject().toString();
                cWid = varWid.getCode();
            }
            String tLen = "";
            CodeExpression.Code cLen = CodeExpression.Code.NONE;
            Variable varLen = ni.getVar(Schematics.ATTR_LENGTH);
            if (varLen != null) {
                tLen = varLen.getObject().toString();
                cLen = varLen.getCode();
            }
            this.initComponents(wnd, ni, "Transistor Properties", tWid, cWid, tLen, cLen);
            this.moreHit = false;
            this.cancelHit = false;
            this.setVisible(true);
            if (!this.cancelHit) {
                String newWid = this.valueWid.getText();
                String newLen = this.valueLen.getText();
                CodeExpression.Code newWidCode = (CodeExpression.Code)((Object)this.comboWid.getSelectedItem());
                CodeExpression.Code newLenCode = (CodeExpression.Code)((Object)this.comboLen.getSelectedItem());
                new ModifyNodeProperties(ni, newWid, newWidCode, newLen, newLenCode);
            }
        }

        @Override
        protected void escapePressed() {
            this.exit(false);
        }

        private boolean wantMore() {
            return this.moreHit;
        }

        private void exit(boolean goodButton) {
            this.cancelHit = !goodButton;
            this.setVisible(false);
            this.dispose();
        }

        private void moreButton() {
            this.moreHit = true;
            this.exit(true);
        }

        private void initComponents(EditWindow wnd, NodeInst ni, String title, String initialWid, CodeExpression.Code codeWid, String initialLen, CodeExpression.Code codeLen) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle(title);
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    TransistorPropertiesDialog.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Width:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.valueWid = new JTextField(initialWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.valueWid, gbc);
            EDialog.makeTextFieldSelectAllOnTab(this.valueWid);
            this.valueWid.selectAll();
            this.comboWid = new JComboBox();
            Iterator<CodeExpression.Code> it = CodeExpression.Code.getCodes();
            while (it.hasNext()) {
                this.comboWid.addItem(it.next());
            }
            this.comboWid.setSelectedItem((Object)codeWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.comboWid, gbc);
            JLabel lab2 = new JLabel("Length:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            this.valueLen = new JTextField(initialLen);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.valueLen, gbc);
            EDialog.makeTextFieldSelectAllOnTab(this.valueLen);
            this.comboLen = new JComboBox();
            Iterator<CodeExpression.Code> it2 = CodeExpression.Code.getCodes();
            while (it2.hasNext()) {
                this.comboLen.addItem(it2.next());
            }
            this.comboLen.setSelectedItem((Object)codeLen);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.comboLen, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TransistorPropertiesDialog.this.exit(false);
                }
            });
            JButton more = new JButton("More...");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)more, gbc);
            more.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TransistorPropertiesDialog.this.moreButton();
                }
            });
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TransistorPropertiesDialog.this.exit(true);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            this.pack();
            Point ew = wnd.getLocationOnScreen();
            ScreenPoint locInWnd = wnd.databaseToScreen(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point textfield = this.valueWid.getLocation();
            Dimension textSize = this.valueWid.getSize();
            this.setLocation(locInWnd.getIntX() + ew.x - (textfield.x + textSize.width / 2), locInWnd.getIntY() + ew.y - (textfield.y + textSize.height / 2 + 20));
        }
    }

    private static class GlobalPropertiesDialog
    extends EDialog {
        private JTextField value;
        private JComboBox combo;
        private boolean cancelHit;
        private boolean moreHit;

        private GlobalPropertiesDialog(EditWindow wnd, NodeInst ni) {
            super((Frame)null, true);
            String gName = "";
            Variable var = ni.getVar(Schematics.SCHEM_GLOBAL_NAME);
            if (var != null) {
                gName = var.getObject().toString();
            }
            this.initComponents(wnd, ni, "Global Signal", gName);
            this.moreHit = false;
            this.cancelHit = false;
            this.setVisible(true);
            if (!this.cancelHit) {
                String newValue = this.value.getText();
                PortCharacteristic ch = PortCharacteristic.findCharacteristic((String)this.combo.getSelectedItem());
                int newBits = ch.getBits();
                new ModifyNodeProperties(ni, Schematics.SCHEM_GLOBAL_NAME, newValue, newBits);
            }
        }

        @Override
        protected void escapePressed() {
            this.exit(false);
        }

        private boolean wantMore() {
            return this.moreHit;
        }

        private void exit(boolean goodButton) {
            this.cancelHit = !goodButton;
            this.setVisible(false);
            this.dispose();
        }

        private void moreButton() {
            this.moreHit = true;
            this.exit(true);
        }

        private void initComponents(EditWindow wnd, NodeInst ni, String title, String initialValue) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle(title);
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    GlobalPropertiesDialog.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Global signal name:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.value = new JTextField(initialValue);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.value, gbc);
            EDialog.makeTextFieldSelectAllOnTab(this.value);
            this.value.selectAll();
            JLabel lab2 = new JLabel("Characteristics:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            this.combo = new JComboBox();
            List<PortCharacteristic> characteristics = PortCharacteristic.getOrderedCharacteristics();
            for (PortCharacteristic ch : characteristics) {
                this.combo.addItem(ch.getName());
            }
            PortCharacteristic ch = PortCharacteristic.findCharacteristic(ni.getTechSpecific());
            this.combo.setSelectedItem(ch.getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.combo, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GlobalPropertiesDialog.this.exit(false);
                }
            });
            JButton more = new JButton("More...");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)more, gbc);
            more.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GlobalPropertiesDialog.this.moreButton();
                }
            });
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GlobalPropertiesDialog.this.exit(true);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            this.pack();
            Point ew = wnd.getLocationOnScreen();
            ScreenPoint locInWnd = wnd.databaseToScreen(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point textfield = this.value.getLocation();
            Dimension textSize = this.value.getSize();
            this.setLocation(locInWnd.getIntX() + ew.x - (textfield.x + textSize.width / 2), locInWnd.getIntY() + ew.y - (textfield.y + textSize.height / 2 + 20));
        }
    }

    private static class ModifyNodeProperties
    extends Job {
        private NodeInst ni;
        private Variable.Key key;
        private String newValue;
        private String newValueLen;
        private CodeExpression.Code newCode;
        private CodeExpression.Code newCodeLen;
        private int newBits;

        private ModifyNodeProperties(NodeInst ni, Variable.Key key, String newValue) {
            super("Change Node Value", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.key = key;
            this.newValue = newValue;
            this.newBits = -1;
            this.startJob();
        }

        private ModifyNodeProperties(NodeInst ni, Variable.Key key, String newValue, int newBits) {
            super("Change Node Value", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.key = key;
            this.newValue = newValue;
            this.newBits = newBits;
            this.startJob();
        }

        private ModifyNodeProperties(NodeInst ni, String newWid, CodeExpression.Code newWidCode, String newLen, CodeExpression.Code newLenCode) {
            super("Change Node Value", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.key = null;
            this.newValue = newWid;
            this.newCode = newWidCode;
            this.newValueLen = newLen;
            this.newCodeLen = newLenCode;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (this.key == null) {
                Variable oldWid = this.ni.getVar(Schematics.ATTR_WIDTH);
                TextDescriptor wtd = oldWid != null ? oldWid.getTextDescriptor() : ep.getNodeTextDescriptor();
                Object newV = Variable.withCode(this.newValue, this.newCode);
                this.ni.newVar(Schematics.ATTR_WIDTH, newV, wtd);
                Variable oldLen = this.ni.getVar(Schematics.ATTR_LENGTH);
                TextDescriptor ltd = oldLen != null ? oldLen.getTextDescriptor() : ep.getNodeTextDescriptor();
                Object newVL = Variable.withCode(this.newValueLen, this.newCodeLen);
                this.ni.newVar(Schematics.ATTR_LENGTH, newVL, ltd);
            } else {
                Variable oldVar = this.ni.getVar(this.key);
                TextDescriptor td = oldVar != null ? oldVar.getTextDescriptor() : ep.getNodeTextDescriptor();
                CodeExpression.Code newCode = oldVar != null ? oldVar.getCode() : CodeExpression.Code.NONE;
                Object newV = Variable.withCode(this.newValue, newCode);
                this.ni.newVar(this.key, newV, td);
                if (this.newBits != -1) {
                    this.ni.setTechSpecific(this.newBits);
                }
            }
            return true;
        }
    }

    private static class NodePropertiesDialog
    extends EDialog {
        private JTextField value;
        private JComboBox combo;
        private boolean cancelHit;
        private boolean moreHit;

        private NodePropertiesDialog(EditWindow wnd, NodeInst ni, String title, Variable.Key key, AbstractTextDescriptor.Unit units) {
            super((Frame)null, true);
            TextUtils.UnitScale[] scales = TextUtils.UnitScale.getUnitScales();
            String[] theScales = new String[scales.length];
            for (int i = 0; i < scales.length; ++i) {
                theScales[i] = scales[i].toString();
            }
            double num = 0.0;
            TextUtils.UnitScale scale = TextUtils.UnitScale.NONE;
            Variable var = ni.getVar(key);
            if (var != null) {
                String val = var.getObject().toString();
                scale = TextUtils.UnitScale.findUnitScaleFromPostfix(val);
                String postFix = scale.getPostFix();
                if (postFix.length() > 0) {
                    val = val.substring(0, val.length() - postFix.length());
                }
                num = TextUtils.atof(val);
            }
            this.initComponents(wnd, ni, title, TextUtils.formatDouble(num), theScales, scale.getName(), units);
            this.moreHit = false;
            this.cancelHit = false;
            this.setVisible(true);
            this.toFront();
            if (!this.cancelHit) {
                String newValue = this.value.getText();
                if (units != null) {
                    int newScale = this.combo.getSelectedIndex();
                    newValue = newValue + scales[newScale].getPostFix();
                }
                new ModifyNodeProperties(ni, key, newValue);
            }
        }

        @Override
        protected void escapePressed() {
            this.exit(false);
        }

        private boolean wantMore() {
            return this.moreHit;
        }

        private void exit(boolean goodButton) {
            this.cancelHit = !goodButton;
            this.setVisible(false);
            this.dispose();
        }

        private void moreButton() {
            this.moreHit = true;
            this.exit(true);
        }

        private void initComponents(EditWindow wnd, NodeInst ni, String title, String initialValue, String[] theScales, String initialScale, AbstractTextDescriptor.Unit unit) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle(title);
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    NodePropertiesDialog.this.exit(false);
                }
            });
            this.value = new JTextField(initialValue);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = unit == null ? 4 : 2;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.value, gbc);
            EDialog.makeTextFieldSelectAllOnTab(this.value);
            this.value.selectAll();
            if (unit != null) {
                this.combo = new JComboBox();
                int selected = 0;
                for (int k = 0; k < theScales.length; ++k) {
                    String sca = theScales[k];
                    if (sca.equalsIgnoreCase(initialScale)) {
                        selected = k;
                    }
                    if (sca.length() == 0) {
                        this.combo.addItem(unit.getName());
                        continue;
                    }
                    this.combo.addItem(sca + "-" + unit.getName().toLowerCase());
                }
                this.combo.setSelectedIndex(selected);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.gridwidth = 2;
                gbc.anchor = 10;
                gbc.fill = 2;
                gbc.weightx = 0.5;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)this.combo, gbc);
            }
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NodePropertiesDialog.this.exit(false);
                }
            });
            JButton more = new JButton("More...");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)more, gbc);
            more.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NodePropertiesDialog.this.moreButton();
                }
            });
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NodePropertiesDialog.this.exit(true);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            this.pack();
            Point ew = wnd.getLocationOnScreen();
            ScreenPoint locInWnd = wnd.databaseToScreen(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point textfield = this.value.getLocation();
            Dimension textSize = this.value.getSize();
            this.setLocation(locInWnd.getIntX() + ew.x - (textfield.x + textSize.width / 2), locInWnd.getIntY() + ew.y - (textfield.y + textSize.height / 2 + 20));
        }
    }
}

