/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.algorithm;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarClosedListBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNodeBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarOpenListBase;

public class ExternalVisitor<T extends AStarNodeBase<T>>
implements AStarMapVisitorBase<T> {
    private AStarOpenListBase<T> openList;
    private AStarClosedListBase<T> closedList;
    private AStarMapBase<T> map;
    private AStarGoalBase<T> goal;

    public ExternalVisitor(AStarOpenListBase<T> openList, AStarClosedListBase<T> closedList, AStarMapBase<T> map, AStarGoalBase<T> goal) {
        this.openList = openList;
        this.closedList = closedList;
        this.map = map;
        this.goal = goal;
    }

    @Override
    public void visitNeighbour(T origin, int x, int y, int z) {
        int costFromStart = ((AStarNodeBase)origin).costFromStart + this.goal.getNodeCost(origin, x, y, z);
        int costToGoal = this.goal.distanceToGoal(x, y, z);
        int totalCost = costFromStart + costToGoal;
        T foundNode = this.openList.findOpenNode(x, y, z);
        boolean foundCheaperPath = false;
        if (foundNode != null) {
            if (totalCost < ((AStarNodeBase)foundNode).getTotalCost()) {
                foundCheaperPath = true;
                this.openList.removeNodeFromOpenList(foundNode);
            }
        } else {
            foundNode = this.closedList.findClosedNode(x, y, z);
            if (foundNode != null) {
                if (totalCost < ((AStarNodeBase)foundNode).getTotalCost()) {
                    foundCheaperPath = true;
                    this.closedList.removeNodeFromClosedList(foundNode);
                }
            } else {
                foundNode = this.map.nodeAt(x, y, z);
                foundCheaperPath = true;
            }
        }
        if (foundCheaperPath) {
            ((AStarNodeBase)foundNode).origin = origin;
            ((AStarNodeBase)foundNode).costFromStart = costFromStart;
            ((AStarNodeBase)foundNode).costToGoal = costToGoal;
            ((AStarNodeBase)foundNode).totalCost = totalCost;
            this.openList.addNodeToOpenList(foundNode);
        }
    }
}

