/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.DerivedSignal;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.SetFocus;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.EditWindowFocusBrowser;
import com.sun.electric.tool.user.ui.InvisibleLayerConfiguration;
import com.sun.electric.tool.user.ui.LayerTab;
import com.sun.electric.tool.user.ui.MeasureListener;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WindowMenu {
    private static EMenu thisWindowMenu = null;
    private static EMenu visibleLayersMenu = null;
    private static EMenuItem hiddenWindowCycleMenuItem = null;
    private static DynamicEMenuItem messageDynamicMenu = null;

    public static KeyStroke getCloseWindowAccelerator() {
        return EMenuItem.shortcut(87);
    }

    static EMenu makeMenu() {
        EMenu menu;
        int ctrlshift = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40;
        KeyStroke[] numpad4 = new KeyStroke[]{EMenuItem.shortcut(52), EMenuItem.shortcut(100), KeyStroke.getKeyStroke(226, ctrlshift)};
        KeyStroke[] numpad6 = new KeyStroke[]{EMenuItem.shortcut(54), EMenuItem.shortcut(102), KeyStroke.getKeyStroke(227, ctrlshift)};
        KeyStroke[] numpad8 = new KeyStroke[]{EMenuItem.shortcut(56), EMenuItem.shortcut(104), KeyStroke.getKeyStroke(224, ctrlshift)};
        KeyStroke[] numpad2 = new KeyStroke[]{EMenuItem.shortcut(50), EMenuItem.shortcut(98), KeyStroke.getKeyStroke(225, ctrlshift)};
        KeyStroke[] numpad9 = new KeyStroke[]{EMenuItem.shortcut(57), EMenuItem.shortcut(105), KeyStroke.getKeyStroke(33, ctrlshift)};
        KeyStroke[] numpad7 = new KeyStroke[]{EMenuItem.shortcut(55), EMenuItem.shortcut(103), KeyStroke.getKeyStroke(36, ctrlshift)};
        KeyStroke[] numpad0 = new KeyStroke[]{EMenuItem.shortcut(48), EMenuItem.shortcut(96), KeyStroke.getKeyStroke(155, ctrlshift)};
        KeyStroke[] numpad5 = new KeyStroke[]{EMenuItem.shortcut(53), EMenuItem.shortcut(101), KeyStroke.getKeyStroke(65368, ctrlshift)};
        EMenuItem[] visibleLayersList = new EMenuItem[EGraphics.getMaxTransparentLayer() + 1];
        for (int i = 1; i < EGraphics.getMaxTransparentLayer() + 1; ++i) {
            int modifier = 64;
            final int level = i;
            if (i > 9) {
                modifier = 192;
            }
            int keycode = -1;
            switch (i) {
                case 1: 
                case 11: {
                    keycode = 49;
                    break;
                }
                case 2: 
                case 12: {
                    keycode = 50;
                    break;
                }
                case 3: 
                case 13: {
                    keycode = 51;
                    break;
                }
                case 4: 
                case 14: {
                    keycode = 52;
                    break;
                }
                case 5: {
                    keycode = 53;
                    break;
                }
                case 6: {
                    keycode = 54;
                    break;
                }
                case 7: {
                    keycode = 55;
                    break;
                }
                case 8: {
                    keycode = 56;
                    break;
                }
                case 9: {
                    keycode = 57;
                    break;
                }
                case 10: {
                    keycode = 48;
                    break;
                }
                default: {
                    System.out.println("Invalid keystroke in WindowMenu:makeMenu");
                }
            }
            visibleLayersList[i - 1] = new EMenuItem(InvisibleLayerConfiguration.getOnly().getMenuName(level), KeyStroke.getKeyStroke(keycode, modifier)){

                @Override
                public void run() {
                    WindowMenu.setLayerVisible(level);
                }
            };
        }
        visibleLayersList[EGraphics.getMaxTransparentLayer()] = new EMenuItem(InvisibleLayerConfiguration.getOnly().getMenuName(0), KeyStroke.getKeyStroke(48, 64)){

            @Override
            public void run() {
                WindowMenu.setLayerVisible(0);
            }
        };
        visibleLayersMenu = new EMenu("Visible La_yers", visibleLayersList);
        thisWindowMenu = menu = new EMenu("_Window", new EMenuItem("_Fill Window", numpad9){

            @Override
            public void run() {
                WindowMenu.fullDisplay();
            }
        }, new EMenuItem("Redisplay _Window"){

            @Override
            public void run() {
                ZoomAndPanListener.redrawDisplay();
            }
        }, new EMenuItem("Zoom _Out", numpad0){

            @Override
            public void run() {
                WindowMenu.zoomOutDisplay();
            }
        }, new EMenuItem("Zoom _In", numpad7){

            @Override
            public void run() {
                WindowMenu.zoomInDisplay();
            }
        }, new EMenu("Special _Zoom", new EMenuItem("Focus on _Highlighted", 'F'){

            @Override
            public void run() {
                WindowMenu.focusOnHighlighted();
            }
        }, new EMenuItem("_Zoom Box"){

            @Override
            public void run() {
                WindowMenu.zoomBoxCommand();
            }
        }, new EMenuItem("Make _Grid Just Visible"){

            @Override
            public void run() {
                WindowMenu.makeGridJustVisibleCommand();
            }
        }, new EMenuItem("Match Other _Window"){

            @Override
            public void run() {
                WindowMenu.matchOtherWindowCommand(0);
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("Pan _Left", numpad4){

            @Override
            public void run() {
                ZoomAndPanListener.panXOrY(0, WindowFrame.getCurrentWindowFrame(), 1);
            }
        }, new EMenuItem("Pan _Right", numpad6){

            @Override
            public void run() {
                ZoomAndPanListener.panXOrY(0, WindowFrame.getCurrentWindowFrame(), -1);
            }
        }, new EMenuItem("Pan _Up", numpad8){

            @Override
            public void run() {
                ZoomAndPanListener.panXOrY(1, WindowFrame.getCurrentWindowFrame(), -1);
            }
        }, new EMenuItem("Pan _Down", numpad2){

            @Override
            public void run() {
                ZoomAndPanListener.panXOrY(1, WindowFrame.getCurrentWindowFrame(), 1);
            }
        }, new EMenu("Special _Pan", new EMenuItem("Center _Selection"){

            @Override
            public void run() {
                ZoomAndPanListener.centerSelection();
            }
        }, new EMenuItem("Center _Cursor", numpad5){

            @Override
            public void run() {
                ZoomAndPanListener.centerCursor(WindowFrame.getCurrentWindowFrame());
            }
        }, new EMenuItem("Match Other Window in _X"){

            @Override
            public void run() {
                WindowMenu.matchOtherWindowCommand(1);
            }
        }, new EMenuItem("Match Other Window in _Y"){

            @Override
            public void run() {
                WindowMenu.matchOtherWindowCommand(2);
            }
        }, new EMenuItem("Match Other Window in X, Y, _and Scale"){

            @Override
            public void run() {
                WindowMenu.matchOtherWindowCommand(3);
            }
        }), new EMenuItem("Go To Pre_vious Focus"){

            @Override
            public void run() {
                WindowMenu.goToPreviousSavedFocus();
            }
        }, new EMenuItem("Go To Ne_xt Focus"){

            @Override
            public void run() {
                WindowMenu.goToNextSavedFocus();
            }
        }, new EMenuItem("_Set Focus..."){

            @Override
            public void run() {
                SetFocus.showSetFocusDialog();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Toggle _Grid", 'G'){

            @Override
            public void run() {
                WindowMenu.toggleGridCommand();
            }
        }, new EMenu("Me_asurements", new EMenuItem("_Toggle Measurement Mode"){

            @Override
            public void run() {
                ToolBar.setCursorMode(ToolBar.CursorMode.MEASURE);
            }
        }, new EMenuItem("_Clear Measurements"){

            @Override
            public void run() {
                MeasureListener.theOne.reset();
            }
        }), EMenuItem.SEPARATOR, new EMenu("Ad_just Position", new EMenuItem("Tile _Horizontally"){

            @Override
            public void run() {
                WindowMenu.tileHorizontallyCommand();
            }
        }, new EMenuItem("Tile _Vertically", KeyStroke.getKeyStroke(120, 0)){

            @Override
            public void run() {
                WindowMenu.tileVerticallyCommand();
            }
        }, new EMenuItem("_Cascade"){

            @Override
            public void run() {
                WindowMenu.cascadeWindowsCommand();
            }
        }), new EMenuItem("Clos_e Window", WindowMenu.getCloseWindowAccelerator()){

            @Override
            public void run() {
                WindowMenu.closeWindowCommand();
            }
        }, !TopLevel.isMDIMode() ? EMenuItem.SEPARATOR : null, !TopLevel.isMDIMode() && WindowMenu.getAllGraphicsDevices().length >= 2 ? new EMenuItem("Move to Ot_her Display"){

            @Override
            public void run() {
                WindowMenu.moveToOtherDisplayCommand();
            }
        } : null, !TopLevel.isMDIMode() ? new EMenuItem("Remember Locatio_n of Display"){

            @Override
            public void run() {
                WindowMenu.rememberDisplayLocation();
            }
        } : null, EMenuItem.SEPARATOR, visibleLayersMenu, new EMenu("_Color Schemes", new EMenuItem("_Restore Default Colors"){

            @Override
            public void run() {
                WindowMenu.defaultBackgroundCommand();
            }
        }, new EMenuItem("_Black Background Colors"){

            @Override
            public void run() {
                WindowMenu.blackBackgroundCommand();
            }
        }, new EMenuItem("_White Background Colors"){

            @Override
            public void run() {
                WindowMenu.whiteBackgroundCommand();
            }
        }, new EMenuItem("_Cadence Colors, Layers and Keystrokes"){

            @Override
            public void run() {
                WindowMenu.importCadencePreferences();
            }
        }), new EMenu("W_aveform Window", new EMenuItem("_Save Waveform Window Configuration to Disk..."){

            @Override
            public void run() {
                WaveformWindow.saveConfiguration();
            }
        }, new EMenuItem("_Restore Waveform Window Configuration from Disk..."){

            @Override
            public void run() {
                WaveformWindow.restoreConfiguration();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Refresh Simulation _Data", Resources.getResource(WaveformWindow.class, "ButtonSimRefresh.gif")){

            @Override
            public void run() {
                WaveformWindow.refreshSimulationData();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Clear All Signals in Waveform Window"){

            @Override
            public void run() {
                WaveformWindow.clearSimulationData();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Export Simulation Data..."){

            @Override
            public void run() {
                WaveformWindow.exportSimulationData();
            }
        }, new EMenuItem("_Export Simulation Data As CSV..."){

            @Override
            public void run() {
                WaveformWindow.exportSimulationDataAsCSV(OpenFile.chooseOutputFile((FileType)null, "Save Simulation Data as CSV", "simulation.csv"));
            }
        }, new EMenuItem("_Plot Simulation Data On Screen"){

            @Override
            public void run() {
                WaveformWindow.plotSimulationData(null, null);
            }
        }, new EMenuItem("Plot Simulation Data as PS..."){

            @Override
            public void run() {
                WaveformWindow.plotSimulationData(OpenFile.chooseOutputFile((FileType)null, "Save Plot as PS", "plot.ps"), "postscript eps color dashed");
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Fill Only in _X"){

            @Override
            public void run() {
                WaveformWindow.fillInX();
            }
        }, new EMenuItem("Fill Only in _Y"){

            @Override
            public void run() {
                WaveformWindow.fillInY();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Create New Waveform Panel", Resources.getResource(WaveformWindow.class, "ButtonSimAddPanel.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.makeNewPanel(-1);
                }
            }
        }, new EMenuItem("Toggle Horizontal Panel Lock", Resources.getResource(WaveformWindow.class, "ButtonSimLockTime.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.togglePanelXAxisLock();
                }
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Show Points and Lines", Resources.getResource(WaveformWindow.class, "ButtonSimLineOnPointOn.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.toggleShowPoints();
                }
            }
        }, new EMenuItem("Show Lines", Resources.getResource(WaveformWindow.class, "ButtonSimLineOnPointOff.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.toggleShowPoints();
                }
            }
        }, new EMenuItem("Show Points", Resources.getResource(WaveformWindow.class, "ButtonSimLineOffPointOn.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.toggleShowPoints();
                }
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Toggle Grid Points", Resources.getResource(WaveformWindow.class, "ButtonSimGrid.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.toggleGridPoints();
                }
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Increase Minimum Panel Height", Resources.getResource(WaveformWindow.class, "ButtonSimGrow.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.growPanels(1.25);
                }
            }
        }, new EMenuItem("Decrease Minimum Panel Height", Resources.getResource(WaveformWindow.class, "ButtonSimShrink.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.growPanels(0.8);
                }
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Rewind Main X Axis Cursor to Start", Resources.getResource(WaveformWindow.class, "ButtonVCRRewind.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.vcrClickRewind();
                }
            }
        }, new EMenuItem("Play Main X Axis Cursor Backwards", Resources.getResource(WaveformWindow.class, "ButtonVCRPlayBackward.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.vcrClickPlayBackwards();
                }
            }
        }, new EMenuItem("Stop Moving Main X Axis Cursor", Resources.getResource(WaveformWindow.class, "ButtonVCRStop.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.vcrClickStop();
                }
            }
        }, new EMenuItem("Play Main X Axis Cursor", Resources.getResource(WaveformWindow.class, "ButtonVCRPlay.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.vcrClickPlay();
                }
            }
        }, new EMenuItem("Move Main X Axis Cursor to End", Resources.getResource(WaveformWindow.class, "ButtonVCRToEnd.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.vcrClickToEnd();
                }
            }
        }, new EMenuItem("Move Main X Axis Cursor Faster", Resources.getResource(WaveformWindow.class, "ButtonVCRFaster.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.vcrClickFaster();
                }
            }
        }, new EMenuItem("Move Main X Axis Cursor Slower", Resources.getResource(WaveformWindow.class, "ButtonVCRSlower.gif")){

            @Override
            public void run() {
                WaveformWindow ww = WaveformWindow.getCurrentWaveformWindow();
                if (ww != null) {
                    ww.vcrClickSlower();
                }
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Generate Digital Signal from Analog Signal (0.5v threshold)"){

            @Override
            public void run() {
                WindowFrame current = WindowFrame.getCurrentWindowFrame();
                WindowContent content = current.getContent();
                if (!(content instanceof WaveformWindow)) {
                    System.out.println("Must select a Waveform window first");
                    return;
                }
                WaveformWindow ww = (WaveformWindow)content;
                Panel panel = ww.getPanel(0);
                Stimuli stim = ww.getSimData();
                Signal<?> s1 = panel.getSignals().get(0).getSignal();
                SignalCollection sc = Stimuli.newSignalCollection(stim, "DC SIGNALS");
                DerivedSignal<DigitalSample, ScalarSample> derived = new DerivedSignal<DigitalSample, ScalarSample>(sc, stim, s1.getSignalName(), s1.getSignalContext(), true, new Signal[]{s1}){

                    @Override
                    public boolean isEmpty() {
                        return false;
                    }

                    @Override
                    public double getMinValue() {
                        return 0.0;
                    }

                    @Override
                    public double getMaxValue() {
                        return 1.0;
                    }

                    @Override
                    public RangeSample<DigitalSample> getDerivedRange(RangeSample<ScalarSample>[] s) {
                        if (s[0] == null) {
                            return null;
                        }
                        double min = s[0].getMin().getValue();
                        double max = s[0].getMax().getValue();
                        return new RangeSample<DigitalSample>(min < 0.5 ? DigitalSample.LOGIC_0 : DigitalSample.LOGIC_1, max >= 0.5 ? DigitalSample.LOGIC_1 : DigitalSample.LOGIC_0);
                    }
                };
                new WaveSignal(panel, derived);
            }
        }), new EMenu("_Messages Window", new EMenuItem("_Tile with Edit Window"){

            @Override
            public void run() {
                MessagesWindow.tileWithEdit();
            }
        }, new EMenuItem("_Save Messages..."){

            @Override
            public void run() {
                MessagesStream.getMessagesStream().save();
            }
        }, new EMenuItem("_Clear"){

            @Override
            public void run() {
                MessagesWindow.clearAll();
            }
        }, new EMenuItem("Set F_ont..."){

            @Override
            public void run() {
                MessagesWindow.selectFont();
            }
        }), MenuCommands.makeExtraMenu("j3d.ui.J3DMenu", true), new EMenu("Side _Bar", new EMenuItem("On _Left"){

            @Override
            public void run() {
                WindowFrame.setSideBarLocation(true);
            }
        }, new EMenuItem("On _Right"){

            @Override
            public void run() {
                WindowFrame.setSideBarLocation(false);
            }
        }), EMenuItem.SEPARATOR);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowMenu.setDynamicVisibleLayerMenus();
            }
        });
        return menu;
    }

    static EMenuItem getHiddenWindowCycleMenuItem() {
        if (hiddenWindowCycleMenuItem == null) {
            hiddenWindowCycleMenuItem = new EMenuItem("Window Cycle", KeyStroke.getKeyStroke(81, 0)){

                @Override
                public void run() {
                    WindowFrame.getWindows().next().requestFocus();
                }
            };
        }
        return hiddenWindowCycleMenuItem;
    }

    public static void setDynamicMenus() {
        ArrayList<DynamicEMenuItem> list = new ArrayList<DynamicEMenuItem>();
        KeyStroke accelerator = WindowMenu.getHiddenWindowCycleMenuItem().getAccelerator();
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            list.add(new DynamicEMenuItem(wf, accelerator));
            accelerator = null;
        }
        if (messageDynamicMenu == null) {
            messageDynamicMenu = new DynamicEMenuItem(accelerator);
        }
        list.add(messageDynamicMenu);
        Collections.sort(list, new TextUtils.ObjectsByToString());
        thisWindowMenu.setDynamicItems(list);
    }

    public static void setDynamicVisibleLayerMenus() {
        ArrayList<DynamicLayerVisibilityMenuItem> list = new ArrayList<DynamicLayerVisibilityMenuItem>();
        for (String cName : InvisibleLayerConfiguration.getOnly().getConfigurationNames()) {
            if (InvisibleLayerConfiguration.getOnly().getConfigurationHardwiredIndex(cName) >= 0) continue;
            list.add(new DynamicLayerVisibilityMenuItem(cName));
        }
        for (EMenuBar.Instance menuBarInstance : TopLevel.getMenuBars()) {
            JMenu menu = (JMenu)menuBarInstance.findMenuItem(visibleLayersMenu.getPath());
            while (menu.getMenuComponentCount() > InvisibleLayerConfiguration.NUM_CONFIGS) {
                menu.remove(menu.getMenuComponentCount() - 1);
            }
            boolean hasMore = false;
            for (EMenuItem eMenuItem : list) {
                if (eMenuItem == EMenuItem.SEPARATOR) {
                    menu.addSeparator();
                    continue;
                }
                if (!hasMore) {
                    menu.addSeparator();
                }
                hasMore = true;
                JMenuItem item = eMenuItem.genMenu();
                menu.add(item);
            }
        }
    }

    public static void setLayerVisible(int level) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        WindowFrame frame = wnd.getWindowFrame();
        if (frame == null) {
            return;
        }
        LayerTab layerTab = frame.getLayersTab();
        if (layerTab == null) {
            return;
        }
        String cName = InvisibleLayerConfiguration.getOnly().findHardWiredConfiguration(level);
        if (cName == null) {
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            Technology tech = cell.getTechnology();
            if (!tech.isLayout()) {
                return;
            }
            layerTab.setVisibilityLevel(tech, level);
        } else {
            layerTab.setInvisibleLayerConfiguration(cName);
        }
    }

    public static void fullDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().fillScreen();
    }

    public static void zoomOutDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().zoomOutContents();
    }

    public static void zoomInDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().zoomInContents();
    }

    public static void zoomBoxCommand() {
        WindowFrame.ElectricEventListener oldListener = WindowFrame.getListener();
        WindowFrame.setListener(ClickZoomWireListener.theOne);
        ClickZoomWireListener.theOne.zoomBoxSingleShot(oldListener);
    }

    public static void makeGridJustVisibleCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Rectangle2D displayable = wnd.displayableBounds();
        Dimension sz = wnd.getSize();
        double scaleX = wnd.getGridXSpacing() * (double)sz.width / 5.01 / displayable.getWidth();
        double scaleY = wnd.getGridYSpacing() * (double)sz.height / 5.01 / displayable.getHeight();
        double scale = Math.min(scaleX, scaleY);
        wnd.setScale(wnd.getScale() / scale);
        wnd.setGrid(true);
    }

    public static void matchOtherWindowCommand(int how) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        int numOthers = 0;
        EditWindow other = null;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow wfWnd;
            WindowFrame wf = it.next();
            if (!(wf.getContent() instanceof EditWindow) || (wfWnd = (EditWindow)wf.getContent()) == wnd) continue;
            ++numOthers;
            other = wfWnd;
        }
        if (numOthers != 1) {
            System.out.println("There must be exactly two windows in order for one to match the other");
            return;
        }
        switch (how) {
            case 0: {
                wnd.setScale(other.getScale());
                break;
            }
            case 1: {
                wnd.setOffset(new Point2D.Double(other.getOffset().getX(), wnd.getOffset().getY()));
                break;
            }
            case 2: {
                wnd.setOffset(new Point2D.Double(wnd.getOffset().getX(), other.getOffset().getY()));
                break;
            }
            case 3: {
                wnd.setScale(other.getScale());
                wnd.setOffset(new Point2D.Double(other.getOffset().getX(), other.getOffset().getY()));
            }
        }
        wnd.fullRepaint();
    }

    public static void focusOnHighlighted() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().focusOnHighlighted();
    }

    public static void toggleGridCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (wf.getContent() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)wf.getContent();
            if (wnd == null) {
                return;
            }
            wnd.setGrid(!wnd.isGrid());
        } else if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            ww.toggleGridPoints();
        } else {
            System.out.println("Cannot draw a grid in this type of window");
        }
    }

    public static void tileHorizontallyCommand() {
        Rectangle[] areas = WindowMenu.getArrangementWindowAreas();
        Point loc = new Point(0, 0);
        if (TopLevel.isMDIMode()) {
            TopLevel tl = TopLevel.getCurrentJFrame();
            loc = tl.getContentPane().getLocationOnScreen();
        }
        for (Rectangle area : areas) {
            int count = 0;
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX() - loc.x;
                int locY = (int)wfBounds.getCenterY() - loc.y;
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int windowHeight = area.height / count;
            count = 0;
            Iterator<WindowFrame> it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX() - loc.x;
                int locY = (int)wfBounds.getCenterY() - loc.y;
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                Rectangle windowArea = new Rectangle(area.x, area.y + count * windowHeight, area.width, windowHeight);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    public static void tileVerticallyCommand() {
        Rectangle[] areas = WindowMenu.getArrangementWindowAreas();
        Point loc = new Point(0, 0);
        if (TopLevel.isMDIMode()) {
            TopLevel tl = TopLevel.getCurrentJFrame();
            loc = tl.getContentPane().getLocationOnScreen();
        }
        for (Rectangle area : areas) {
            int count = 0;
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX() - loc.x;
                int locY = (int)wfBounds.getCenterY() - loc.y;
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int windowWidth = area.width / count;
            count = 0;
            Iterator<WindowFrame> it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX() - loc.x;
                int locY = (int)wfBounds.getCenterY() - loc.y;
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                Rectangle windowArea = new Rectangle(area.x + count * windowWidth, area.y, windowWidth, area.height);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    public static void cascadeWindowsCommand() {
        Rectangle[] areas = WindowMenu.getArrangementWindowAreas();
        Point loc = new Point(0, 0);
        if (TopLevel.isMDIMode()) {
            TopLevel tl = TopLevel.getCurrentJFrame();
            loc = tl.getContentPane().getLocationOnScreen();
        }
        for (Rectangle area : areas) {
            int count = 0;
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX() - loc.x;
                int locY = (int)wfBounds.getCenterY() - loc.y;
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int numRuns = 1;
            int windowXSpacing = 0;
            int windowYSpacing = 0;
            int windowWidth = area.width;
            int windowHeight = area.height;
            if (count > 1) {
                windowWidth = area.width * 3 / 4;
                windowHeight = area.height * 3 / 4;
                int windowSpacing = Math.min(area.width - windowWidth, area.height - windowHeight) / (count - 1);
                if (windowSpacing < 70) {
                    numRuns = 70 / windowSpacing;
                    if (70 % windowSpacing != 0) {
                        ++numRuns;
                    }
                    windowSpacing *= numRuns;
                }
                windowXSpacing = (area.width - windowWidth) / (count - 1) * numRuns;
                windowYSpacing = (area.height - windowHeight) / (count - 1) * numRuns;
            }
            count = 0;
            Iterator<WindowFrame> it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX() - loc.x;
                int locY = (int)wfBounds.getCenterY() - loc.y;
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                int index = count / numRuns;
                Rectangle windowArea = new Rectangle(area.x + index * windowXSpacing, area.y + index * windowYSpacing, windowWidth, windowHeight);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    private static void closeWindowCommand() {
        WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
        curWF.finished();
    }

    private static Rectangle[] getArrangementWindowAreas() {
        Rectangle[] areas = TopLevel.getWindowAreas();
        for (MessagesWindow mw : MessagesWindow.getMessagesWindows()) {
            Rectangle mb = mw.getMessagesLocation();
            if (mb == null) continue;
            WindowMenu.removeOccludingRectangle(areas, mb);
        }
        return areas;
    }

    private static void removeOccludingRectangle(Rectangle[] areas, Rectangle occluding) {
        int cX = occluding.x + occluding.width / 2;
        int cY = occluding.y + occluding.height / 2;
        for (Rectangle area : areas) {
            int lX = (int)area.getMinX();
            int hX = (int)area.getMaxX();
            int lY = (int)area.getMinY();
            int hY = (int)area.getMaxY();
            if (cX <= lX || cX >= hX || cY <= lY || cY >= hY) continue;
            if (occluding.width > occluding.height) {
                if (occluding.getMaxY() - (double)lY < (double)hY - occluding.getMinY()) {
                    lY = (int)occluding.getMaxY();
                } else {
                    hY = (int)occluding.getMinY();
                }
            } else if (occluding.getMaxX() - (double)lX < (double)hX - occluding.getMinX()) {
                lX = (int)occluding.getMaxX();
            } else {
                hX = (int)occluding.getMinX();
            }
            area.x = lX;
            area.width = hX - lX;
            area.y = lY;
            area.height = hY - lY;
        }
    }

    public static void defaultBackgroundCommand() {
        User.resetFactoryColor(User.ColorPrefType.BACKGROUND);
        User.resetFactoryColor(User.ColorPrefType.GRID);
        User.resetFactoryColor(User.ColorPrefType.MEASUREMENT);
        User.resetFactoryColor(User.ColorPrefType.HIGHLIGHT);
        User.resetFactoryColor(User.ColorPrefType.PORT_HIGHLIGHT);
        User.resetFactoryColor(User.ColorPrefType.TEXT);
        User.resetFactoryColor(User.ColorPrefType.INSTANCE);
        User.resetFactoryColor(User.ColorPrefType.WAVE_BACKGROUND);
        User.resetFactoryColor(User.ColorPrefType.WAVE_FOREGROUND);
        User.resetFactoryColor(User.ColorPrefType.WAVE_STIMULI);
        EDatabase database = EDatabase.clientDatabase();
        Layer layer = database.getArtwork().defaultLayer;
        layer.setGraphics(layer.getGraphics().withColor(Color.BLACK));
        database.getGeneric().setBackgroudColor(Color.BLACK);
        WindowFrame.repaintAllWindows();
    }

    public static void blackBackgroundCommand() {
        User.setColor(User.ColorPrefType.BACKGROUND, Color.BLACK.getRGB());
        User.setColor(User.ColorPrefType.GRID, Color.WHITE.getRGB());
        User.setColor(User.ColorPrefType.MEASUREMENT, Color.RED.getRGB());
        User.setColor(User.ColorPrefType.HIGHLIGHT, Color.RED.getRGB());
        User.setColor(User.ColorPrefType.PORT_HIGHLIGHT, Color.YELLOW.getRGB());
        User.setColor(User.ColorPrefType.TEXT, Color.WHITE.getRGB());
        User.setColor(User.ColorPrefType.INSTANCE, Color.WHITE.getRGB());
        User.setColor(User.ColorPrefType.WAVE_BACKGROUND, Color.BLACK.getRGB());
        User.setColor(User.ColorPrefType.WAVE_FOREGROUND, Color.WHITE.getRGB());
        User.setColor(User.ColorPrefType.WAVE_STIMULI, Color.RED.getRGB());
        EDatabase database = EDatabase.clientDatabase();
        Layer layer = database.getArtwork().defaultLayer;
        layer.setGraphics(layer.getGraphics().withColor(Color.WHITE));
        database.getGeneric().setBackgroudColor(Color.WHITE);
        WindowFrame.repaintAllWindows();
    }

    public static void whiteBackgroundCommand() {
        User.setColor(User.ColorPrefType.BACKGROUND, Color.WHITE.getRGB());
        User.setColor(User.ColorPrefType.GRID, Color.BLACK.getRGB());
        User.setColor(User.ColorPrefType.MEASUREMENT, Color.RED.getRGB());
        User.setColor(User.ColorPrefType.HIGHLIGHT, Color.RED.getRGB());
        User.setColor(User.ColorPrefType.PORT_HIGHLIGHT, Color.DARK_GRAY.getRGB());
        User.setColor(User.ColorPrefType.TEXT, Color.BLACK.getRGB());
        User.setColor(User.ColorPrefType.INSTANCE, Color.BLACK.getRGB());
        User.setColor(User.ColorPrefType.WAVE_BACKGROUND, Color.WHITE.getRGB());
        User.setColor(User.ColorPrefType.WAVE_FOREGROUND, Color.BLACK.getRGB());
        User.setColor(User.ColorPrefType.WAVE_STIMULI, Color.RED.getRGB());
        EDatabase database = EDatabase.clientDatabase();
        Layer layer = database.getArtwork().defaultLayer;
        layer.setGraphics(layer.getGraphics().withColor(Color.BLACK));
        database.getGeneric().setBackgroudColor(Color.BLACK);
        WindowFrame.repaintAllWindows();
    }

    private static GraphicsDevice[] getAllGraphicsDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        return gs;
    }

    public static void moveToOtherDisplayCommand() {
        int i;
        if (TopLevel.isMDIMode()) {
            return;
        }
        WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
        WindowContent content = curWF.getContent();
        GraphicsConfiguration curConfig = content.getPanel().getGraphicsConfiguration();
        GraphicsDevice curDevice = curConfig.getDevice();
        GraphicsDevice[] gs = WindowMenu.getAllGraphicsDevices();
        for (i = 0; i < gs.length && gs[i] != curDevice; ++i) {
        }
        i = i == gs.length - 1 ? 0 : ++i;
        curWF.moveEditWindow(gs[i].getDefaultConfiguration());
    }

    public static void rememberDisplayLocation() {
        block1: {
            if (TopLevel.isMDIMode()) {
                return;
            }
            WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
            TopLevel tl = curWF.getFrame();
            Point pt = tl.getLocation();
            User.setDefaultWindowPos(pt);
            Dimension sz = tl.getSize();
            User.setDefaultWindowSize(sz);
            Iterator<MessagesWindow> iterator = MessagesWindow.getMessagesWindows().iterator();
            if (!iterator.hasNext()) break block1;
            MessagesWindow mw = iterator.next();
            Rectangle rect = mw.getMessagesLocation();
            User.setDefaultMessagesPos(new Point(rect.x, rect.y));
            User.setDefaultMessagesSize(new Dimension(rect.width, rect.height));
        }
    }

    public static void goToPreviousSavedFocus() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        EditWindowFocusBrowser browser = wnd.getSavedFocusBrowser();
        browser.goBack();
    }

    public static void goToNextSavedFocus() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        EditWindowFocusBrowser browser = wnd.getSavedFocusBrowser();
        browser.goForward();
    }

    private static void importCadencePreferences() {
        String[] options = new String[]{"Yes", "No", "Cancel Import"};
        int response = Job.getUserInterface().askForChoice("You won't be able to restore previous preferences.\nDo you want to backup your preferences before importing Cadence values?", "Import Cadence Preferences", options, options[1]);
        if (response == 0) {
            String backFileName = OpenFile.chooseOutputFile(FileType.XML, "Backup Preferences", "electricPrefsBack.xml");
            if (backFileName != null) {
                Pref.exportPrefs(backFileName);
            } else {
                System.out.println("Previous Preferences not backup");
            }
        }
        if (response != 2) {
            String cadenceFileName = "CadencePrefs.xml";
            URL fileURL = Resources.getURLResource(TopLevel.class, cadenceFileName);
            if (fileURL != null) {
                UserInterfaceMain.importPrefs(fileURL);
            } else {
                System.out.println("Cannot import '" + cadenceFileName + "'");
            }
        }
    }

    private static class DynamicEMenuItem
    extends EMenuItem {
        private WindowFrame window;

        public DynamicEMenuItem(WindowFrame w, KeyStroke accelerator) {
            super(w.getTitle(), accelerator);
            this.window = w;
        }

        public DynamicEMenuItem(KeyStroke accelerator) {
            super("Electric Messages", accelerator);
            this.window = null;
        }

        @Override
        public String getDescription() {
            return "Window Cycle";
        }

        @Override
        protected void updateButtons() {
        }

        @Override
        public void run() {
            block1: {
                block0: {
                    if (this.window == null) break block0;
                    this.window.requestFocus();
                    break block1;
                }
                Iterator<MessagesWindow> iterator = MessagesWindow.getMessagesWindows().iterator();
                if (!iterator.hasNext()) break block1;
                MessagesWindow mw = iterator.next();
                mw.requestFocus();
            }
        }
    }

    private static class DynamicLayerVisibilityMenuItem
    extends EMenuItem {
        private String cName;

        public DynamicLayerVisibilityMenuItem(String cName) {
            super(cName);
            this.cName = cName;
        }

        @Override
        public String getDescription() {
            return "Visible Layer Combination";
        }

        @Override
        protected void updateButtons() {
        }

        @Override
        public void run() {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                wf.getLayersTab().setInvisibleLayerConfiguration(this.cName);
            }
        }
    }
}

