/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVMap;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPcall;
import gnu.jel.OPcondtnl;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.debug.Debug;
import java.lang.reflect.Member;
import java.util.Stack;

public class Parser {
    Stack<OP> paramOPs;
    Stack<OP> xchgOP;
    int err_col = -1;
    Library lib;
    StringBuffer accDV = null;
    StringBuffer typeAccum = new StringBuffer();
    private String in;
    private int pos = 0;
    protected int c;
    private boolean prevCR = false;
    private boolean prevLF = false;
    private int column = 0;
    private int line = 1;
    public int ct_column;
    public int ct_line;
    public Object val;
    public int type;
    private StringBuffer buf = new StringBuffer();

    public Parser(String in, Library lib) {
        this.in = in;
        this.read();
        this.lib = lib;
        this.paramOPs = new Stack();
        this.xchgOP = new Stack();
        if (lib.resolver != null) {
            this.accDV = new StringBuffer();
        }
    }

    protected int read() {
        try {
            this.c = this.in.charAt(this.pos++);
        }
        catch (Exception e) {
            this.c = -1;
        }
        ++this.column;
        if (this.prevLF) {
            this.prevLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCR) {
            this.prevCR = false;
            if (this.c == 10) {
                this.prevLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (this.c) {
            case 13: {
                this.prevCR = true;
                break;
            }
            case 10: {
                this.prevLF = true;
                break;
            }
            case 9: {
                --this.column;
                this.column += 8 - (this.column & 7);
                break;
            }
        }
        return this.c;
    }

    public void error(int code, Object param, int column) throws CompilationException {
        CompilationException exc = new CompilationException(code, param);
        exc.col = column;
        throw exc;
    }

    protected void consume(int cc) throws CompilationException {
        if (cc < 0 || this.c != cc) {
            this.error(this.c == -1 ? 1 : 3, Character.valueOf((char)this.c), this.column - (this.c == -1 ? 1 : 0));
        }
        this.read();
    }

    public void nextToken() throws CompilationException {
        this.ct_column = this.column;
        this.ct_line = this.line;
        block48: while (true) {
            switch (this.c) {
                case -1: {
                    this.type = -1;
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    this.ct_column = this.column;
                    this.ct_line = this.line;
                    continue block48;
                }
                case 43: {
                    this.read();
                    this.type = 0;
                    return;
                }
                case 45: {
                    this.read();
                    this.type = 1;
                    return;
                }
                case 42: {
                    this.read();
                    this.type = 2;
                    return;
                }
                case 47: {
                    this.read();
                    this.type = 3;
                    return;
                }
                case 37: {
                    this.read();
                    this.type = 4;
                    return;
                }
                case 38: {
                    switch (this.read()) {
                        case 38: {
                            this.read();
                            this.type = 17;
                            return;
                        }
                    }
                    this.type = 5;
                    return;
                }
                case 124: {
                    switch (this.read()) {
                        case 124: {
                            this.read();
                            this.type = 18;
                            return;
                        }
                    }
                    this.type = 6;
                    return;
                }
                case 94: {
                    this.read();
                    this.type = 7;
                    return;
                }
                case 61: {
                    this.read();
                    this.consume(61);
                    this.type = 8;
                    return;
                }
                case 33: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 9;
                            return;
                        }
                    }
                    this.type = 31;
                    return;
                }
                case 60: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 13;
                            return;
                        }
                        case 60: {
                            this.read();
                            this.type = 14;
                            return;
                        }
                    }
                    this.type = 10;
                    return;
                }
                case 62: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 11;
                            return;
                        }
                        case 62: {
                            switch (this.read()) {
                                case 62: {
                                    this.read();
                                    this.type = 16;
                                    return;
                                }
                            }
                            this.type = 15;
                            return;
                        }
                    }
                    this.type = 12;
                    return;
                }
                case 126: {
                    this.read();
                    this.type = 30;
                    return;
                }
                case 91: {
                    this.read();
                    this.type = 19;
                    return;
                }
                case 93: {
                    this.read();
                    this.type = 20;
                    return;
                }
                case 63: {
                    this.read();
                    this.type = 35;
                    return;
                }
                case 58: {
                    this.read();
                    this.type = 36;
                    return;
                }
                case 46: {
                    int cc = this.read();
                    if (cc >= 48 && cc <= 57) {
                        this.parseReal();
                    } else {
                        this.type = 40;
                    }
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.parseNumber();
                    return;
                }
                case 40: {
                    this.read();
                    this.type = 41;
                    return;
                }
                case 41: {
                    this.read();
                    this.type = 42;
                    return;
                }
                case 44: {
                    this.read();
                    this.type = 43;
                    return;
                }
                case 34: {
                    this.read();
                    this.parseString();
                    return;
                }
                case 39: {
                    this.parseChar();
                    return;
                }
            }
            if (Character.isJavaIdentifierStart((char)this.c)) {
                this.parseID();
                return;
            }
            this.consume(-1);
        }
    }

    private int parseEscape() throws CompilationException {
        switch (this.read()) {
            case 114: {
                this.read();
                return 13;
            }
            case 110: {
                this.read();
                return 10;
            }
            case 102: {
                this.read();
                return 12;
            }
            case 98: {
                this.read();
                return 8;
            }
            case 116: {
                this.read();
                return 9;
            }
            case 117: {
                int v = 0;
                for (int i = 0; i < 4; ++i) {
                    this.read();
                    v <<= 4;
                    if (this.c >= 48 && this.c <= 57) {
                        v += this.c - 48;
                        continue;
                    }
                    if (this.c >= 97 && this.c <= 102) {
                        v += this.c - 97 + 10;
                        continue;
                    }
                    if (this.c >= 65 && this.c < 70) {
                        v += this.c - 65 + 10;
                        continue;
                    }
                    this.consume(-1);
                    return -1;
                }
                this.read();
                return v;
            }
            case 34: 
            case 39: 
            case 92: {
                return this.c + (this.read() - this.c);
            }
        }
        if (this.c >= 48 && this.c <= 55) {
            int v = this.c - 48;
            for (int i = 0; i < 2; ++i) {
                this.read();
                if (this.c < 48 || this.c > 55) {
                    if (v > 255) {
                        this.consume(-1);
                    }
                    return v;
                }
                v = (v << 3) + this.c - 48;
            }
            this.read();
            if (v > 255) {
                this.consume(-1);
            }
            return v;
        }
        this.consume(-1);
        return -1;
    }

    private void parseChar() throws CompilationException {
        char ch = '\u0000';
        switch (this.read()) {
            case 92: {
                ch = (char)this.parseEscape();
                break;
            }
            case -1: 
            case 10: 
            case 13: 
            case 39: {
                this.consume(-1);
                break;
            }
            default: {
                ch = (char)this.c;
                this.read();
            }
        }
        this.consume(39);
        this.type = 60;
        this.val = Character.valueOf(ch);
    }

    private void parseString() throws CompilationException {
        Debug.check(this.buf.length() == 0);
        block5: while (true) {
            switch (this.c) {
                case -1: 
                case 10: 
                case 13: 
                case 39: {
                    this.consume(-1);
                    continue block5;
                }
                case 92: {
                    this.buf.append((char)this.parseEscape());
                    continue block5;
                }
                case 34: {
                    this.read();
                    this.type = 60;
                    this.val = this.buf.toString();
                    this.buf.setLength(0);
                    return;
                }
            }
            this.buf.append((char)this.c);
            this.read();
        }
    }

    private void parseID() throws CompilationException {
        Debug.check(this.buf.length() == 0);
        do {
            this.buf.append((char)this.c);
            this.read();
        } while (this.c > 0 && Character.isJavaIdentifierPart((char)this.c));
        this.type = 50;
        this.val = this.buf.toString();
        this.buf.setLength(0);
        if (this.val.equals("true")) {
            this.type = 60;
            this.val = Boolean.TRUE;
        } else if (this.val.equals("false")) {
            this.type = 60;
            this.val = Boolean.FALSE;
        }
    }

    private void parseNumber() throws CompilationException {
        Debug.check(this.buf.length() == 0);
        boolean seenDigit = false;
        boolean seen89 = false;
        int base = this.c == 48 ? 8 : 10;
        long value = this.c - 48;
        this.buf.append((char)this.c);
        block9: while (true) {
            switch (this.read()) {
                case 56: 
                case 57: {
                    seen89 = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    seenDigit = true;
                    this.buf.append((char)this.c);
                    if (base == 10) {
                        if (value * 10L / 10L != value) {
                            this.error(30, null, this.column - 1);
                        }
                        value = value * 10L + (long)(this.c - 48);
                        continue block9;
                    }
                    if (base == 8) {
                        if (value >>> 61 > 0L) {
                            this.error(30, null, this.column - 1);
                        }
                        value = (value << 3) + (long)(this.c - 48);
                        continue block9;
                    }
                    if (value >>> 60 > 0L) {
                        this.error(30, null, this.column - 1);
                    }
                    value = (value << 4) + (long)(this.c - 48);
                    continue block9;
                }
                case 68: 
                case 69: 
                case 70: 
                case 100: 
                case 101: 
                case 102: {
                    if (base != 16) {
                        this.parseReal();
                        return;
                    }
                }
                case 65: 
                case 66: 
                case 67: 
                case 97: 
                case 98: 
                case 99: {
                    if (base != 16) break block9;
                    seenDigit = true;
                    if (value >>> 60 > 0L) {
                        this.error(30, null, this.column - 1);
                    }
                    value = (value << 4) + (long)(10 + Character.toLowerCase((char)this.c) - 97);
                    continue block9;
                }
                case 46: {
                    if (base == 16) break block9;
                    this.parseReal();
                    return;
                }
                case 76: 
                case 108: {
                    this.read();
                    this.buf.setLength(0);
                    this.type = 60;
                    this.val = value;
                    break block9;
                }
                case 88: 
                case 120: {
                    if (this.buf.length() != 1 || base != 8) break block9;
                    base = 16;
                    seenDigit = false;
                    continue block9;
                }
                default: {
                    this.buf.setLength(0);
                    this.type = 60;
                    if (value <= 127L) {
                        this.val = (byte)value;
                        break block9;
                    }
                    if (value <= 32767L) {
                        this.val = (short)value;
                        break block9;
                    }
                    if (value <= Integer.MAX_VALUE) {
                        this.val = (int)value;
                        break block9;
                    }
                    if ((base == 16 || base == 8) && value <= 0xFFFFFFFFL) {
                        this.val = (int)value;
                        break block9;
                    }
                    this.error(29, value, this.column - 1);
                    break block9;
                }
            }
            break;
        }
        if (this.c == 46 || Character.isJavaIdentifierPart((char)this.c)) {
            this.consume(-1);
        } else if (base == 8 && seen89) {
            this.consume(-1);
        } else if (base == 16 && !seenDigit) {
            this.consume(-1);
        }
    }

    private void parseReal() throws CompilationException {
        char lch;
        boolean seenE = false;
        boolean makeFloat = false;
        if (this.c == 46) {
            this.read();
        }
        this.buf.append('.');
        block7: while (true) {
            switch (this.c) {
                case 69: 
                case 101: {
                    if (seenE) break block7;
                    seenE = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.buf.append((char)this.c);
                    break;
                }
                case 43: 
                case 45: {
                    lch = this.buf.charAt(this.buf.length() - 1);
                    if (lch != 'e' && lch != 'E') break block7;
                    this.buf.append((char)this.c);
                    break;
                }
                case 70: 
                case 102: {
                    this.read();
                    makeFloat = true;
                    break block7;
                }
                case 68: 
                case 100: {
                    this.read();
                }
                default: {
                    break block7;
                }
            }
            this.read();
        }
        if (this.c == 46 || Character.isJavaIdentifierPart((char)this.c)) {
            this.consume(-1);
        } else {
            lch = this.buf.charAt(this.buf.length() - 1);
            if (lch == 'E' || lch == 'e' || lch == '+' || lch == '-') {
                this.consume(-1);
            } else {
                this.type = 60;
                if (makeFloat) {
                    this.val = Float.valueOf(this.buf.toString());
                    if (Float.isInfinite(((Float)this.val).floatValue())) {
                        this.error(31, null, this.column - 1);
                    }
                } else {
                    this.val = Double.valueOf(this.buf.toString());
                    if (Double.isInfinite((Double)this.val)) {
                        this.error(31, null, this.column - 1);
                    }
                }
                this.buf.setLength(0);
            }
        }
    }

    public boolean isCast() {
        if (this.type != 41) {
            return false;
        }
        boolean t_CR = this.prevCR;
        boolean t_LF = this.prevLF;
        int t_column = this.column;
        int t_line = this.line;
        int t_pos = this.pos;
        int t_c = this.c;
        boolean result = false;
        boolean arrCast = false;
        block19: while (true) {
            switch (this.c) {
                case -1: {
                    break block19;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block19;
                }
                default: {
                    if (!Character.isJavaIdentifierStart((char)this.c)) break block19;
                    this.read();
                    while (Character.isJavaIdentifierPart((char)this.c)) {
                        this.read();
                    }
                    block21: while (true) {
                        switch (this.c) {
                            case -1: {
                                break block19;
                            }
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                this.read();
                                continue block21;
                            }
                        }
                        break;
                    }
                    switch (this.c) {
                        case 46: {
                            this.read();
                            continue block19;
                        }
                        case 41: {
                            break;
                        }
                        case 91: {
                            arrCast = true;
                            break;
                        }
                        default: {
                            break block19;
                        }
                    }
                    this.read();
                    block22: while (true) {
                        switch (this.c) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                this.read();
                                continue block22;
                            }
                            case 93: {
                                result = true;
                            }
                            case 34: 
                            case 39: 
                            case 40: 
                            case 46: {
                                if (arrCast) break block19;
                                result = true;
                            }
                            case -1: {
                                break block19;
                            }
                            default: {
                                result = !arrCast && (this.c >= 48 && this.c <= 57 || Character.isJavaIdentifierStart((char)this.c));
                                break block19;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
        this.prevCR = t_CR;
        this.prevLF = t_LF;
        this.c = t_c;
        this.column = t_column;
        this.line = t_line;
        this.pos = t_pos;
        return result;
    }

    public OP parse(Class<?> resultType) throws CompilationException {
        try {
            this.expression();
            this.err_col = this.ct_column - 1;
            if (this.paramOPs.peek().resID == 10) {
                this.paramOPs.push(new OPunary(this.paramOPs, 11, null, false));
            }
            if (resultType != null) {
                this.paramOPs.push(new OPunary(this.paramOPs, OP.typeID(resultType), resultType, false));
            }
            this.paramOPs.push(new OPunary(this.paramOPs, 3));
        }
        catch (CompilationException exc) {
            if (exc.col < 0) {
                Debug.check(this.err_col > 0);
                exc.col = this.err_col;
            }
            throw exc;
        }
        Debug.check(this.paramOPs.size() == 1, "There must be only a single item left in paramOPs stack.");
        return this.paramOPs.pop();
    }

    private void consumeT(int t) throws CompilationException {
        if (this.type != t) {
            this.consume(-1);
        }
        this.nextToken();
    }

    private void expression() throws CompilationException {
        this.nextToken();
        this.conditional();
        this.consumeT(-1);
    }

    private void conditional() throws CompilationException {
        this.binOP(0);
        if (this.type == 35) {
            int ecol = this.ct_column;
            this.nextToken();
            int stackSizeBeforeBranch = this.paramOPs.size();
            this.conditional();
            this.consumeT(36);
            int stackSizeAfterFirstBranch = this.paramOPs.size();
            this.conditional();
            this.err_col = ecol;
            Debug.check(this.paramOPs.size() == stackSizeAfterFirstBranch + 1 && stackSizeAfterFirstBranch == stackSizeBeforeBranch + 1, "Stack in conditional branches is not balanced.");
            this.paramOPs.push(new OPcondtnl(this.paramOPs));
        }
    }

    private void binOP(int idx) throws CompilationException {
        int t;
        if (idx == 9) {
            this.unary();
        } else {
            this.binOP(idx + 1);
        }
        Debug.check(idx >= 0 && idx <= 9);
        int v = (int)(idx < 5 ? 181667661137490L >>> idx * 10 : 142971423336744L >>> (idx - 5) * 10);
        while ((t = this.type) >= (v & 0x1F) && t <= (v >>> 5 & 0x1F)) {
            int ecol = this.ct_column;
            this.nextToken();
            if (idx == 9) {
                this.unary();
            } else {
                this.binOP(idx + 1);
            }
            this.err_col = ecol;
            this.paramOPs.push(new OPbinary(this.paramOPs, t));
        }
    }

    private void unary() throws CompilationException {
        int t = this.type;
        if (t == 1 || t == 30 || t == 31) {
            int ecol = this.ct_column;
            this.nextToken();
            this.unary();
            if (t >= 30) {
                t -= 28;
            }
            this.err_col = ecol;
            this.paramOPs.push(new OPunary(this.paramOPs, t - 1));
        } else if (this.isCast()) {
            int typeID;
            this.consumeT(41);
            int ecol = this.ct_column;
            int accumStrt = this.typeAccum.length();
            this.typeAccum.append(this.val);
            this.consumeT(50);
            while (this.type == 40) {
                this.typeAccum.append('.');
                this.nextToken();
                this.typeAccum.append(this.val);
                this.consumeT(50);
            }
            this.consumeT(42);
            this.element();
            this.err_col = ecol;
            Class<?> clazz = null;
            for (typeID = 0; typeID < 8 && !this.typeAccum.substring(accumStrt).equals(OP.specialTypes[typeID].toString()); ++typeID) {
            }
            Debug.check(typeID <= 8);
            if (typeID == 8 && (clazz = this.lib.cnmap == null ? null : this.lib.cnmap.get(this.typeAccum.substring(accumStrt))) == null) {
                typeID = -1;
            }
            if (typeID == 8) {
                typeID = OP.typeID(clazz);
            }
            this.typeAccum.setLength(accumStrt);
            if (typeID < 0) {
                throw new CompilationException(4, this.typeAccum.toString());
            }
            this.paramOPs.push(new OPunary(this.paramOPs, typeID, clazz, true));
        } else {
            t = this.type;
            if (t == 60 || t == 50 || t == 41) {
                this.element();
            } else {
                this.consume(-1);
            }
        }
    }

    private void element() throws CompilationException {
        switch (this.type) {
            case 60: {
                this.paramOPs.push(new OPload(this.val));
                this.nextToken();
                break;
            }
            case 41: {
                this.nextToken();
                this.conditional();
                this.consumeT(42);
                break;
            }
            case 50: {
                this.invocation(false);
                break;
            }
            default: {
                this.consume(-1);
            }
        }
        while (this.type == 40) {
            this.nextToken();
            this.invocation(true);
        }
        this.genDVCall();
    }

    private void invocation(boolean afterDot) throws CompilationException {
        int ecol;
        int paramsStart = 0;
        Class<?> resolveIn = null;
        boolean inDVmatch = false;
        int ecol_id = ecol = this.ct_column;
        Object idImage = this.val;
        this.consumeT(50);
        if (this.accDV != null) {
            int oldLen = this.accDV.length();
            if (afterDot) {
                this.accDV.append('.');
            }
            this.accDV.append(idImage);
            inDVmatch = this.isDV() && this.type != 41;
            if (!inDVmatch) {
                this.accDV.setLength(oldLen);
                this.err_col = ecol;
                this.genDVCall();
            }
        }
        if (!inDVmatch) {
            if (afterDot) {
                resolveIn = this.paramOPs.peek().resType;
            }
            paramsStart = this.paramOPs.size();
        }
        if (this.type == 41) {
            ecol = this.ct_column;
            this.nextToken();
            int t = this.type;
            if (t == 1 || t == 30 || t == 31 || t == 41 || t == 60 || t == 50) {
                this.conditional();
                while (this.type == 43) {
                    this.nextToken();
                    this.conditional();
                }
            }
            this.consumeT(42);
        }
        if (!inDVmatch) {
            this.err_col = ecol_id;
            this.functionCall(resolveIn, (String)idImage, paramsStart);
        }
        while (this.type == 19) {
            ecol = this.ct_column;
            this.nextToken();
            this.genDVCall();
            this.conditional();
            this.consumeT(20);
            this.err_col = ecol;
            this.paramOPs.push(new OPbinary(this.paramOPs, 19));
        }
    }

    private final boolean isDV() {
        return this.lib.resolver.getTypeName(this.accDV.toString()) != null;
    }

    private final void genDVCall() throws CompilationException {
        if (this.accDV == null || this.accDV.length() == 0) {
            return;
        }
        String varName = this.accDV.toString();
        String typeName = this.lib.resolver.getTypeName(varName);
        int paramsStart = this.paramOPs.size();
        Object varObj = this.lib.resolver instanceof DVMap ? this.lib.resolver.translate(varName) : varName;
        this.paramOPs.push(new OPload(varObj));
        this.functionCall(null, "get" + typeName + "Property", paramsStart);
        this.accDV.setLength(0);
    }

    private final void functionCall(Class<?> resolveInClass, String name, int paramsStart) throws CompilationException {
        int np = this.paramOPs.size() - paramsStart;
        Class[] params = new Class[np];
        for (int i = np - 1; i >= 0; --i) {
            OP cop = this.paramOPs.pop();
            this.xchgOP.push(cop);
            params[i] = cop.resType;
        }
        Member m = this.lib.getMember(resolveInClass, name, params);
        if (resolveInClass == null && (m.getModifiers() & 8) == 0) {
            this.paramOPs.push(new OPcall(1, new Object[0].getClass()));
            int classID = this.lib.getDynamicMethodClassID(m);
            this.paramOPs.push(new OPload(classID));
            this.paramOPs.push(new OPbinary(this.paramOPs, 19));
        }
        for (int i = 0; i < np; ++i) {
            this.paramOPs.push(this.xchgOP.pop());
        }
        this.paramOPs.push(new OPcall(m, np, this.paramOPs, this.lib.isStateless(m)));
    }
}

