/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.functions.Arithmetic;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberCompare
extends ProcedureN
implements CanInline,
Inlineable {
    Language language;
    static final int RESULT_GRT = 1;
    static final int RESULT_EQU = 0;
    static final int RESULT_LSS = -1;
    static final int RESULT_NAN = -2;
    static final int RESULT_NEQ = -3;
    public static final int TRUE_IF_GRT = 16;
    public static final int TRUE_IF_EQU = 8;
    public static final int TRUE_IF_LSS = 4;
    public static final int TRUE_IF_NAN = 2;
    public static final int TRUE_IF_NEQ = 1;
    int flags;
    private static final int Unknown_KIND = 0;
    private static final int Number_KIND = 1;
    private static final int Numeric_KIND = 2;
    private static final int RealNum_KIND = 3;
    private static final int double_KIND = 4;
    private static final int IntNum_KIND = 5;
    private static final int long_KIND = 6;
    private static final int int_KIND = 7;

    public int numArgs() {
        return -4094;
    }

    public static boolean $Eq(Object arg1, Object arg2) {
        return NumberCompare.apply2(8, arg1, arg2);
    }

    public static boolean $Gr(Object arg1, Object arg2) {
        return NumberCompare.apply2(16, arg1, arg2);
    }

    public static boolean $Gr$Eq(Object arg1, Object arg2) {
        return NumberCompare.apply2(24, arg1, arg2);
    }

    public static boolean $Ls(Object arg1, Object arg2) {
        return NumberCompare.apply2(4, arg1, arg2);
    }

    public static boolean $Ls$Eq(Object arg1, Object arg2) {
        return NumberCompare.apply2(12, arg1, arg2);
    }

    public static boolean $Eq$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Eq(arg1, arg2) && NumberCompare.$Eq(arg2, arg3) && (rest.length == 0 || NumberCompare.$Eq(arg3, rest[0]) && NumberCompare.applyN(8, rest));
    }

    public static boolean $Gr$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Gr(arg1, arg2) && NumberCompare.$Gr(arg2, arg3) && (rest.length == 0 || NumberCompare.$Gr(arg3, rest[0]) && NumberCompare.applyN(16, rest));
    }

    public static boolean $Gr$Eq$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Gr$Eq(arg1, arg2) && NumberCompare.$Gr$Eq(arg2, arg3) && (rest.length == 0 || NumberCompare.$Gr$Eq(arg3, rest[0]) && NumberCompare.applyN(24, rest));
    }

    public static boolean $Ls$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Ls(arg1, arg2) && NumberCompare.$Ls(arg2, arg3) && (rest.length == 0 || NumberCompare.$Ls(arg3, rest[0]) && NumberCompare.applyN(4, rest));
    }

    public static boolean $Ls$Eq$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Ls$Eq(arg1, arg2) && NumberCompare.$Ls$Eq(arg2, arg3) && (rest.length == 0 || NumberCompare.$Ls$Eq(arg3, rest[0]) && NumberCompare.applyN(12, rest));
    }

    public static NumberCompare make(Language language, String name, int flags) {
        NumberCompare proc = new NumberCompare();
        proc.language = language;
        proc.setName(name);
        proc.flags = flags;
        return proc;
    }

    protected final Language getLanguage() {
        return this.language;
    }

    public Object apply2(Object arg1, Object arg2) {
        return this.getLanguage().booleanObject(NumberCompare.apply2(this.flags, arg1, arg2));
    }

    public static boolean apply2(int flags, Object arg1, Object arg2) {
        return (1 << 3 + NumberCompare.compare(arg1, arg2, true) & flags) != 0;
    }

    public static boolean checkCompareCode(int code, int flags) {
        return (1 << 3 + code & flags) != 0;
    }

    public static boolean applyWithPromotion(int flags, Object arg1, Object arg2) {
        return NumberCompare.checkCompareCode(NumberCompare.compare(arg1, arg2, false), flags);
    }

    public static int compare(Object arg1, Object arg2, boolean exact) {
        int code1 = Arithmetic.classifyValue(arg1);
        int code2 = Arithmetic.classifyValue(arg2);
        return NumberCompare.compare(arg1, code1, arg2, code2, exact);
    }

    public static int compare(Object arg1, int code1, Object arg2, int code2, boolean exact) {
        int comp;
        if (code1 < 0 || code2 < 0) {
            return -3;
        }
        int code = code1 < code2 ? code2 : code1;
        switch (code) {
            case 1: {
                int i1 = Arithmetic.asInt(arg1);
                int i2 = Arithmetic.asInt(arg2);
                comp = i1 < i2 ? -1 : (i1 > i2 ? 1 : 0);
                break;
            }
            case 2: {
                long l1 = Arithmetic.asLong(arg1);
                long l2 = Arithmetic.asLong(arg2);
                comp = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
                break;
            }
            case 3: {
                BigInteger bi1 = Arithmetic.asBigInteger(arg1);
                BigInteger bi2 = Arithmetic.asBigInteger(arg2);
                comp = bi1.compareTo(bi2);
                break;
            }
            case 4: {
                comp = IntNum.compare(Arithmetic.asIntNum(arg1), Arithmetic.asIntNum(arg2));
                break;
            }
            case 5: {
                BigDecimal bd1 = Arithmetic.asBigDecimal(arg1);
                BigDecimal bd2 = Arithmetic.asBigDecimal(arg2);
                comp = bd1.compareTo(bd2);
                break;
            }
            case 6: {
                comp = RatNum.compare(Arithmetic.asRatNum(arg1), Arithmetic.asRatNum(arg2));
                break;
            }
            case 7: {
                if (!exact || code1 > 6 && code2 > 6) {
                    float f2;
                    float f1 = Arithmetic.asFloat(arg1);
                    comp = f1 > (f2 = Arithmetic.asFloat(arg2)) ? 1 : (f1 < f2 ? -1 : (f1 == f2 ? 0 : -2));
                    break;
                }
            }
            case 8: 
            case 9: {
                if (!exact || code1 > 6 && code2 > 6) {
                    double d2;
                    double d1 = Arithmetic.asDouble(arg1);
                    comp = d1 > (d2 = Arithmetic.asDouble(arg2)) ? 1 : (d1 < d2 ? -1 : (d1 == d2 ? 0 : -2));
                    break;
                }
            }
            default: {
                Numeric num1 = Arithmetic.asNumeric(arg1);
                Numeric num2 = Arithmetic.asNumeric(arg2);
                comp = num1.compare(num2);
            }
        }
        return comp;
    }

    static boolean applyN(int flags, Object[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            Object arg1 = args[i];
            Object arg2 = args[i + 1];
            if (NumberCompare.apply2(flags, arg1, arg2)) continue;
            return false;
        }
        return true;
    }

    public Object applyN(Object[] args) {
        return this.getLanguage().booleanObject(NumberCompare.applyN(this.flags, args));
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        exp.walkArgs(walker, argsInlined);
        Expression folded = exp.inlineIfConstant((Procedure)this, walker);
        if (folded != exp) {
            return folded;
        }
        return exp;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        if (args.length == 2) {
            Expression arg0 = args[0];
            Expression arg1 = args[1];
            int kind0 = NumberCompare.classify(arg0);
            int kind1 = NumberCompare.classify(arg1);
            CodeAttr code = comp.getCode();
            if (kind0 >= 3 && kind1 >= 3 && (kind0 != 3 || kind1 != 3)) {
                Object value;
                int opcode;
                Label label1;
                if (!(target instanceof ConditionalTarget)) {
                    IfExp.compile(exp, QuoteExp.trueExp, QuoteExp.falseExp, comp, target);
                    return;
                }
                int mask = this.flags;
                if (mask == 1) {
                    mask = 20;
                }
                if (kind0 >= 5 && kind1 >= 5 && (kind0 < 6 || kind1 < 6)) {
                    Type[] ctypes = new Type[2];
                    ctypes[0] = Arithmetic.typeIntNum;
                    if (kind1 >= 6) {
                        ctypes[1] = Type.longType;
                    } else if (kind0 >= 6 && (arg0 instanceof QuoteExp || arg1 instanceof QuoteExp || arg0 instanceof ReferenceExp || arg1 instanceof ReferenceExp)) {
                        ctypes[1] = Type.longType;
                        args = new Expression[]{arg1, arg0};
                        if (mask != 8 && mask != 20) {
                            mask ^= 0x14;
                        }
                    } else {
                        ctypes[1] = Arithmetic.typeIntNum;
                    }
                    Method cmeth = Arithmetic.typeIntNum.getMethod("compare", ctypes);
                    PrimProcedure compare = new PrimProcedure(cmeth);
                    arg0 = new ApplyExp(compare, args);
                    arg1 = new QuoteExp(IntNum.zero());
                    kind1 = 7;
                    kind0 = 7;
                }
                PrimType commonType = kind0 >= 7 && kind1 >= 7 ? Type.intType : (kind0 >= 6 && kind1 >= 6 ? Type.longType : Type.doubleType);
                StackTarget subTarget = new StackTarget(commonType);
                ConditionalTarget ctarget = (ConditionalTarget)target;
                if (arg0 instanceof QuoteExp && !(arg1 instanceof QuoteExp)) {
                    Expression tmp = arg1;
                    arg1 = arg0;
                    arg0 = tmp;
                    if (mask != 8 && mask != 20) {
                        mask ^= 0x14;
                    }
                }
                Label label = label1 = ctarget.trueBranchComesFirst ? ctarget.ifFalse : ctarget.ifTrue;
                if (ctarget.trueBranchComesFirst) {
                    mask ^= 0x1C;
                }
                switch (mask) {
                    case 16: {
                        opcode = 157;
                        break;
                    }
                    case 8: {
                        opcode = 153;
                        break;
                    }
                    case 4: {
                        opcode = 155;
                        break;
                    }
                    case 20: {
                        opcode = 154;
                        break;
                    }
                    case 24: {
                        opcode = 156;
                        break;
                    }
                    case 12: {
                        opcode = 158;
                        break;
                    }
                    default: {
                        opcode = 0;
                    }
                }
                arg0.compile(comp, subTarget);
                if (kind0 >= 7 && kind1 >= 7 && arg1 instanceof QuoteExp && (value = ((QuoteExp)arg1).getValue()) instanceof IntNum && ((IntNum)value).isZero()) {
                    code.emitGotoIfCompare1(label1, opcode);
                } else {
                    arg1.compile(comp, subTarget);
                    code.emitGotoIfCompare2(label1, opcode);
                }
                ctarget.emitGotoFirstBranch(code);
                return;
            }
        }
        ApplyExp.compile(exp, comp, target);
    }

    static int classify(Expression exp) {
        Object value;
        Type type = exp.getType();
        int kind = NumberCompare.classify(type);
        if (kind == 5 && exp instanceof QuoteExp && (value = ((QuoteExp)exp).getValue()) instanceof IntNum) {
            int ilength = ((IntNum)value).intLength();
            if (ilength < 32) {
                return 7;
            }
            if (ilength < 64) {
                return 6;
            }
        }
        return kind;
    }

    static int classify(Type type) {
        if (type instanceof PrimType) {
            char sig = type.getSignature().charAt(0);
            if (sig == 'V' || sig == 'Z' || sig == 'C') {
                return 0;
            }
            if (sig == 'D' || sig == 'F') {
                return 4;
            }
            if (sig == 'J') {
                return 6;
            }
            return 7;
        }
        if (type.isSubtype(Arithmetic.typeIntNum)) {
            return 5;
        }
        if (type.isSubtype(Arithmetic.typeDFloNum)) {
            return 4;
        }
        if (type.isSubtype(Arithmetic.typeRealNum)) {
            return 3;
        }
        if (type.isSubtype(Arithmetic.typeNumeric)) {
            return 2;
        }
        return 0;
    }

    public Type getReturnType(Expression[] args) {
        return Type.booleanType;
    }
}

