/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.lists.Array;
import gnu.lists.FVector;
import gnu.lists.GeneralArray;
import gnu.lists.SimpleVector;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.IntNum;

public class Arrays {
    static final int[] shapeStrides = new int[]{2, 1};
    static final int[] zeros2 = new int[2];

    public static Array shape(Object[] vals) {
        int len = vals.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("shape: not an even number of arguments");
        }
        int d = len >> 1;
        int[] dims = new int[]{d, 2};
        return new FVector(vals).transpose(zeros2, dims, 0, shapeStrides);
    }

    public static Array make(Array shape, Object value) {
        int rank = shape.getSize(0);
        int[] dimensions = new int[rank];
        int[] lowBounds = null;
        int total = 1;
        int i = rank;
        while (--i >= 0) {
            int size;
            int lo = ((Number)shape.getRowMajor(2 * i)).intValue();
            int hi = ((Number)shape.getRowMajor(2 * i + 1)).intValue();
            dimensions[i] = size = hi - lo;
            if (lo != 0) {
                if (lowBounds == null) {
                    lowBounds = new int[rank];
                }
                lowBounds[i] = lo;
            }
            total *= size;
        }
        return GeneralArray.makeSimple(lowBounds, dimensions, new FVector(total, value));
    }

    public static Array makeSimple(Array shape, SimpleVector base) {
        int rank = shape.getSize(0);
        int[] dimensions = new int[rank];
        int[] lowBounds = null;
        int i = rank;
        while (--i >= 0) {
            int lo = ((Number)shape.getRowMajor(2 * i)).intValue();
            int hi = ((Number)shape.getRowMajor(2 * i + 1)).intValue();
            dimensions[i] = hi - lo;
            if (lo == 0) continue;
            if (lowBounds == null) {
                lowBounds = new int[rank];
            }
            lowBounds[i] = lo;
        }
        return GeneralArray.makeSimple(lowBounds, dimensions, base);
    }

    public static int effectiveIndex(Array array, Procedure proc, Object[] args, int[] work) throws Throwable {
        Object mapval = proc.applyN(args);
        if (mapval instanceof Values) {
            Values mapvals = (Values)mapval;
            int i = 0;
            int j = 0;
            while ((i = mapvals.nextPos(i)) != 0) {
                work[j] = ((Number)mapvals.getPosPrevious(i)).intValue();
                ++j;
            }
        } else {
            work[0] = ((Number)mapval).intValue();
        }
        return array.getEffectiveIndex(work);
    }

    public static Array shareArray(Array array, Array shape, Procedure proc) throws Throwable {
        int offset0;
        int rank = shape.getSize(0);
        Object[] args = new Object[rank];
        int[] dimensions = new int[rank];
        int[] lowBounds = new int[rank];
        boolean empty = false;
        int i = rank;
        while (--i >= 0) {
            int size;
            int lo;
            Object low = shape.getRowMajor(2 * i);
            args[i] = low;
            lowBounds[i] = lo = ((Number)low).intValue();
            int hi = ((Number)shape.getRowMajor(2 * i + 1)).intValue();
            dimensions[i] = size = hi - lo;
            if (size > 0) continue;
            empty = true;
        }
        int arank = array.rank();
        int[] offsets = new int[rank];
        if (empty) {
            offset0 = 0;
        } else {
            int[] work = new int[arank];
            offset0 = Arrays.effectiveIndex(array, proc, args, work);
            int i2 = rank;
            while (--i2 >= 0) {
                int size = dimensions[i2];
                int lo = lowBounds[i2];
                if (size <= 1) {
                    offsets[i2] = 0;
                    continue;
                }
                Object low = args[i2];
                args[i2] = IntNum.make(lo + 1);
                offsets[i2] = Arrays.effectiveIndex(array, proc, args, work) - offset0;
                args[i2] = low;
            }
        }
        return array.transpose(lowBounds, dimensions, offset0, offsets);
    }
}

