/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Named;
import gnu.mapping.NamedLocation;
import gnu.mapping.SharedLocation;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocation<T>
extends NamedLocation<T>
implements Named {
    static int counter;
    public static final String ANONYMOUS;
    SharedLocation<T> global;
    private ThreadLocal<NamedLocation<T>> thLocal;
    private int hash;
    static SimpleEnvironment env;

    private static synchronized int nextCounter() {
        return ++counter;
    }

    public ThreadLocation() {
        this("param#" + ThreadLocation.nextCounter());
    }

    public ThreadLocation(String name) {
        super(Symbol.makeUninterned(name), ANONYMOUS);
        this.thLocal = new InheritingLocation();
        this.global = new SharedLocation(this.name, null, 0);
    }

    private ThreadLocation(Symbol name) {
        super(name, ANONYMOUS);
        this.thLocal = new InheritingLocation();
        String str = name == null ? null : name.toString();
        this.global = new SharedLocation(Symbol.makeUninterned(str), null, 0);
    }

    public ThreadLocation(Symbol name, Object property, SharedLocation global) {
        super(name, property);
        this.hash = name.hashCode() ^ System.identityHashCode(property);
        this.global = global;
    }

    public static ThreadLocation makeAnonymous(String name) {
        return new ThreadLocation(name);
    }

    public static ThreadLocation makeAnonymous(Symbol name) {
        return new ThreadLocation(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobal(T value) {
        ThreadLocation threadLocation = this;
        synchronized (threadLocation) {
            if (this.global == null) {
                this.global = new SharedLocation(this.name, null, 0);
            }
            this.global.set(value);
        }
    }

    public NamedLocation<T> getLocation() {
        if (this.property != ANONYMOUS) {
            return Environment.getCurrent().getLocation(this.name, this.property, this.hash, true);
        }
        NamedLocation<T> entry = this.thLocal.get();
        if (entry == null) {
            entry = new SharedLocation(this.name, this.property, 0);
            if (this.global != null) {
                entry.setBase(this.global);
            }
            this.thLocal.set(entry);
        }
        return entry;
    }

    @Override
    public T get() {
        return this.getLocation().get();
    }

    @Override
    public T get(T defaultValue) {
        return this.getLocation().get(defaultValue);
    }

    @Override
    public boolean isBound() {
        return this.getLocation().isBound();
    }

    @Override
    public void set(T value) {
        this.getLocation().set(value);
    }

    @Override
    public Object setWithSave(T newValue) {
        return this.getLocation().setWithSave(newValue);
    }

    @Override
    public void setRestore(Object oldValue) {
        this.getLocation().setRestore(oldValue);
    }

    @Override
    public String getName() {
        return this.name == null ? null : this.name.toString();
    }

    @Override
    public Object getSymbol() {
        if (this.name != null && this.property == ANONYMOUS && this.global.getKeySymbol() == this.name) {
            return this.name.toString();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new RuntimeException("setName not allowed");
    }

    public static synchronized ThreadLocation getInstance(Symbol name, Object property) {
        if (env == null) {
            env = new SimpleEnvironment("[thread-locations]");
        }
        IndirectableLocation loc = (IndirectableLocation)env.getLocation(name, property);
        if (loc.base != null) {
            return (ThreadLocation)loc.base;
        }
        ThreadLocation tloc = new ThreadLocation(name, property, null);
        loc.base = tloc;
        return tloc;
    }

    static {
        ANONYMOUS = new String("(dynamic)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InheritingLocation<T>
    extends InheritableThreadLocal<NamedLocation<T>> {
        @Override
        protected SharedLocation childValue(NamedLocation<T> parentValue) {
            SharedLocation sloc;
            if (ThreadLocation.this.property != ANONYMOUS) {
                throw new Error();
            }
            if (parentValue == null) {
                parentValue = (SharedLocation)ThreadLocation.this.getLocation();
            }
            SharedLocation nloc = parentValue;
            if (nloc.base == null) {
                sloc = new SharedLocation(ThreadLocation.this.name, ThreadLocation.this.property, 0);
                sloc.value = nloc.value;
                nloc.base = sloc;
                nloc.value = null;
                nloc = sloc;
            }
            sloc = new SharedLocation(ThreadLocation.this.name, ThreadLocation.this.property, 0);
            sloc.value = null;
            sloc.base = nloc;
            return sloc;
        }
    }
}

