/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ErrorExp;
import gnu.expr.ExitExp;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.ThisExp;
import gnu.expr.TryExp;
import gnu.text.SourceMessages;

public class ExpWalker {
    SourceMessages messages;
    Compilation comp;
    LambdaExp currentLambda = null;
    Object exitValue = null;

    public Compilation getCompilation() {
        return this.comp;
    }

    protected Expression walkExpression(Expression expression) {
        expression.walkChildren(this);
        return expression;
    }

    public void setContext(Compilation compilation) {
        this.comp = compilation;
        this.messages = compilation.getMessages();
    }

    public Expression walk(Expression expression) {
        int n = expression.getLine();
        if (this.messages != null && n > 0) {
            String string = this.messages.getFile();
            int n2 = this.messages.getLine();
            int n3 = this.messages.getColumn();
            this.messages.setLine(expression.getFile(), n, expression.getColumn());
            Expression expression2 = expression.walk(this);
            this.messages.setLine(string, n2, n3);
            return expression2;
        }
        return expression.walk(this);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        return this.walkExpression(applyExp);
    }

    protected Expression walkIfExp(IfExp ifExp) {
        return this.walkExpression(ifExp);
    }

    protected Expression walkScopeExp(ScopeExp scopeExp) {
        return this.walkExpression(scopeExp);
    }

    protected Expression walkLetExp(LetExp letExp) {
        return this.walkScopeExp(letExp);
    }

    protected Expression walkLambdaExp(LambdaExp lambdaExp) {
        return this.walkScopeExp(lambdaExp);
    }

    protected Expression walkClassExp(ClassExp classExp) {
        return this.walkLambdaExp(classExp);
    }

    protected Expression walkObjectExp(ObjectExp objectExp) {
        return this.walkClassExp(objectExp);
    }

    protected Expression walkModuleExp(ModuleExp moduleExp) {
        return this.walkLambdaExp(moduleExp);
    }

    protected Expression walkSetExp(SetExp setExp) {
        return this.walkExpression(setExp);
    }

    protected Expression walkTryExp(TryExp tryExp) {
        return this.walkExpression(tryExp);
    }

    protected Expression walkBeginExp(BeginExp beginExp) {
        return this.walkExpression(beginExp);
    }

    protected Expression walkQuoteExp(QuoteExp quoteExp) {
        return this.walkExpression(quoteExp);
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        return this.walkExpression(referenceExp);
    }

    protected Expression walkThisExp(ThisExp thisExp) {
        return this.walkReferenceExp(thisExp);
    }

    protected Expression walkSynchronizedExp(SynchronizedExp synchronizedExp) {
        return this.walkExpression(synchronizedExp);
    }

    protected Expression walkBlockExp(BlockExp blockExp) {
        return this.walkExpression(blockExp);
    }

    protected Expression walkExitExp(ExitExp exitExp) {
        return this.walkExpression(exitExp);
    }

    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        return this.walkLetExp(fluidLetExp);
    }

    public final LambdaExp getCurrentLambda() {
        return this.currentLambda;
    }

    public Expression[] walkExps(Expression[] expressionArray) {
        return this.walkExps(expressionArray, expressionArray.length);
    }

    public Expression[] walkExps(Expression[] expressionArray, int n) {
        int n2;
        int n3;
        String string;
        if (this.messages != null) {
            string = this.messages.getFile();
            n3 = this.messages.getLine();
            n2 = this.messages.getColumn();
        } else {
            string = null;
            n3 = 0;
            n2 = 0;
        }
        boolean bl = false;
        for (int i = 0; i < n && this.exitValue == null; ++i) {
            Expression expression = expressionArray[i];
            int n4 = expression.getLine();
            if (this.messages != null && n4 > 0) {
                this.messages.setLine(expression.getFile(), n4, expression.getColumn());
                bl = true;
            } else if (bl) {
                this.messages.setLine(string, n3, n2);
                bl = false;
            }
            expressionArray[i] = this.walk(expression);
        }
        if (bl) {
            this.messages.setLine(string, n3, n2);
        }
        return expressionArray;
    }

    public void walkDefaultArgs(LambdaExp lambdaExp) {
        if (lambdaExp.defaultArgs != null) {
            lambdaExp.defaultArgs = this.walkExps(lambdaExp.defaultArgs);
        }
    }

    public void error(char c, String string) {
        if (this.messages != null) {
            this.messages.error(c, string);
        } else {
            new Error("internal error: " + string);
        }
    }

    public Expression noteError(String string) {
        if (this.messages != null) {
            this.messages.error('e', string);
        }
        return new ErrorExp(string);
    }

    public final String getFile() {
        return this.messages.getFile();
    }

    public final int getLine() {
        return this.messages.getLine();
    }

    public final int getColumn() {
        return this.messages.getColumn();
    }

    public void setFile(String string) {
        this.messages.setFile(string);
    }

    public void setLine(int n) {
        this.messages.setLine(n);
    }

    public void setColumn(int n) {
        this.messages.setColumn(n);
    }

    public void setLine(String string, int n, int n2) {
        this.messages.setLine(string, n, n2);
    }
}

