/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.xml.AttributeConstructor;
import gnu.kawa.xml.ElementConstructor;
import gnu.kawa.xml.ElementType;
import gnu.kawa.xml.NodeType;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xquery.lang.XQuery;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;

public class XQParser
extends LispReader {
    int curToken;
    Object curValue;
    boolean focusDefined = true;
    XQuery interpreter;
    public static final InstanceOf instanceOf = new InstanceOf(XQuery.getInstance(), "instance");
    int nesting;
    static final int EOF_TOKEN = -1;
    static final int EOL_TOKEN = 10;
    static final char INTEGER_TOKEN = '0';
    static final char FLOAT_TOKEN = '1';
    static final int STRING_TOKEN = 34;
    static final int SLASHSLASH_TOKEN = 68;
    static final int DOTDOT_TOKEN = 50;
    static final int COLON_EQUAL_TOKEN = 76;
    static final int COLONCOLON_TOKEN = 88;
    static final int NCNAME_TOKEN = 65;
    static final int NCNAME_COLON_TOKEN = 67;
    static final int QNAME_TOKEN = 81;
    static final int ARROW_TOKEN = 82;
    static final int FNAME_TOKEN = 70;
    static final int DECLARE_NAMESPACE_TOKEN = 77;
    static final int DEFAULT_ELEMENT_TOKEN = 78;
    static final int DEFAULT_FUNCTION_TOKEN = 79;
    static final int DEFINE_FUNCTION_TOKEN = 80;
    static final int DEFINE_VARIABLE_TOKEN = 86;
    static final int OP_AXIS_FIRST = 100;
    static final int COUNT_OP_AXIS = 13;
    static final int AXIS_ANCESTOR = 0;
    static final int AXIS_ANCESTOR_OR_SELF = 1;
    static final int AXIS_ATTRIBUTE = 2;
    static final int AXIS_CHILD = 3;
    static final int AXIS_DESCENDANT = 4;
    static final int AXIS_DESCENDANT_OR_SELF = 5;
    static final int AXIS_FOLLOWING = 6;
    static final int AXIS_FOLLOWING_SIBLING = 7;
    static final int AXIS_NAMESPACE = 8;
    static final int AXIS_PARENT = 9;
    static final int AXIS_PRECEDING = 10;
    static final int AXIS_PRECEDING_SIBLING = 11;
    static final int AXIS_SELF = 12;
    static final int OP_WHERE = 196;
    static final int OP_OR = 200;
    static final int OP_AND = 204;
    static final int OP_EQU = 208;
    static final int OP_NEQ = 209;
    static final int OP_INSTANCEOF = 210;
    static final int OP_RANGE_TO = 211;
    static final int OP_LSS = 212;
    static final int OP_GRT = 213;
    static final int OP_LEQ = 214;
    static final int OP_GEQ = 215;
    static final int OP_ADD = 216;
    static final int OP_SUB = 217;
    static final int OP_MUL = 220;
    static final int OP_DIV = 221;
    static final int OP_MOD = 222;
    static final int OP_INTERSECT = 224;
    static final int OP_EXCEPT = 225;
    static final int OP_UNION = 226;
    static final int OP_NODE = 231;
    static final int OP_TEXT = 232;
    private int saveToken;
    private Object saveValue;
    public static ReadTable xqlReadTable = ReadTable.getInitial();
    int count = 0;
    private boolean warnedOldStyleKindTest;
    Compilation parser;
    String defaultElementNamespace = "";
    String defaultFunctionNamespace = "http://www.w3.org/2002/08/xquery-functions";
    Hashtable namespaces = new Hashtable(50);
    public static final String[] axisNames = new String[13];
    static final Expression funcNamedChildren;
    static final Expression funcNamedDescendants;
    static final Expression funcNamedDescendantsOrSelf;
    static final Expression funcValuesFilter;
    static final NodeType textNodeTest;
    static final NodeType anyNodeTest;

    protected char pushNesting(char c) {
        ++this.nesting;
        InPort inPort = (InPort)this.getPort();
        char c2 = inPort.readState;
        inPort.readState = c;
        return c2;
    }

    protected void popNesting(char c) {
        InPort inPort = (InPort)this.getPort();
        inPort.readState = c;
        --this.nesting;
    }

    final int skipSpace() throws IOException {
        int n;
        while ((n = this.read()) >= 0 && Character.isWhitespace((char)n)) {
        }
        return n;
    }

    final int skipSpaceOrComment() throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) == 40) {
                if (!this.checkNext(':')) {
                    return 40;
                }
                this.skipComment();
                continue;
            }
            if (n == 123) {
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    return 123;
                }
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    this.unread(45);
                    return 123;
                }
                this.skipOldComment();
                continue;
            }
            if (n < 0 || !Character.isWhitespace((char)n)) break;
        }
        return n;
    }

    final void skipOldComment() throws IOException, SyntaxException {
        int n = 0;
        int n2 = this.getLineNumber() + 1;
        while (true) {
            int n3;
            if ((n3 = this.read()) == 45) {
                ++n;
                continue;
            }
            if (n3 == 125 && n >= 2) {
                return;
            }
            if (n3 < 0) {
                this.eofError("non-terminated comment starting at line " + n2);
                continue;
            }
            n = 0;
        }
    }

    final void skipComment() throws IOException, SyntaxException {
        int n = this.getLineNumber() + 1;
        int n2 = 0;
        int n3 = 0;
        char c = this.pushNesting(':');
        while (true) {
            int n4;
            if ((n4 = this.read()) == 58) {
                if (n2 == 40) {
                    ++n3;
                    n4 = 0;
                }
            } else if (n4 == 41 && n2 == 58) {
                if (n3 == 0) {
                    this.popNesting(c);
                    return;
                }
                --n3;
            } else if (n4 < 0) {
                this.eofError("non-terminated comment starting at line " + n);
            }
            n2 = n4;
        }
    }

    final int skipHSpace() throws IOException {
        int n;
        while ((n = this.read()) == 32 || n == 9) {
        }
        return n;
    }

    final int peekNonSpace(String string) throws IOException, SyntaxException {
        int n = this.skipSpaceOrComment();
        if (n < 0) {
            this.eofError(string);
        }
        this.unread(n);
        return n;
    }

    public static boolean isNameStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNamePart(char c) {
        return Character.isUnicodeIdentifierPart(c) || c == '-' || c == '.';
    }

    public void mark() throws IOException {
        super.mark();
        this.saveToken = this.curToken;
        this.saveValue = this.curValue;
    }

    public void reset() throws IOException {
        this.curToken = this.saveToken;
        this.curValue = this.saveValue;
        super.reset();
    }

    int getRawToken() throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) < 0) {
                this.curToken = -1;
                return -1;
            }
            if (n == 10 || n == 13) {
                if (this.nesting > 0) continue;
                this.curToken = 10;
                return 10;
            }
            if (n == 40) {
                if (this.checkNext(':')) {
                    this.skipComment();
                    continue;
                }
                this.curToken = 40;
                return 40;
            }
            if (n == 123) {
                if (!this.checkNext('-')) {
                    this.curToken = 123;
                    return 123;
                }
                n = this.read();
                if (n != 45) {
                    this.unread();
                    this.unread();
                    this.curToken = 123;
                    return 123;
                }
                this.skipOldComment();
                continue;
            }
            if (n != 32 && n != 9) break;
        }
        this.tokenBufferLength = 0;
        int n2 = n;
        switch (n2) {
            case 36: 
            case 41: 
            case 44: 
            case 63: 
            case 64: 
            case 91: 
            case 93: 
            case 125: {
                break;
            }
            case 58: {
                if (!this.checkNext('=')) break;
                n2 = 76;
                break;
            }
            case 124: {
                n2 = 226;
                break;
            }
            case 42: {
                n2 = 220;
                break;
            }
            case 43: {
                n2 = 216;
                break;
            }
            case 45: {
                n2 = 217;
                break;
            }
            case 33: {
                if (!this.checkNext('=')) break;
                n2 = 209;
                break;
            }
            case 47: {
                if (!this.checkNext('/')) break;
                n2 = 68;
                break;
            }
            case 61: {
                if (this.checkNext('>')) {
                    n2 = 82;
                }
                n2 = 208;
                break;
            }
            case 62: {
                n2 = this.checkNext('=') ? 215 : 213;
                break;
            }
            case 60: {
                n2 = this.checkNext('=') ? 214 : 212;
                break;
            }
            case 46: {
                if (this.checkNext('.')) {
                    n2 = 50;
                    break;
                }
                n = this.peek();
                if (!Character.isDigit((char)n)) break;
                this.tokenBufferAppend(46);
                do {
                    this.tokenBufferAppend((char)n);
                    this.skip();
                } while (Character.isDigit((char)(n = this.peek())));
                n2 = 49;
                break;
            }
            case 34: 
            case 39: {
                char c = this.pushNesting((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        this.eofError("unexpected end-of-file in string");
                    }
                    if (n == 38) {
                        this.parseEntityOrCharRef();
                        continue;
                    }
                    if (n2 == n && n2 != (n = this.read())) break;
                    this.tokenBufferAppend((char)n);
                }
                this.unread(n);
                this.popNesting(c);
                n2 = 34;
                break;
            }
            default: {
                if (Character.isDigit((char)n2)) {
                    boolean bl = false;
                    while (true) {
                        this.tokenBufferAppend(n2);
                        n = this.read();
                        if (n < 0) break;
                        n2 = (char)n;
                        if (n2 == 46) {
                            if (bl) break;
                            bl = true;
                            continue;
                        }
                        if (!Character.isDigit((char)n2)) break;
                    }
                    if (n == 101 || n == 69) {
                        n = this.read();
                        if (n == 43 || n == 45) {
                            this.tokenBufferAppend((char)n);
                            n = this.read();
                        }
                        int n3 = 0;
                        while (n >= 0) {
                            n2 = (char)n;
                            if (!Character.isDigit((char)n2)) {
                                this.unread();
                                break;
                            }
                            this.tokenBufferAppend(n2);
                            n = this.read();
                            ++n3;
                        }
                        if (n3 == 0) {
                            this.error("no digits following exponent");
                        }
                        n2 = 49;
                        break;
                    }
                    int n4 = n2 = bl ? 49 : 48;
                    if (n < 0) break;
                    this.unread(n);
                    break;
                }
                if (XQParser.isNameStart((char)n2)) {
                    do {
                        this.tokenBufferAppend(n2);
                    } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                    if (n < 0) {
                        n2 = 65;
                        break;
                    }
                    if (n != 58) {
                        n2 = 65;
                    } else {
                        n = this.read();
                        if (n < 0) {
                            this.eofError("unexpected end-of-file after NAME ':'");
                        }
                        if (XQParser.isNameStart((char)(n2 = (int)((char)n)))) {
                            this.tokenBufferAppend(58);
                            do {
                                this.tokenBufferAppend(n2);
                            } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                            n2 = 81;
                        } else if (n2 == 61) {
                            this.unread(n2);
                            n2 = 65;
                        } else {
                            n2 = 67;
                        }
                    }
                    this.unread(n);
                    break;
                }
                if (n2 >= 32 && n2 < 127) {
                    this.syntaxError("invalid character '" + (char)n2 + '\'', 1);
                    break;
                }
                this.syntaxError("invalid character '\\u" + Integer.toHexString(n2) + '\'', 1);
            }
        }
        this.curToken = n2;
        return n2;
    }

    public void appendNamedEntity(String string) {
        string = string.intern();
        int n = 63;
        if (string == "lt") {
            n = 60;
        } else if (string == "gt") {
            n = 62;
        } else if (string == "amp") {
            n = 38;
        } else if (string == "quot") {
            n = 34;
        } else if (string == "apos") {
            n = 39;
        } else {
            this.error("unknown enity reference: '" + string + "'");
        }
        this.tokenBufferAppend(n);
    }

    int peekOperator() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            this.getRawToken();
        }
        if (this.curToken == 65) {
            int n = this.tokenBufferLength;
            if (n == 2 || n == 3) {
                char c = this.tokenBuffer[0];
                if (n == 2) {
                    if (c == 'o' && this.tokenBuffer[1] == 'r') {
                        this.curToken = 200;
                    } else if (c == 't' && this.tokenBuffer[1] == 'o') {
                        this.curToken = 211;
                    }
                } else {
                    char c2 = this.tokenBuffer[1];
                    char c3 = this.tokenBuffer[2];
                    if (c == 'a') {
                        if (c2 == 'n' && c3 == 'd') {
                            this.curToken = 204;
                        }
                    } else if (c == 'm') {
                        if (c2 == 'u' && c3 == 'l') {
                            this.curToken = 220;
                        }
                        if (c2 == 'o' && c3 == 'd') {
                            this.curToken = 222;
                        }
                    } else if (c == 'd' && c2 == 'i' && c3 == 'v') {
                        this.curToken = 221;
                    }
                }
            } else if (n == 5) {
                if (this.match("where")) {
                    this.curToken = 196;
                }
            } else if (n == 10) {
                int n2 = 0;
                while (true) {
                    if (n2 == 10) {
                        this.curToken = 210;
                        break;
                    }
                    if (this.tokenBuffer[n2] != "instanceof".charAt(n2)) break;
                    ++n2;
                }
            }
        }
        return this.curToken;
    }

    private boolean lookingAt(String string, String string2) throws IOException, SyntaxException {
        int n;
        if (!string.equals(this.curValue)) {
            return false;
        }
        int n2 = 0;
        int n3 = string2.length();
        do {
            n = this.read();
            if (n2 != n3) continue;
            if (n < 0) {
                return true;
            }
            if (!XQParser.isNamePart((char)n)) {
                this.unread();
                return true;
            }
            ++n2;
            break;
        } while (n >= 0 && n == string2.charAt(n2++));
        this.port.skip(-n2);
        return false;
    }

    int peekOperand() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            this.getRawToken();
        }
        if (this.curToken == 65 || this.curToken == 81) {
            int n;
            int n2 = n = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
            if (n == 40 && this.peek() != 58) {
                int n3 = 70;
                switch (this.tokenBuffer[0]) {
                    case 'i': {
                        if (!this.match("if")) break;
                        this.unread();
                        return this.curToken;
                    }
                    case 'n': {
                        if (!this.match("node")) break;
                        n3 = 231;
                        break;
                    }
                    case 't': {
                        if (!this.match("text")) break;
                        n3 = 232;
                    }
                }
                this.curToken = n3;
                return this.curToken;
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.curValue = string;
            switch (n) {
                case 101: {
                    if (!this.lookingAt("default", "lement")) break;
                    this.curToken = 78;
                    return 78;
                }
                case 102: {
                    if (this.lookingAt("define", "unction")) {
                        this.curToken = 80;
                        return 80;
                    }
                    if (!this.lookingAt("default", "unction")) break;
                    this.curToken = 79;
                    return 79;
                }
                case 110: {
                    if (!this.lookingAt("declare", "amespace")) break;
                    this.curToken = 77;
                    return 77;
                }
                case 118: {
                    if (!this.lookingAt("define", "ariable")) break;
                    this.curToken = 86;
                    return 86;
                }
            }
            if (n >= 0) {
                this.unread();
            }
            return this.curToken;
        }
        if (this.curToken == 67) {
            int n = this.read();
            if (n == 58) {
                String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                int n4 = 13;
                while (--n4 >= 0) {
                    if (axisNames[n4] == string) break;
                }
                if (n4 >= 0) {
                    this.curToken = (char)(100 + n4);
                } else {
                    this.error("unknown axis name '" + string + '\'');
                }
                this.curValue = string;
            } else {
                this.unread(n);
            }
        }
        return this.curToken;
    }

    private void pushStandardNamespaces() {
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.namespaces.put("fn", "http://www.w3.org/2002/11/xquery-functions");
    }

    public XQParser(InPort inPort) {
        this(inPort, null);
    }

    public XQParser(InPort inPort, SourceMessages sourceMessages) {
        super(inPort, sourceMessages);
        this.pushStandardNamespaces();
        this.nesting = 1;
    }

    public void setInteractive(boolean bl) {
        if (this.interactive != bl) {
            this.nesting = bl ? --this.nesting : ++this.nesting;
        }
        this.interactive = bl;
    }

    protected ReadTable getReadTable() {
        return xqlReadTable;
    }

    public static Object readObject(InPort inPort) throws IOException, SyntaxException {
        return new XQParser(inPort).readObject();
    }

    private static final int priority(int n) {
        return n >> 2;
    }

    Expression parseExpr() throws IOException, SyntaxException {
        return this.parseSortExpr();
    }

    static Expression makeBinary(Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2, expression3};
        return new ApplyExp(expression, expressionArray);
    }

    static Expression makeExprSequence(Expression expression, Expression expression2) {
        return XQParser.makeBinary(XQParser.makeFunctionExp("gnu.kawa.functions.AppendValues", "appendValues"), expression, expression2);
    }

    Expression makeBinary(int n, Expression expression, Expression expression2) {
        Expression expression3;
        switch (n) {
            case 216: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "+");
                break;
            }
            case 217: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "-");
                break;
            }
            case 220: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.MultiplyOp", "$St", "mul");
                break;
            }
            case 221: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.DivideOp", "$Sl", "div");
                break;
            }
            case 222: {
                expression3 = new QuoteExp(new PrimProcedure(ClassType.make("gnu.math.IntNum").getDeclaredMethod("remainder", 2)));
                break;
            }
            case 208: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "=");
                break;
            }
            case 209: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "!=");
                break;
            }
            case 212: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<");
                break;
            }
            case 214: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<=");
                break;
            }
            case 213: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">");
                break;
            }
            case 215: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">=");
                break;
            }
            case 211: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.IntegerRange", "integerRange");
                break;
            }
            default: {
                return new ErrorExp("unimplemented binary op: " + n);
            }
        }
        return XQParser.makeBinary(expression3, expression, expression2);
    }

    Expression parseSortExpr() throws IOException, SyntaxException {
        Expression expression = this.parseBinaryExpr(XQParser.priority(200));
        return expression;
    }

    private void parseSimpleKindType() throws IOException, SyntaxException {
        this.getRawToken();
        if (this.curToken == 40) {
            this.getRawToken();
            if (this.curToken == 41) {
                this.getRawToken();
            } else {
                this.error("expected ')'");
            }
        } else {
            this.warnOldStyleKindTest();
        }
    }

    public Type parseElementType() throws IOException, SyntaxException {
        Symbol symbol;
        if (this.curToken == 40) {
            this.getRawToken();
            if (this.curToken == 41) {
                symbol = new Symbol(null);
                this.getRawToken();
            } else {
                symbol = this.parseNameTest(this.defaultElementNamespace);
                this.getRawToken();
                if (this.curToken == 44) {
                    this.getRawToken();
                    Symbol symbol2 = this.parseNameTest(this.defaultElementNamespace);
                    this.getRawToken();
                }
                if (this.curToken == 41) {
                    this.getRawToken();
                } else {
                    this.error("expected ')' after element");
                }
            }
        } else {
            this.warnOldStyleKindTest();
            if (this.curToken == 81 || this.curToken == 220 || this.curToken == 65 || this.curToken == 67) {
                symbol = this.parseNameTest(this.defaultElementNamespace);
                this.getRawToken();
            } else {
                symbol = new Symbol(null);
            }
        }
        return new ElementType(symbol);
    }

    private void warnOldStyleKindTest() {
        if (this.warnedOldStyleKindTest) {
            return;
        }
        this.error('w', "old-style KindTest - first one here");
        this.warnedOldStyleKindTest = true;
    }

    public Expression parseOptionalTypeDeclaration() throws IOException, SyntaxException {
        if (!this.match("as")) {
            return null;
        }
        this.getRawToken();
        return this.parseDataType();
    }

    public Expression parseDataType() throws IOException, SyntaxException {
        int n;
        int n2;
        Type type = this.parseItemType();
        if (type == null) {
            return this.syntaxError("bad syntax - expected DataType");
        }
        if (this.curToken == 63) {
            n2 = 0;
            n = 1;
        } else if (this.curToken == 216) {
            n2 = 1;
            n = -1;
        } else if (this.curToken == 220) {
            n2 = 0;
            n = -1;
        } else {
            n2 = 1;
            n = 1;
        }
        if (n2 != n) {
            this.getRawToken();
            return new QuoteExp(new OccurrenceType(type, n2, n));
        }
        return new QuoteExp(type);
    }

    public Type parseItemType() throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            if (this.match("element")) {
                this.getRawToken();
                return this.parseElementType();
            }
            if (this.match("text")) {
                this.parseSimpleKindType();
                return textNodeTest;
            }
            if (this.match("node")) {
                this.parseSimpleKindType();
                return anyNodeTest;
            }
            if (this.match("empty")) {
                this.parseSimpleKindType();
                return Type.void_type;
            }
            if (this.match("item")) {
                this.parseSimpleKindType();
                return Type.pointer_type;
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.getRawToken();
            Type type = this.interpreter.getTypeFor(string);
            if (type == null) {
                type = ClassType.make(string);
            }
            return type;
        }
        return null;
    }

    Expression parseBinaryExpr(int n) throws IOException, SyntaxException {
        Expression expression = this.parseUnaryExpr();
        while (this.nesting != 0 || this.curToken != 10) {
            Expression[] expressionArray;
            int n2 = this.peekOperator();
            if (n2 == 212 && this.peek() == 47) {
                return expression;
            }
            int n3 = XQParser.priority(n2);
            if (n3 < n || n3 > 55) {
                return expression;
            }
            char c = this.pushNesting('%');
            this.getRawToken();
            this.popNesting(c);
            if (n2 == 210) {
                expressionArray = new Expression[]{expression, this.parseDataType()};
                expression = new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "instanceOf"), expressionArray);
                continue;
            }
            expressionArray = this.parseBinaryExpr(n3 + 1);
            if (n2 == 204) {
                expression = new IfExp(XQParser.booleanValue(expression), (Expression)expressionArray, QuoteExp.falseExp);
                continue;
            }
            if (n2 == 200) {
                expression = new IfExp(XQParser.booleanValue(expression), QuoteExp.trueExp, (Expression)expressionArray);
                continue;
            }
            expression = this.makeBinary(n2, expression, (Expression)expressionArray);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 217 || this.curToken == 216) {
            this.getRawToken();
            expression = this.parseUnionExpr();
            expression = this.syntaxError("non-trivial UnaryExpr not implemented");
        } else {
            expression = this.parseUnionExpr();
        }
        return expression;
    }

    Expression parseUnionExpr() throws IOException, SyntaxException {
        Expression expression = this.parseIntersectExceptExpr();
        while (this.curToken == 226) {
            int n = this.curToken;
            this.getRawToken();
            Expression expression2 = this.parseIntersectExceptExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws IOException, SyntaxException {
        Expression expression = this.parsePathExpr();
        while (this.curToken == 224 || this.curToken == 225) {
            int n = this.curToken;
            this.getRawToken();
            Expression expression2 = this.parsePathExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parsePathExpr() throws IOException, SyntaxException {
        if (this.curToken == 47 || this.curToken == 68) {
            return this.syntaxError("unimplemented non-relative PathExpr");
        }
        return this.parseRelativePathExpr();
    }

    Symbol parseNameTest(String string) throws IOException, SyntaxException {
        String string2 = null;
        String string3 = null;
        if (this.curToken == 81) {
            int n = this.tokenBufferLength;
            while (this.tokenBuffer[--n] != ':') {
            }
            String string4 = new String(this.tokenBuffer, 0, n);
            string2 = new String(this.tokenBuffer, ++n, this.tokenBufferLength - n);
            string3 = (String)this.namespaces.get(string4);
            if (string3 == null) {
                this.syntaxError("unknown namespace '" + string4 + "'");
            }
        } else if (this.curToken == 220) {
            int n = this.read();
            if (n != 58) {
                this.unread(n);
            } else {
                n = this.read();
                if (n < 0) {
                    this.eofError("unexpected end-of-file after '*:'");
                }
                if (XQParser.isNameStart((char)n)) {
                    this.unread();
                    this.getRawToken();
                    if (this.curToken != 65) {
                        this.syntaxError("invalid name test");
                    } else {
                        string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    }
                } else if (n != 42) {
                    this.syntaxError("missing local-name after '*:'");
                }
            }
        } else if (this.curToken == 65) {
            string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            string3 = string;
        } else if (this.curToken == 67) {
            String string5 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            int n = this.read();
            if (n != 42) {
                this.syntaxError("invalid characters after 'NCName:'");
                return Symbol.make(string, string5);
            }
            string3 = (String)this.namespaces.get(string5);
            if (string3 == null) {
                this.syntaxError("unknown namespace '" + string5 + "'");
            }
            string2 = null;
        }
        if (string3 == null) {
            return new Symbol(string2 == null ? null : string2.intern());
        }
        return Symbol.make(string3, string2);
    }

    Expression parseCheckNodeTest(int n) throws IOException, SyntaxException {
        Expression expression = this.parseNodeTest(n);
        if (expression != null && !this.focusDefined) {
            return this.syntaxError("node test when focus is undefined");
        }
        return expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Expression parseNodeTest(int n) throws IOException, SyntaxException {
        ApplyExp applyExp;
        Declaration declaration = this.parser.lookup("dot", -1);
        ReferenceExp referenceExp = new ReferenceExp("dot", declaration);
        int n2 = this.peekOperand();
        if (n2 == 70) {
            // empty if block
        }
        if (this.curToken == 64 && n < 0) {
            this.getRawToken();
            n = 2;
        }
        if (!(n >= 0 && n != 3 && n != 4 && n != 5 || this.curToken != 65 && this.curToken != 81 && this.curToken != 67 && this.curToken != 220 && this.curToken != 231 && this.curToken != 232)) {
            Expression[] expressionArray;
            NodeType nodeType;
            if (this.curToken == 231 || this.curToken == 232) {
                nodeType = this.curToken == 231 ? anyNodeTest : textNodeTest;
                if (this.getRawToken() != 41) {
                    return this.syntaxError("missing '()' after node test");
                }
            } else {
                expressionArray = this.parseNameTest(this.defaultElementNamespace);
                nodeType = new ElementType((Symbol)expressionArray);
            }
            expressionArray = new Expression[]{referenceExp, new QuoteExp(nodeType)};
            Expression expression = n == 4 ? funcNamedDescendants : (n == 5 ? funcNamedDescendantsOrSelf : funcNamedChildren);
            applyExp = new ApplyExp(expression, expressionArray);
        } else if (n == 2) {
            if (this.curToken != 65 && this.curToken != 81 && this.curToken != 67 && this.curToken != 220) return this.syntaxError("missing name or '*' after '@' or attribute::");
            Symbol symbol = this.parseNameTest("");
            Expression[] expressionArray = new Expression[]{referenceExp, new QuoteExp(symbol)};
            applyExp = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.xml.NamedAttributes", "namedAttributes"), expressionArray);
        } else {
            if (n < 0) return null;
            return this.syntaxError("unsupported axis '" + axisNames[n] + "::'");
        }
        this.getRawToken();
        return applyExp;
    }

    Expression parseRelativePathExpr() throws IOException, SyntaxException {
        Expression expression = this.parseStepExpr();
        boolean bl = this.focusDefined;
        this.focusDefined = true;
        while (this.curToken == 47 || this.curToken == 68) {
            Expression expression2;
            Expression[] expressionArray;
            boolean bl2 = this.curToken == 68;
            LambdaExp lambdaExp = new LambdaExp(1);
            Declaration declaration = lambdaExp.addDeclaration("dot");
            declaration.setFlag(262144);
            declaration.noteValue(null);
            this.parser.push(lambdaExp);
            this.getRawToken();
            lambdaExp.body = this.parseStepExpr();
            this.parser.pop(lambdaExp);
            boolean bl3 = false;
            if (lambdaExp.body instanceof ApplyExp) {
                expressionArray = (Expression[])lambdaExp.body;
                expression2 = expressionArray.getFunction();
                Expression[] expressionArray2 = expressionArray.getArgs();
                if (expression2 == funcNamedChildren && expressionArray2.length == 2 && expressionArray2[0] instanceof ReferenceExp && ((ReferenceExp)expressionArray2[0]).getBinding() == declaration) {
                    expressionArray2[0] = expression;
                    if (bl2) {
                        expression2 = funcNamedDescendants;
                    }
                    expression = new ApplyExp(expression2, expressionArray2);
                    bl3 = true;
                } else if (expression2 == funcValuesFilter && expressionArray2.length == 2 && expressionArray2[0] instanceof ApplyExp && bl2) {
                    ApplyExp applyExp = (ApplyExp)expressionArray2[0];
                    Expression[] expressionArray3 = applyExp.getArgs();
                    if (applyExp.getFunction() == funcNamedChildren && expressionArray3.length == 2 && ((ReferenceExp)expressionArray3[0]).getBinding() == declaration) {
                        applyExp.setFunction(funcNamedDescendants);
                    }
                }
            }
            if (bl3) continue;
            expressionArray = new Expression[]{lambdaExp, expression};
            expression2 = XQParser.makeFunctionExp("gnu.kawa.functions.ValuesMap", "valuesMap");
            expression = new ApplyExp(expression2, expressionArray);
        }
        this.focusDefined = bl;
        return expression;
    }

    Expression parseStepExpr() throws IOException, SyntaxException {
        int n = this.peekOperand() - 100;
        if (n >= 0 && n < 13) {
            this.getRawToken();
            return this.parseStepQualifiers(this.parseCheckNodeTest(n));
        }
        return this.parseOtherStepExpr();
    }

    Expression parseStepQualifiers(Expression expression) throws IOException, SyntaxException {
        boolean bl = this.focusDefined;
        this.focusDefined = true;
        while (this.curToken == 91) {
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(1);
            lambdaExp.setFile(this.getName());
            lambdaExp.setLine(n, n2);
            Declaration declaration = lambdaExp.addDeclaration("dot");
            this.parser.push(lambdaExp);
            declaration.noteValue(null);
            Expression expression2 = this.parseExpr();
            expression2.setFile(this.getName());
            expression2.setLine(n, n2);
            this.parser.pop(lambdaExp);
            lambdaExp.body = expression2;
            if (this.curToken != 93) {
                return this.syntaxError("missing ']'");
            }
            this.getRawToken();
            Expression[] expressionArray = new Expression[]{expression, lambdaExp};
            expression = new ApplyExp(funcValuesFilter, expressionArray);
        }
        this.focusDefined = bl;
        return expression;
    }

    Expression parseOtherStepExpr() throws IOException, SyntaxException {
        Expression expression = this.parsePrimaryExpr();
        expression = this.parseStepQualifiers(expression);
        return expression;
    }

    Expression parsePrimaryExpr() throws IOException, SyntaxException {
        Expression expression = this.parseMaybePrimaryExpr();
        if (expression == null) {
            return this.syntaxError("missing expression");
        }
        return expression;
    }

    void parseEntityOrCharRef() throws IOException, SyntaxException {
        int n = this.read();
        if (n == 35) {
            int n2;
            n = this.read();
            if (n == 120) {
                n2 = 16;
                n = this.read();
            } else {
                n2 = 10;
            }
            int n3 = 0;
            while (n >= 0) {
                char c = (char)n;
                int n4 = Character.digit(c, n2);
                if (n4 < 0 || n3 >= 0x8000000) break;
                n3 *= n2;
                n3 += n4;
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid character reference");
            } else {
                this.tokenBufferAppend(n3);
            }
        } else {
            int n5 = this.tokenBufferLength;
            while (n >= 0) {
                char c = (char)n;
                if (!XQParser.isNamePart(c)) break;
                this.tokenBufferAppend(c);
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid entity reference");
                return;
            }
            String string = new String(this.tokenBuffer, n5, this.tokenBufferLength - n5);
            this.tokenBufferLength = n5;
            this.appendNamedEntity(string);
        }
    }

    void parseContent(char c, Vector vector) throws IOException, SyntaxException {
        this.tokenBufferLength = 0;
        while (true) {
            Object object2;
            int n;
            if (((n = this.read()) < 0 || n == 123 || n == c) && this.tokenBufferLength > 0) {
                object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                vector.addElement(new QuoteExp(object2));
                this.tokenBufferLength = 0;
            }
            if (n < 0) {
                this.eofError("unexpected end-of-file");
            }
            if (n == 123) {
                n = this.read();
                if (n == 123) {
                    this.tokenBufferAppend(123);
                    continue;
                }
                this.unread(n);
                object2 = this.parseEnclosedExpr();
                if (c != '<') {
                    object2 = XQParser.stringValue((Expression)object2);
                }
                vector.addElement(object2);
                this.tokenBufferLength = 0;
                continue;
            }
            if (n == 125) {
                n = this.read();
                if (n == 125) {
                    this.tokenBufferAppend(125);
                    continue;
                }
                this.error("unexpected '}' in element content");
                this.unread(n);
                continue;
            }
            if (n == c) {
                if (c != '<') {
                    if (!this.checkNext(c)) break;
                    this.tokenBufferAppend(c);
                    continue;
                }
                if (this.checkNext('/')) break;
                this.getRawToken();
                vector.addElement(this.parseElementConstructor());
                this.tokenBufferLength = 0;
                continue;
            }
            if (n == 38) {
                this.parseEntityOrCharRef();
                continue;
            }
            this.tokenBufferAppend((char)n);
        }
    }

    Expression parseEnclosedExpr() throws IOException, SyntaxException {
        char c = this.pushNesting('{');
        this.peekNonSpace("unexpected end-of-file after '{'");
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        this.getRawToken();
        Expression expression = this.parseExpr();
        while (this.curToken != 125) {
            if (this.curToken == -1 || this.curToken == 41 || this.curToken == 93) {
                expression = this.syntaxError("missing '}'");
                break;
            }
            if (this.curToken != 44) {
                expression = this.syntaxError("missing '}' or ','");
            }
            this.getRawToken();
            expression = XQParser.makeExprSequence(expression, this.parseExpr());
        }
        expression.setFile(this.getName());
        expression.setLine(n, n2);
        this.popNesting(c);
        return expression;
    }

    public static Expression stringValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.StringValue", "string");
        return new ApplyExp(expression2, expressionArray);
    }

    public static Expression booleanValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.BooleanValue", "booleanValue");
        return new ApplyExp(expression2, expressionArray);
    }

    Expression parseNameSpec(String string, boolean bl) throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            Symbol symbol = this.curToken == 65 ? Symbol.make(string, string2) : this.parseNameTest(null);
            return new QuoteExp(bl ? AttributeConstructor.make(string2, symbol) : ElementConstructor.make(string2, symbol));
        }
        if (this.curToken == 123) {
            return this.parseEnclosedExpr();
        }
        return null;
    }

    Expression parseElementConstructor() throws IOException, SyntaxException {
        Object[] objectArray;
        Object object2;
        int n;
        int n2;
        Vector<Expression> vector = new Vector<Expression>();
        Expression expression = this.parseNameSpec(this.defaultElementNamespace, false);
        vector.addElement(expression);
        if (expression == null) {
            return this.syntaxError("missing NameSpec");
        }
        while ((n2 = this.skipSpace()) >= 0 && n2 != 62 && n2 != 47) {
            this.unread(n2);
            this.getRawToken();
            n = vector.size();
            object2 = this.parseNameSpec("", true);
            if (object2 == null) break;
            if (!(object2 instanceof QuoteExp) || !(((QuoteExp)object2).getValue() instanceof AttributeConstructor)) {
                vector.addElement((Expression)object2);
                object2 = XQParser.makeFunctionExp("gnu.xquery.util.MakeAttribute", "makeAttribute");
            }
            if ((n2 = this.skipSpace()) != 61) {
                return this.syntaxError("missing '=' after attribute");
            }
            n2 = this.skipSpace();
            if (n2 == 123) {
                vector.addElement(XQParser.stringValue(this.parseEnclosedExpr()));
            } else {
                this.parseContent((char)n2, vector);
            }
            objectArray = new Expression[vector.size() - n];
            int n3 = objectArray.length;
            while (--n3 >= 0) {
                objectArray[n3] = (Expression)vector.elementAt(n + n3);
            }
            vector.setSize(n);
            vector.addElement(new ApplyExp((Expression)object2, (Expression[])objectArray));
        }
        n = 0;
        if (n2 == 47) {
            n2 = this.read();
            if (n2 == 62) {
                n = 1;
            } else {
                this.unread(n2);
            }
        }
        if (n == 0) {
            if (n2 != 62) {
                return this.syntaxError("missing '>' after start element");
            }
            this.parseContent('<', vector);
            n2 = this.skipSpace();
            if (n2 >= 0 && n2 != 62) {
                String string;
                this.unread(n2);
                this.getRawToken();
                if (this.curToken != 65 && this.curToken != 81) {
                    return this.syntaxError("invalid tag syntax after '</'");
                }
                if (!(expression instanceof QuoteExp)) {
                    return this.syntaxError("'<{'expression'}>' must be closed by '</>'");
                }
                object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                Object object3 = ((QuoteExp)expression).getValue();
                String string2 = string = object3 instanceof ElementConstructor ? ((ElementConstructor)object3).getXmlName() : object3.toString();
                if (!((String)object2).equals(string)) {
                    return this.syntaxError("'<" + string + ">' closed by '</" + (String)object2 + ">'");
                }
                n2 = this.skipSpace();
            }
            if (n2 != 62) {
                return this.syntaxError("missing '>' after end element");
            }
        }
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.MakeElement", "makeElement"), (Expression[])objectArray);
    }

    Expression parseExprSequence(int n) throws IOException, SyntaxException {
        if (this.curToken == n || this.curToken == -1) {
            return QuoteExp.voidExp;
        }
        Expression expression = null;
        while (true) {
            Expression expression2 = this.parseExpr();
            Expression expression3 = expression = expression == null ? expression2 : XQParser.makeExprSequence(expression, expression2);
            if (this.curToken == n || this.curToken == -1) break;
            if (this.nesting == 0 && this.curToken == 10) {
                return expression;
            }
            if (this.curToken != 44) {
                return this.syntaxError("missing ')' - saw " + new String(this.tokenBuffer, 0, this.tokenBufferLength) + " @:" + this.getColumnNumber());
            }
            this.getRawToken();
        }
        return expression;
    }

    Expression parseTypeSwitch() throws IOException, SyntaxException {
        Object[] objectArray;
        Expression expression;
        char c = this.pushNesting('t');
        this.getRawToken();
        Expression expression2 = this.parseExpr();
        if (this.curToken != 41) {
            return this.syntaxError("missing ')' after 'typeswitch' selector");
        }
        this.getRawToken();
        Object object2 = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(expression2);
        if (this.match("as")) {
            this.getRawToken();
            if (this.curToken == 36) {
                this.getRawToken();
                if (this.curToken == 81 || this.curToken == 65) {
                    object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                }
            }
            if (object2 == null) {
                return this.syntaxError("missing Variable after 'as' clause");
            }
            this.getRawToken();
        }
        String string = object2 == null ? "$arg$" : object2.toString();
        while (this.match("case")) {
            Expression expression3;
            this.pushNesting('c');
            this.getRawToken();
            expression = this.parseDataType();
            this.popNesting('t');
            objectArray = new LambdaExp(1);
            Declaration declaration = objectArray.addDeclaration(string, (Type)((QuoteExp)expression).getValue());
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'case'");
            }
            this.parser.push((ScopeExp)objectArray);
            this.pushNesting('r');
            objectArray.body = expression3 = this.parseExpr();
            this.popNesting('t');
            this.parser.pop((ScopeExp)objectArray);
            vector.addElement(objectArray);
        }
        expression = new LambdaExp(0);
        if (this.match("default")) {
            this.getRawToken();
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'default'");
            }
            this.parser.push((ScopeExp)expression);
            expression.body = objectArray = this.parseExpr();
            this.parser.pop((ScopeExp)expression);
        } else {
            expression.body = QuoteExp.voidExp;
            this.error('w', "no 'default' clause in 'typeswitch'");
        }
        vector.addElement(expression);
        this.popNesting(c);
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.reflect.TypeSwitch", "typeSwitch"), (Expression[])objectArray);
    }

    char matchConstructorKeyword(int n) throws IOException, SyntaxException {
        if (this.curToken == 65) {
            int n2;
            if (this.match("element")) {
                n2 = 101;
            } else if (this.match("attribute")) {
                n2 = 97;
            } else if (this.match("document") && n == 123) {
                n2 = 100;
            } else if (this.match("text") && n == 123) {
                n2 = 116;
            } else {
                return '\u0000';
            }
            if (n2 == 101 || n2 == 97) {
                if (!XQParser.isNameStart((char)n)) {
                    return '\u0000';
                }
                this.mark();
                this.getRawToken();
                this.getRawToken();
                if (this.curToken != 123) {
                    n2 = 0;
                }
                this.reset();
            }
            return (char)n2;
        }
        return '\u0000';
    }

    Expression parseMaybePrimaryExpr() throws IOException, SyntaxException {
        Expression expression;
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        int n3 = this.peekOperand();
        if (n3 == 40) {
            this.getRawToken();
            char c = this.pushNesting('(');
            expression = this.parseExprSequence(41);
            this.popNesting(c);
            if (this.curToken == -1) {
                this.eofError("missing ')' - unexpected end-of-file");
            }
        } else if (n3 == 212) {
            --n2;
            this.getRawToken();
            if (this.curToken == 47) {
                this.getRawToken();
                String string = this.curToken == 65 || this.curToken == 81 || this.curToken == 67 ? "saw end tag '</" + new String(this.tokenBuffer, 0, this.tokenBufferLength) + ">' not in an element constructor" : "saw end tag '</' not in an element constructor";
                Expression expression2 = this.syntaxError(string);
                while (this.curToken != 213 && this.curToken != -1 && this.curToken != 10) {
                    this.getRawToken();
                }
                return expression2;
            }
            char c = this.pushNesting('<');
            expression = this.parseElementConstructor();
            expression.setFile(this.getName());
            expression.setLine(n, n2);
            this.popNesting(c);
        } else if (n3 == 34) {
            expression = new QuoteExp(new String(this.tokenBuffer, 0, this.tokenBufferLength));
        } else if (n3 == 48) {
            IntNum intNum = IntNum.valueOf(this.tokenBuffer, 0, this.tokenBufferLength, 10, false);
            expression = new QuoteExp(intNum);
        } else if (n3 == 49) {
            DFloNum dFloNum = new DFloNum(new String(this.tokenBuffer, 0, this.tokenBufferLength));
            expression = new QuoteExp(dFloNum);
        } else if (n3 == 36) {
            int n4 = this.peek();
            if (n4 < 0 || Character.isWhitespace((char)n4)) {
                return this.syntaxError("missing name after variable-name operator '$'");
            }
            this.getRawToken();
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
            Declaration declaration = this.parser.lookup(string, -1);
            expression = null;
            if (declaration == null) {
                if (string == "request") {
                    expression = XQParser.makeFunctionExp("gnu.kawa.servlet.GetRequest", "getRequest");
                }
                if (string == "response") {
                    expression = XQParser.makeFunctionExp("gnu.kawa.servlet.GetResponse", "getResponse");
                }
                if (expression != null) {
                    expression = new ApplyExp(expression, Expression.noExpressions);
                }
            }
            if (expression == null) {
                expression = new ReferenceExp(string, declaration);
            }
        } else if (n3 == 70) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string;
            int n5 = this.tokenBufferLength;
            while (--n5 >= 0 && this.tokenBuffer[n5] != ':') {
            }
            if (n5 >= 0) {
                string = new String(this.tokenBuffer, 0, n5);
                object5 = new String(this.tokenBuffer, ++n5, this.tokenBufferLength - n5);
                object4 = (String)this.namespaces.get(string);
                if (object4 == null) {
                    try {
                        object3 = Class.forName(string);
                        object4 = "class:" + string;
                    }
                    catch (Exception exception) {
                        this.syntaxError("unknown namespace '" + string + "'");
                        object2 = new Symbol(((String)object5).intern());
                    }
                }
                object2 = Symbol.make(object4, (String)object5);
            } else {
                string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                if (string.equals("typeswitch")) {
                    return this.parseTypeSwitch();
                }
                object2 = this.defaultFunctionNamespace == "" ? string.intern() : Symbol.make(this.defaultFunctionNamespace, string);
            }
            n2 -= this.tokenBufferLength;
            char c = this.pushNesting('(');
            this.getRawToken();
            object5 = new Vector(10);
            if (this.curToken != 41) {
                while (true) {
                    object4 = this.parseExpr();
                    ((Vector)object5).addElement(object4);
                    if (this.curToken == 41) break;
                    if (this.curToken != 44) {
                        return this.syntaxError("missing ')' after function call");
                    }
                    this.getRawToken();
                }
            }
            object4 = new Expression[((Vector)object5).size()];
            ((Vector)object5).copyInto((Object[])object4);
            object3 = new ReferenceExp(object2, null);
            ((ReferenceExp)object3).setProcedureName(true);
            expression = new ApplyExp((Expression)object3, (Expression[])object4);
            expression.setFile(this.getName());
            expression.setLine(n, n2);
            this.popNesting(c);
        } else {
            if (n3 == 65 || n3 == 81) {
                int n6;
                int n7 = n6 = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
                if (n6 == 36) {
                    int n8 = -1;
                    if (this.tokenBufferLength == 3) {
                        char c = this.tokenBuffer[0];
                        char c2 = this.tokenBuffer[1];
                        char c3 = this.tokenBuffer[2];
                        if (c == 'l' && c2 == 'e' && c3 == 't') {
                            n8 = 0;
                        } else if (c == 'f' && c2 == 'o' && c3 == 'r') {
                            n8 = 1;
                        }
                    }
                    if (n8 < 0) {
                        throw new Error("invalid syntax - variable following name");
                    }
                    Expression expression3 = this.parseFLWRExpression(n8 > 0);
                    expression3.setFile(this.getName());
                    expression3.setLine(n, n2 - 3);
                    return expression3;
                }
                char c = this.matchConstructorKeyword(n6);
                if (c != '\u0000') {
                    Expression expression4;
                    if (n6 >= 0) {
                        this.unread();
                    }
                    this.getRawToken();
                    Vector<Expression> vector = new Vector<Expression>();
                    if (c == 'e' || c == 'a') {
                        Expression expression5 = this.parseNameSpec(this.defaultElementNamespace, c == 'a');
                        if (expression5 == null) {
                            return this.syntaxError("missing element/attribute name");
                        }
                        vector.addElement(expression5);
                        expression4 = c == 'e' ? XQParser.makeFunctionExp("gnu.xquery.util.MakeElement", "makeElement") : XQParser.makeFunctionExp("gnu.xquery.util.MakeAttribute", "makeAttribute");
                        this.getRawToken();
                    } else {
                        expression4 = c == 'd' ? XQParser.makeFunctionExp("gnu.kawa.xml.DocumentConstructor", "documentConstructor") : XQParser.makeFunctionExp("gnu.kawa.xml.TextConstructor", "textConstructor");
                    }
                    char c4 = this.pushNesting('{');
                    this.peekNonSpace("unexpected end-of-file after '{'");
                    if (this.curToken != 123) {
                        return this.syntaxError("missing '{'");
                    }
                    this.getRawToken();
                    if (this.curToken != 125) {
                        vector.addElement(this.parseExpr());
                        while (this.curToken == 44) {
                            this.getRawToken();
                            vector.addElement(this.parseExpr());
                        }
                    }
                    this.popNesting(c4);
                    if (this.curToken != 125) {
                        return this.syntaxError("missing '}'");
                    }
                    Object[] objectArray = new Expression[vector.size()];
                    vector.copyInto(objectArray);
                    ApplyExp applyExp = new ApplyExp(expression4, (Expression[])objectArray);
                    applyExp.setFile(this.getName());
                    applyExp.setLine(n, n2);
                    this.getRawToken();
                    return applyExp;
                }
                if (n6 == 40 && this.tokenBufferLength == 2 && this.tokenBuffer[0] == 'i' && this.tokenBuffer[1] == 'f') {
                    return this.parseIfExpr();
                }
                if (n6 >= 0) {
                    this.unread();
                }
                return this.parseCheckNodeTest(-1);
            }
            if (n3 == 220 || n3 == 67 || n3 == 64 || n3 == 231 || n3 == 232) {
                return this.parseCheckNodeTest(-1);
            }
            return null;
        }
        this.getRawToken();
        return expression;
    }

    public Expression parseIfExpr() throws IOException, SyntaxException {
        this.getRawToken();
        char c = this.pushNesting('i');
        Expression expression = this.parseExpr();
        if (this.curToken != 41) {
            return this.syntaxError("missing ')' after 'if (EXPR'");
        }
        this.getRawToken();
        if (this.curToken != 65 || this.tokenBufferLength != 4 || !new String(this.tokenBuffer, 0, 4).equalsIgnoreCase("then")) {
            this.syntaxError("missing 'then'");
        } else {
            this.getRawToken();
        }
        Expression expression2 = this.parseExpr();
        if (this.curToken != 65 || this.tokenBufferLength != 4 || !new String(this.tokenBuffer, 0, 4).equalsIgnoreCase("else")) {
            this.syntaxError("missing 'else'");
        } else {
            this.getRawToken();
        }
        this.popNesting(c);
        Expression expression3 = this.parseExpr();
        return new IfExp(XQParser.booleanValue(expression), expression2, expression3);
    }

    public boolean match(String string) {
        if (this.curToken != 65) {
            return false;
        }
        int n = string.length();
        if (this.tokenBufferLength != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = this.tokenBuffer[n2])) continue;
            return false;
        }
        return true;
    }

    public Expression parseFLWRExpression(boolean bl, String string, Expression expression) throws IOException, SyntaxException {
        Expression expression2;
        ScopeExp scopeExp;
        Object object2;
        Expression[] expressionArray = new Expression[]{expression};
        if (bl) {
            object2 = new LambdaExp(1);
            scopeExp = object2;
        } else {
            object2 = new LetExp(expressionArray);
            scopeExp = object2;
        }
        object2 = scopeExp.addDeclaration(string);
        if (bl) {
            ((Declaration)object2).noteValue(null);
            ((Declaration)object2).setFlag(262144);
        }
        this.parser.push(scopeExp);
        if (this.curToken == 44) {
            int n = this.skipSpaceOrComment();
            if (n != 36) {
                return this.syntaxError("missing $NAME after ','");
            }
            expression2 = this.parseFLWRExpression(bl);
        } else {
            Expression expression3;
            char c = this.pushNesting('w');
            if (this.curToken == 196) {
                this.getRawToken();
                expression3 = this.parseBinaryExpr(XQParser.priority(200));
            } else {
                expression3 = this.match("where") ? this.parseBinaryExpr(XQParser.priority(200)) : null;
            }
            this.popNesting(c);
            boolean bl2 = this.match("return");
            if (!(bl2 || this.match("let") || this.match("for"))) {
                return this.syntaxError("missing 'return' clause");
            }
            this.peekNonSpace("unexpected eof-of-file after 'return'");
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl2) {
                this.getRawToken();
            }
            expression2 = this.parseExpr();
            if (expression3 != null) {
                expression2 = new IfExp(XQParser.booleanValue(expression3), expression2, QuoteExp.voidExp);
            }
            expression2.setFile(this.getName());
            expression2.setLine(n, n2);
        }
        this.parser.pop(scopeExp);
        if (bl) {
            ((LambdaExp)scopeExp).body = expression2;
            Expression[] expressionArray2 = new Expression[]{scopeExp, expressionArray[0]};
            return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.functions.ValuesMap", "valuesMap"), expressionArray2);
        }
        ((LetExp)scopeExp).setBody(expression2);
        return scopeExp;
    }

    public Expression parseFLWRExpression(boolean bl) throws IOException, SyntaxException {
        char c = this.pushNesting(bl ? (char)'f' : 'l');
        this.getRawToken();
        if (this.curToken != 81 && this.curToken != 65) {
            return this.syntaxError("missing Variable token:" + this.curToken);
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
        this.getRawToken();
        if (bl) {
            if (this.match("in")) {
                this.getRawToken();
            } else {
                if (this.curToken == 76) {
                    this.getRawToken();
                }
                this.syntaxError("missing 'in' in 'for' clause");
            }
        } else if (this.curToken == 76) {
            this.getRawToken();
        } else {
            if (this.match("in")) {
                this.getRawToken();
            }
            this.syntaxError("missing ':=' in 'let' clause");
        }
        Expression expression = this.parseBinaryExpr(XQParser.priority(200));
        this.popNesting(c);
        return this.parseFLWRExpression(bl, string, expression);
    }

    public Expression parseFunctionDefinition(int n, int n2) throws IOException, SyntaxException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.curToken == 81) {
            int n3 = this.tokenBufferLength;
            while (this.tokenBuffer[--n3] != ':') {
            }
            object5 = new String(this.tokenBuffer, 0, n3);
            object4 = new String(this.tokenBuffer, ++n3, this.tokenBufferLength - n3);
            object3 = (String)this.namespaces.get(object5);
            if (object3 == null) {
                this.syntaxError("unknown namespace '" + (String)object5 + "'");
            }
            object2 = Symbol.make(object3, (String)object4);
        } else if (this.curToken == 65) {
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            object2 = this.defaultFunctionNamespace == "" ? string.intern() : Symbol.make(this.defaultFunctionNamespace, string);
        } else {
            return this.syntaxError("missing function name");
        }
        this.getRawToken();
        if (this.curToken != 40) {
            return this.syntaxError("missing parameter list:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp();
        lambdaExp.setFile(this.getName());
        lambdaExp.setLine(n, n2);
        lambdaExp.setName(object2);
        object5 = this.parser.currentScope().addDeclaration(object2);
        this.parser.push((Declaration)object5);
        ((Declaration)object5).setCanRead(true);
        ((Declaration)object5).setProcedureDecl(true);
        ((Declaration)object5).setFile(this.getName());
        ((Declaration)object5).setLine(n, n2);
        this.parser.push(lambdaExp);
        if (this.curToken != 41) {
            while (true) {
                if (this.curToken != 36) {
                    this.error("missing '$' before parameter name");
                } else {
                    this.getRawToken();
                }
                if (this.curToken == 81 || this.curToken == 65) {
                    object4 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                    object3 = lambdaExp.addDeclaration(object4);
                    this.parser.push((Declaration)object3);
                    this.getRawToken();
                    ++lambdaExp.min_args;
                    ++lambdaExp.max_args;
                    Expression expression = this.parseOptionalTypeDeclaration();
                    if (expression instanceof QuoteExp) {
                        ((Declaration)object3).setType((Type)((QuoteExp)expression).getValue());
                    } else if (expression != null) {
                        this.error('w', "parameter type too complex");
                    }
                } else {
                    this.error("missing parameter name");
                }
                if (this.curToken == 41) break;
                if (this.curToken != 44) {
                    return this.syntaxError("missing ',' in parameter list");
                }
                this.getRawToken();
            }
        }
        this.getRawToken();
        this.focusDefined = false;
        lambdaExp.body = this.parseEnclosedExpr();
        this.focusDefined = true;
        this.parser.pop(lambdaExp);
        object4 = new SetExp(object2, (Expression)lambdaExp);
        ((SetExp)object4).setDefining(true);
        ((SetExp)object4).binding = object5;
        ((Declaration)object5).noteValue(lambdaExp);
        return object4;
    }

    public Object readObject() throws IOException, SyntaxException {
        return this.parse(null);
    }

    public Expression parse(Compilation compilation) throws IOException, SyntaxException {
        int n;
        this.parser = compilation;
        int n2 = this.skipSpace();
        if (n2 < 0) {
            return null;
        }
        this.unread(n2);
        int n3 = this.getLineNumber() + 1;
        int n4 = this.getColumnNumber() + 1;
        if (n2 == 35 && n3 == 1 && n4 == 1) {
            this.read();
            n2 = this.read();
            if (n2 != 33 || (n2 = this.read()) != 47) {
                this.error("'#' is only allowed in initial '#!/PROGRAM'");
            }
            while (n2 != 13 && n2 != 10 && n2 >= 0) {
                n2 = this.read();
            }
        }
        if (this.getRawToken() == -1) {
            return null;
        }
        this.peekOperand();
        if (this.curToken == 80) {
            int n5 = this.getLineNumber() + 1;
            int n6 = this.getColumnNumber() + 1;
            this.getRawToken();
            this.peekNonSpace("unexpected end-of-file after 'define function'");
            char c = this.pushNesting('d');
            Expression expression = this.parseFunctionDefinition(n5, n6);
            this.popNesting(c);
            expression.setFile(this.getName());
            expression.setLine(n3, n4);
            return expression;
        }
        if (this.curToken == 86) {
            this.getRawToken();
            if (this.curToken == 36) {
                this.getRawToken();
            } else {
                this.syntaxError("missing '$'");
            }
            if (this.curToken != 81 && this.curToken != 65) {
                return this.syntaxError("missing Variable");
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
            this.getRawToken();
            Expression expression = this.parseOptionalTypeDeclaration();
            Declaration declaration = compilation.currentScope().addDeclaration(string);
            compilation.push(declaration);
            Expression expression2 = null;
            if (this.curToken == 123) {
                expression2 = this.parseEnclosedExpr();
            } else if (this.match("external")) {
                this.error("external variables not implemented yet");
            } else {
                this.error('e', "expected {expression} or external");
                if (this.curToken == 208 || this.curToken == 76) {
                    this.getRawToken();
                }
                expression2 = this.parseMaybePrimaryExpr();
            }
            SetExp setExp = new SetExp(declaration, expression2);
            setExp.setDefining(true);
            declaration.noteValue(expression2);
            return setExp;
        }
        if (this.curToken == 65 && "namespace".equals((String)this.curValue)) {
            this.error('w', "use 'declare namespace' instead of 'namespace'");
            this.curToken = 77;
        }
        if (this.curToken == 77) {
            int n7 = n = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
            if (n >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n)) {
                    this.getRawToken();
                    if (this.curToken != 65) {
                        return this.syntaxError("confused after seeing 'declare namespace'");
                    }
                    String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.getRawToken();
                    if (this.curToken != 208) {
                        return this.syntaxError("missing '=' in namespace declaration");
                    }
                    this.getRawToken();
                    if (this.curToken != 34) {
                        return this.syntaxError("missing uri namespace declaration");
                    }
                    String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.namespaces.put(string, string2);
                    return QuoteExp.voidExp;
                }
            }
        }
        if (this.curToken == 78 || this.curToken == 79 || this.curToken == 65 && "default".equals((String)this.curValue)) {
            int n8 = n = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
            if (n >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n)) {
                    boolean bl;
                    boolean bl2 = bl = this.curToken == 79;
                    if (this.curToken == 65) {
                        this.error('w', "use 'default element namespace' instead of 'default namespace'");
                    }
                    this.getRawToken();
                    this.curValue = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    if (this.curToken != 65 || !"namespace".equalsIgnoreCase((String)this.curValue)) {
                        return this.syntaxError("expected 'namespace' after 'default'");
                    }
                    this.getRawToken();
                    if (this.curToken != 208) {
                        return this.syntaxError("missing '=' in namespace declaration");
                    }
                    this.getRawToken();
                    if (this.curToken != 34) {
                        return this.syntaxError("missing uri namespace declaration");
                    }
                    String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    if (bl) {
                        this.error('w', "'declare function namespace' not implemented - ignored");
                        this.defaultFunctionNamespace = string.toString();
                    } else {
                        this.defaultElementNamespace = string.toString();
                    }
                    return QuoteExp.voidExp;
                }
            }
        }
        Expression expression = this.parseExprSequence(-1);
        if (this.curToken == 10) {
            this.unread(10);
        }
        expression.setFile(this.getName());
        expression.setLine(n3, n4);
        return expression;
    }

    public static Expression makeFunctionExp(String string, String string2) {
        return XQParser.makeFunctionExp(string, Compilation.mangleNameIfNeeded(string2), string2);
    }

    public static Expression makeFunctionExp(String string, String string2, String string3) {
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            Procedure procedure = (Procedure)field.get(null);
            ClassType classType = ClassType.make(string);
            gnu.bytecode.Field field2 = classType.getDeclaredField(string2);
            Declaration declaration = new Declaration((Object)string3, field2);
            declaration.noteValue(new QuoteExp(procedure));
            declaration.setFlag(16384);
            return new ReferenceExp(string3, declaration);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    public void error(String string) {
        super.error(string);
    }

    public Expression syntaxError(String string) throws IOException, SyntaxException {
        return this.syntaxError(string, this.tokenWidth());
    }

    private int tokenWidth() {
        switch (this.curToken) {
            case -1: {
                return 0;
            }
            case 48: 
            case 49: 
            case 65: 
            case 81: {
                return this.tokenBufferLength;
            }
        }
        return 1;
    }

    public Expression syntaxError(String string, int n) throws IOException, SyntaxException {
        int n2 = this.port.getLineNumber();
        int n3 = this.port.getColumnNumber();
        this.error('e', this.port.getName(), n2 + 1, n3 < 0 ? 0 : n3 + 1 - n, string);
        if (this.interactive) {
            int n4;
            this.curToken = 0;
            this.curValue = null;
            this.nesting = 0;
            ((InPort)this.getPort()).readState = (char)10;
            while ((n4 = this.read()) >= 0) {
                if (n4 != 13 && n4 != 10) continue;
                this.unread(n4);
                break;
            }
            throw new SyntaxException(this.getMessages());
        }
        return new ErrorExp(string);
    }

    static {
        XQParser.axisNames[0] = "ancestor";
        XQParser.axisNames[1] = "ancestor-or-self";
        XQParser.axisNames[2] = "attribute";
        XQParser.axisNames[3] = "child";
        XQParser.axisNames[4] = "descendant";
        XQParser.axisNames[5] = "descendant-or-self";
        XQParser.axisNames[6] = "following";
        XQParser.axisNames[7] = "following-sibling";
        XQParser.axisNames[8] = "namespace";
        XQParser.axisNames[9] = "parent";
        XQParser.axisNames[10] = "preceding";
        XQParser.axisNames[11] = "preceding-sibling";
        XQParser.axisNames[12] = "self";
        funcNamedChildren = XQParser.makeFunctionExp("gnu.kawa.xml.NamedChildren", "namedChildren");
        funcNamedDescendants = XQParser.makeFunctionExp("gnu.kawa.xml.NamedDescendants", "namedDescendants");
        funcNamedDescendantsOrSelf = XQParser.makeFunctionExp("gnu.kawa.xml.NamedDescendants", "namedDescendantsOrSelf");
        funcValuesFilter = XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "valuesFilter");
        textNodeTest = new NodeType("text", 1);
        anyNodeTest = new NodeType("node");
    }
}

