/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.ModuleContext;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleManager;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.FieldLocation;
import gnu.mapping.Location;
import gnu.mapping.WrappedException;
import gnu.text.URI_utils;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

public class ModuleInfo {
    ModuleInfo next;
    public String className;
    public Class moduleClass;
    String uri;
    ModuleExp exp;
    Compilation comp;
    ModuleInfo[] dependencies;
    int numDependencies;
    public String sourcePath;
    public String sourceAbsPath;
    public long lastCheckedTime;
    public long lastModifiedTime;

    public ModuleInfo nextModule() {
        return this.next;
    }

    public String getNamespaceUri() {
        return this.uri;
    }

    public void setNamespaceUri(String uri) {
        this.uri = uri;
    }

    public Compilation getCompilation() {
        return this.comp;
    }

    public void setCompilation(Compilation comp) {
        ModuleExp mod;
        comp.minfo = this;
        this.comp = comp;
        this.exp = mod = comp.mainLambda;
        if (mod != null) {
            String fileName;
            this.sourcePath = fileName = mod.getFileName();
            this.sourceAbsPath = ModuleInfo.absPath(fileName);
        }
    }

    public static String absPath(String path) {
        Serializable url;
        try {
            url = URI_utils.toURL(path);
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
        try {
            url = URI_utils.toURI(url).normalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ((Object)url).toString();
    }

    public synchronized void addDependency(ModuleInfo dep) {
        if (this.dependencies == null) {
            this.dependencies = new ModuleInfo[8];
        } else if (this.numDependencies == this.dependencies.length) {
            ModuleInfo[] deps = new ModuleInfo[2 * this.numDependencies];
            System.arraycopy(this.dependencies, 0, deps, 0, this.numDependencies);
            this.dependencies = deps;
        }
        this.dependencies[this.numDependencies++] = dep;
    }

    public ClassType getClassType() {
        if (this.moduleClass != null) {
            return (ClassType)Type.make(this.moduleClass);
        }
        if (this.comp != null && this.comp.mainClass != null) {
            return this.comp.mainClass;
        }
        return ClassType.make(this.className);
    }

    public synchronized ModuleExp getModuleExp() {
        ModuleExp m = this.exp;
        if (m == null) {
            if (this.comp != null) {
                return this.comp.mainLambda;
            }
            ClassType ctype = ClassType.make(this.className);
            m = new ModuleExp();
            m.type = ctype;
            m.setName(ctype.getName());
            m.flags |= 0x20000;
            m.info = this;
            this.exp = m;
        }
        return m;
    }

    public synchronized ModuleExp setupModuleExp() {
        ClassType type;
        Class rclass;
        ModuleExp mod = this.getModuleExp();
        if ((mod.flags & 0x20000) == 0) {
            return mod;
        }
        mod.setFlag(false, 131072);
        if (this.moduleClass != null) {
            rclass = this.moduleClass;
            type = (ClassType)Type.make(rclass);
        } else {
            type = ClassType.make(this.className);
            rclass = type.getReflectClass();
        }
        Object instance = null;
        Language language = Language.getDefaultLanguage();
        for (Field fld = type.getFields(); fld != null; fld = fld.getNext()) {
            int flags = fld.getFlags();
            if ((flags & 1) == 0) continue;
            try {
                if ((flags & 8) == 0 && instance == null) {
                    instance = this.getInstance();
                }
                Object fvalue = rclass.getField(fld.getName()).get(instance);
                Declaration fdecl = language.declFromField(mod, fvalue, fld);
                if ((flags & 0x10) != 0 && (!(fvalue instanceof Location) || fvalue instanceof FieldLocation)) {
                    fdecl.noteValue(new QuoteExp(fvalue));
                    continue;
                }
                fdecl.noteValue(null);
                continue;
            }
            catch (Exception ex) {
                throw new WrappedException(ex);
            }
        }
        for (Declaration fdecl = mod.firstDecl(); fdecl != null; fdecl = fdecl.nextDecl()) {
            ModuleInfo.makeDeclInModule2(mod, fdecl);
        }
        return mod;
    }

    public Class getModuleClass() throws ClassNotFoundException {
        Class<?> mclass = this.moduleClass;
        if (mclass != null) {
            return mclass;
        }
        this.moduleClass = mclass = Class.forName(this.className);
        return mclass;
    }

    public static ModuleInfo findFromInstance(Object instance) {
        return ModuleContext.getContext().findFromInstance(instance);
    }

    public static ModuleInfo find(String className) {
        return ModuleManager.getInstance().findWithClassName(className);
    }

    public static ModuleInfo find(Type type) {
        ModuleInfo info = ModuleManager.getInstance().findWithClassName(type.getName());
        if (type instanceof ObjectType && ((ObjectType)type).isExisting()) {
            try {
                info.moduleClass = type.getReflectClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return info;
    }

    public static void register(Object instance) {
        ModuleInfo info = ModuleInfo.find(instance.getClass().getName());
        ModuleContext.getContext().setInstance(info, instance);
    }

    public Object getInstance() {
        return ModuleContext.getContext().findInstance(this);
    }

    public Object getRunInstance() {
        Object inst = this.getInstance();
        if (inst instanceof Runnable) {
            ((Runnable)inst).run();
        }
        return inst;
    }

    static void makeDeclInModule2(ModuleExp mod, Declaration fdecl) {
        Object fvalue = fdecl.getConstantValue();
        if (fvalue instanceof FieldLocation) {
            FieldLocation floc = (FieldLocation)fvalue;
            Declaration vdecl = floc.getDeclaration();
            ReferenceExp fref = new ReferenceExp(vdecl);
            fdecl.setAlias(true);
            fref.setDontDereference(true);
            fref.setFlag(8);
            fdecl.setValue(fref);
            if (vdecl.isProcedureDecl()) {
                fdecl.setProcedureDecl(true);
            }
            if (vdecl.getFlag(32768)) {
                fdecl.setSyntax();
            }
            if (!fdecl.getFlag(2048)) {
                ClassType vtype = floc.getDeclaringClass();
                String vname = vtype.getName();
                for (Declaration xdecl = mod.firstDecl(); xdecl != null; xdecl = xdecl.nextDecl()) {
                    if (!vname.equals(xdecl.getType().getName()) || !xdecl.getFlag(0x40000000)) continue;
                    fref.setContextDecl(xdecl);
                    break;
                }
            }
        }
    }

    public int getState() {
        return this.comp == null ? 14 : this.comp.getState();
    }

    public void loadByStages(int wantedState) {
        int state = this.getState();
        if (state + 1 >= wantedState) {
            return;
        }
        this.loadByStages(wantedState - 2);
        state = this.getState();
        if (state >= wantedState) {
            return;
        }
        this.comp.setState(state + 1);
        int ndeps = this.numDependencies;
        for (int idep = 0; idep < ndeps; ++idep) {
            ModuleInfo dep = this.dependencies[idep];
            dep.loadByStages(wantedState);
        }
        state = this.getState();
        if (state >= wantedState) {
            return;
        }
        this.comp.setState(state & 0xFFFFFFFE);
        this.comp.process(wantedState);
    }

    public boolean loadEager(int wantedState) {
        if (this.comp == null && this.className != null) {
            return false;
        }
        int state = this.getState();
        if (state >= wantedState) {
            return true;
        }
        if ((state & 1) != 0) {
            return false;
        }
        this.comp.setState(state + 1);
        int ndeps = this.numDependencies;
        for (int idep = 0; idep < ndeps; ++idep) {
            ModuleInfo dep = this.dependencies[idep];
            if (dep.loadEager(wantedState)) continue;
            if (this.getState() == state + 1) {
                this.comp.setState(state);
            }
            return false;
        }
        if (this.getState() == state + 1) {
            this.comp.setState(state);
        }
        this.comp.process(wantedState);
        return this.getState() == wantedState;
    }

    public void clearClass() {
        this.moduleClass = null;
        this.numDependencies = 0;
        this.dependencies = null;
    }

    public boolean checkCurrent(ModuleManager manager, long now) {
        if (this.lastCheckedTime + manager.lastModifiedCacheTime >= now) {
            return true;
        }
        this.lastCheckedTime = now;
        long lastModifiedTime = URI_utils.lastModified(this.sourceAbsPath);
        if (this.moduleClass == null && this.className != null) {
            try {
                this.moduleClass = Class.forName(this.className, false, manager.defaultClassLoader);
            }
            catch (ClassNotFoundException ex) {
                this.lastModifiedTime = lastModifiedTime;
                return false;
            }
        }
        if (this.lastModifiedTime == 0L && this.moduleClass != null) {
            URL resource;
            String classFilename = this.className;
            int dot = classFilename.lastIndexOf(46);
            if (dot >= 0) {
                classFilename = classFilename.substring(dot + 1);
            }
            if ((resource = this.moduleClass.getResource(classFilename = classFilename + ".class")) != null) {
                try {
                    this.lastModifiedTime = resource.openConnection().getLastModified();
                }
                catch (IOException ex) {
                    resource = null;
                }
            }
            if (resource == null) {
                this.lastModifiedTime = lastModifiedTime;
                return true;
            }
        }
        if (this.className == null || lastModifiedTime > this.lastModifiedTime) {
            this.moduleClass = null;
            this.lastModifiedTime = lastModifiedTime;
            return false;
        }
        int i = this.numDependencies;
        while (--i >= 0) {
            ModuleInfo dep = this.dependencies[i];
            if (dep.checkCurrent(manager, now)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("ModuleInfo[");
        if (this.moduleClass != null) {
            sbuf.append("class: ");
            sbuf.append(this.moduleClass);
        } else if (this.className != null) {
            sbuf.append("class-name: ");
            sbuf.append(this.className);
        }
        sbuf.append(']');
        return sbuf.toString();
    }
}

