/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.AccessExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.UnboundLocationException;
import gnu.mapping.WrappedException;

public class ReferenceExp
extends AccessExp {
    static int counter;
    int id = ++counter;
    public static final int DONT_DEREFERENCE = 1;
    public static final int PROCEDURE_NAME = 2;
    public static final int PREFER_BINDING2 = 4;
    public static final int CREATE_FIELD_REFERENCE = 8;

    public final boolean getDontDereference() {
        return (this.flags & 1) != 0;
    }

    public final void setDontDereference(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean isProcedureName() {
        return (this.flags & 2) != 0;
    }

    public final void setProcedureName(boolean bl) {
        this.setFlag(bl, 2);
    }

    public ReferenceExp(Object object2) {
        this.symbol = object2;
    }

    public ReferenceExp(Object object2, Declaration declaration) {
        this.symbol = object2;
        this.binding = declaration;
    }

    public ReferenceExp(Declaration declaration) {
        this(declaration.getSymbol(), declaration);
    }

    public Object eval(Environment environment) {
        Object object2;
        if (this.binding != null) {
            if (this.binding.value instanceof QuoteExp && this.binding.value != QuoteExp.undefined_exp && (!this.getDontDereference() || this.binding.isIndirectBinding())) {
                Object object3 = this.binding.getConstantValue();
                if (this.binding.isIndirectBinding()) {
                    return ((Location)object3).get();
                }
                return object3;
            }
            if (this.binding.field != null && this.binding.field.getStaticFlag() && (!this.getDontDereference() || this.binding.isIndirectBinding())) {
                try {
                    Object object4 = this.binding.field.getReflectField().get(null);
                    if (this.binding.isIndirectBinding()) {
                        return ((Location)object4).get();
                    }
                    return object4;
                }
                catch (Exception exception) {
                    throw WrappedException.wrapIfNeeded(exception);
                }
            }
            if (!(this.binding.context instanceof ModuleExp) || this.binding.isPrivate()) {
                throw new Error("internal error: ReferenceExp.eval on lexical binding");
            }
        }
        Symbol symbol = this.symbol instanceof Symbol ? (Symbol)this.symbol : environment.getSymbol(this.symbol.toString());
        Object object5 = object2 = this.getFlag(4) && this.isProcedureName() ? EnvironmentKey.FUNCTION : null;
        if (this.getDontDereference()) {
            return environment.getLocation(symbol, object2);
        }
        String string = Location.UNBOUND;
        Object object6 = environment.get(symbol, object2, string);
        if (object6 == string) {
            throw new UnboundLocationException(symbol);
        }
        return object6;
    }

    public void compile(Compilation compilation, Target target) {
        this.binding.load(this.contextDecl(), this.flags, compilation, target);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkReferenceExp(this);
    }

    public void print(OutPort outPort) {
        outPort.print("(Ref/");
        outPort.print(this.id);
        if (this.symbol != null && (this.binding == null || this.symbol.toString() != this.binding.getName())) {
            outPort.print('/');
            outPort.print(this.symbol);
        }
        if (this.binding != null) {
            outPort.print('/');
            outPort.print(this.binding);
        }
        outPort.print(")");
    }

    public Type getType() {
        return this.binding == null || this.binding.isFluid() ? Type.pointer_type : (this.getDontDereference() ? Compilation.typeLocation : Declaration.followAliases(this.binding).getType());
    }

    public String toString() {
        return "RefExp/" + this.symbol + '/' + this.id + '/';
    }
}

