/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Language;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.lispexpr.ReaderDispatch;
import gnu.kawa.lispexpr.ReaderIgnoreRestOfLine;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.kawa.lispexpr.ReaderQuote;
import gnu.kawa.lispexpr.ReaderString;
import gnu.kawa.lispexpr.ReaderTypespec;
import gnu.kawa.util.RangeTable;
import gnu.mapping.ThreadLocation;

public class ReadTable
extends RangeTable {
    public static final int ILLEGAL = 0;
    public static final int WHITESPACE = 1;
    public static final int CONSTITUENT = 2;
    public static final int SINGLE_ESCAPE = 3;
    public static final int MULTIPLE_ESCAPE = 4;
    public static final int TERMINATING_MACRO = 5;
    public static final int NON_TERMINATING_MACRO = 6;
    public static int defaultBracketMode = -1;
    static final ThreadLocation current = new ThreadLocation("read-table");

    public static ReadTable getInitial() {
        ReadTable readTable = new ReadTable();
        ReadTableEntry readTableEntry = ReadTableEntry.getWhitespaceInstance();
        readTable.set(32, readTableEntry);
        readTable.set(9, readTableEntry);
        readTable.set(10, readTableEntry);
        readTable.set(13, readTableEntry);
        readTable.set(12, readTableEntry);
        readTable.set(124, ReadTableEntry.getMultipleEscapeInstance());
        readTable.set(92, ReadTableEntry.getSingleEscapeInstance());
        readTable.set(48, 57, ReadTableEntry.getDigitInstance());
        readTableEntry = ReadTableEntry.getConstituentInstance();
        readTable.set(97, 122, readTableEntry);
        readTable.set(65, 90, readTableEntry);
        readTable.set(33, readTableEntry);
        readTable.set(36, readTableEntry);
        readTable.set(37, readTableEntry);
        readTable.set(38, readTableEntry);
        readTable.set(42, readTableEntry);
        readTable.set(43, readTableEntry);
        readTable.set(45, readTableEntry);
        readTable.set(46, readTableEntry);
        readTable.set(47, readTableEntry);
        readTable.set(58, readTableEntry);
        readTable.set(61, readTableEntry);
        readTable.set(62, readTableEntry);
        readTable.set(63, readTableEntry);
        readTable.set(64, readTableEntry);
        readTable.set(94, readTableEntry);
        readTable.set(95, readTableEntry);
        readTable.set(123, readTableEntry);
        readTable.set(125, readTableEntry);
        readTable.set(126, readTableEntry);
        readTable.set(127, readTableEntry);
        readTable.set(8, readTableEntry);
        readTable.set(34, new ReaderString());
        readTable.set(35, ReaderDispatch.create());
        readTable.set(59, ReaderIgnoreRestOfLine.getInstance());
        readTable.set(40, ReaderParens.getInstance('(', ')'));
        readTable.set(39, new ReaderQuote("quote"));
        readTable.set(96, new ReaderQuote("quasiquote"));
        readTable.set(44, new ReaderQuote("unquote", '@', "unquote-splicing"));
        readTable.setBracketMode();
        return readTable;
    }

    public void setBracketMode(int n) {
        if (n <= 0) {
            ReadTableEntry readTableEntry = ReadTableEntry.getConstituentInstance();
            this.set(60, readTableEntry);
            if (n < 0) {
                this.set(91, readTableEntry);
                this.set(93, readTableEntry);
            }
        } else {
            this.set(60, new ReaderTypespec());
        }
        if (n >= 0) {
            this.set(91, ReaderParens.getInstance('[', ']'));
            this.remove(93);
        }
    }

    public void setBracketMode() {
        this.setBracketMode(defaultBracketMode);
    }

    public static ReadTable getCurrent() {
        ReadTable readTable = (ReadTable)current.get(null);
        if (readTable == null) {
            Language language = Language.getDefaultLanguage();
            readTable = language instanceof LispLanguage ? ((LispLanguage)language).defaultReadTable : ReadTable.getInitial();
            current.set(readTable);
        }
        return readTable;
    }

    public static void setCurrent(ReadTable readTable) {
        current.set(readTable);
    }

    public ReadTableEntry lookup(int n) {
        ReadTableEntry readTableEntry = (ReadTableEntry)this.lookup(n, null);
        if (readTableEntry == null && n >= 0 && n < 65536) {
            if (Character.isDigit((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(48, null);
            } else if (Character.isLowerCase((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(97, null);
            } else if (Character.isLetter((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(65, null);
            } else if (Character.isWhitespace((char)n)) {
                readTableEntry = (ReadTableEntry)this.lookup(32, null);
            }
            if (readTableEntry == null && n >= 128) {
                readTableEntry = ReadTableEntry.getConstituentInstance();
            }
        }
        return readTableEntry;
    }
}

