/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.LineBufferedReader;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SourceError {
    public SourceError next;
    public char severity;
    public String filename;
    public int line;
    public int column;
    public String message;

    public SourceError(char c, String string, int n, int n2, String string2) {
        this.severity = c;
        this.filename = string;
        this.line = n;
        this.column = n2;
        this.message = string2;
    }

    public SourceError(LineBufferedReader lineBufferedReader, char c, String string) {
        this(c, lineBufferedReader.getName(), lineBufferedReader.getLineNumber() + 1, lineBufferedReader.getColumnNumber(), string);
        if (this.column >= 0) {
            ++this.column;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.filename == null ? "<unknown>" : this.filename);
        if (this.line != 0 || this.column != 0) {
            stringBuffer.append(':');
            stringBuffer.append(this.line);
            if (this.column > 0) {
                stringBuffer.append(':');
                stringBuffer.append(this.column);
            }
        }
        stringBuffer.append(": ");
        if (this.severity == 'w') {
            stringBuffer.append("warning - ");
        }
        stringBuffer.append(this.message);
        return stringBuffer.toString();
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(this);
    }

    public void println(PrintWriter printWriter) {
        int n;
        String string = this.toString();
        while ((n = string.indexOf(10)) >= 0) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        printWriter.println(string);
    }

    public void println(PrintStream printStream) {
        int n;
        String string = this.toString();
        while ((n = string.indexOf(10)) >= 0) {
            printStream.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        printStream.println(string);
    }
}

