/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class SyntaxForm
implements Externalizable {
    public Object form;
    public TemplateScope scope;

    private SyntaxForm() {
    }

    public static SyntaxForm make(Object object2, TemplateScope templateScope) {
        SyntaxForm syntaxForm = new SyntaxForm();
        syntaxForm.form = object2;
        syntaxForm.scope = templateScope;
        return syntaxForm;
    }

    public String toString() {
        return "#<syntax " + this.form + " in #" + this.scope.id + ">";
    }

    public SyntaxForm fromDatum(Object object2) {
        SyntaxForm syntaxForm = new SyntaxForm();
        syntaxForm.form = object2;
        syntaxForm.scope = this.scope;
        return syntaxForm;
    }

    public static Object makeWithTemplate(Object object2, Object object3) {
        if (object3 instanceof SyntaxForm) {
            return (SyntaxForm)object3;
        }
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            if (object3 == syntaxForm.form) {
                return syntaxForm;
            }
            return syntaxForm.fromDatum(object3);
        }
        return object3;
    }

    public SyntaxForm fromDatumIfNeeded(Object object2) {
        if (object2 == this.form) {
            return this;
        }
        if (object2 instanceof SyntaxForm) {
            return (SyntaxForm)object2;
        }
        return this.fromDatum(object2);
    }

    public static Expression rewrite(Object object2) {
        Translator translator = (Translator)Compilation.getCurrent();
        return translator.rewrite(object2);
    }

    public static Expression rewriteBody(Object object2) {
        Translator translator = (Translator)Compilation.getCurrent();
        return translator.rewrite_body(object2);
    }

    public boolean isIdentifier() {
        return this.form instanceof String || this.form instanceof Symbol;
    }

    public static boolean freeIdentifierEquals(SyntaxForm syntaxForm, SyntaxForm syntaxForm2) {
        Translator translator = (Translator)Compilation.getCurrent();
        return translator.lexical.lookup(syntaxForm.form, -1) == translator.lexical.lookup(syntaxForm2.form, -1);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.form);
        objectOutput.writeObject(this.scope);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.form = objectInput.readObject();
        this.scope = (TemplateScope)objectInput.readObject();
    }
}

