/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common;

import java.util.EnumSet;
import java.util.Set;

public enum ServerStatus {
    IN_TRANSACTION(1),
    AUTOCOMMIT(2),
    MORE_RESULTS_EXISTS(8),
    QUERY_NO_GOOD_INDEX_USED(16),
    QUERY_NO_INDEX_USED(32),
    CURSOR_EXISTS(64),
    LAST_ROW_SENT(128),
    DB_DROPPED(256),
    NO_BACKSLASH_ESCAPES(512),
    QUERY_WAS_SLOW(1024);

    private final short bitmapFlag;

    private ServerStatus(short i) {
        this.bitmapFlag = i;
    }

    public short getBitmapFlag() {
        return this.bitmapFlag;
    }

    public static Set<ServerStatus> getServerStatusSet(short i) {
        EnumSet<ServerStatus> statusSet = EnumSet.noneOf(ServerStatus.class);
        for (ServerStatus value : ServerStatus.values()) {
            if ((i & value.getBitmapFlag()) != value.getBitmapFlag()) continue;
            statusSet.add(value);
        }
        return statusSet;
    }
}

