/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.client;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class FileResourceImpl
extends ResourceImpl
implements FileResource {
    private String fileType;
    private byte[] data;
    private String referenceURI;

    public FileResourceImpl() {
    }

    public FileResourceImpl(FileResourceImpl another) {
        super(another);
        this.fileType = another.fileType;
        this.data = another.data != null ? (byte[])another.data.clone() : null;
        this.referenceURI = another.referenceURI;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public void readData(InputStream is) {
        this.setData(DataContainerStreamUtil.readData(is));
    }

    @Override
    public InputStream getDataStream() {
        return this.data == null ? null : new ByteArrayInputStream(this.data);
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    @Override
    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @Override
    public boolean isReference() {
        return this.referenceURI != null && this.referenceURI.length() > 0;
    }

    @Override
    public String getReferenceURI() {
        return this.referenceURI;
    }

    @Override
    public void setReferenceURI(String referenceURI) {
        this.referenceURI = referenceURI;
    }

    @Override
    public boolean hasData() {
        return !this.isReference() && this.data != null && this.data.length > 0;
    }

    @Override
    protected Class getImplementingItf() {
        return FileResource.class;
    }

    @Override
    public boolean isSameType(Resource resource) {
        boolean same = super.isSameType(resource);
        if (same) {
            FileResource fileRes = (FileResource)resource;
            String resType = fileRes.getFileType();
            String type = this.getFileType();
            if (type != null && resType != null && !type.equals(resType)) {
                same = false;
            }
        }
        return same;
    }
}

