/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.service.JdbcDriverService;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsDataSourceRecovery;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsEc2MetadataClient;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsProperties;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.InstanceProductTypeResolver;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.VirtualReportDataSourceImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.CustomReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.core.util.JSONUtil;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JdkTimeZonesList;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import com.jaspersoft.jasperserver.war.dto.StringOption;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.json.JSONObject;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class DataSourceAction
extends FormAction
implements ApplicationContextAware {
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private static final String RESOURCE_DATA_SOURCE_CONNECTION_STATE_FAILED = "resource.dataSource.connectionState.failed";
    private static final String RESOURCE_DATA_SOURCE_CONNECTION_STATE_PASSED = "resource.dataSource.connectionState.passed";
    private RepositoryService repository;
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    private JdkTimeZonesList timezones;
    private ResourceFactory dataSourceMappings;
    private List<String> awsRegions;
    private AwsDataSourceRecovery awsDataSourceRecovery;
    private AwsProperties awsProperties;
    private AwsEc2MetadataClient awsEc2MetadataClient;
    private InstanceProductTypeResolver instanceProductTypeResolver;
    public static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    public static final String FORM_OBJECT_KEY = "dataResource";
    public static final String JDBC_DRIVERS_JSON_KEY = "jdbcDriversJSON";
    public static final String PASSWORD_SUBSTITUTION_KEY = "passwordSubstitution";
    public static final String VALIDATION_PATTERNS = "validationPatterns";
    public static final String DYNAMIC_URL_PART_PATTERN = "dynamicUrlPartPattern";
    public static final String DATASOURCEURI_PARAM = "resource";
    public static final String PARENT_FOLDER_ATTR = "parentFolder";
    public static final String PARENT_FOLDER_URI = "ParentFolderUri";
    public static final String DATASOURCE_JDBC = "jdbc";
    public static final String DATASOURCE_JNDI = "jndi";
    public static final String DATASOURCE_BEAN = "bean";
    public static final String DATASOURCE_VIRTUAL = "virtual";
    public static final String DATASOURCE_AWS = "aws";
    public static final String TYPE = "type";
    public static final String SUB_DATASOURCES_JSON_KEY = "selectedSubDs";
    public static final String SUB_DATASOURCE_ID_KEY = "dsId";
    public static final String SUB_DATASOURCE_URI_KEY = "dsUri";
    public static final String SUB_DATASOURCE_NAME_KEY = "dsName";
    public static final String DEPENDENT_RESOURCES_JSON_KEY = "dependentResources";
    public static final int MAX_DEPENDENT_RESOURCES = 20;
    protected MessageSource messages;
    private ConfigurationBean configuration;
    private CustomReportDataSourceServiceFactory customDataSourceFactory;
    private EngineService engine;
    private String queryLanguageFlowAttribute;
    private String UPLOAD_DRIVER_PREFIX = "file_";
    private String passwordSubstitution = null;
    private ObjectMapper jsonMapper = new ObjectMapper();
    private JdbcDriverService jdbcDriverService;
    private Map<String, Map<String, Object>> jdbcConnectionMap;
    private String dynamicUrlPartPattern;
    private Map<String, String> validationPatternsMap;
    ApplicationContext ctx;

    public DataSourceAction() {
        this.setFormObjectClass(ReportDataSourceWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = arg0;
    }

    public Event initAction(RequestContext context) throws Exception {
        TimeZone zone;
        StringOption option;
        ReportDataSourceWrapper formObject = (ReportDataSourceWrapper)this.getFormObject(context);
        Object parentFlowObject = null;
        if (formObject != null) {
            parentFlowObject = formObject.getParentFlowObject();
        }
        if (formObject.isNewMode()) {
            context.getFlowScope().put(TYPE, (Object)context.getExternalContext().getRequestParameterMap().get(TYPE));
        } else {
            context.getFlowScope().put(TYPE, (Object)this.getTypeByFormObjectByType(formObject.getType()));
        }
        String typeFromRequest = context.getExternalContext().getRequestParameterMap().get(TYPE);
        boolean forceNewMode = formObject.isSubflowMode();
        if (formObject.isNewMode() || typeFromRequest != null && !typeFromRequest.equals(this.getTypeByFormObjectByType(formObject.getType()))) {
            formObject = (ReportDataSourceWrapper)this.createFormObject(context);
            if (forceNewMode) {
                formObject.setParentFlowObject(parentFlowObject);
                formObject.setMode((byte)3);
            }
        }
        ReportDataSource ds = formObject.getReportDataSource();
        Locale displayLocale = LocaleContextHolder.getLocale();
        String selectedTimezone = null;
        if (ds instanceof JdbcReportDataSource) {
            selectedTimezone = ((JdbcReportDataSource)ds).getTimezone();
        }
        if (ds instanceof JndiJdbcReportDataSource) {
            selectedTimezone = ((JndiJdbcReportDataSource)ds).getTimezone();
        }
        ArrayList<StringOption> timezoneList = this.timezones.getTimeZones(displayLocale);
        timezoneList = new ArrayList<StringOption>(timezoneList);
        if (selectedTimezone != null && selectedTimezone.length() > 0 && !timezoneList.contains(option = new StringOption(selectedTimezone, (zone = TimeZone.getTimeZone(selectedTimezone)).getDisplayName(displayLocale)))) {
            timezoneList.add(0, option);
        }
        context.getFlowScope().put("timezones", timezoneList);
        context.getFlowScope().put("selectedTimezone", (Object)selectedTimezone);
        this.getFormObjectAccessor(context).setCurrentFormObject((Object)formObject, ScopeType.FLOW);
        context.getFlowScope().put(FORM_OBJECT_KEY, (Object)formObject);
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        context.getFlowScope().put("awsRegions", this.getAwsRegions());
        context.getFlowScope().put("isEc2Instance", (Object)this.awsEc2MetadataClient.isEc2Instance());
        context.getFlowScope().put("suppressEc2CredentialsWarnings", (Object)this.awsProperties.isSuppressEc2CredentialsWarnings());
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal != null && principal instanceof TenantQualified && ((TenantQualified)principal).getTenantId() != null) {
            context.getFlowScope().put("tenantId", (Object)((TenantQualified)principal).getTenantId());
        }
        String requestParentFolder = context.getExternalContext().getRequestParameterMap().get(PARENT_FOLDER_URI);
        if (formObject.getReportDataSource() != null) {
            if (StringUtils.isBlank((String)requestParentFolder) || !this.repository.repositoryPathExists(null, requestParentFolder)) {
                requestParentFolder = null;
            }
            formObject.getReportDataSource().setParentFolder(requestParentFolder);
        }
        if (formObject.isSubflowMode() && formObject.getAllDatasources() == null) {
            context.getFlowScope().put("constants", (Object)this.constants);
        }
        if (ds instanceof CustomReportDataSource) {
            CustomReportDataSource cds = (CustomReportDataSource)ds;
            CustomDataSourceDefinition customDef = this.customDataSourceFactory.getDefinition(cds);
            customDef.setDefaultValues(cds);
            formObject.setCustomProperties(customDef.getEditablePropertyDefinitions());
            formObject.setCustomDatasourceLabel(customDef.getLabelName());
            context.getFlowScope().put(TYPE, (Object)customDef.getName());
        }
        this.passwordSubstitution = this.messages.getMessage("input.password.substitution", null, LocaleContextHolder.getLocale());
        context.getFlowScope().put(JDBC_DRIVERS_JSON_KEY, (Object)JSONUtil.toJSON(this.getAvailableJdbcDrivers()));
        context.getFlowScope().put(DYNAMIC_URL_PART_PATTERN, (Object)JSONUtil.toJSON((Object)this.dynamicUrlPartPattern));
        context.getFlowScope().put(VALIDATION_PATTERNS, (Object)JSONUtil.toJSON(this.validationPatternsMap));
        context.getFlowScope().put(PASSWORD_SUBSTITUTION_KEY, (Object)this.passwordSubstitution);
        return this.success();
    }

    public Map<String, Map<String, Object>> getAvailableJdbcDrivers() {
        LinkedHashMap<String, Map<String, Object>> availableDrivers = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : this.jdbcConnectionMap.entrySet()) {
            HashMap<String, Object> driverData = new HashMap<String, Object>();
            driverData.putAll(entry.getValue());
            driverData.put("available", this.jdbcDriverService.isRegistered(String.valueOf(entry.getValue().get("jdbcDriverClass"))));
            availableDrivers.put(entry.getKey(), driverData);
        }
        for (String registeredDriverClassName : this.jdbcDriverService.getRegisteredDriverClassNames()) {
            boolean defined = false;
            for (Map.Entry<String, Map<String, Object>> entry : this.jdbcConnectionMap.entrySet()) {
                if (!registeredDriverClassName.equals(entry.getValue().get("jdbcDriverClass"))) continue;
                defined = true;
                break;
            }
            if (defined) continue;
            availableDrivers.put(registeredDriverClassName, null);
        }
        return availableDrivers;
    }

    public String getTypeByFormObjectByType(String formObjectType) {
        if (JasperServerConstImpl.getJNDIDatasourceType().equals(formObjectType)) {
            return DATASOURCE_JNDI;
        }
        if (JasperServerConstImpl.getJDBCDatasourceType().equals(formObjectType)) {
            return DATASOURCE_JDBC;
        }
        if (JasperServerConstImpl.getBeanDatasourceType().equals(formObjectType)) {
            return DATASOURCE_BEAN;
        }
        if (JasperServerConstImpl.getVirtualDatasourceType().equals(formObjectType)) {
            return DATASOURCE_VIRTUAL;
        }
        if (JasperServerConstImpl.getAwsDatasourceType().equals(formObjectType)) {
            return DATASOURCE_AWS;
        }
        return formObjectType;
    }

    public Event prepareChooseType(RequestContext context) throws Exception {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        for (CustomDataSourceDefinition cds : this.customDataSourceFactory.getDefinitions()) {
            typeMap.put(cds.getName(), this.messages.getMessage(cds.getLabelName(), null, LocaleContextHolder.getLocale()));
        }
        context.getRequestScope().put("allTypes", typeMap);
        return this.success();
    }

    public Event bindSubDatasources(RequestContext context) throws Exception {
        ReportDataSourceWrapper formObject = (ReportDataSourceWrapper)this.getFormObject(context);
        VirtualReportDataSource vds = (VirtualReportDataSource)formObject.getReportDataSource();
        String subDsJSON = (String)formObject.getNamedProperties().get(SUB_DATASOURCES_JSON_KEY);
        vds.getDataSourceUriMap().clear();
        if (StringUtils.isEmpty((String)subDsJSON)) {
            return this.success();
        }
        JsonNode subDsList = this.jsonMapper.readTree(subDsJSON);
        for (JsonNode subDs : subDsList) {
            String id = subDs.get(SUB_DATASOURCE_ID_KEY).asText();
            String uri = subDs.get(SUB_DATASOURCE_URI_KEY).asText();
            vds.getDataSourceUriMap().put(id, new ResourceReference(uri));
        }
        return this.success();
    }

    public Event saveDatasource(RequestContext context) throws Exception {
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        if (wrapper.isStandAloneMode()) {
            if (wrapper.getType() != null) {
                ReportDataSource ds = wrapper.getReportDataSource();
                if (ds instanceof JdbcReportDataSource && ((JdbcReportDataSource)ds).getDriverClass().equalsIgnoreCase("VirtualDS")) {
                    VirtualReportDataSourceImpl fds = new VirtualReportDataSourceImpl();
                    fds.setCreationDate(ds.getCreationDate());
                    fds.setDescription(ds.getDescription());
                    fds.setLabel(ds.getLabel());
                    fds.setName(ds.getName());
                    fds.setParentFolder(ds.getParentFolder());
                    fds.setUpdateDate(ds.getUpdateDate());
                    try {
                        String[] paths = ds.getDescription().split("\\|");
                        String schemaList = ((JdbcReportDataSource)ds).getConnectionUrl();
                        String[] schemas = null;
                        if (schemaList != null && !schemaList.equals("")) {
                            schemas = schemaList.split("\\|");
                        }
                        HashMap<String, ResourceReference> uriMap = new HashMap<String, ResourceReference>();
                        for (int i = 0; i < paths.length; ++i) {
                            String schemaName = null;
                            String path = paths[i].trim();
                            schemaName = schemas != null && i < schemas.length ? schemas[i].trim() : path.substring(path.lastIndexOf("/") + 1);
                            uriMap.put(schemaName, new ResourceReference(path));
                        }
                        fds.setDataSourceUriMap(uriMap);
                        ds = fds;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (ds.getName() != null) {
                    try {
                        CustomReportDataSource existingDs;
                        Object password;
                        JdbcReportDataSource existingDs2;
                        if (ds instanceof JdbcReportDataSource && ((JdbcReportDataSource)ds).getPassword().equals(this.passwordSubstitution) && (existingDs2 = (JdbcReportDataSource)this.repository.getResource(null, ds.getURIString())) != null) {
                            ((JdbcReportDataSource)ds).setPassword(existingDs2.getPassword());
                        }
                        if (ds instanceof AwsReportDataSource && ((AwsReportDataSource)ds).getAWSSecretKey().equals(this.passwordSubstitution) && (existingDs2 = (AwsReportDataSource)this.repository.getResource(null, ds.getURIString())) != null) {
                            ((AwsReportDataSource)ds).setAWSSecretKey(existingDs2.getAWSSecretKey());
                        }
                        if (ds instanceof CustomReportDataSource && (password = ((CustomReportDataSource)ds).getPropertyMap().get("password")) != null && password.equals(this.passwordSubstitution) && (existingDs = (CustomReportDataSource)this.repository.getResource(null, ds.getURIString())) != null) {
                            ((CustomReportDataSource)ds).getPropertyMap().put("password", existingDs.getPropertyMap().get("password"));
                        }
                        this.repository.saveResource(null, (Resource)ds);
                        if (wrapper.isEditMode() && ds instanceof AwsReportDataSource) {
                            try {
                                this.awsDataSourceRecovery.createAwsDSSecurityGroup((AwsReportDataSource)ds);
                            }
                            catch (Exception ex) {
                                this.logger.error((Object)"Exception creating of Aws Security Group", (Throwable)ex);
                            }
                        }
                    }
                    catch (JSDuplicateResourceException e) {
                        this.getFormErrors(context).rejectValue("reportDataSource.name", "ReportDataSourceValidator.error.duplicate");
                        return this.error();
                    }
                }
            }
            if (!wrapper.isEditMode()) {
                context.getExternalContext().getSessionMap().put("repositorySystemConfirm", (Object)this.messages.getMessage("resource.file.fileAdded", (Object[])new String[]{wrapper.getReportDataSource().getName(), wrapper.getReportDataSource().getParentFolder()}, LocaleContextHolder.getLocale()));
            }
            return this.yes();
        }
        return this.success();
    }

    public Event testCustomDataSource(RequestContext context) throws Exception {
        String connectionStatusMessageKey = RESOURCE_DATA_SOURCE_CONNECTION_STATE_FAILED;
        if (this.customDataSourceFactory != null) {
            try {
                ReportDataSourceService service;
                CustomReportDataSource existingDs;
                ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
                CustomReportDataSource ds = (CustomReportDataSource)wrapper.getReportDataSource();
                if (ds.getPropertyMap().get("password") != null && ds.getPropertyMap().get("password").equals(this.passwordSubstitution) && (existingDs = (CustomReportDataSource)this.repository.getResource(null, ds.getURIString())) != null) {
                    ds.getPropertyMap().put("password", existingDs.getPropertyMap().get("password"));
                }
                if (this.setTestAvailable(context, service = this.customDataSourceFactory.createService((ReportDataSource)ds)) && ((CustomReportDataSourceService)service).testConnection()) {
                    connectionStatusMessageKey = RESOURCE_DATA_SOURCE_CONNECTION_STATE_PASSED;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"exception testing custom data source", (Throwable)e);
            }
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)this.messages.getMessage(connectionStatusMessageKey, null, LocaleContextHolder.getLocale()));
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event testJdbcDataSource(RequestContext context) throws Exception {
        TestJdbcConnectionResponseBuilder response = new TestJdbcConnectionResponseBuilder().failed();
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        JdbcReportDataSource ds = (JdbcReportDataSource)wrapper.getReportDataSource();
        Connection conn = null;
        try {
            JdbcReportDataSource existingDs;
            this.jdbcDriverService.register(ds.getDriverClass());
            if (ds.getPassword().equals(this.passwordSubstitution) && (existingDs = (JdbcReportDataSource)this.repository.getResource(null, ds.getURIString())) != null) {
                ds.setPassword(existingDs.getPassword());
            }
            if ((conn = DriverManager.getConnection(ds.getConnectionUrl(), ds.getUsername(), ds.getPassword())) != null) {
                response.passed();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"exception testing jdbc data source", (Throwable)e);
            response.failed(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.buildJson());
        return this.success();
    }

    public void setInstanceProductTypeResolver(InstanceProductTypeResolver instanceProductTypeResolver) {
        this.instanceProductTypeResolver = instanceProductTypeResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event testAwsDataSource(RequestContext context) throws Exception {
        TestJdbcConnectionResponseBuilder response = new TestJdbcConnectionResponseBuilder().failed();
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        AwsReportDataSource ds = (AwsReportDataSource)wrapper.getReportDataSource();
        Connection conn = null;
        try {
            AwsReportDataSource existingDs;
            this.jdbcDriverService.register(ds.getDriverClass());
            if (ds.getPassword().equals(this.passwordSubstitution) && (existingDs = (AwsReportDataSource)this.repository.getResource(null, ds.getURIString())) != null) {
                ds.setPassword(existingDs.getPassword());
            }
            if (ds.getAWSSecretKey().equals(this.passwordSubstitution) && (existingDs = (AwsReportDataSource)this.repository.getResource(null, ds.getURIString())) != null) {
                ds.setAWSSecretKey(existingDs.getAWSSecretKey());
            }
            this.awsDataSourceRecovery.createAwsDSSecurityGroup(ds);
            conn = DriverManager.getConnection(ds.getConnectionUrl(), ds.getUsername(), ds.getPassword());
            if (conn != null) {
                response.passed();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"exception testing AWS data source", (Throwable)e);
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)e);
            if (throwable instanceof ConnectException || throwable instanceof SocketTimeoutException || e instanceof SQLException && ((SQLException)e).getSQLState().startsWith("08")) {
                response.failed((Exception)new JSException(this.messages.getMessage("aws.exception.datasource.recovery.timeout", null, LocaleContextHolder.getLocale()), (Throwable)e));
            } else {
                response.failed(e);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.buildJson());
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event testJndiDataSource(RequestContext context) throws Exception {
        String connectionStatusMessageKey = RESOURCE_DATA_SOURCE_CONNECTION_STATE_FAILED;
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)wrapper.getReportDataSource();
        Connection conn = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource dataSource = (DataSource)ctx.lookup("java:comp/env/" + ds.getJndiName());
            conn = dataSource.getConnection();
            if (conn != null) {
                connectionStatusMessageKey = RESOURCE_DATA_SOURCE_CONNECTION_STATE_PASSED;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"exception testing jndi data source", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)this.messages.getMessage(connectionStatusMessageKey, null, LocaleContextHolder.getLocale()));
        return this.success();
    }

    public Event testBeanDataSource(RequestContext context) throws Exception {
        String connectionStatusMessageKey;
        block7: {
            connectionStatusMessageKey = RESOURCE_DATA_SOURCE_CONNECTION_STATE_FAILED;
            ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
            BeanReportDataSource ds = (BeanReportDataSource)wrapper.getReportDataSource();
            try {
                Object bean = this.ctx.getBean(ds.getBeanName());
                if (bean == null) break block7;
                if (ds.getBeanMethod() == null) {
                    if (bean instanceof ReportDataSourceService) {
                        connectionStatusMessageKey = RESOURCE_DATA_SOURCE_CONNECTION_STATE_PASSED;
                    }
                    break block7;
                }
                try {
                    Method serviceMethod = bean.getClass().getMethod(ds.getBeanMethod(), null);
                    Object obj = serviceMethod.invoke(bean, null);
                    if (obj != null) {
                        connectionStatusMessageKey = RESOURCE_DATA_SOURCE_CONNECTION_STATE_PASSED;
                    }
                }
                catch (SecurityException e) {
                    this.logger.error((Object)"exception testing bean data source", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"exception testing bean data source", (Throwable)e);
            }
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)this.messages.getMessage(connectionStatusMessageKey, null, LocaleContextHolder.getLocale()));
        return this.success();
    }

    public Event validateDataSource(RequestContext context) throws Exception {
        Errors errors = this.getFormErrors(context);
        ReportDataSourceWrapper wrapper = (ReportDataSourceWrapper)this.getFormObject(context);
        this.getValidator().validate((Object)wrapper, errors);
        List fieldErrors = errors.getFieldErrors();
        if (fieldErrors != null && !fieldErrors.isEmpty()) {
            FieldError error = (FieldError)fieldErrors.get(0);
            String field = error.getField();
            if ("source".equals(field) || "selectedUri".equals(field)) {
                return this.result("chooseSource");
            }
            if (TYPE.equals(field)) {
                return this.result("chooseType");
            }
            if (JasperServerConstImpl.getJDBCDatasourceType().equals(wrapper.getType())) {
                return this.result("jdbcPropsForm");
            }
            if (JasperServerConstImpl.getJNDIDatasourceType().equals(wrapper.getType())) {
                return this.result("jndiPropsForm");
            }
            if (JasperServerConstImpl.getBeanDatasourceType().equals(wrapper.getType())) {
                return this.result("beanPropsForm");
            }
            if (JasperServerConstImpl.getVirtualDatasourceType().equals(wrapper.getType())) {
                return this.result("virtualPropsForm");
            }
            return this.result("customPropsForm");
        }
        return this.success();
    }

    public void initSubDatasources(ReportDataSourceWrapper formObject) {
        ArrayNode subDsList = this.jsonMapper.createArrayNode();
        VirtualReportDataSource vds = (VirtualReportDataSource)formObject.getReportDataSource();
        for (Map.Entry dsMapping : vds.getDataSourceUriMap().entrySet()) {
            ObjectNode subDsNode = subDsList.addObject();
            subDsNode.put(SUB_DATASOURCE_ID_KEY, (String)dsMapping.getKey());
            subDsNode.put(SUB_DATASOURCE_URI_KEY, ((ResourceReference)dsMapping.getValue()).getReferenceURI());
            Resource res = this.repository.getResource(null, ((ResourceReference)dsMapping.getValue()).getReferenceURI());
            subDsNode.put(SUB_DATASOURCE_NAME_KEY, res.getName());
        }
        String subDsJson = JSONUtil.toJSON((Object)subDsList);
        formObject.getNamedProperties().put(SUB_DATASOURCES_JSON_KEY, subDsJson);
    }

    public void initDependentResourcesList(ReportDataSourceWrapper formObject) {
        if (!formObject.isEditMode()) {
            return;
        }
        List depRes = this.repository.getDependentResources(null, formObject.getReportDataSource().getURIString(), null, 0, 20);
        String depResJson = JSONUtil.toJSON((Collection)depRes);
        formObject.getNamedProperties().put(DEPENDENT_RESOURCES_JSON_KEY, depResJson);
    }

    public Object createFormObject(RequestContext context) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ReportDataSourceWrapper formObject = new ReportDataSourceWrapper();
        String resourceUri = context.getRequestParameters().get(DATASOURCEURI_PARAM);
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            Resource resource = this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            formObject.setMode((byte)2);
            ReportDataSource dataSource = (ReportDataSource)resource;
            formObject.setType(this.getDataSourceMappings().getIdForClass(dataSource.getClass()));
            if (JasperServerConstImpl.getJNDIDatasourceType().equals(this.getDataSourceMappings().getIdForClass(dataSource.getClass()))) {
                context.getFlowScope().put(TYPE, (Object)DATASOURCE_JNDI);
            } else if (JasperServerConstImpl.getBeanDatasourceType().equals(this.getDataSourceMappings().getIdForClass(dataSource.getClass()))) {
                context.getFlowScope().put(TYPE, (Object)DATASOURCE_BEAN);
            }
            formObject.setReportDataSource(dataSource);
            if (JasperServerConstImpl.getVirtualDatasourceType().equals(formObject.getType())) {
                this.initDependentResourcesList(formObject);
                this.initSubDatasources(formObject);
            }
        }
        if (formObject.getReportDataSource() == null) {
            ReportDataSource source;
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            String type = context.getExternalContext().getRequestParameterMap().get(TYPE);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get(PARENT_FOLDER_URI);
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            formObject.setMode((byte)1);
            formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            if (type == null && this.instanceProductTypeResolver.isEC2() || DATASOURCE_AWS.equals(type)) {
                source = this.newReportDataSource(JasperServerConstImpl.getAwsDatasourceType());
                context.getFlowScope().put(TYPE, (Object)DATASOURCE_AWS);
                formObject.setType(JasperServerConstImpl.getAwsDatasourceType());
                if (this.awsEc2MetadataClient.isEc2Instance()) {
                    ((AwsReportDataSource)source).setAWSRegion(this.awsEc2MetadataClient.getEc2InstanceRegion());
                }
            } else if (type == null) {
                source = this.newReportDataSource(JasperServerConstImpl.getJDBCDatasourceType());
                formObject.setType(JasperServerConstImpl.getJDBCDatasourceType());
            } else if (type.equals(DATASOURCE_JDBC)) {
                source = this.newReportDataSource(JasperServerConstImpl.getJDBCDatasourceType());
                formObject.setType(JasperServerConstImpl.getJNDIDatasourceType());
            } else if (type.equals(DATASOURCE_JNDI)) {
                source = this.newReportDataSource(JasperServerConstImpl.getJNDIDatasourceType());
                formObject.setType(JasperServerConstImpl.getJNDIDatasourceType());
            } else if (type.equals(DATASOURCE_BEAN)) {
                source = this.newReportDataSource(JasperServerConstImpl.getBeanDatasourceType());
                formObject.setType(JasperServerConstImpl.getBeanDatasourceType());
            } else if (type.equals(DATASOURCE_VIRTUAL)) {
                source = this.newReportDataSource(JasperServerConstImpl.getVirtualDatasourceType());
                formObject.setType(JasperServerConstImpl.getVirtualDatasourceType());
            } else {
                source = this.newReportDataSource(type);
                formObject.setType(type);
            }
            source.setParentFolder(parentFolder);
            source.setVersion(-1);
            formObject.setReportDataSource(source);
        }
        if (formObject.getReportDataSource() instanceof CustomReportDataSource) {
            this.evaluateTestAvailability(context, (CustomReportDataSource)formObject.getReportDataSource());
        }
        return formObject;
    }

    private void evaluateTestAvailability(RequestContext context, CustomReportDataSource reportDataSource) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Evaluating service class: " + reportDataSource.getServiceClass()));
        }
        try {
            Class<?> serviceClass = Class.forName(reportDataSource.getServiceClass());
            Object newServiceClass = serviceClass.newInstance();
            this.setTestAvailable(context, newServiceClass);
            newServiceClass = null;
        }
        catch (ClassNotFoundException cnf) {
            this.setTestAvailable(context, cnf);
        }
    }

    private boolean setTestAvailable(RequestContext context, Object instance) {
        boolean isAvailable = instance instanceof CustomReportDataSourceService;
        context.getRequestScope().put("testAvailable", (Object)isAvailable);
        return isAvailable;
    }

    private ReportDataSource newReportDataSource(String dsType) {
        CustomDataSourceDefinition cdsd;
        if (this.customDataSourceFactory != null && (cdsd = this.customDataSourceFactory.getDefinitionByName(dsType)) != null) {
            return this.customDataSourceFactory.createDataSource(dsType);
        }
        return (ReportDataSource)this.getDataSourceMappings().newResource(null, dsType);
    }

    private ReportDataSource newReportDataSource(String dsType, ReportDataSource oldDS) {
        ReportDataSource newDS = this.newReportDataSource(dsType);
        newDS.setParentFolder(oldDS.getParentFolder());
        newDS.setName(oldDS.getName());
        newDS.setLabel(oldDS.getLabel());
        newDS.setDescription(oldDS.getDescription());
        newDS.setVersion(oldDS.getVersion());
        if (oldDS instanceof JdbcReportDataSource) {
            JdbcReportDataSource oldJdbc = (JdbcReportDataSource)oldDS;
            JdbcReportDataSource newJdbc = (JdbcReportDataSource)newDS;
            newJdbc.setDriverClass(oldJdbc.getDriverClass());
            newJdbc.setConnectionUrl(oldJdbc.getConnectionUrl());
            newJdbc.setPassword(oldJdbc.getPassword());
            newJdbc.setTimezone(oldJdbc.getTimezone());
            newJdbc.setUsername(oldJdbc.getUsername());
        } else if (oldDS instanceof JndiJdbcReportDataSource) {
            JndiJdbcReportDataSource oldJndi = (JndiJdbcReportDataSource)oldDS;
            JndiJdbcReportDataSource newJndi = (JndiJdbcReportDataSource)newDS;
            newJndi.setJndiName(oldJndi.getJndiName());
            newJndi.setTimezone(oldJndi.getTimezone());
        } else if (oldDS instanceof VirtualReportDataSource) {
            VirtualReportDataSource oldVirtual = (VirtualReportDataSource)oldDS;
            VirtualReportDataSource newVirtual = (VirtualReportDataSource)newDS;
            newVirtual.setDataSourceUriMap(new HashMap(oldVirtual.getDataSourceUriMap()));
            newVirtual.setTimezone(oldVirtual.getTimezone());
        } else if (oldDS instanceof BeanReportDataSource) {
            BeanReportDataSource oldBean = (BeanReportDataSource)oldDS;
            BeanReportDataSource newBean = (BeanReportDataSource)newDS;
            newBean.setBeanMethod(oldBean.getBeanMethod());
            newBean.setBeanName(oldBean.getBeanName());
        }
        return newDS;
    }

    public Event uploadJDBCDrivers(RequestContext context) throws Exception {
        String driverClassName = context.getRequestParameters().get("className");
        if (driverClassName == null || driverClassName.isEmpty()) {
            throw new Exception("Class name is empty.");
        }
        HashMap<String, byte[]> driverFilesData = new HashMap<String, byte[]>();
        int i = 0;
        MultipartFile multipartFile = context.getRequestParameters().getMultipartFile(this.UPLOAD_DRIVER_PREFIX + i);
        while (multipartFile != null) {
            driverFilesData.put(multipartFile.getOriginalFilename(), multipartFile.getBytes());
            multipartFile = context.getRequestParameters().getMultipartFile(this.UPLOAD_DRIVER_PREFIX + ++i);
        }
        String errorMessage = "";
        try {
            this.jdbcDriverService.setDriver(driverClassName, driverFilesData);
        }
        catch (NoClassDefFoundError e) {
            errorMessage = this.messages.getMessage("resource.dataSource.jdbc.classNotFound", (Object[])new String[]{e.getMessage()}, LocaleContextHolder.getLocale());
            this.logger.error((Object)errorMessage);
        }
        catch (ClassNotFoundException e) {
            errorMessage = this.messages.getMessage("resource.dataSource.jdbc.classNotFound", (Object[])new String[]{e.getMessage()}, LocaleContextHolder.getLocale());
            this.logger.error((Object)errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            this.logger.error((Object)errorMessage);
        }
        Map<String, Map<String, Object>> availableDrivers = this.getAvailableJdbcDrivers();
        JSONObject json = new JSONObject();
        json.put("result", StringUtils.isEmpty((String)errorMessage));
        json.put("errorMessage", (Object)errorMessage);
        json.put(JDBC_DRIVERS_JSON_KEY, (Object)JSONUtil.toJSON(availableDrivers));
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)json.toString());
        context.getFlowScope().put(JDBC_DRIVERS_JSON_KEY, (Object)JSONUtil.toJSON(availableDrivers));
        return this.success();
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public ResourceFactory getDataSourceMappings() {
        return this.dataSourceMappings;
    }

    public void setDataSourceMappings(ResourceFactory dataSourceMappings) {
        this.dataSourceMappings = dataSourceMappings;
    }

    public JdkTimeZonesList getTimezones() {
        return this.timezones;
    }

    public void setTimezones(JdkTimeZonesList timezones) {
        this.timezones = timezones;
    }

    public List<String> getAwsRegions() {
        return this.awsRegions;
    }

    public void setAwsRegions(List<String> awsRegions) {
        this.awsRegions = awsRegions;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public CustomReportDataSourceServiceFactory getCustomDataSourceFactory() {
        return this.customDataSourceFactory;
    }

    public void setCustomDataSourceFactory(CustomReportDataSourceServiceFactory customDataSourceFactory) {
        this.customDataSourceFactory = customDataSourceFactory;
    }

    public String getQueryLanguageFlowAttribute() {
        return this.queryLanguageFlowAttribute;
    }

    public void setQueryLanguageFlowAttribute(String queryLanguageFlowAttribute) {
        this.queryLanguageFlowAttribute = queryLanguageFlowAttribute;
    }

    protected String getQueryLanguage(RequestContext context) {
        return context.getFlowScope().getString(this.getQueryLanguageFlowAttribute());
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public void setJdbcDriverService(JdbcDriverService jdbcDriverService) {
        this.jdbcDriverService = jdbcDriverService;
    }

    public void setAwsDataSourceRecovery(AwsDataSourceRecovery awsDataSourceRecovery) {
        this.awsDataSourceRecovery = awsDataSourceRecovery;
    }

    public void setAwsProperties(AwsProperties awsProperties) {
        this.awsProperties = awsProperties;
    }

    public void setAwsEc2MetadataClient(AwsEc2MetadataClient awsEc2MetadataClient) {
        this.awsEc2MetadataClient = awsEc2MetadataClient;
    }

    public void setJdbcConnectionMap(Map<String, Map<String, Object>> jdbcConnectionMap) {
        this.jdbcConnectionMap = jdbcConnectionMap;
    }

    public void setDynamicUrlPartPattern(String dynamicUrlPartPattern) {
        this.dynamicUrlPartPattern = dynamicUrlPartPattern;
    }

    public void setValidationPatternsMap(Map<String, String> validationPatternsMap) {
        this.validationPatternsMap = validationPatternsMap;
    }

    private class TestJdbcConnectionResponseBuilder {
        public static final String PASSED = "PASSED";
        public static final String FAILED = "FAILED";
        private Map<String, String> response = new HashMap<String, String>();

        private TestJdbcConnectionResponseBuilder() {
        }

        public TestJdbcConnectionResponseBuilder passed() {
            this.response.put("status", PASSED);
            this.response.put("message", DataSourceAction.this.messages.getMessage(DataSourceAction.RESOURCE_DATA_SOURCE_CONNECTION_STATE_PASSED, null, LocaleContextHolder.getLocale()));
            return this;
        }

        public TestJdbcConnectionResponseBuilder failed() {
            this.response.put("status", FAILED);
            this.response.put("message", DataSourceAction.this.messages.getMessage(DataSourceAction.RESOURCE_DATA_SOURCE_CONNECTION_STATE_FAILED, null, LocaleContextHolder.getLocale()));
            return this;
        }

        public TestJdbcConnectionResponseBuilder failed(Exception e) {
            this.failed();
            if (e != null) {
                this.response.put("message", e.getMessage());
                StringWriter result = new StringWriter();
                PrintWriter trace = new PrintWriter(result);
                e.printStackTrace(trace);
                this.response.put("details", result.toString());
            }
            return this;
        }

        public String buildJson() throws Exception {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter result = new StringWriter();
            mapper.writeValue((Writer)result, this.response);
            return result.toString();
        }
    }
}

